# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UsageMetric(Model):
    """A metric describing the usage of a resource.

    :param name: The name of the metric.
    :type name: ~azure.mgmt.loganalytics.models.MetricName
    :param unit: The units used for the metric.
    :type unit: str
    :param current_value: The current value of the metric.
    :type current_value: float
    :param limit: The quota limit for the metric.
    :type limit: float
    :param next_reset_time: The time that the metric's value will reset.
    :type next_reset_time: datetime
    :param quota_period: The quota period that determines the length of time
     between value resets.
    :type quota_period: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'MetricName'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'limit': {'key': 'limit', 'type': 'float'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UsageMetric, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.unit = kwargs.get('unit', None)
        self.current_value = kwargs.get('current_value', None)
        self.limit = kwargs.get('limit', None)
        self.next_reset_time = kwargs.get('next_reset_time', None)
        self.quota_period = kwargs.get('quota_period', None)
