# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MongoDbClusterInfo(Model):
    """Describes a MongoDB data source.

    All required parameters must be populated in order to send to Azure.

    :param databases: Required. A list of non-system databases in the cluster
    :type databases:
     list[~azure.mgmt.datamigration.models.MongoDbDatabaseInfo]
    :param supports_sharding: Required. Whether the cluster supports sharded
     collections
    :type supports_sharding: bool
    :param type: Required. The type of data source. Possible values include:
     'BlobContainer', 'CosmosDb', 'MongoDb'
    :type type: str or ~azure.mgmt.datamigration.models.MongoDbClusterType
    :param version: Required. The version of the data source in the form x.y.z
     (e.g. 3.6.7). Not used if Type is BlobContainer.
    :type version: str
    """

    _validation = {
        'databases': {'required': True},
        'supports_sharding': {'required': True},
        'type': {'required': True},
        'version': {'required': True},
    }

    _attribute_map = {
        'databases': {'key': 'databases', 'type': '[MongoDbDatabaseInfo]'},
        'supports_sharding': {'key': 'supportsSharding', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, *, databases, supports_sharding: bool, type, version: str, **kwargs) -> None:
        super(MongoDbClusterInfo, self).__init__(**kwargs)
        self.databases = databases
        self.supports_sharding = supports_sharding
        self.type = type
        self.version = version
