# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DataMigrationServiceStatusResponse(Model):
    """Service health status.

    :param agent_version: The DMS instance agent version
    :type agent_version: str
    :param status: The machine-readable status, such as 'Initializing',
     'Offline', 'Online', 'Deploying', 'Deleting', 'Stopped', 'Stopping',
     'Starting', 'FailedToStart', 'FailedToStop' or 'Failed'
    :type status: str
    :param vm_size: The services virtual machine size, such as
     'Standard_D2_v2'
    :type vm_size: str
    :param supported_task_types: The list of supported task types
    :type supported_task_types: list[str]
    """

    _attribute_map = {
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'supported_task_types': {'key': 'supportedTaskTypes', 'type': '[str]'},
    }

    def __init__(self, *, agent_version: str=None, status: str=None, vm_size: str=None, supported_task_types=None, **kwargs) -> None:
        super(DataMigrationServiceStatusResponse, self).__init__(**kwargs)
        self.agent_version = agent_version
        self.status = status
        self.vm_size = vm_size
        self.supported_task_types = supported_task_types
