# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .contractual_rules_attribution import ContractualRulesAttribution


class ContractualRulesLinkAttribution(ContractualRulesAttribution):
    """Defines a contractual rule for link attribution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar target_property_name: The name of the field that the rule applies
     to.
    :vartype target_property_name: str
    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar must_be_close_to_content: A Boolean value that determines whether
     the contents of the rule must be placed in close proximity to the field
     that the rule applies to. If true, the contents must be placed in close
     proximity. If false, or this field does not exist, the contents may be
     placed at the caller's discretion.
    :vartype must_be_close_to_content: bool
    :param text: Required. The attribution text.
    :type text: str
    :param url: Required. The URL to the provider's website. Use text and URL
     to create the hyperlink.
    :type url: str
    :ivar optional_for_list_display: Indicates whether this provider's
     attribution is optional.
    :vartype optional_for_list_display: bool
    """

    _validation = {
        'target_property_name': {'readonly': True},
        '_type': {'required': True},
        'must_be_close_to_content': {'readonly': True},
        'text': {'required': True},
        'url': {'required': True},
        'optional_for_list_display': {'readonly': True},
    }

    _attribute_map = {
        'target_property_name': {'key': 'targetPropertyName', 'type': 'str'},
        '_type': {'key': '_type', 'type': 'str'},
        'must_be_close_to_content': {'key': 'mustBeCloseToContent', 'type': 'bool'},
        'text': {'key': 'text', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'optional_for_list_display': {'key': 'optionalForListDisplay', 'type': 'bool'},
    }

    def __init__(self, *, text: str, url: str, **kwargs) -> None:
        super(ContractualRulesLinkAttribution, self).__init__(**kwargs)
        self.text = text
        self.url = url
        self.optional_for_list_display = None
        self._type = 'ContractualRules/LinkAttribution'
