# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PoolNodeCounts(Model):
    """The number of nodes in each state for a pool.

    All required parameters must be populated in order to send to Azure.

    :param pool_id: Required. The ID of the pool.
    :type pool_id: str
    :param dedicated: The number of dedicated nodes in each state.
    :type dedicated: ~azure.batch.models.NodeCounts
    :param low_priority: The number of low priority nodes in each state.
    :type low_priority: ~azure.batch.models.NodeCounts
    """

    _validation = {
        'pool_id': {'required': True},
    }

    _attribute_map = {
        'pool_id': {'key': 'poolId', 'type': 'str'},
        'dedicated': {'key': 'dedicated', 'type': 'NodeCounts'},
        'low_priority': {'key': 'lowPriority', 'type': 'NodeCounts'},
    }

    def __init__(self, **kwargs):
        super(PoolNodeCounts, self).__init__(**kwargs)
        self.pool_id = kwargs.get('pool_id', None)
        self.dedicated = kwargs.get('dedicated', None)
        self.low_priority = kwargs.get('low_priority', None)
