#!/usr/bin/bash

# name:    git_report.sh
# author:  nbehrnd@yahoo.com
# license: MIT
# date:    [2022-12-12 Mon]
# edit:    [2023-01-21 Sat]

# Why:
# The preparation of file `copyright` with `gem2deb` about `markdownlint` only
# states Mark Harrison as copyright holder.  This however omits subsequent
# contributors.
#
# How to:
# Copy-paste of this bash script into a local clone of the GitHub hosted
# markdownlint.git repository of `markdownlint` and run
#
# ```bash
# bash ./git_report.sh
# ```
#
# The longlist reports the contributor's first commit in the format of
#
# <YYYY> <author's name> <author's email>
#
# The output is used for file `debian/copyright`.  The deduplication by
# AWK is a pattern by presented by Sundeep Agarwal,
# <https://learnbyexample.github.io/learn_gnuawk/dealing-with-duplicates.html>

git log --reverse --pretty='format:%as %an <%ae>' | \
cut -c1-4,11- | \
awk '!seen[$NF]++ {print $0}' > longlist.txt && \
echo "Longlist for debian/copyright was written to file longlist.txt."

# The shortlist reports the contributors by their names known to GitHub
# in sequence of their first commit to markdownlint.  The result is used
# in file debian/markdownlint.1, the linter's man page.

git log --reverse --pretty='format: %an' | \
awk '!seen[$NF]++ {printf ("%s,", $0)}' | \
fold -s -w 72 > shortlist.txt &&
sed -i 's/^[ ]//' shortlist.txt && \
sed -i 's/[ \t]*$//' shortlist.txt && \
echo "Shortlist for man page file was written to file shortlist.txt."

