---
layout: post
title: Polyglot 1.12 - redirect improvements and community contributions
lang: en
description: Jekyll Polyglot 1.12.0 brings improved redirect support for sublanguages, fallback page detection, and new site language support
---

Jekyll-Polyglot `1.12.0` has been released! This release focuses on improving redirect handling and includes several community contributions.

## redirect improvements

This release includes important improvements to how redirects work with Polyglot:

- **PR #275**: Anchor tag preservation in redirects - thanks to a solution from [@GruberMarkus](https://github.com/GruberMarkus), redirect URLs now properly preserve anchor tags, ensuring users land exactly where they intended.

- **PR #293**: Sublanguage redirect support for the jekyll-redirect-from plugin - suggested by [@rathboma](https://github.com/rathboma), Polyglot now correctly scopes `redirect_from` frontmatter across sublanguages, preventing duplicate redirects and ensuring proper routing for non-default language pages.

## detect fallback pages with page.rendered_lang

- **PR #283**: New `page.rendered_lang` variable - contributed by [@rathboma](https://github.com/rathboma), this new liquid variable lets you detect when a page is being rendered as a fallback. When `page.rendered_lang != site.active_lang`, you know the page content hasn't been translated yet.

The [/about](/about) page has been updated with instructions on how to best use this `page.rendered_lang` convenience liquid variable.

## new language support

- **PR #280**: Italian and Turkish language support has been added to the Polyglot documentation site, expanding our multilingual reach.

## community contributions

Several community members contributed improvements to the project:

- **PR #277**: Updated sidebar rich text definitions, improving the site's multilingual presentation.

- **PR #288**: Japanese rich text strings contributed by [@manabu-nakamura](https://github.com/manabu-nakamura), enhancing the Japanese language experience.

A special thanks to [@PanderMusubi](https://github.com/PanderMusubi) for the [jekyll-minimal-mistakes-polyglot](https://github.com/PanderMusubi/jekyll-minimal-mistakes-polyglot) demo, showing how to integrate Polyglot with the popular Minimal Mistakes theme.

Thank you to all contributors who made this release possible!
