
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XmlMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Attribute.hxx>
#include <XmlObjMgt_Persistent.hxx>

// module includes
#include <XmlMDataXtd.hxx>
#include <XmlMDataXtd_ConstraintDriver.hxx>
#include <XmlMDataXtd_GeometryDriver.hxx>
#include <XmlMDataXtd_PatternStdDriver.hxx>
#include <XmlMDataXtd_PositionDriver.hxx>
#include <XmlMDataXtd_PresentationDriver.hxx>
#include <XmlMDataXtd_TriangulationDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_XmlMDataXtd(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("XmlMDataXtd"));
py::object klass;

//Python trampoline classes

// classes

    // Class XmlMDataXtd from ./opencascade/XmlMDataXtd.hxx
    klass = m.attr("XmlMDataXtd");

    // default constructor
    register_default_constructor<XmlMDataXtd , shared_ptr<XmlMDataXtd>>(m,"XmlMDataXtd");

    // nested enums

    static_cast<py::class_<XmlMDataXtd , shared_ptr<XmlMDataXtd>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("AddDrivers_s",
                    (void (*)(  const handle<XmlMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) ) static_cast<void (*)(  const handle<XmlMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) >(&XmlMDataXtd::AddDrivers),
                    R"#(Adds the attribute drivers to <aDriverTable>.)#"  , py::arg("aDriverTable"),  py::arg("anMsgDrv")
          )
        .def_static("SetDocumentVersion_s",
                    (void (*)(  const Standard_Integer  ) ) static_cast<void (*)(  const Standard_Integer  ) >(&XmlMDataXtd::SetDocumentVersion),
                    R"#()#"  , py::arg("DocVersion")
          )
        .def_static("DocumentVersion_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&XmlMDataXtd::DocumentVersion),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class XmlMDataXtd_ConstraintDriver from ./opencascade/XmlMDataXtd_ConstraintDriver.hxx
    klass = m.attr("XmlMDataXtd_ConstraintDriver");


    // nested enums

    static_cast<py::class_<XmlMDataXtd_ConstraintDriver ,opencascade::handle<XmlMDataXtd_ConstraintDriver>  , XmlMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (XmlMDataXtd_ConstraintDriver::*)() const) static_cast<handle<TDF_Attribute> (XmlMDataXtd_ConstraintDriver::*)() const>(&XmlMDataXtd_ConstraintDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (XmlMDataXtd_ConstraintDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (XmlMDataXtd_ConstraintDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const>(&XmlMDataXtd_ConstraintDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (XmlMDataXtd_ConstraintDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const) static_cast<void (XmlMDataXtd_ConstraintDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const>(&XmlMDataXtd_ConstraintDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlMDataXtd_ConstraintDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlMDataXtd_ConstraintDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlMDataXtd_ConstraintDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlMDataXtd_ConstraintDriver::*)() const>(&XmlMDataXtd_ConstraintDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class XmlMDataXtd_GeometryDriver from ./opencascade/XmlMDataXtd_GeometryDriver.hxx
    klass = m.attr("XmlMDataXtd_GeometryDriver");


    // nested enums

    static_cast<py::class_<XmlMDataXtd_GeometryDriver ,opencascade::handle<XmlMDataXtd_GeometryDriver>  , XmlMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (XmlMDataXtd_GeometryDriver::*)() const) static_cast<handle<TDF_Attribute> (XmlMDataXtd_GeometryDriver::*)() const>(&XmlMDataXtd_GeometryDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (XmlMDataXtd_GeometryDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (XmlMDataXtd_GeometryDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const>(&XmlMDataXtd_GeometryDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (XmlMDataXtd_GeometryDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const) static_cast<void (XmlMDataXtd_GeometryDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const>(&XmlMDataXtd_GeometryDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlMDataXtd_GeometryDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlMDataXtd_GeometryDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlMDataXtd_GeometryDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlMDataXtd_GeometryDriver::*)() const>(&XmlMDataXtd_GeometryDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class XmlMDataXtd_PatternStdDriver from ./opencascade/XmlMDataXtd_PatternStdDriver.hxx
    klass = m.attr("XmlMDataXtd_PatternStdDriver");


    // nested enums

    static_cast<py::class_<XmlMDataXtd_PatternStdDriver ,opencascade::handle<XmlMDataXtd_PatternStdDriver>  , XmlMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (XmlMDataXtd_PatternStdDriver::*)() const) static_cast<handle<TDF_Attribute> (XmlMDataXtd_PatternStdDriver::*)() const>(&XmlMDataXtd_PatternStdDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (XmlMDataXtd_PatternStdDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (XmlMDataXtd_PatternStdDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const>(&XmlMDataXtd_PatternStdDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (XmlMDataXtd_PatternStdDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const) static_cast<void (XmlMDataXtd_PatternStdDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const>(&XmlMDataXtd_PatternStdDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlMDataXtd_PatternStdDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlMDataXtd_PatternStdDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlMDataXtd_PatternStdDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlMDataXtd_PatternStdDriver::*)() const>(&XmlMDataXtd_PatternStdDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class XmlMDataXtd_PositionDriver from ./opencascade/XmlMDataXtd_PositionDriver.hxx
    klass = m.attr("XmlMDataXtd_PositionDriver");


    // nested enums

    static_cast<py::class_<XmlMDataXtd_PositionDriver ,opencascade::handle<XmlMDataXtd_PositionDriver>  , XmlMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (XmlMDataXtd_PositionDriver::*)() const) static_cast<handle<TDF_Attribute> (XmlMDataXtd_PositionDriver::*)() const>(&XmlMDataXtd_PositionDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (XmlMDataXtd_PositionDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (XmlMDataXtd_PositionDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const>(&XmlMDataXtd_PositionDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (XmlMDataXtd_PositionDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const) static_cast<void (XmlMDataXtd_PositionDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const>(&XmlMDataXtd_PositionDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlMDataXtd_PositionDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlMDataXtd_PositionDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlMDataXtd_PositionDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlMDataXtd_PositionDriver::*)() const>(&XmlMDataXtd_PositionDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class XmlMDataXtd_PresentationDriver from ./opencascade/XmlMDataXtd_PresentationDriver.hxx
    klass = m.attr("XmlMDataXtd_PresentationDriver");


    // nested enums

    static_cast<py::class_<XmlMDataXtd_PresentationDriver ,opencascade::handle<XmlMDataXtd_PresentationDriver>  , XmlMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (XmlMDataXtd_PresentationDriver::*)() const) static_cast<handle<TDF_Attribute> (XmlMDataXtd_PresentationDriver::*)() const>(&XmlMDataXtd_PresentationDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (XmlMDataXtd_PresentationDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (XmlMDataXtd_PresentationDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const>(&XmlMDataXtd_PresentationDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (XmlMDataXtd_PresentationDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const) static_cast<void (XmlMDataXtd_PresentationDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const>(&XmlMDataXtd_PresentationDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlMDataXtd_PresentationDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlMDataXtd_PresentationDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlMDataXtd_PresentationDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlMDataXtd_PresentationDriver::*)() const>(&XmlMDataXtd_PresentationDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class XmlMDataXtd_TriangulationDriver from ./opencascade/XmlMDataXtd_TriangulationDriver.hxx
    klass = m.attr("XmlMDataXtd_TriangulationDriver");


    // nested enums

    static_cast<py::class_<XmlMDataXtd_TriangulationDriver ,opencascade::handle<XmlMDataXtd_TriangulationDriver>  , XmlMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (XmlMDataXtd_TriangulationDriver::*)() const) static_cast<handle<TDF_Attribute> (XmlMDataXtd_TriangulationDriver::*)() const>(&XmlMDataXtd_TriangulationDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (XmlMDataXtd_TriangulationDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (XmlMDataXtd_TriangulationDriver::*)(  const XmlObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  XmlObjMgt_RRelocationTable &  ) const>(&XmlMDataXtd_TriangulationDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (XmlMDataXtd_TriangulationDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const) static_cast<void (XmlMDataXtd_TriangulationDriver::*)(  const handle<TDF_Attribute> & ,  XmlObjMgt_Persistent & ,  XmlObjMgt_SRelocationTable &  ) const>(&XmlMDataXtd_TriangulationDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XmlMDataXtd_TriangulationDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XmlMDataXtd_TriangulationDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XmlMDataXtd_TriangulationDriver::*)() const) static_cast< const handle<Standard_Type> & (XmlMDataXtd_TriangulationDriver::*)() const>(&XmlMDataXtd_TriangulationDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/XmlMDataXtd.hxx
// ./opencascade/XmlMDataXtd_ConstraintDriver.hxx
// ./opencascade/XmlMDataXtd_GeometryDriver.hxx
// ./opencascade/XmlMDataXtd_PatternStdDriver.hxx
// ./opencascade/XmlMDataXtd_PositionDriver.hxx
// ./opencascade/XmlMDataXtd_PresentationDriver.hxx
// ./opencascade/XmlMDataXtd_TriangulationDriver.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
