
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <XCAFView_Object.hxx>
#include <XCAFView_ProjectionType.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_XCAFView(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("XCAFView"));
py::object klass;

//Python trampoline classes

// classes

    // Class XCAFView_Object from ./opencascade/XCAFView_Object.hxx
    klass = m.attr("XCAFView_Object");


    // nested enums

    static_cast<py::class_<XCAFView_Object ,opencascade::handle<XCAFView_Object>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<XCAFView_Object> & >()  , py::arg("theObj") )
    // custom constructors
    // methods
        .def("SetName",
             (void (XCAFView_Object::*)( handle<TCollection_HAsciiString>  ) ) static_cast<void (XCAFView_Object::*)( handle<TCollection_HAsciiString>  ) >(&XCAFView_Object::SetName),
             R"#()#"  , py::arg("theName")
          )
        .def("Name",
             (handle<TCollection_HAsciiString> (XCAFView_Object::*)() ) static_cast<handle<TCollection_HAsciiString> (XCAFView_Object::*)() >(&XCAFView_Object::Name),
             R"#()#" 
          )
        .def("SetType",
             (void (XCAFView_Object::*)( XCAFView_ProjectionType  ) ) static_cast<void (XCAFView_Object::*)( XCAFView_ProjectionType  ) >(&XCAFView_Object::SetType),
             R"#()#"  , py::arg("theType")
          )
        .def("Type",
             (XCAFView_ProjectionType (XCAFView_Object::*)() ) static_cast<XCAFView_ProjectionType (XCAFView_Object::*)() >(&XCAFView_Object::Type),
             R"#()#" 
          )
        .def("SetProjectionPoint",
             (void (XCAFView_Object::*)(  const gp_Pnt &  ) ) static_cast<void (XCAFView_Object::*)(  const gp_Pnt &  ) >(&XCAFView_Object::SetProjectionPoint),
             R"#()#"  , py::arg("thePoint")
          )
        .def("ProjectionPoint",
             (gp_Pnt (XCAFView_Object::*)() ) static_cast<gp_Pnt (XCAFView_Object::*)() >(&XCAFView_Object::ProjectionPoint),
             R"#()#" 
          )
        .def("SetViewDirection",
             (void (XCAFView_Object::*)(  const gp_Dir &  ) ) static_cast<void (XCAFView_Object::*)(  const gp_Dir &  ) >(&XCAFView_Object::SetViewDirection),
             R"#()#"  , py::arg("theDirection")
          )
        .def("ViewDirection",
             (gp_Dir (XCAFView_Object::*)() ) static_cast<gp_Dir (XCAFView_Object::*)() >(&XCAFView_Object::ViewDirection),
             R"#()#" 
          )
        .def("SetUpDirection",
             (void (XCAFView_Object::*)(  const gp_Dir &  ) ) static_cast<void (XCAFView_Object::*)(  const gp_Dir &  ) >(&XCAFView_Object::SetUpDirection),
             R"#()#"  , py::arg("theDirection")
          )
        .def("UpDirection",
             (gp_Dir (XCAFView_Object::*)() ) static_cast<gp_Dir (XCAFView_Object::*)() >(&XCAFView_Object::UpDirection),
             R"#()#" 
          )
        .def("SetZoomFactor",
             (void (XCAFView_Object::*)( Standard_Real  ) ) static_cast<void (XCAFView_Object::*)( Standard_Real  ) >(&XCAFView_Object::SetZoomFactor),
             R"#()#"  , py::arg("theZoomFactor")
          )
        .def("ZoomFactor",
             (Standard_Real (XCAFView_Object::*)() ) static_cast<Standard_Real (XCAFView_Object::*)() >(&XCAFView_Object::ZoomFactor),
             R"#()#" 
          )
        .def("SetWindowHorizontalSize",
             (void (XCAFView_Object::*)( Standard_Real  ) ) static_cast<void (XCAFView_Object::*)( Standard_Real  ) >(&XCAFView_Object::SetWindowHorizontalSize),
             R"#()#"  , py::arg("theSize")
          )
        .def("WindowHorizontalSize",
             (Standard_Real (XCAFView_Object::*)() ) static_cast<Standard_Real (XCAFView_Object::*)() >(&XCAFView_Object::WindowHorizontalSize),
             R"#()#" 
          )
        .def("SetWindowVerticalSize",
             (void (XCAFView_Object::*)( Standard_Real  ) ) static_cast<void (XCAFView_Object::*)( Standard_Real  ) >(&XCAFView_Object::SetWindowVerticalSize),
             R"#()#"  , py::arg("theSize")
          )
        .def("WindowVerticalSize",
             (Standard_Real (XCAFView_Object::*)() ) static_cast<Standard_Real (XCAFView_Object::*)() >(&XCAFView_Object::WindowVerticalSize),
             R"#()#" 
          )
        .def("SetClippingExpression",
             (void (XCAFView_Object::*)( handle<TCollection_HAsciiString>  ) ) static_cast<void (XCAFView_Object::*)( handle<TCollection_HAsciiString>  ) >(&XCAFView_Object::SetClippingExpression),
             R"#()#"  , py::arg("theExpression")
          )
        .def("ClippingExpression",
             (handle<TCollection_HAsciiString> (XCAFView_Object::*)() ) static_cast<handle<TCollection_HAsciiString> (XCAFView_Object::*)() >(&XCAFView_Object::ClippingExpression),
             R"#()#" 
          )
        .def("UnsetFrontPlaneClipping",
             (void (XCAFView_Object::*)() ) static_cast<void (XCAFView_Object::*)() >(&XCAFView_Object::UnsetFrontPlaneClipping),
             R"#()#" 
          )
        .def("HasFrontPlaneClipping",
             (Standard_Boolean (XCAFView_Object::*)() ) static_cast<Standard_Boolean (XCAFView_Object::*)() >(&XCAFView_Object::HasFrontPlaneClipping),
             R"#()#" 
          )
        .def("SetFrontPlaneDistance",
             (void (XCAFView_Object::*)( Standard_Real  ) ) static_cast<void (XCAFView_Object::*)( Standard_Real  ) >(&XCAFView_Object::SetFrontPlaneDistance),
             R"#()#"  , py::arg("theDistance")
          )
        .def("FrontPlaneDistance",
             (Standard_Real (XCAFView_Object::*)() ) static_cast<Standard_Real (XCAFView_Object::*)() >(&XCAFView_Object::FrontPlaneDistance),
             R"#()#" 
          )
        .def("UnsetBackPlaneClipping",
             (void (XCAFView_Object::*)() ) static_cast<void (XCAFView_Object::*)() >(&XCAFView_Object::UnsetBackPlaneClipping),
             R"#()#" 
          )
        .def("HasBackPlaneClipping",
             (Standard_Boolean (XCAFView_Object::*)() ) static_cast<Standard_Boolean (XCAFView_Object::*)() >(&XCAFView_Object::HasBackPlaneClipping),
             R"#()#" 
          )
        .def("SetBackPlaneDistance",
             (void (XCAFView_Object::*)( Standard_Real  ) ) static_cast<void (XCAFView_Object::*)( Standard_Real  ) >(&XCAFView_Object::SetBackPlaneDistance),
             R"#()#"  , py::arg("theDistance")
          )
        .def("BackPlaneDistance",
             (Standard_Real (XCAFView_Object::*)() ) static_cast<Standard_Real (XCAFView_Object::*)() >(&XCAFView_Object::BackPlaneDistance),
             R"#()#" 
          )
        .def("SetViewVolumeSidesClipping",
             (void (XCAFView_Object::*)( Standard_Boolean  ) ) static_cast<void (XCAFView_Object::*)( Standard_Boolean  ) >(&XCAFView_Object::SetViewVolumeSidesClipping),
             R"#()#"  , py::arg("theViewVolumeSidesClipping")
          )
        .def("HasViewVolumeSidesClipping",
             (Standard_Boolean (XCAFView_Object::*)() ) static_cast<Standard_Boolean (XCAFView_Object::*)() >(&XCAFView_Object::HasViewVolumeSidesClipping),
             R"#()#" 
          )
        .def("CreateGDTPoints",
             (void (XCAFView_Object::*)(  const Standard_Integer  ) ) static_cast<void (XCAFView_Object::*)(  const Standard_Integer  ) >(&XCAFView_Object::CreateGDTPoints),
             R"#()#"  , py::arg("theLenght")
          )
        .def("HasGDTPoints",
             (Standard_Boolean (XCAFView_Object::*)() ) static_cast<Standard_Boolean (XCAFView_Object::*)() >(&XCAFView_Object::HasGDTPoints),
             R"#()#" 
          )
        .def("NbGDTPoints",
             (Standard_Integer (XCAFView_Object::*)() ) static_cast<Standard_Integer (XCAFView_Object::*)() >(&XCAFView_Object::NbGDTPoints),
             R"#()#" 
          )
        .def("SetGDTPoint",
             (void (XCAFView_Object::*)(  const Standard_Integer ,   const gp_Pnt &  ) ) static_cast<void (XCAFView_Object::*)(  const Standard_Integer ,   const gp_Pnt &  ) >(&XCAFView_Object::SetGDTPoint),
             R"#()#"  , py::arg("theIndex"),  py::arg("thePoint")
          )
        .def("GDTPoint",
             (gp_Pnt (XCAFView_Object::*)(  const Standard_Integer  ) ) static_cast<gp_Pnt (XCAFView_Object::*)(  const Standard_Integer  ) >(&XCAFView_Object::GDTPoint),
             R"#()#"  , py::arg("theIndex")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XCAFView_Object::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XCAFView_Object::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (XCAFView_Object::*)() const) static_cast< const handle<Standard_Type> & (XCAFView_Object::*)() const>(&XCAFView_Object::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/XCAFView_Object.hxx
// ./opencascade/XCAFView_ProjectionType.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
