
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Label.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XCAFPrs_Style.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDocStd_Document.hxx>
#include <XCAFDoc_ColorTool.hxx>
#include <XCAFDoc_VisMaterialTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDF_Label.hxx>
#include <AIS_InteractiveObject.hxx>
#include <Standard_GUID.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <XCAFPrs.hxx>
#include <XCAFPrs_AISObject.hxx>
#include <XCAFPrs_DataMapIteratorOfDataMapOfStyleShape.hxx>
#include <XCAFPrs_DataMapIteratorOfDataMapOfStyleTransient.hxx>
#include <XCAFPrs_DataMapIteratorOfIndexedDataMapOfShapeStyle.hxx>
#include <XCAFPrs_DataMapOfStyleShape.hxx>
#include <XCAFPrs_DataMapOfStyleTransient.hxx>
#include <XCAFPrs_DocumentExplorer.hxx>
#include <XCAFPrs_DocumentIdIterator.hxx>
#include <XCAFPrs_DocumentNode.hxx>
#include <XCAFPrs_Driver.hxx>
#include <XCAFPrs_IndexedDataMapOfShapeStyle.hxx>
#include <XCAFPrs_Style.hxx>
#include <XCAFPrs_Texture.hxx>

// template related includes

#include "NCollection_tmpl.hxx"

#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <Image_SupportedFormats.hxx>
#include <Image_CompressedPixMap.hxx>

// Module definiiton
void register_XCAFPrs_enums(py::module &main_module) {


py::module m = main_module.def_submodule("XCAFPrs", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums
    m.attr("XCAFPrs_DocumentExplorerFlags_None") = py::cast(int(XCAFPrs_DocumentExplorerFlags_None));
    m.attr("XCAFPrs_DocumentExplorerFlags_OnlyLeafNodes") = py::cast(int(XCAFPrs_DocumentExplorerFlags_OnlyLeafNodes));
    m.attr("XCAFPrs_DocumentExplorerFlags_NoStyle") = py::cast(int(XCAFPrs_DocumentExplorerFlags_NoStyle));

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<XCAFPrs , shared_ptr<XCAFPrs>  >(m,"XCAFPrs",R"#(Presentation (visualiation, selection etc.) tools for DECAF documents)#");
    py::class_<XCAFPrs_DocumentExplorer , shared_ptr<XCAFPrs_DocumentExplorer>  >(m,"XCAFPrs_DocumentExplorer",R"#(Document iterator through shape nodes.)#");
    py::class_<XCAFPrs_DocumentIdIterator , shared_ptr<XCAFPrs_DocumentIdIterator>  >(m,"XCAFPrs_DocumentIdIterator",R"#(Auxiliary tool for iterating through Path identification string.)#");
    py::class_<XCAFPrs_DocumentNode , shared_ptr<XCAFPrs_DocumentNode>  >(m,"XCAFPrs_DocumentNode",R"#(Structure defining document node.)#");
    py::class_<XCAFPrs_Style , shared_ptr<XCAFPrs_Style>  >(m,"XCAFPrs_Style",R"#(Represents a set of styling settings applicable to a (sub)shape)#");
    py::class_<XCAFPrs_AISObject ,opencascade::handle<XCAFPrs_AISObject>  , AIS_ColoredShape >(m,"XCAFPrs_AISObject",R"#(Implements AIS_InteractiveObject functionality for shape in DECAF document.Implements AIS_InteractiveObject functionality for shape in DECAF document.)#");
    preregister_template_NCollection_DataMap<XCAFPrs_Style, TopoDS_Shape>(m,"XCAFPrs_DataMapOfStyleShape");
    py::class_<XCAFPrs_Driver ,opencascade::handle<XCAFPrs_Driver>  , TPrsStd_Driver >(m,"XCAFPrs_Driver",R"#(Implements a driver for presentation of shapes in DECAF document. Its the only purpose is to initialize and return XCAFPrs_AISObject object on requestImplements a driver for presentation of shapes in DECAF document. Its the only purpose is to initialize and return XCAFPrs_AISObject object on requestImplements a driver for presentation of shapes in DECAF document. Its the only purpose is to initialize and return XCAFPrs_AISObject object on request)#");
    preregister_template_NCollection_IndexedDataMap<TopoDS_Shape, XCAFPrs_Style, TopTools_ShapeMapHasher>(m,"XCAFPrs_IndexedDataMapOfShapeStyle");
    py::class_<XCAFPrs_Texture ,opencascade::handle<XCAFPrs_Texture>  , Graphic3d_Texture2D >(m,"XCAFPrs_Texture",R"#(Texture holder.)#");

};

// user-defined post-inclusion per module

// user-defined post
