
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRepDS_HDataStructure.hxx>
#include <TopOpeBRep_Point2d.hxx>
#include <Bnd_Box.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRep_LineInter.hxx>
#include <TopOpeBRep_VPointInter.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRepDS_Transition.hxx>
#include <TopOpeBRep_VPointInter.hxx>
#include <TopOpeBRep_LineInter.hxx>
#include <TopoDS_Shape.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <TopOpeBRep_FaceEdgeIntersector.hxx>
#include <TopOpeBRepDS_HDataStructure.hxx>
#include <TopOpeBRepDS_Point.hxx>
#include <TopOpeBRepDS_DataStructure.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRepDS_Transition.hxx>
#include <TopOpeBRepDS_HDataStructure.hxx>
#include <TopOpeBRep_FFDumper.hxx>
#include <TopOpeBRep_VPointInter.hxx>
#include <TopOpeBRep_VPointInterClassifier.hxx>
#include <TopOpeBRep_VPointInterIterator.hxx>
#include <TopOpeBRepDS_Point.hxx>
#include <BRepTopAdaptor_TopolTool.hxx>
#include <Bnd_Box.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRep_LineInter.hxx>
#include <TopoDS_Shape.hxx>
#include <TopOpeBRepDS_Curve.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom_Curve.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BRepAdaptor_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IntPatch_ALine.hxx>
#include <IntPatch_RLine.hxx>
#include <IntPatch_WLine.hxx>
#include <IntPatch_GLine.hxx>
#include <BRepAdaptor_Surface.hxx>
#include <Geom_Curve.hxx>
#include <TopOpeBRep_Bipoint.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRep_EdgesIntersector.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRep_FacesFiller.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRep_FacesIntersector.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IntRes2d_IntersectionPoint.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRep_LineInter.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IntSurf_PntOn2S.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IntPatch_Point.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRep_Hctxff2d.hxx>
#include <TopOpeBRep_Hctxee2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRepDS_Point.hxx>
#include <TopOpeBRep_VPointInter.hxx>
#include <TopOpeBRep_Point2d.hxx>
#include <TopOpeBRep_FaceEdgeIntersector.hxx>
#include <TopoDS_Shape.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRepTool_HBoxTool.hxx>
#include <TopOpeBRepTool_HBoxTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRepTool_ShapeExplorer.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Face.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRep_VPointInter.hxx>
#include <TopOpeBRep_PointClassifier.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRep_VPointInter.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt2d.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopOpeBRep_WPointInter.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <TopOpeBRep.hxx>
#include <TopOpeBRep_Array1OfLineInter.hxx>
#include <TopOpeBRep_Array1OfVPointInter.hxx>
#include <TopOpeBRep_Bipoint.hxx>
#include <TopOpeBRep_DataMapIteratorOfDataMapOfTopolTool.hxx>
#include <TopOpeBRep_DataMapOfTopolTool.hxx>
#include <TopOpeBRep_define.hxx>
#include <TopOpeBRep_DRAW.hxx>
#include <TopOpeBRep_DSFiller.hxx>
#include <TopOpeBRep_EdgesFiller.hxx>
#include <TopOpeBRep_EdgesIntersector.hxx>
#include <TopOpeBRep_FaceEdgeFiller.hxx>
#include <TopOpeBRep_FaceEdgeIntersector.hxx>
#include <TopOpeBRep_FacesFiller.hxx>
#include <TopOpeBRep_FacesIntersector.hxx>
#include <TopOpeBRep_FFDumper.hxx>
#include <TopOpeBRep_FFTransitionTool.hxx>
#include <TopOpeBRep_GeomTool.hxx>
#include <TopOpeBRep_HArray1OfLineInter.hxx>
#include <TopOpeBRep_HArray1OfVPointInter.hxx>
#include <TopOpeBRep_Hctxee2d.hxx>
#include <TopOpeBRep_Hctxff2d.hxx>
#include <TopOpeBRep_LineInter.hxx>
#include <TopOpeBRep_ListIteratorOfListOfBipoint.hxx>
#include <TopOpeBRep_ListOfBipoint.hxx>
#include <TopOpeBRep_P2Dstatus.hxx>
#include <TopOpeBRep_PEdgesIntersector.hxx>
#include <TopOpeBRep_PFacesFiller.hxx>
#include <TopOpeBRep_PFacesIntersector.hxx>
#include <TopOpeBRep_PIntRes2d_IntersectionPoint.hxx>
#include <TopOpeBRep_PLineInter.hxx>
#include <TopOpeBRep_Point2d.hxx>
#include <TopOpeBRep_PointClassifier.hxx>
#include <TopOpeBRep_PointGeomTool.hxx>
#include <TopOpeBRep_PPntOn2S.hxx>
#include <TopOpeBRep_PThePointOfIntersection.hxx>
#include <TopOpeBRep_SequenceOfPoint2d.hxx>
#include <TopOpeBRep_ShapeIntersector.hxx>
#include <TopOpeBRep_ShapeIntersector2d.hxx>
#include <TopOpeBRep_ShapeScanner.hxx>
#include <TopOpeBRep_traceSIFF.hxx>
#include <TopOpeBRep_TypeLineCurve.hxx>
#include <TopOpeBRep_VPointInter.hxx>
#include <TopOpeBRep_VPointInterClassifier.hxx>
#include <TopOpeBRep_VPointInterIterator.hxx>
#include <TopOpeBRep_WPointInter.hxx>
#include <TopOpeBRep_WPointInterIterator.hxx>

// template related includes

// ./opencascade/TopOpeBRep_Array1OfLineInter.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/TopOpeBRep_Array1OfVPointInter.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/TopOpeBRep_DataMapOfTopolTool.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/TopOpeBRep_ListOfBipoint.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/TopOpeBRep_ListOfBipoint.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/TopOpeBRep_SequenceOfPoint2d.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_TopOpeBRep(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("TopOpeBRep"));
py::object klass;

//Python trampoline classes

// classes

    // Class TopOpeBRep from ./opencascade/TopOpeBRep.hxx
    klass = m.attr("TopOpeBRep");

    // default constructor
    register_default_constructor<TopOpeBRep , shared_ptr<TopOpeBRep>>(m,"TopOpeBRep");

    // nested enums

    static_cast<py::class_<TopOpeBRep , shared_ptr<TopOpeBRep>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Print_s",
                    (Standard_OStream & (*)(  const TopOpeBRep_TypeLineCurve ,  Standard_OStream &  ) ) static_cast<Standard_OStream & (*)(  const TopOpeBRep_TypeLineCurve ,  Standard_OStream &  ) >(&TopOpeBRep::Print),
                    R"#(Prints the name of <TLC> as a String on the Stream <S> and returns <S>.)#"  , py::arg("TLC"),  py::arg("OS")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class TopOpeBRep_Bipoint from ./opencascade/TopOpeBRep_Bipoint.hxx
    klass = m.attr("TopOpeBRep_Bipoint");


    // nested enums

    static_cast<py::class_<TopOpeBRep_Bipoint , shared_ptr<TopOpeBRep_Bipoint>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const Standard_Integer, const Standard_Integer >()  , py::arg("I1"),  py::arg("I2") )
    // custom constructors
    // methods
        .def("I1",
             (Standard_Integer (TopOpeBRep_Bipoint::*)() const) static_cast<Standard_Integer (TopOpeBRep_Bipoint::*)() const>(&TopOpeBRep_Bipoint::I1),
             R"#()#" 
          )
        .def("I2",
             (Standard_Integer (TopOpeBRep_Bipoint::*)() const) static_cast<Standard_Integer (TopOpeBRep_Bipoint::*)() const>(&TopOpeBRep_Bipoint::I2),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class TopOpeBRep_DSFiller from ./opencascade/TopOpeBRep_DSFiller.hxx
    klass = m.attr("TopOpeBRep_DSFiller");


    // nested enums

    static_cast<py::class_<TopOpeBRep_DSFiller , shared_ptr<TopOpeBRep_DSFiller>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Insert",
             (void (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const handle<TopOpeBRepDS_HDataStructure> & ,   const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const handle<TopOpeBRepDS_HDataStructure> & ,   const Standard_Boolean  ) >(&TopOpeBRep_DSFiller::Insert),
             R"#(Stores in <DS> the intersections of <S1> and <S2>. if orientFORWARD = True S FORWARD,REVERSED --> FORWARD S EXTERNAL,INTERNAL --> EXTERNAL,INTERNAL)#"  , py::arg("S1"),  py::arg("S2"),  py::arg("HDS"),  py::arg("orientFORWARD")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("InsertIntersection",
             (void (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const handle<TopOpeBRepDS_HDataStructure> & ,   const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const handle<TopOpeBRepDS_HDataStructure> & ,   const Standard_Boolean  ) >(&TopOpeBRep_DSFiller::InsertIntersection),
             R"#(Stores in <DS> the intersections of <S1> and <S2>. if orientFORWARD = True S FORWAR,REVERSED --> FORWARD S EXTERNAL,INTERNAL --> EXTERNAL,INTERNAL)#"  , py::arg("S1"),  py::arg("S2"),  py::arg("HDS"),  py::arg("orientFORWARD")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("Complete",
             (void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) ) static_cast<void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) >(&TopOpeBRep_DSFiller::Complete),
             R"#()#"  , py::arg("HDS")
          )
        .def("Insert2d",
             (void (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const handle<TopOpeBRepDS_HDataStructure> &  ) ) static_cast<void (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const handle<TopOpeBRepDS_HDataStructure> &  ) >(&TopOpeBRep_DSFiller::Insert2d),
             R"#(Stores in <DS> the intersections of <S1> and <S2>. S1 et S2 contain only SameDomain Face)#"  , py::arg("S1"),  py::arg("S2"),  py::arg("HDS")
          )
        .def("InsertIntersection2d",
             (void (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const handle<TopOpeBRepDS_HDataStructure> &  ) ) static_cast<void (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const handle<TopOpeBRepDS_HDataStructure> &  ) >(&TopOpeBRep_DSFiller::InsertIntersection2d),
             R"#(S1, S2 set of tangent face lance les intersections 2d pour coder correctement les faces SameDomain.)#"  , py::arg("S1"),  py::arg("S2"),  py::arg("HDS")
          )
        .def("IsMadeOf1d",
             (Standard_Boolean (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape &  ) const) static_cast<Standard_Boolean (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape &  ) const>(&TopOpeBRep_DSFiller::IsMadeOf1d),
             R"#()#"  , py::arg("S")
          )
        .def("IsContext1d",
             (Standard_Boolean (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape &  ) const) static_cast<Standard_Boolean (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape &  ) const>(&TopOpeBRep_DSFiller::IsContext1d),
             R"#()#"  , py::arg("S")
          )
        .def("Insert1d",
             (void (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const TopoDS_Face & ,   const TopoDS_Face & ,   const handle<TopOpeBRepDS_HDataStructure> & ,   const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_DSFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const TopoDS_Face & ,   const TopoDS_Face & ,   const handle<TopOpeBRepDS_HDataStructure> & ,   const Standard_Boolean  ) >(&TopOpeBRep_DSFiller::Insert1d),
             R"#(Stores in <DS> the intersections of <S1> and <S2>. S1 and S2 are edges or wires. S1 edges have a 2d representation in face F1 S2 edges have a 2d representation in face F2 F1 is the face which surface is taken as reference for 2d description of S1 and S2 edges. if orientFORWARD = True S FORWARD,REVERSED --> FORWARD S EXTERNAL,INTERNAL --> EXTERNAL,INTERNAL)#"  , py::arg("S1"),  py::arg("S2"),  py::arg("F1"),  py::arg("F2"),  py::arg("HDS"),  py::arg("orientFORWARD")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def("GapFiller",
             (void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) const) static_cast<void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) const>(&TopOpeBRep_DSFiller::GapFiller),
             R"#()#"  , py::arg("HDS")
          )
        .def("CompleteDS",
             (void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) const) static_cast<void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) const>(&TopOpeBRep_DSFiller::CompleteDS),
             R"#(Update the data structure with relevant information deduced from the intersections.)#"  , py::arg("HDS")
          )
        .def("Filter",
             (void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) const) static_cast<void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) const>(&TopOpeBRep_DSFiller::Filter),
             R"#()#"  , py::arg("HDS")
          )
        .def("Reducer",
             (void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) const) static_cast<void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) const>(&TopOpeBRep_DSFiller::Reducer),
             R"#()#"  , py::arg("HDS")
          )
        .def("RemoveUnsharedGeometry",
             (void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) ) static_cast<void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) >(&TopOpeBRep_DSFiller::RemoveUnsharedGeometry),
             R"#()#"  , py::arg("HDS")
          )
        .def("Checker",
             (void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) const) static_cast<void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) const>(&TopOpeBRep_DSFiller::Checker),
             R"#()#"  , py::arg("HDS")
          )
        .def("CompleteDS2d",
             (void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) const) static_cast<void (TopOpeBRep_DSFiller::*)(  const handle<TopOpeBRepDS_HDataStructure> &  ) const>(&TopOpeBRep_DSFiller::CompleteDS2d),
             R"#(Update the data structure with relevant information deduced from the intersections 2d.)#"  , py::arg("HDS")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ChangeShapeIntersector",
             (TopOpeBRep_ShapeIntersector & (TopOpeBRep_DSFiller::*)() ) static_cast<TopOpeBRep_ShapeIntersector & (TopOpeBRep_DSFiller::*)() >(&TopOpeBRep_DSFiller::ChangeShapeIntersector),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ChangeShapeIntersector2d",
             (TopOpeBRep_ShapeIntersector2d & (TopOpeBRep_DSFiller::*)() ) static_cast<TopOpeBRep_ShapeIntersector2d & (TopOpeBRep_DSFiller::*)() >(&TopOpeBRep_DSFiller::ChangeShapeIntersector2d),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ChangeFacesFiller",
             (TopOpeBRep_FacesFiller & (TopOpeBRep_DSFiller::*)() ) static_cast<TopOpeBRep_FacesFiller & (TopOpeBRep_DSFiller::*)() >(&TopOpeBRep_DSFiller::ChangeFacesFiller),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ChangeEdgesFiller",
             (TopOpeBRep_EdgesFiller & (TopOpeBRep_DSFiller::*)() ) static_cast<TopOpeBRep_EdgesFiller & (TopOpeBRep_DSFiller::*)() >(&TopOpeBRep_DSFiller::ChangeEdgesFiller),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ChangeFaceEdgeFiller",
             (TopOpeBRep_FaceEdgeFiller & (TopOpeBRep_DSFiller::*)() ) static_cast<TopOpeBRep_FaceEdgeFiller & (TopOpeBRep_DSFiller::*)() >(&TopOpeBRep_DSFiller::ChangeFaceEdgeFiller),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class TopOpeBRep_EdgesFiller from ./opencascade/TopOpeBRep_EdgesFiller.hxx
    klass = m.attr("TopOpeBRep_EdgesFiller");


    // nested enums

    static_cast<py::class_<TopOpeBRep_EdgesFiller , shared_ptr<TopOpeBRep_EdgesFiller>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Insert",
             (void (TopOpeBRep_EdgesFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,  TopOpeBRep_EdgesIntersector & ,   const handle<TopOpeBRepDS_HDataStructure> &  ) ) static_cast<void (TopOpeBRep_EdgesFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,  TopOpeBRep_EdgesIntersector & ,   const handle<TopOpeBRepDS_HDataStructure> &  ) >(&TopOpeBRep_EdgesFiller::Insert),
             R"#()#"  , py::arg("E1"),  py::arg("E2"),  py::arg("EI"),  py::arg("HDS")
          )
        .def("Face",
             (void (TopOpeBRep_EdgesFiller::*)(  const Standard_Integer ,   const TopoDS_Shape &  ) ) static_cast<void (TopOpeBRep_EdgesFiller::*)(  const Standard_Integer ,   const TopoDS_Shape &  ) >(&TopOpeBRep_EdgesFiller::Face),
             R"#()#"  , py::arg("I"),  py::arg("F")
          )
        .def("Face",
             ( const TopoDS_Shape & (TopOpeBRep_EdgesFiller::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Shape & (TopOpeBRep_EdgesFiller::*)(  const Standard_Integer  ) const>(&TopOpeBRep_EdgesFiller::Face),
             R"#()#"  , py::arg("I")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class TopOpeBRep_EdgesIntersector from ./opencascade/TopOpeBRep_EdgesIntersector.hxx
    klass = m.attr("TopOpeBRep_EdgesIntersector");


    // nested enums

    static_cast<py::class_<TopOpeBRep_EdgesIntersector , shared_ptr<TopOpeBRep_EdgesIntersector>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetFaces",
             (void (TopOpeBRep_EdgesIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<void (TopOpeBRep_EdgesIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&TopOpeBRep_EdgesIntersector::SetFaces),
             R"#()#"  , py::arg("F1"),  py::arg("F2")
          )
        .def("SetFaces",
             (void (TopOpeBRep_EdgesIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const Bnd_Box & ,   const Bnd_Box &  ) ) static_cast<void (TopOpeBRep_EdgesIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const Bnd_Box & ,   const Bnd_Box &  ) >(&TopOpeBRep_EdgesIntersector::SetFaces),
             R"#()#"  , py::arg("F1"),  py::arg("F2"),  py::arg("B1"),  py::arg("B2")
          )
        .def("ForceTolerances",
             (void (TopOpeBRep_EdgesIntersector::*)(  const Standard_Real ,   const Standard_Real  ) ) static_cast<void (TopOpeBRep_EdgesIntersector::*)(  const Standard_Real ,   const Standard_Real  ) >(&TopOpeBRep_EdgesIntersector::ForceTolerances),
             R"#()#"  , py::arg("Tol1"),  py::arg("Tol2")
          )
        .def("Dimension",
             (void (TopOpeBRep_EdgesIntersector::*)(  const Standard_Integer  ) ) static_cast<void (TopOpeBRep_EdgesIntersector::*)(  const Standard_Integer  ) >(&TopOpeBRep_EdgesIntersector::Dimension),
             R"#()#"  , py::arg("D")
          )
        .def("Dimension",
             (Standard_Integer (TopOpeBRep_EdgesIntersector::*)() const) static_cast<Standard_Integer (TopOpeBRep_EdgesIntersector::*)() const>(&TopOpeBRep_EdgesIntersector::Dimension),
             R"#(set working space dimension D = 1 for E &|| W, 2 for E in F)#" 
          )
        .def("Perform",
             (void (TopOpeBRep_EdgesIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_EdgesIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const Standard_Boolean  ) >(&TopOpeBRep_EdgesIntersector::Perform),
             R"#()#"  , py::arg("E1"),  py::arg("E2"),  py::arg("ReduceSegments")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("IsEmpty",
             (Standard_Boolean (TopOpeBRep_EdgesIntersector::*)() ) static_cast<Standard_Boolean (TopOpeBRep_EdgesIntersector::*)() >(&TopOpeBRep_EdgesIntersector::IsEmpty),
             R"#()#" 
          )
        .def("HasSegment",
             (Standard_Boolean (TopOpeBRep_EdgesIntersector::*)() const) static_cast<Standard_Boolean (TopOpeBRep_EdgesIntersector::*)() const>(&TopOpeBRep_EdgesIntersector::HasSegment),
             R"#(true if at least one intersection segment.)#" 
          )
        .def("SameDomain",
             (Standard_Boolean (TopOpeBRep_EdgesIntersector::*)() const) static_cast<Standard_Boolean (TopOpeBRep_EdgesIntersector::*)() const>(&TopOpeBRep_EdgesIntersector::SameDomain),
             R"#(= mySameDomain.)#" 
          )
        .def("Edge",
             ( const TopoDS_Shape & (TopOpeBRep_EdgesIntersector::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Shape & (TopOpeBRep_EdgesIntersector::*)(  const Standard_Integer  ) const>(&TopOpeBRep_EdgesIntersector::Edge),
             R"#()#"  , py::arg("Index")
          )
        .def("Curve",
             ( const Geom2dAdaptor_Curve & (TopOpeBRep_EdgesIntersector::*)(  const Standard_Integer  ) const) static_cast< const Geom2dAdaptor_Curve & (TopOpeBRep_EdgesIntersector::*)(  const Standard_Integer  ) const>(&TopOpeBRep_EdgesIntersector::Curve),
             R"#()#"  , py::arg("Index")
          )
        .def("Face",
             ( const TopoDS_Shape & (TopOpeBRep_EdgesIntersector::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Shape & (TopOpeBRep_EdgesIntersector::*)(  const Standard_Integer  ) const>(&TopOpeBRep_EdgesIntersector::Face),
             R"#()#"  , py::arg("Index")
          )
        .def("Surface",
             ( const BRepAdaptor_Surface & (TopOpeBRep_EdgesIntersector::*)(  const Standard_Integer  ) const) static_cast< const BRepAdaptor_Surface & (TopOpeBRep_EdgesIntersector::*)(  const Standard_Integer  ) const>(&TopOpeBRep_EdgesIntersector::Surface),
             R"#()#"  , py::arg("Index")
          )
        .def("SurfacesSameOriented",
             (Standard_Boolean (TopOpeBRep_EdgesIntersector::*)() const) static_cast<Standard_Boolean (TopOpeBRep_EdgesIntersector::*)() const>(&TopOpeBRep_EdgesIntersector::SurfacesSameOriented),
             R"#()#" 
          )
        .def("FacesSameOriented",
             (Standard_Boolean (TopOpeBRep_EdgesIntersector::*)() const) static_cast<Standard_Boolean (TopOpeBRep_EdgesIntersector::*)() const>(&TopOpeBRep_EdgesIntersector::FacesSameOriented),
             R"#()#" 
          )
        .def("ToleranceMax",
             (Standard_Real (TopOpeBRep_EdgesIntersector::*)() const) static_cast<Standard_Real (TopOpeBRep_EdgesIntersector::*)() const>(&TopOpeBRep_EdgesIntersector::ToleranceMax),
             R"#()#" 
          )
        .def("NbPoints",
             (Standard_Integer (TopOpeBRep_EdgesIntersector::*)() const) static_cast<Standard_Integer (TopOpeBRep_EdgesIntersector::*)() const>(&TopOpeBRep_EdgesIntersector::NbPoints),
             R"#()#" 
          )
        .def("NbSegments",
             (Standard_Integer (TopOpeBRep_EdgesIntersector::*)() const) static_cast<Standard_Integer (TopOpeBRep_EdgesIntersector::*)() const>(&TopOpeBRep_EdgesIntersector::NbSegments),
             R"#()#" 
          )
        .def("Dump",
             (void (TopOpeBRep_EdgesIntersector::*)(  const TCollection_AsciiString & ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (TopOpeBRep_EdgesIntersector::*)(  const TCollection_AsciiString & ,   const Standard_Integer ,   const Standard_Integer  ) >(&TopOpeBRep_EdgesIntersector::Dump),
             R"#()#"  , py::arg("str"),  py::arg("ie1")=static_cast< const Standard_Integer>(0),  py::arg("ie2")=static_cast< const Standard_Integer>(0)
          )
        .def("InitPoint",
             (void (TopOpeBRep_EdgesIntersector::*)(  const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_EdgesIntersector::*)(  const Standard_Boolean  ) >(&TopOpeBRep_EdgesIntersector::InitPoint),
             R"#()#"  , py::arg("selectkeep")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("MorePoint",
             (Standard_Boolean (TopOpeBRep_EdgesIntersector::*)() const) static_cast<Standard_Boolean (TopOpeBRep_EdgesIntersector::*)() const>(&TopOpeBRep_EdgesIntersector::MorePoint),
             R"#()#" 
          )
        .def("NextPoint",
             (void (TopOpeBRep_EdgesIntersector::*)() ) static_cast<void (TopOpeBRep_EdgesIntersector::*)() >(&TopOpeBRep_EdgesIntersector::NextPoint),
             R"#()#" 
          )
        .def("Point",
             ( const TopOpeBRep_Point2d & (TopOpeBRep_EdgesIntersector::*)(  const Standard_Integer  ) const) static_cast< const TopOpeBRep_Point2d & (TopOpeBRep_EdgesIntersector::*)(  const Standard_Integer  ) const>(&TopOpeBRep_EdgesIntersector::Point),
             R"#()#"  , py::arg("I")
          )
        .def("ReduceSegment",
             (Standard_Boolean (TopOpeBRep_EdgesIntersector::*)( TopOpeBRep_Point2d & ,  TopOpeBRep_Point2d & ,  TopOpeBRep_Point2d &  ) const) static_cast<Standard_Boolean (TopOpeBRep_EdgesIntersector::*)( TopOpeBRep_Point2d & ,  TopOpeBRep_Point2d & ,  TopOpeBRep_Point2d &  ) const>(&TopOpeBRep_EdgesIntersector::ReduceSegment),
             R"#()#"  , py::arg("P1"),  py::arg("P2"),  py::arg("Pn")
          )
        .def("Status1",
             (TopOpeBRep_P2Dstatus (TopOpeBRep_EdgesIntersector::*)() const) static_cast<TopOpeBRep_P2Dstatus (TopOpeBRep_EdgesIntersector::*)() const>(&TopOpeBRep_EdgesIntersector::Status1),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
        .def("Tolerances",
             []( TopOpeBRep_EdgesIntersector &self   ){
                 Standard_Real  tol1;
                Standard_Real  tol2;

                 self.Tolerances(tol1,tol2);
                 
                 return std::make_tuple(tol1,tol2); },
             R"#()#" 
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Points",
             ( const TopOpeBRep_SequenceOfPoint2d & (TopOpeBRep_EdgesIntersector::*)() const) static_cast< const TopOpeBRep_SequenceOfPoint2d & (TopOpeBRep_EdgesIntersector::*)() const>(&TopOpeBRep_EdgesIntersector::Points),
             R"#()#"
             
         )
       .def("Point",
             ( const TopOpeBRep_Point2d & (TopOpeBRep_EdgesIntersector::*)() const) static_cast< const TopOpeBRep_Point2d & (TopOpeBRep_EdgesIntersector::*)() const>(&TopOpeBRep_EdgesIntersector::Point),
             R"#()#"
             
         )
;

    // Class TopOpeBRep_FFDumper from ./opencascade/TopOpeBRep_FFDumper.hxx
    klass = m.attr("TopOpeBRep_FFDumper");


    // nested enums

    static_cast<py::class_<TopOpeBRep_FFDumper ,opencascade::handle<TopOpeBRep_FFDumper>  , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("DumpLine",
             (void (TopOpeBRep_FFDumper::*)(  const Standard_Integer  ) ) static_cast<void (TopOpeBRep_FFDumper::*)(  const Standard_Integer  ) >(&TopOpeBRep_FFDumper::DumpLine),
             R"#()#"  , py::arg("I")
          )
        .def("DumpLine",
             (void (TopOpeBRep_FFDumper::*)(  const TopOpeBRep_LineInter &  ) ) static_cast<void (TopOpeBRep_FFDumper::*)(  const TopOpeBRep_LineInter &  ) >(&TopOpeBRep_FFDumper::DumpLine),
             R"#()#"  , py::arg("L")
          )
        .def("DumpVP",
             (void (TopOpeBRep_FFDumper::*)(  const TopOpeBRep_VPointInter &  ) ) static_cast<void (TopOpeBRep_FFDumper::*)(  const TopOpeBRep_VPointInter &  ) >(&TopOpeBRep_FFDumper::DumpVP),
             R"#()#"  , py::arg("VP")
          )
        .def("DumpVP",
             (void (TopOpeBRep_FFDumper::*)(  const TopOpeBRep_VPointInter & ,   const Standard_Integer  ) ) static_cast<void (TopOpeBRep_FFDumper::*)(  const TopOpeBRep_VPointInter & ,   const Standard_Integer  ) >(&TopOpeBRep_FFDumper::DumpVP),
             R"#()#"  , py::arg("VP"),  py::arg("ISI")
          )
        .def("ExploreIndex",
             (Standard_Integer (TopOpeBRep_FFDumper::*)(  const TopoDS_Shape & ,   const Standard_Integer  ) const) static_cast<Standard_Integer (TopOpeBRep_FFDumper::*)(  const TopoDS_Shape & ,   const Standard_Integer  ) const>(&TopOpeBRep_FFDumper::ExploreIndex),
             R"#()#"  , py::arg("S"),  py::arg("ISI")
          )
        .def("DumpDSP",
             (void (TopOpeBRep_FFDumper::*)(  const TopOpeBRep_VPointInter & ,   const TopOpeBRepDS_Kind ,   const Standard_Integer ,   const Standard_Boolean  ) const) static_cast<void (TopOpeBRep_FFDumper::*)(  const TopOpeBRep_VPointInter & ,   const TopOpeBRepDS_Kind ,   const Standard_Integer ,   const Standard_Boolean  ) const>(&TopOpeBRep_FFDumper::DumpDSP),
             R"#()#"  , py::arg("VP"),  py::arg("GK"),  py::arg("G"),  py::arg("newinDS")
          )
        .def("PFacesFillerDummy",
             (TopOpeBRep_PFacesFiller (TopOpeBRep_FFDumper::*)() const) static_cast<TopOpeBRep_PFacesFiller (TopOpeBRep_FFDumper::*)() const>(&TopOpeBRep_FFDumper::PFacesFillerDummy),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&TopOpeBRep_FFDumper::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&TopOpeBRep_FFDumper::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (TopOpeBRep_FFDumper::*)() const) static_cast< const handle<Standard_Type> & (TopOpeBRep_FFDumper::*)() const>(&TopOpeBRep_FFDumper::DynamicType),
             R"#()#"
             
         )
;

    // Class TopOpeBRep_FFTransitionTool from ./opencascade/TopOpeBRep_FFTransitionTool.hxx
    klass = m.attr("TopOpeBRep_FFTransitionTool");

    // default constructor
    register_default_constructor<TopOpeBRep_FFTransitionTool , shared_ptr<TopOpeBRep_FFTransitionTool>>(m,"TopOpeBRep_FFTransitionTool");

    // nested enums

    static_cast<py::class_<TopOpeBRep_FFTransitionTool , shared_ptr<TopOpeBRep_FFTransitionTool>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("ProcessLineTransition_s",
                    (TopOpeBRepDS_Transition (*)(  const TopOpeBRep_VPointInter & ,   const Standard_Integer ,   const TopAbs_Orientation  ) ) static_cast<TopOpeBRepDS_Transition (*)(  const TopOpeBRep_VPointInter & ,   const Standard_Integer ,   const TopAbs_Orientation  ) >(&TopOpeBRep_FFTransitionTool::ProcessLineTransition),
                    R"#()#"  , py::arg("P"),  py::arg("Index"),  py::arg("EdgeOrientation")
          )
        .def_static("ProcessLineTransition_s",
                    (TopOpeBRepDS_Transition (*)(  const TopOpeBRep_VPointInter & ,   const TopOpeBRep_LineInter &  ) ) static_cast<TopOpeBRepDS_Transition (*)(  const TopOpeBRep_VPointInter & ,   const TopOpeBRep_LineInter &  ) >(&TopOpeBRep_FFTransitionTool::ProcessLineTransition),
                    R"#()#"  , py::arg("P"),  py::arg("L")
          )
        .def_static("ProcessEdgeTransition_s",
                    (TopOpeBRepDS_Transition (*)(  const TopOpeBRep_VPointInter & ,   const Standard_Integer ,   const TopAbs_Orientation  ) ) static_cast<TopOpeBRepDS_Transition (*)(  const TopOpeBRep_VPointInter & ,   const Standard_Integer ,   const TopAbs_Orientation  ) >(&TopOpeBRep_FFTransitionTool::ProcessEdgeTransition),
                    R"#()#"  , py::arg("P"),  py::arg("Index"),  py::arg("LineOrientation")
          )
        .def_static("ProcessFaceTransition_s",
                    (TopOpeBRepDS_Transition (*)(  const TopOpeBRep_LineInter & ,   const Standard_Integer ,   const TopAbs_Orientation  ) ) static_cast<TopOpeBRepDS_Transition (*)(  const TopOpeBRep_LineInter & ,   const Standard_Integer ,   const TopAbs_Orientation  ) >(&TopOpeBRep_FFTransitionTool::ProcessFaceTransition),
                    R"#()#"  , py::arg("L"),  py::arg("Index"),  py::arg("FaceOrientation")
          )
        .def_static("ProcessEdgeONTransition_s",
                    (TopOpeBRepDS_Transition (*)(  const TopOpeBRep_VPointInter & ,   const Standard_Integer ,   const TopoDS_Shape & ,   const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<TopOpeBRepDS_Transition (*)(  const TopOpeBRep_VPointInter & ,   const Standard_Integer ,   const TopoDS_Shape & ,   const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&TopOpeBRep_FFTransitionTool::ProcessEdgeONTransition),
                    R"#(compute transition on "IntPatch_Restriction line" edge <R> when crossing edge <E> of face <F> at point <VP>. VP is given on edge <E> of face <F> of index <Index> (1 or 2). <VP> has been classified by FacesFiller as TopAbs_ON an edge <R> of the other face than <F> of current (face/face) intersection. Transition depends on the orientation of E in F. This method should be provided by IntPatch_Line (NYI))#"  , py::arg("VP"),  py::arg("Index"),  py::arg("R"),  py::arg("E"),  py::arg("F")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class TopOpeBRep_FaceEdgeFiller from ./opencascade/TopOpeBRep_FaceEdgeFiller.hxx
    klass = m.attr("TopOpeBRep_FaceEdgeFiller");


    // nested enums

    static_cast<py::class_<TopOpeBRep_FaceEdgeFiller , shared_ptr<TopOpeBRep_FaceEdgeFiller>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Insert",
             (void (TopOpeBRep_FaceEdgeFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,  TopOpeBRep_FaceEdgeIntersector & ,   const handle<TopOpeBRepDS_HDataStructure> &  ) ) static_cast<void (TopOpeBRep_FaceEdgeFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,  TopOpeBRep_FaceEdgeIntersector & ,   const handle<TopOpeBRepDS_HDataStructure> &  ) >(&TopOpeBRep_FaceEdgeFiller::Insert),
             R"#()#"  , py::arg("F"),  py::arg("E"),  py::arg("FEINT"),  py::arg("HDS")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class TopOpeBRep_FaceEdgeIntersector from ./opencascade/TopOpeBRep_FaceEdgeIntersector.hxx
    klass = m.attr("TopOpeBRep_FaceEdgeIntersector");


    // nested enums

    static_cast<py::class_<TopOpeBRep_FaceEdgeIntersector , shared_ptr<TopOpeBRep_FaceEdgeIntersector>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Perform",
             (void (TopOpeBRep_FaceEdgeIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<void (TopOpeBRep_FaceEdgeIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&TopOpeBRep_FaceEdgeIntersector::Perform),
             R"#()#"  , py::arg("F"),  py::arg("E")
          )
        .def("IsEmpty",
             (Standard_Boolean (TopOpeBRep_FaceEdgeIntersector::*)() ) static_cast<Standard_Boolean (TopOpeBRep_FaceEdgeIntersector::*)() >(&TopOpeBRep_FaceEdgeIntersector::IsEmpty),
             R"#()#" 
          )
        .def("Shape",
             ( const TopoDS_Shape & (TopOpeBRep_FaceEdgeIntersector::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Shape & (TopOpeBRep_FaceEdgeIntersector::*)(  const Standard_Integer  ) const>(&TopOpeBRep_FaceEdgeIntersector::Shape),
             R"#(returns intersected face or edge according to value of <Index> = 1 or 2)#"  , py::arg("Index")
          )
        .def("ForceTolerance",
             (void (TopOpeBRep_FaceEdgeIntersector::*)(  const Standard_Real  ) ) static_cast<void (TopOpeBRep_FaceEdgeIntersector::*)(  const Standard_Real  ) >(&TopOpeBRep_FaceEdgeIntersector::ForceTolerance),
             R"#(Force the tolerance values used by the next Perform(S1,S2) call.)#"  , py::arg("tol")
          )
        .def("Tolerance",
             (Standard_Real (TopOpeBRep_FaceEdgeIntersector::*)() const) static_cast<Standard_Real (TopOpeBRep_FaceEdgeIntersector::*)() const>(&TopOpeBRep_FaceEdgeIntersector::Tolerance),
             R"#(Return the tolerance value used in the last Perform() call If ForceTolerance() has been called, return the given value. If not, return value extracted from shapes.)#" 
          )
        .def("NbPoints",
             (Standard_Integer (TopOpeBRep_FaceEdgeIntersector::*)() const) static_cast<Standard_Integer (TopOpeBRep_FaceEdgeIntersector::*)() const>(&TopOpeBRep_FaceEdgeIntersector::NbPoints),
             R"#()#" 
          )
        .def("InitPoint",
             (void (TopOpeBRep_FaceEdgeIntersector::*)() ) static_cast<void (TopOpeBRep_FaceEdgeIntersector::*)() >(&TopOpeBRep_FaceEdgeIntersector::InitPoint),
             R"#()#" 
          )
        .def("MorePoint",
             (Standard_Boolean (TopOpeBRep_FaceEdgeIntersector::*)() const) static_cast<Standard_Boolean (TopOpeBRep_FaceEdgeIntersector::*)() const>(&TopOpeBRep_FaceEdgeIntersector::MorePoint),
             R"#()#" 
          )
        .def("NextPoint",
             (void (TopOpeBRep_FaceEdgeIntersector::*)() ) static_cast<void (TopOpeBRep_FaceEdgeIntersector::*)() >(&TopOpeBRep_FaceEdgeIntersector::NextPoint),
             R"#()#" 
          )
        .def("Value",
             (gp_Pnt (TopOpeBRep_FaceEdgeIntersector::*)() const) static_cast<gp_Pnt (TopOpeBRep_FaceEdgeIntersector::*)() const>(&TopOpeBRep_FaceEdgeIntersector::Value),
             R"#(return the 3D point of the current intersection point.)#" 
          )
        .def("Parameter",
             (Standard_Real (TopOpeBRep_FaceEdgeIntersector::*)() const) static_cast<Standard_Real (TopOpeBRep_FaceEdgeIntersector::*)() const>(&TopOpeBRep_FaceEdgeIntersector::Parameter),
             R"#(parametre de Value() sur l'arete)#" 
          )
        .def("UVPoint",
             (void (TopOpeBRep_FaceEdgeIntersector::*)( gp_Pnt2d &  ) const) static_cast<void (TopOpeBRep_FaceEdgeIntersector::*)( gp_Pnt2d &  ) const>(&TopOpeBRep_FaceEdgeIntersector::UVPoint),
             R"#(parametre de Value() sur la face)#"  , py::arg("P")
          )
        .def("State",
             (TopAbs_State (TopOpeBRep_FaceEdgeIntersector::*)() const) static_cast<TopAbs_State (TopOpeBRep_FaceEdgeIntersector::*)() const>(&TopOpeBRep_FaceEdgeIntersector::State),
             R"#(IN ou ON / a la face. Les points OUT ne sont pas retournes.)#" 
          )
        .def("Transition",
             (TopOpeBRepDS_Transition (TopOpeBRep_FaceEdgeIntersector::*)(  const Standard_Integer ,   const TopAbs_Orientation  ) const) static_cast<TopOpeBRepDS_Transition (TopOpeBRep_FaceEdgeIntersector::*)(  const Standard_Integer ,   const TopAbs_Orientation  ) const>(&TopOpeBRep_FaceEdgeIntersector::Transition),
             R"#(Index = 1 transition par rapport a la face, en cheminant sur l'arete)#"  , py::arg("Index"),  py::arg("FaceOrientation")
          )
        .def("IsVertex",
             (Standard_Boolean (TopOpeBRep_FaceEdgeIntersector::*)(  const TopoDS_Shape & ,   const gp_Pnt & ,   const Standard_Real ,  TopoDS_Vertex &  ) ) static_cast<Standard_Boolean (TopOpeBRep_FaceEdgeIntersector::*)(  const TopoDS_Shape & ,   const gp_Pnt & ,   const Standard_Real ,  TopoDS_Vertex &  ) >(&TopOpeBRep_FaceEdgeIntersector::IsVertex),
             R"#()#"  , py::arg("S"),  py::arg("P"),  py::arg("Tol"),  py::arg("V")
          )
        .def("IsVertex",
             (Standard_Boolean (TopOpeBRep_FaceEdgeIntersector::*)(  const Standard_Integer ,  TopoDS_Vertex &  ) ) static_cast<Standard_Boolean (TopOpeBRep_FaceEdgeIntersector::*)(  const Standard_Integer ,  TopoDS_Vertex &  ) >(&TopOpeBRep_FaceEdgeIntersector::IsVertex),
             R"#()#"  , py::arg("I"),  py::arg("V")
          )
        .def("Index",
             (Standard_Integer (TopOpeBRep_FaceEdgeIntersector::*)() const) static_cast<Standard_Integer (TopOpeBRep_FaceEdgeIntersector::*)() const>(&TopOpeBRep_FaceEdgeIntersector::Index),
             R"#(trace only)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class TopOpeBRep_FacesFiller from ./opencascade/TopOpeBRep_FacesFiller.hxx
    klass = m.attr("TopOpeBRep_FacesFiller");


    // nested enums

    static_cast<py::class_<TopOpeBRep_FacesFiller , shared_ptr<TopOpeBRep_FacesFiller>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Insert",
             (void (TopOpeBRep_FacesFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,  TopOpeBRep_FacesIntersector & ,   const handle<TopOpeBRepDS_HDataStructure> &  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,  TopOpeBRep_FacesIntersector & ,   const handle<TopOpeBRepDS_HDataStructure> &  ) >(&TopOpeBRep_FacesFiller::Insert),
             R"#(Stores in <DS> the intersections of <S1> and <S2>.)#"  , py::arg("F1"),  py::arg("F2"),  py::arg("FACINT"),  py::arg("HDS")
          )
        .def("ProcessSectionEdges",
             (void (TopOpeBRep_FacesFiller::*)() ) static_cast<void (TopOpeBRep_FacesFiller::*)() >(&TopOpeBRep_FacesFiller::ProcessSectionEdges),
             R"#()#" 
          )
        .def("LoadLine",
             (void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_LineInter &  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_LineInter &  ) >(&TopOpeBRep_FacesFiller::LoadLine),
             R"#()#"  , py::arg("L")
          )
        .def("CheckLine",
             (Standard_Boolean (TopOpeBRep_FacesFiller::*)( TopOpeBRep_LineInter &  ) const) static_cast<Standard_Boolean (TopOpeBRep_FacesFiller::*)( TopOpeBRep_LineInter &  ) const>(&TopOpeBRep_FacesFiller::CheckLine),
             R"#()#"  , py::arg("L")
          )
        .def("VP_Position",
             (void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_FacesIntersector &  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_FacesIntersector &  ) >(&TopOpeBRep_FacesFiller::VP_Position),
             R"#(compute position of VPoints of lines)#"  , py::arg("FACINT")
          )
        .def("VP_Position",
             (void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_LineInter &  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_LineInter &  ) >(&TopOpeBRep_FacesFiller::VP_Position),
             R"#(compute position of VPoints of line L)#"  , py::arg("L")
          )
        .def("VP_PositionOnL",
             (void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_LineInter &  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_LineInter &  ) >(&TopOpeBRep_FacesFiller::VP_PositionOnL),
             R"#(compute position of VPoints of non-restriction line L.)#"  , py::arg("L")
          )
        .def("VP_PositionOnR",
             (void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_LineInter &  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_LineInter &  ) >(&TopOpeBRep_FacesFiller::VP_PositionOnR),
             R"#(compute position of VPoints of restriction line L.)#"  , py::arg("L")
          )
        .def("VP_Position",
             (void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_VPointInter & ,  TopOpeBRep_VPointInterClassifier &  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_VPointInter & ,  TopOpeBRep_VPointInterClassifier &  ) >(&TopOpeBRep_FacesFiller::VP_Position),
             R"#(compute position of VP with current faces, according to VP.ShapeIndex() .)#"  , py::arg("VP"),  py::arg("VPC")
          )
        .def("ProcessLine",
             (void (TopOpeBRep_FacesFiller::*)() ) static_cast<void (TopOpeBRep_FacesFiller::*)() >(&TopOpeBRep_FacesFiller::ProcessLine),
             R"#(Process current intersection line (set by LoadLine))#" 
          )
        .def("ResetDSC",
             (void (TopOpeBRep_FacesFiller::*)() ) static_cast<void (TopOpeBRep_FacesFiller::*)() >(&TopOpeBRep_FacesFiller::ResetDSC),
             R"#()#" 
          )
        .def("ProcessRLine",
             (void (TopOpeBRep_FacesFiller::*)() ) static_cast<void (TopOpeBRep_FacesFiller::*)() >(&TopOpeBRep_FacesFiller::ProcessRLine),
             R"#(Process current restriction line, adding restriction edge and computing face/edge interference.)#" 
          )
        .def("FillLineVPonR",
             (void (TopOpeBRep_FacesFiller::*)() ) static_cast<void (TopOpeBRep_FacesFiller::*)() >(&TopOpeBRep_FacesFiller::FillLineVPonR),
             R"#(VP processing for restriction line and line sharing same domain with section edges : - if restriction : Adds restriction edges as section edges and compute face/edge interference. - if same domain : If line share same domain with section edges, compute parts of line IN/IN the two faces, and compute curve/point interference for VP boundaries.)#" 
          )
        .def("FillLine",
             (void (TopOpeBRep_FacesFiller::*)() ) static_cast<void (TopOpeBRep_FacesFiller::*)() >(&TopOpeBRep_FacesFiller::FillLine),
             R"#()#" 
          )
        .def("AddShapesLine",
             (void (TopOpeBRep_FacesFiller::*)() ) static_cast<void (TopOpeBRep_FacesFiller::*)() >(&TopOpeBRep_FacesFiller::AddShapesLine),
             R"#(compute 3d curve, pcurves and face/curve interferences for current NDSC. Add them to the DS.)#" 
          )
        .def("GetESL",
             (void (TopOpeBRep_FacesFiller::*)( TopTools_ListOfShape &  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)( TopTools_ListOfShape &  ) >(&TopOpeBRep_FacesFiller::GetESL),
             R"#(Get map <mapES > of restriction edges having parts IN one of the 2 faces.)#"  , py::arg("LES")
          )
        .def("ProcessVPR",
             (void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_FacesFiller & ,   const TopOpeBRep_VPointInter &  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_FacesFiller & ,   const TopOpeBRep_VPointInter &  ) >(&TopOpeBRep_FacesFiller::ProcessVPR),
             R"#(calling the following ProcessVPIonR and ProcessVPonR.)#"  , py::arg("FF"),  py::arg("VP")
          )
        .def("ProcessVPIonR",
             (void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_VPointInterIterator & ,   const TopOpeBRepDS_Transition & ,   const TopoDS_Shape & ,   const Standard_Integer  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_VPointInterIterator & ,   const TopOpeBRepDS_Transition & ,   const TopoDS_Shape & ,   const Standard_Integer  ) >(&TopOpeBRep_FacesFiller::ProcessVPIonR),
             R"#(processing ProcessVPonR for VPI.)#"  , py::arg("VPI"),  py::arg("trans1"),  py::arg("F1"),  py::arg("ShapeIndex")
          )
        .def("ProcessVPonR",
             (void (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_VPointInter & ,   const TopOpeBRepDS_Transition & ,   const TopoDS_Shape & ,   const Standard_Integer  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_VPointInter & ,   const TopOpeBRepDS_Transition & ,   const TopoDS_Shape & ,   const Standard_Integer  ) >(&TopOpeBRep_FacesFiller::ProcessVPonR),
             R"#(adds <VP>'s geometric point (if not stored) and computes (curve or edge)/(point or vertex) interference.)#"  , py::arg("VP"),  py::arg("trans1"),  py::arg("F1"),  py::arg("ShapeIndex")
          )
        .def("ProcessVPonclosingR",
             (void (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_VPointInter & ,   const TopoDS_Shape & ,   const Standard_Integer ,   const TopOpeBRepDS_Transition & ,   const TopOpeBRepDS_Kind ,   const Standard_Integer ,   const Standard_Boolean ,   const handle<TopOpeBRepDS_Interference> &  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_VPointInter & ,   const TopoDS_Shape & ,   const Standard_Integer ,   const TopOpeBRepDS_Transition & ,   const TopOpeBRepDS_Kind ,   const Standard_Integer ,   const Standard_Boolean ,   const handle<TopOpeBRepDS_Interference> &  ) >(&TopOpeBRep_FacesFiller::ProcessVPonclosingR),
             R"#(VP processing on closing arc.)#"  , py::arg("VP"),  py::arg("F1"),  py::arg("ShapeIndex"),  py::arg("transEdge"),  py::arg("PVKind"),  py::arg("PVIndex"),  py::arg("EPIfound"),  py::arg("IEPI")
          )
        .def("ProcessVPondgE",
             (Standard_Boolean (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_VPointInter & ,   const Standard_Integer ,  TopOpeBRepDS_Kind & ,  Standard_Integer & ,  Standard_Boolean & ,  handle<TopOpeBRepDS_Interference> & ,  Standard_Boolean & ,  handle<TopOpeBRepDS_Interference> &  ) ) static_cast<Standard_Boolean (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_VPointInter & ,   const Standard_Integer ,  TopOpeBRepDS_Kind & ,  Standard_Integer & ,  Standard_Boolean & ,  handle<TopOpeBRepDS_Interference> & ,  Standard_Boolean & ,  handle<TopOpeBRepDS_Interference> &  ) >(&TopOpeBRep_FacesFiller::ProcessVPondgE),
             R"#(VP processing on degenerated arc.)#"  , py::arg("VP"),  py::arg("ShapeIndex"),  py::arg("PVKind"),  py::arg("PVIndex"),  py::arg("EPIfound"),  py::arg("IEPI"),  py::arg("CPIfound"),  py::arg("ICPI")
          )
        .def("ProcessVPInotonR",
             (void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_VPointInterIterator &  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)( TopOpeBRep_VPointInterIterator &  ) >(&TopOpeBRep_FacesFiller::ProcessVPInotonR),
             R"#(processing ProcessVPnotonR for VPI.)#"  , py::arg("VPI")
          )
        .def("ProcessVPnotonR",
             (void (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_VPointInter &  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_VPointInter &  ) >(&TopOpeBRep_FacesFiller::ProcessVPnotonR),
             R"#(adds <VP>'s geometrical point to the DS (if not stored) and computes curve point interference.)#"  , py::arg("VP")
          )
        .def("GetGeometry",
             (Standard_Boolean (TopOpeBRep_FacesFiller::*)( TopOpeBRepDS_ListIteratorOfListOfInterference & ,   const TopOpeBRep_VPointInter & ,  Standard_Integer & ,  TopOpeBRepDS_Kind &  ) ) static_cast<Standard_Boolean (TopOpeBRep_FacesFiller::*)( TopOpeBRepDS_ListIteratorOfListOfInterference & ,   const TopOpeBRep_VPointInter & ,  Standard_Integer & ,  TopOpeBRepDS_Kind &  ) >(&TopOpeBRep_FacesFiller::GetGeometry),
             R"#(Get the geometry of a DS point <DSP>. Search for it with ScanInterfList (previous method). if found, set <G> to the geometry of the interference found. else, add the point <DSP> in the <DS> and set <G> to the value of the new geometry such created. returns the value of ScanInterfList().)#"  , py::arg("IT"),  py::arg("VP"),  py::arg("G"),  py::arg("K")
          )
        .def("MakeGeometry",
             (Standard_Integer (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_VPointInter & ,   const Standard_Integer ,  TopOpeBRepDS_Kind &  ) ) static_cast<Standard_Integer (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_VPointInter & ,   const Standard_Integer ,  TopOpeBRepDS_Kind &  ) >(&TopOpeBRep_FacesFiller::MakeGeometry),
             R"#()#"  , py::arg("VP"),  py::arg("ShapeIndex"),  py::arg("K")
          )
        .def("StoreCurveInterference",
             (void (TopOpeBRep_FacesFiller::*)(  const handle<TopOpeBRepDS_Interference> &  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)(  const handle<TopOpeBRepDS_Interference> &  ) >(&TopOpeBRep_FacesFiller::StoreCurveInterference),
             R"#(Add interference <I> to list myDSCIL. on a given line, at first call, add a new DS curve.)#"  , py::arg("I")
          )
        .def("GetFFGeometry",
             (Standard_Boolean (TopOpeBRep_FacesFiller::*)(  const TopOpeBRepDS_Point & ,  TopOpeBRepDS_Kind & ,  Standard_Integer &  ) const) static_cast<Standard_Boolean (TopOpeBRep_FacesFiller::*)(  const TopOpeBRepDS_Point & ,  TopOpeBRepDS_Kind & ,  Standard_Integer &  ) const>(&TopOpeBRep_FacesFiller::GetFFGeometry),
             R"#(search for G = geometry of Point which is identical to <DSP> among the DS Points created in the CURRENT face/face intersection ( current Insert() call).)#"  , py::arg("DSP"),  py::arg("K"),  py::arg("G")
          )
        .def("GetFFGeometry",
             (Standard_Boolean (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_VPointInter & ,  TopOpeBRepDS_Kind & ,  Standard_Integer &  ) const) static_cast<Standard_Boolean (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_VPointInter & ,  TopOpeBRepDS_Kind & ,  Standard_Integer &  ) const>(&TopOpeBRep_FacesFiller::GetFFGeometry),
             R"#(search for G = geometry of Point which is identical to <VP> among the DS Points created in the CURRENT face/face intersection ( current Insert() call).)#"  , py::arg("VP"),  py::arg("K"),  py::arg("G")
          )
        .def("HDataStructure",
             (handle<TopOpeBRepDS_HDataStructure> (TopOpeBRep_FacesFiller::*)() ) static_cast<handle<TopOpeBRepDS_HDataStructure> (TopOpeBRep_FacesFiller::*)() >(&TopOpeBRep_FacesFiller::HDataStructure),
             R"#()#" 
          )
        .def("Face",
             ( const TopoDS_Face & (TopOpeBRep_FacesFiller::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Face & (TopOpeBRep_FacesFiller::*)(  const Standard_Integer  ) const>(&TopOpeBRep_FacesFiller::Face),
             R"#()#"  , py::arg("I")
          )
        .def("FaceFaceTransition",
             ( const TopOpeBRepDS_Transition & (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_LineInter & ,   const Standard_Integer  ) const) static_cast< const TopOpeBRepDS_Transition & (TopOpeBRep_FacesFiller::*)(  const TopOpeBRep_LineInter & ,   const Standard_Integer  ) const>(&TopOpeBRep_FacesFiller::FaceFaceTransition),
             R"#()#"  , py::arg("L"),  py::arg("I")
          )
        .def("FaceFaceTransition",
             ( const TopOpeBRepDS_Transition & (TopOpeBRep_FacesFiller::*)(  const Standard_Integer  ) const) static_cast< const TopOpeBRepDS_Transition & (TopOpeBRep_FacesFiller::*)(  const Standard_Integer  ) const>(&TopOpeBRep_FacesFiller::FaceFaceTransition),
             R"#()#"  , py::arg("I")
          )
        .def("PFacesIntersectorDummy",
             (TopOpeBRep_PFacesIntersector (TopOpeBRep_FacesFiller::*)() const) static_cast<TopOpeBRep_PFacesIntersector (TopOpeBRep_FacesFiller::*)() const>(&TopOpeBRep_FacesFiller::PFacesIntersectorDummy),
             R"#()#" 
          )
        .def("PDataStructureDummy",
             (TopOpeBRepDS_PDataStructure (TopOpeBRep_FacesFiller::*)() const) static_cast<TopOpeBRepDS_PDataStructure (TopOpeBRep_FacesFiller::*)() const>(&TopOpeBRep_FacesFiller::PDataStructureDummy),
             R"#()#" 
          )
        .def("PLineInterDummy",
             (TopOpeBRep_PLineInter (TopOpeBRep_FacesFiller::*)() const) static_cast<TopOpeBRep_PLineInter (TopOpeBRep_FacesFiller::*)() const>(&TopOpeBRep_FacesFiller::PLineInterDummy),
             R"#()#" 
          )
        .def("SetTraceIndex",
             (void (TopOpeBRep_FacesFiller::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (TopOpeBRep_FacesFiller::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&TopOpeBRep_FacesFiller::SetTraceIndex),
             R"#()#"  , py::arg("exF1"),  py::arg("exF2")
          )
    // methods using call by reference i.s.o. return
        .def("GetTraceIndex",
             []( TopOpeBRep_FacesFiller &self   ){
                 Standard_Integer  exF1;
                Standard_Integer  exF2;

                 self.GetTraceIndex(exF1,exF2);
                 
                 return std::make_tuple(exF1,exF2); },
             R"#()#" 
          )
    // static methods
        .def_static("LSameDomainERL_s",
                    (Standard_Boolean (*)(  const TopOpeBRep_LineInter & ,   const TopTools_ListOfShape &  ) ) static_cast<Standard_Boolean (*)(  const TopOpeBRep_LineInter & ,   const TopTools_ListOfShape &  ) >(&TopOpeBRep_FacesFiller::LSameDomainERL),
                    R"#(Returns <True> if <L> shares a same geometric domain with at least one of the section edges of <ERL>.)#"  , py::arg("L"),  py::arg("ERL")
          )
        .def_static("IsVPtransLok_s",
                    (Standard_Boolean (*)(  const TopOpeBRep_LineInter & ,   const Standard_Integer ,   const Standard_Integer ,  TopOpeBRepDS_Transition &  ) ) static_cast<Standard_Boolean (*)(  const TopOpeBRep_LineInter & ,   const Standard_Integer ,   const Standard_Integer ,  TopOpeBRepDS_Transition &  ) >(&TopOpeBRep_FacesFiller::IsVPtransLok),
                    R"#(Computes the transition <T> of the VPoint <iVP> on the edge of <SI12>. Returns <False> if the status is unknown.)#"  , py::arg("L"),  py::arg("iVP"),  py::arg("SI12"),  py::arg("T")
          )
        .def_static("TransvpOK_s",
                    (Standard_Boolean (*)(  const TopOpeBRep_LineInter & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean  ) ) static_cast<Standard_Boolean (*)(  const TopOpeBRep_LineInter & ,   const Standard_Integer ,   const Standard_Integer ,   const Standard_Boolean  ) >(&TopOpeBRep_FacesFiller::TransvpOK),
                    R"#(Computes transition on line for VP<iVP> on edge restriction of <SI>. If <isINOUT> : returns <true> if transition computed is IN/OUT else : returns <true> if transition computed is OUT/IN.)#"  , py::arg("L"),  py::arg("iVP"),  py::arg("SI"),  py::arg("isINOUT")
          )
        .def_static("VPParamOnER_s",
                    (Standard_Real (*)(  const TopOpeBRep_VPointInter & ,   const TopOpeBRep_LineInter &  ) ) static_cast<Standard_Real (*)(  const TopOpeBRep_VPointInter & ,   const TopOpeBRep_LineInter &  ) >(&TopOpeBRep_FacesFiller::VPParamOnER),
                    R"#(Returns parameter u of vp on the restriction edge.)#"  , py::arg("vp"),  py::arg("Lrest")
          )
        .def_static("EqualpPonR_s",
                    (Standard_Boolean (*)(  const TopOpeBRep_LineInter & ,   const TopOpeBRep_VPointInter & ,   const TopOpeBRep_VPointInter &  ) ) static_cast<Standard_Boolean (*)(  const TopOpeBRep_LineInter & ,   const TopOpeBRep_VPointInter & ,   const TopOpeBRep_VPointInter &  ) >(&TopOpeBRep_FacesFiller::EqualpPonR),
                    R"#()#"  , py::arg("Lrest"),  py::arg("VP1"),  py::arg("VP2")
          )
    // static methods using call by reference i.s.o. return
        .def_static("Lminmax_s",
            []( const TopOpeBRep_LineInter & L ){
                Standard_Real  pmin;
                Standard_Real  pmax;

                TopOpeBRep_FacesFiller::Lminmax(L,pmin,pmax);
                
return std::make_tuple(pmin,pmax); },
            R"#(Computes <pmin> and <pmax> the upper and lower bounds of <L> enclosing all vpoints.)#"  , py::arg("L")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ChangePointClassifier",
             (TopOpeBRep_PointClassifier & (TopOpeBRep_FacesFiller::*)() ) static_cast<TopOpeBRep_PointClassifier & (TopOpeBRep_FacesFiller::*)() >(&TopOpeBRep_FacesFiller::ChangePointClassifier),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ChangeFacesIntersector",
             (TopOpeBRep_FacesIntersector & (TopOpeBRep_FacesFiller::*)() ) static_cast<TopOpeBRep_FacesIntersector & (TopOpeBRep_FacesFiller::*)() >(&TopOpeBRep_FacesFiller::ChangeFacesIntersector),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ChangeDataStructure",
             (TopOpeBRepDS_DataStructure & (TopOpeBRep_FacesFiller::*)() ) static_cast<TopOpeBRepDS_DataStructure & (TopOpeBRep_FacesFiller::*)() >(&TopOpeBRep_FacesFiller::ChangeDataStructure),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class TopOpeBRep_FacesIntersector from ./opencascade/TopOpeBRep_FacesIntersector.hxx
    klass = m.attr("TopOpeBRep_FacesIntersector");


    // nested enums

    static_cast<py::class_<TopOpeBRep_FacesIntersector , shared_ptr<TopOpeBRep_FacesIntersector>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Perform",
             (void (TopOpeBRep_FacesIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<void (TopOpeBRep_FacesIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&TopOpeBRep_FacesIntersector::Perform),
             R"#(Computes the intersection of faces S1 and S2.)#"  , py::arg("S1"),  py::arg("S2")
          )
        .def("Perform",
             (void (TopOpeBRep_FacesIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const Bnd_Box & ,   const Bnd_Box &  ) ) static_cast<void (TopOpeBRep_FacesIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const Bnd_Box & ,   const Bnd_Box &  ) >(&TopOpeBRep_FacesIntersector::Perform),
             R"#(Computes the intersection of faces S1 and S2.)#"  , py::arg("S1"),  py::arg("S2"),  py::arg("B1"),  py::arg("B2")
          )
        .def("IsEmpty",
             (Standard_Boolean (TopOpeBRep_FacesIntersector::*)() ) static_cast<Standard_Boolean (TopOpeBRep_FacesIntersector::*)() >(&TopOpeBRep_FacesIntersector::IsEmpty),
             R"#()#" 
          )
        .def("IsDone",
             (Standard_Boolean (TopOpeBRep_FacesIntersector::*)() const) static_cast<Standard_Boolean (TopOpeBRep_FacesIntersector::*)() const>(&TopOpeBRep_FacesIntersector::IsDone),
             R"#()#" 
          )
        .def("SameDomain",
             (Standard_Boolean (TopOpeBRep_FacesIntersector::*)() const) static_cast<Standard_Boolean (TopOpeBRep_FacesIntersector::*)() const>(&TopOpeBRep_FacesIntersector::SameDomain),
             R"#(Returns True if Perform() arguments are two faces with the same surface.)#" 
          )
        .def("Face",
             ( const TopoDS_Shape & (TopOpeBRep_FacesIntersector::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Shape & (TopOpeBRep_FacesIntersector::*)(  const Standard_Integer  ) const>(&TopOpeBRep_FacesIntersector::Face),
             R"#(returns first or second intersected face.)#"  , py::arg("Index")
          )
        .def("SurfacesSameOriented",
             (Standard_Boolean (TopOpeBRep_FacesIntersector::*)() const) static_cast<Standard_Boolean (TopOpeBRep_FacesIntersector::*)() const>(&TopOpeBRep_FacesIntersector::SurfacesSameOriented),
             R"#(Returns True if Perform() arguments are two faces SameDomain() and normals on both side. Raise if SameDomain is False)#" 
          )
        .def("IsRestriction",
             (Standard_Boolean (TopOpeBRep_FacesIntersector::*)(  const TopoDS_Shape &  ) const) static_cast<Standard_Boolean (TopOpeBRep_FacesIntersector::*)(  const TopoDS_Shape &  ) const>(&TopOpeBRep_FacesIntersector::IsRestriction),
             R"#(returns true if edge <E> is found as same as the edge associated with a RESTRICTION line.)#"  , py::arg("E")
          )
        .def("PrepareLines",
             (void (TopOpeBRep_FacesIntersector::*)() ) static_cast<void (TopOpeBRep_FacesIntersector::*)() >(&TopOpeBRep_FacesIntersector::PrepareLines),
             R"#()#" 
          )
        .def("Lines",
             (handle<TopOpeBRep_HArray1OfLineInter> (TopOpeBRep_FacesIntersector::*)() ) static_cast<handle<TopOpeBRep_HArray1OfLineInter> (TopOpeBRep_FacesIntersector::*)() >(&TopOpeBRep_FacesIntersector::Lines),
             R"#()#" 
          )
        .def("NbLines",
             (Standard_Integer (TopOpeBRep_FacesIntersector::*)() const) static_cast<Standard_Integer (TopOpeBRep_FacesIntersector::*)() const>(&TopOpeBRep_FacesIntersector::NbLines),
             R"#()#" 
          )
        .def("InitLine",
             (void (TopOpeBRep_FacesIntersector::*)() ) static_cast<void (TopOpeBRep_FacesIntersector::*)() >(&TopOpeBRep_FacesIntersector::InitLine),
             R"#()#" 
          )
        .def("MoreLine",
             (Standard_Boolean (TopOpeBRep_FacesIntersector::*)() const) static_cast<Standard_Boolean (TopOpeBRep_FacesIntersector::*)() const>(&TopOpeBRep_FacesIntersector::MoreLine),
             R"#()#" 
          )
        .def("NextLine",
             (void (TopOpeBRep_FacesIntersector::*)() ) static_cast<void (TopOpeBRep_FacesIntersector::*)() >(&TopOpeBRep_FacesIntersector::NextLine),
             R"#()#" 
          )
        .def("CurrentLineIndex",
             (Standard_Integer (TopOpeBRep_FacesIntersector::*)() const) static_cast<Standard_Integer (TopOpeBRep_FacesIntersector::*)() const>(&TopOpeBRep_FacesIntersector::CurrentLineIndex),
             R"#()#" 
          )
        .def("ChangeLine",
             (TopOpeBRep_LineInter & (TopOpeBRep_FacesIntersector::*)(  const Standard_Integer  ) ) static_cast<TopOpeBRep_LineInter & (TopOpeBRep_FacesIntersector::*)(  const Standard_Integer  ) >(&TopOpeBRep_FacesIntersector::ChangeLine),
             R"#()#"  , py::arg("IL")
          )
        .def("ForceTolerances",
             (void (TopOpeBRep_FacesIntersector::*)(  const Standard_Real ,   const Standard_Real  ) ) static_cast<void (TopOpeBRep_FacesIntersector::*)(  const Standard_Real ,   const Standard_Real  ) >(&TopOpeBRep_FacesIntersector::ForceTolerances),
             R"#(Force the tolerance values used by the next Perform(S1,S2) call.)#"  , py::arg("tolarc"),  py::arg("toltang")
          )
    // methods using call by reference i.s.o. return
        .def("GetTolerances",
             []( TopOpeBRep_FacesIntersector &self   ){
                 Standard_Real  tolarc;
                Standard_Real  toltang;

                 self.GetTolerances(tolarc,toltang);
                 
                 return std::make_tuple(tolarc,toltang); },
             R"#(Return the tolerance values used in the last Perform() call If ForceTolerances() has been called, return the given values. If not, return values extracted from shapes.)#" 
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Restrictions",
             ( const TopTools_IndexedMapOfShape & (TopOpeBRep_FacesIntersector::*)() const) static_cast< const TopTools_IndexedMapOfShape & (TopOpeBRep_FacesIntersector::*)() const>(&TopOpeBRep_FacesIntersector::Restrictions),
             R"#(returns the map of edges found as TopeBRepBRep_RESTRICTION)#"
             
         )
       .def("CurrentLine",
             (TopOpeBRep_LineInter & (TopOpeBRep_FacesIntersector::*)() ) static_cast<TopOpeBRep_LineInter & (TopOpeBRep_FacesIntersector::*)() >(&TopOpeBRep_FacesIntersector::CurrentLine),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class TopOpeBRep_GeomTool from ./opencascade/TopOpeBRep_GeomTool.hxx
    klass = m.attr("TopOpeBRep_GeomTool");

    // default constructor
    register_default_constructor<TopOpeBRep_GeomTool , shared_ptr<TopOpeBRep_GeomTool>>(m,"TopOpeBRep_GeomTool");

    // nested enums

    static_cast<py::class_<TopOpeBRep_GeomTool , shared_ptr<TopOpeBRep_GeomTool>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("MakeBSpline1fromWALKING3d_s",
                    (handle<Geom_Curve> (*)(  const TopOpeBRep_LineInter &  ) ) static_cast<handle<Geom_Curve> (*)(  const TopOpeBRep_LineInter &  ) >(&TopOpeBRep_GeomTool::MakeBSpline1fromWALKING3d),
                    R"#()#"  , py::arg("L")
          )
        .def_static("MakeBSpline1fromWALKING2d_s",
                    (handle<Geom2d_Curve> (*)(  const TopOpeBRep_LineInter & ,   const Standard_Integer  ) ) static_cast<handle<Geom2d_Curve> (*)(  const TopOpeBRep_LineInter & ,   const Standard_Integer  ) >(&TopOpeBRep_GeomTool::MakeBSpline1fromWALKING2d),
                    R"#()#"  , py::arg("L"),  py::arg("SI")
          )
    // static methods using call by reference i.s.o. return
        .def_static("MakeCurves_s",
            []( const Standard_Real min, const Standard_Real max, const TopOpeBRep_LineInter & L, const TopoDS_Shape & S1, const TopoDS_Shape & S2,TopOpeBRepDS_Curve & C,Geom2d_Curve& PC1,Geom2d_Curve& PC2 ){
                handle<Geom2d_Curve>  PC1_ptr; PC1_ptr = &PC1;
                handle<Geom2d_Curve>  PC2_ptr; PC2_ptr = &PC2;

                TopOpeBRep_GeomTool::MakeCurves(min,max,L,S1,S2,C,PC1_ptr,PC2_ptr);
                if ( PC1_ptr.get() != &PC1 ) copy_if_copy_constructible(PC1, *PC1_ptr);
                if ( PC2_ptr.get() != &PC2 ) copy_if_copy_constructible(PC2, *PC2_ptr);

 },
            R"#(Make the DS curve <C> and the pcurves <PC1,PC2> from intersection line <L> lying on shapes <S1,S2>. <min,max> = <L> bounds)#"  , py::arg("min"),  py::arg("max"),  py::arg("L"),  py::arg("S1"),  py::arg("S2"),  py::arg("C"),  py::arg("PC1"),  py::arg("PC2")
          )
        .def_static("MakeCurve_s",
            []( const Standard_Real min, const Standard_Real max, const TopOpeBRep_LineInter & L,Geom_Curve& C ){
                handle<Geom_Curve>  C_ptr; C_ptr = &C;

                TopOpeBRep_GeomTool::MakeCurve(min,max,L,C_ptr);
                if ( C_ptr.get() != &C ) copy_if_copy_constructible(C, *C_ptr);

 },
            R"#()#"  , py::arg("min"),  py::arg("max"),  py::arg("L"),  py::arg("C")
          )
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class TopOpeBRep_HArray1OfLineInter from ./opencascade/TopOpeBRep_HArray1OfLineInter.hxx
    klass = m.attr("TopOpeBRep_HArray1OfLineInter");


    // nested enums

    static_cast<py::class_<TopOpeBRep_HArray1OfLineInter ,opencascade::handle<TopOpeBRep_HArray1OfLineInter>  , TopOpeBRep_Array1OfLineInter , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const Standard_Integer, const Standard_Integer >()  , py::arg("theLower"),  py::arg("theUpper") )
        .def(py::init<  const Standard_Integer, const Standard_Integer, const typename NCollection_Array1<TopOpeBRep_LineInter>::value_type & >()  , py::arg("theLower"),  py::arg("theUpper"),  py::arg("theValue") )
        .def(py::init<  const typename NCollection_Array1<TopOpeBRep_LineInter>::value_type &, const Standard_Integer, const Standard_Integer, const bool >()  , py::arg("theBegin"),  py::arg("theLower"),  py::arg("theUpper"),  py::arg("arg3") )
        .def(py::init<  const TopOpeBRep_Array1OfLineInter & >()  , py::arg("theOther") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&TopOpeBRep_HArray1OfLineInter::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&TopOpeBRep_HArray1OfLineInter::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Array1",
             ( const TopOpeBRep_Array1OfLineInter & (TopOpeBRep_HArray1OfLineInter::*)() const) static_cast< const TopOpeBRep_Array1OfLineInter & (TopOpeBRep_HArray1OfLineInter::*)() const>(&TopOpeBRep_HArray1OfLineInter::Array1),
             R"#()#"
             
         )
       .def("ChangeArray1",
             (TopOpeBRep_Array1OfLineInter & (TopOpeBRep_HArray1OfLineInter::*)() ) static_cast<TopOpeBRep_Array1OfLineInter & (TopOpeBRep_HArray1OfLineInter::*)() >(&TopOpeBRep_HArray1OfLineInter::ChangeArray1),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (TopOpeBRep_HArray1OfLineInter::*)() const) static_cast< const handle<Standard_Type> & (TopOpeBRep_HArray1OfLineInter::*)() const>(&TopOpeBRep_HArray1OfLineInter::DynamicType),
             R"#()#"
             
         )
;

    // Class TopOpeBRep_HArray1OfVPointInter from ./opencascade/TopOpeBRep_HArray1OfVPointInter.hxx
    klass = m.attr("TopOpeBRep_HArray1OfVPointInter");


    // nested enums

    static_cast<py::class_<TopOpeBRep_HArray1OfVPointInter ,opencascade::handle<TopOpeBRep_HArray1OfVPointInter>  , TopOpeBRep_Array1OfVPointInter , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const Standard_Integer, const Standard_Integer >()  , py::arg("theLower"),  py::arg("theUpper") )
        .def(py::init<  const Standard_Integer, const Standard_Integer, const typename NCollection_Array1<TopOpeBRep_VPointInter>::value_type & >()  , py::arg("theLower"),  py::arg("theUpper"),  py::arg("theValue") )
        .def(py::init<  const typename NCollection_Array1<TopOpeBRep_VPointInter>::value_type &, const Standard_Integer, const Standard_Integer, const bool >()  , py::arg("theBegin"),  py::arg("theLower"),  py::arg("theUpper"),  py::arg("arg3") )
        .def(py::init<  const TopOpeBRep_Array1OfVPointInter & >()  , py::arg("theOther") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&TopOpeBRep_HArray1OfVPointInter::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&TopOpeBRep_HArray1OfVPointInter::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Array1",
             ( const TopOpeBRep_Array1OfVPointInter & (TopOpeBRep_HArray1OfVPointInter::*)() const) static_cast< const TopOpeBRep_Array1OfVPointInter & (TopOpeBRep_HArray1OfVPointInter::*)() const>(&TopOpeBRep_HArray1OfVPointInter::Array1),
             R"#()#"
             
         )
       .def("ChangeArray1",
             (TopOpeBRep_Array1OfVPointInter & (TopOpeBRep_HArray1OfVPointInter::*)() ) static_cast<TopOpeBRep_Array1OfVPointInter & (TopOpeBRep_HArray1OfVPointInter::*)() >(&TopOpeBRep_HArray1OfVPointInter::ChangeArray1),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (TopOpeBRep_HArray1OfVPointInter::*)() const) static_cast< const handle<Standard_Type> & (TopOpeBRep_HArray1OfVPointInter::*)() const>(&TopOpeBRep_HArray1OfVPointInter::DynamicType),
             R"#()#"
             
         )
;

    // Class TopOpeBRep_Hctxee2d from ./opencascade/TopOpeBRep_Hctxee2d.hxx
    klass = m.attr("TopOpeBRep_Hctxee2d");


    // nested enums

    static_cast<py::class_<TopOpeBRep_Hctxee2d ,opencascade::handle<TopOpeBRep_Hctxee2d>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetEdges",
             (void (TopOpeBRep_Hctxee2d::*)(  const TopoDS_Edge & ,   const TopoDS_Edge & ,   const BRepAdaptor_Surface & ,   const BRepAdaptor_Surface &  ) ) static_cast<void (TopOpeBRep_Hctxee2d::*)(  const TopoDS_Edge & ,   const TopoDS_Edge & ,   const BRepAdaptor_Surface & ,   const BRepAdaptor_Surface &  ) >(&TopOpeBRep_Hctxee2d::SetEdges),
             R"#()#"  , py::arg("E1"),  py::arg("E2"),  py::arg("BAS1"),  py::arg("BAS2")
          )
        .def("Edge",
             ( const TopoDS_Shape & (TopOpeBRep_Hctxee2d::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Shape & (TopOpeBRep_Hctxee2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_Hctxee2d::Edge),
             R"#()#"  , py::arg("I")
          )
        .def("Curve",
             ( const Geom2dAdaptor_Curve & (TopOpeBRep_Hctxee2d::*)(  const Standard_Integer  ) const) static_cast< const Geom2dAdaptor_Curve & (TopOpeBRep_Hctxee2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_Hctxee2d::Curve),
             R"#()#"  , py::arg("I")
          )
        .def("Domain",
             ( const IntRes2d_Domain & (TopOpeBRep_Hctxee2d::*)(  const Standard_Integer  ) const) static_cast< const IntRes2d_Domain & (TopOpeBRep_Hctxee2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_Hctxee2d::Domain),
             R"#()#"  , py::arg("I")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&TopOpeBRep_Hctxee2d::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&TopOpeBRep_Hctxee2d::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (TopOpeBRep_Hctxee2d::*)() const) static_cast< const handle<Standard_Type> & (TopOpeBRep_Hctxee2d::*)() const>(&TopOpeBRep_Hctxee2d::DynamicType),
             R"#()#"
             
         )
;

    // Class TopOpeBRep_Hctxff2d from ./opencascade/TopOpeBRep_Hctxff2d.hxx
    klass = m.attr("TopOpeBRep_Hctxff2d");


    // nested enums

    static_cast<py::class_<TopOpeBRep_Hctxff2d ,opencascade::handle<TopOpeBRep_Hctxff2d>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetFaces",
             (void (TopOpeBRep_Hctxff2d::*)(  const TopoDS_Face & ,   const TopoDS_Face &  ) ) static_cast<void (TopOpeBRep_Hctxff2d::*)(  const TopoDS_Face & ,   const TopoDS_Face &  ) >(&TopOpeBRep_Hctxff2d::SetFaces),
             R"#()#"  , py::arg("F1"),  py::arg("F2")
          )
        .def("SetHSurfaces",
             (void (TopOpeBRep_Hctxff2d::*)(  const handle<BRepAdaptor_Surface> & ,   const handle<BRepAdaptor_Surface> &  ) ) static_cast<void (TopOpeBRep_Hctxff2d::*)(  const handle<BRepAdaptor_Surface> & ,   const handle<BRepAdaptor_Surface> &  ) >(&TopOpeBRep_Hctxff2d::SetHSurfaces),
             R"#()#"  , py::arg("S1"),  py::arg("S2")
          )
        .def("SetTolerances",
             (void (TopOpeBRep_Hctxff2d::*)(  const Standard_Real ,   const Standard_Real  ) ) static_cast<void (TopOpeBRep_Hctxff2d::*)(  const Standard_Real ,   const Standard_Real  ) >(&TopOpeBRep_Hctxff2d::SetTolerances),
             R"#()#"  , py::arg("Tol1"),  py::arg("Tol2")
          )
        .def("GetMaxTolerance",
             (Standard_Real (TopOpeBRep_Hctxff2d::*)() const) static_cast<Standard_Real (TopOpeBRep_Hctxff2d::*)() const>(&TopOpeBRep_Hctxff2d::GetMaxTolerance),
             R"#()#" 
          )
        .def("Face",
             ( const TopoDS_Face & (TopOpeBRep_Hctxff2d::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Face & (TopOpeBRep_Hctxff2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_Hctxff2d::Face),
             R"#()#"  , py::arg("I")
          )
        .def("HSurface",
             (handle<BRepAdaptor_Surface> (TopOpeBRep_Hctxff2d::*)(  const Standard_Integer  ) const) static_cast<handle<BRepAdaptor_Surface> (TopOpeBRep_Hctxff2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_Hctxff2d::HSurface),
             R"#()#"  , py::arg("I")
          )
        .def("SurfacesSameOriented",
             (Standard_Boolean (TopOpeBRep_Hctxff2d::*)() const) static_cast<Standard_Boolean (TopOpeBRep_Hctxff2d::*)() const>(&TopOpeBRep_Hctxff2d::SurfacesSameOriented),
             R"#()#" 
          )
        .def("FacesSameOriented",
             (Standard_Boolean (TopOpeBRep_Hctxff2d::*)() const) static_cast<Standard_Boolean (TopOpeBRep_Hctxff2d::*)() const>(&TopOpeBRep_Hctxff2d::FacesSameOriented),
             R"#()#" 
          )
        .def("FaceSameOrientedWithRef",
             (Standard_Boolean (TopOpeBRep_Hctxff2d::*)(  const Standard_Integer  ) const) static_cast<Standard_Boolean (TopOpeBRep_Hctxff2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_Hctxff2d::FaceSameOrientedWithRef),
             R"#()#"  , py::arg("I")
          )
    // methods using call by reference i.s.o. return
        .def("GetTolerances",
             []( TopOpeBRep_Hctxff2d &self   ){
                 Standard_Real  Tol1;
                Standard_Real  Tol2;

                 self.GetTolerances(Tol1,Tol2);
                 
                 return std::make_tuple(Tol1,Tol2); },
             R"#()#" 
          )
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&TopOpeBRep_Hctxff2d::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&TopOpeBRep_Hctxff2d::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (TopOpeBRep_Hctxff2d::*)() const) static_cast< const handle<Standard_Type> & (TopOpeBRep_Hctxff2d::*)() const>(&TopOpeBRep_Hctxff2d::DynamicType),
             R"#()#"
             
         )
;

    // Class TopOpeBRep_LineInter from ./opencascade/TopOpeBRep_LineInter.hxx
    klass = m.attr("TopOpeBRep_LineInter");


    // nested enums

    static_cast<py::class_<TopOpeBRep_LineInter , shared_ptr<TopOpeBRep_LineInter>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetLine",
             (void (TopOpeBRep_LineInter::*)(  const handle<IntPatch_Line> & ,   const BRepAdaptor_Surface & ,   const BRepAdaptor_Surface &  ) ) static_cast<void (TopOpeBRep_LineInter::*)(  const handle<IntPatch_Line> & ,   const BRepAdaptor_Surface & ,   const BRepAdaptor_Surface &  ) >(&TopOpeBRep_LineInter::SetLine),
             R"#()#"  , py::arg("L"),  py::arg("S1"),  py::arg("S2")
          )
        .def("SetFaces",
             (void (TopOpeBRep_LineInter::*)(  const TopoDS_Face & ,   const TopoDS_Face &  ) ) static_cast<void (TopOpeBRep_LineInter::*)(  const TopoDS_Face & ,   const TopoDS_Face &  ) >(&TopOpeBRep_LineInter::SetFaces),
             R"#()#"  , py::arg("F1"),  py::arg("F2")
          )
        .def("TypeLineCurve",
             (TopOpeBRep_TypeLineCurve (TopOpeBRep_LineInter::*)() const) static_cast<TopOpeBRep_TypeLineCurve (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::TypeLineCurve),
             R"#()#" 
          )
        .def("NbVPoint",
             (Standard_Integer (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Integer (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::NbVPoint),
             R"#()#" 
          )
        .def("VPoint",
             ( const TopOpeBRep_VPointInter & (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) const) static_cast< const TopOpeBRep_VPointInter & (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) const>(&TopOpeBRep_LineInter::VPoint),
             R"#()#"  , py::arg("I")
          )
        .def("ChangeVPoint",
             (TopOpeBRep_VPointInter & (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) ) static_cast<TopOpeBRep_VPointInter & (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) >(&TopOpeBRep_LineInter::ChangeVPoint),
             R"#()#"  , py::arg("I")
          )
        .def("SetINL",
             (void (TopOpeBRep_LineInter::*)() ) static_cast<void (TopOpeBRep_LineInter::*)() >(&TopOpeBRep_LineInter::SetINL),
             R"#()#" 
          )
        .def("INL",
             (Standard_Boolean (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::INL),
             R"#()#" 
          )
        .def("SetIsVClosed",
             (void (TopOpeBRep_LineInter::*)() ) static_cast<void (TopOpeBRep_LineInter::*)() >(&TopOpeBRep_LineInter::SetIsVClosed),
             R"#()#" 
          )
        .def("IsVClosed",
             (Standard_Boolean (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::IsVClosed),
             R"#()#" 
          )
        .def("SetOK",
             (void (TopOpeBRep_LineInter::*)(  const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_LineInter::*)(  const Standard_Boolean  ) >(&TopOpeBRep_LineInter::SetOK),
             R"#()#"  , py::arg("B")
          )
        .def("OK",
             (Standard_Boolean (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::OK),
             R"#()#" 
          )
        .def("SetHasVPonR",
             (void (TopOpeBRep_LineInter::*)() ) static_cast<void (TopOpeBRep_LineInter::*)() >(&TopOpeBRep_LineInter::SetHasVPonR),
             R"#()#" 
          )
        .def("HasVPonR",
             (Standard_Boolean (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::HasVPonR),
             R"#()#" 
          )
        .def("SetVPBounds",
             (void (TopOpeBRep_LineInter::*)() ) static_cast<void (TopOpeBRep_LineInter::*)() >(&TopOpeBRep_LineInter::SetVPBounds),
             R"#()#" 
          )
        .def("IsPeriodic",
             (Standard_Boolean (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::IsPeriodic),
             R"#()#" 
          )
        .def("Period",
             (Standard_Real (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Real (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::Period),
             R"#()#" 
          )
        .def("HasVInternal",
             (Standard_Boolean (TopOpeBRep_LineInter::*)() ) static_cast<Standard_Boolean (TopOpeBRep_LineInter::*)() >(&TopOpeBRep_LineInter::HasVInternal),
             R"#()#" 
          )
        .def("NbWPoint",
             (Standard_Integer (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Integer (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::NbWPoint),
             R"#()#" 
          )
        .def("WPoint",
             ( const TopOpeBRep_WPointInter & (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) ) static_cast< const TopOpeBRep_WPointInter & (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) >(&TopOpeBRep_LineInter::WPoint),
             R"#()#"  , py::arg("I")
          )
        .def("TransitionOnS1",
             (IntSurf_TypeTrans (TopOpeBRep_LineInter::*)() const) static_cast<IntSurf_TypeTrans (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::TransitionOnS1),
             R"#()#" 
          )
        .def("TransitionOnS2",
             (IntSurf_TypeTrans (TopOpeBRep_LineInter::*)() const) static_cast<IntSurf_TypeTrans (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::TransitionOnS2),
             R"#()#" 
          )
        .def("SituationS1",
             (IntSurf_Situation (TopOpeBRep_LineInter::*)() const) static_cast<IntSurf_Situation (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::SituationS1),
             R"#()#" 
          )
        .def("SituationS2",
             (IntSurf_Situation (TopOpeBRep_LineInter::*)() const) static_cast<IntSurf_Situation (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::SituationS2),
             R"#()#" 
          )
        .def("Curve",
             (handle<Geom_Curve> (TopOpeBRep_LineInter::*)() const) static_cast<handle<Geom_Curve> (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::Curve),
             R"#()#" 
          )
        .def("Curve",
             (handle<Geom_Curve> (TopOpeBRep_LineInter::*)(  const Standard_Real ,   const Standard_Real  ) const) static_cast<handle<Geom_Curve> (TopOpeBRep_LineInter::*)(  const Standard_Real ,   const Standard_Real  ) const>(&TopOpeBRep_LineInter::Curve),
             R"#()#"  , py::arg("parmin"),  py::arg("parmax")
          )
        .def("ArcIsEdge",
             (Standard_Boolean (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) const) static_cast<Standard_Boolean (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) const>(&TopOpeBRep_LineInter::ArcIsEdge),
             R"#(returns true if Arc() edge (of a RESTRICTION line) is an edge of the original face <Index> (1 or 2).)#"  , py::arg("I")
          )
        .def("HasFirstPoint",
             (Standard_Boolean (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::HasFirstPoint),
             R"#()#" 
          )
        .def("HasLastPoint",
             (Standard_Boolean (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::HasLastPoint),
             R"#()#" 
          )
        .def("ComputeFaceFaceTransition",
             (void (TopOpeBRep_LineInter::*)() ) static_cast<void (TopOpeBRep_LineInter::*)() >(&TopOpeBRep_LineInter::ComputeFaceFaceTransition),
             R"#()#" 
          )
        .def("FaceFaceTransition",
             ( const TopOpeBRepDS_Transition & (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) const) static_cast< const TopOpeBRepDS_Transition & (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) const>(&TopOpeBRep_LineInter::FaceFaceTransition),
             R"#()#"  , py::arg("I")
          )
        .def("Index",
             (void (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) ) static_cast<void (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) >(&TopOpeBRep_LineInter::Index),
             R"#()#"  , py::arg("I")
          )
        .def("Index",
             (Standard_Integer (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Integer (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::Index),
             R"#()#" 
          )
        .def("DumpType",
             (void (TopOpeBRep_LineInter::*)() const) static_cast<void (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::DumpType),
             R"#()#" 
          )
        .def("DumpVPoint",
             (void (TopOpeBRep_LineInter::*)(  const Standard_Integer ,   const TCollection_AsciiString & ,   const TCollection_AsciiString &  ) const) static_cast<void (TopOpeBRep_LineInter::*)(  const Standard_Integer ,   const TCollection_AsciiString & ,   const TCollection_AsciiString &  ) const>(&TopOpeBRep_LineInter::DumpVPoint),
             R"#()#"  , py::arg("I"),  py::arg("s1"),  py::arg("s2")
          )
        .def("DumpBipoint",
             (void (TopOpeBRep_LineInter::*)(  const TopOpeBRep_Bipoint & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString &  ) const) static_cast<void (TopOpeBRep_LineInter::*)(  const TopOpeBRep_Bipoint & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString &  ) const>(&TopOpeBRep_LineInter::DumpBipoint),
             R"#()#"  , py::arg("B"),  py::arg("s1"),  py::arg("s2")
          )
        .def("SetTraceIndex",
             (void (TopOpeBRep_LineInter::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (TopOpeBRep_LineInter::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&TopOpeBRep_LineInter::SetTraceIndex),
             R"#()#"  , py::arg("exF1"),  py::arg("exF2")
          )
        .def("DumpLineTransitions",
             (Standard_OStream & (TopOpeBRep_LineInter::*)( Standard_OStream &  ) const) static_cast<Standard_OStream & (TopOpeBRep_LineInter::*)( Standard_OStream &  ) const>(&TopOpeBRep_LineInter::DumpLineTransitions),
             R"#()#"  , py::arg("OS")
          )
        .def("SetFaces",
             (void (TopOpeBRep_LineInter::*)(  const TopoDS_Face & ,   const TopoDS_Face &  ) ) static_cast<void (TopOpeBRep_LineInter::*)(  const TopoDS_Face & ,   const TopoDS_Face &  ) >(&TopOpeBRep_LineInter::SetFaces),
             R"#()#"  , py::arg("F1"),  py::arg("F2")
          )
        .def("TypeLineCurve",
             (TopOpeBRep_TypeLineCurve (TopOpeBRep_LineInter::*)() const) static_cast<TopOpeBRep_TypeLineCurve (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::TypeLineCurve),
             R"#()#" 
          )
        .def("NbVPoint",
             (Standard_Integer (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Integer (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::NbVPoint),
             R"#()#" 
          )
        .def("INL",
             (Standard_Boolean (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::INL),
             R"#()#" 
          )
        .def("IsVClosed",
             (Standard_Boolean (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::IsVClosed),
             R"#()#" 
          )
        .def("HasVPonR",
             (Standard_Boolean (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::HasVPonR),
             R"#()#" 
          )
        .def("TransitionOnS1",
             (IntSurf_TypeTrans (TopOpeBRep_LineInter::*)() const) static_cast<IntSurf_TypeTrans (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::TransitionOnS1),
             R"#()#" 
          )
        .def("TransitionOnS2",
             (IntSurf_TypeTrans (TopOpeBRep_LineInter::*)() const) static_cast<IntSurf_TypeTrans (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::TransitionOnS2),
             R"#()#" 
          )
        .def("SituationS1",
             (IntSurf_Situation (TopOpeBRep_LineInter::*)() const) static_cast<IntSurf_Situation (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::SituationS1),
             R"#()#" 
          )
        .def("SituationS2",
             (IntSurf_Situation (TopOpeBRep_LineInter::*)() const) static_cast<IntSurf_Situation (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::SituationS2),
             R"#()#" 
          )
        .def("Index",
             (void (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) ) static_cast<void (TopOpeBRep_LineInter::*)(  const Standard_Integer  ) >(&TopOpeBRep_LineInter::Index),
             R"#()#"  , py::arg("I")
          )
        .def("Index",
             (Standard_Integer (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Integer (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::Index),
             R"#()#" 
          )
        .def("OK",
             (Standard_Boolean (TopOpeBRep_LineInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::OK),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
        .def("VPBounds",
             []( TopOpeBRep_LineInter &self   ){
                 Standard_Integer  f;
                Standard_Integer  l;
                Standard_Integer  n;

                 self.VPBounds(f,l,n);
                 
                 return std::make_tuple(f,l,n); },
             R"#()#" 
          )
        .def("Bounds",
             []( TopOpeBRep_LineInter &self   ){
                 Standard_Real  f;
                Standard_Real  l;

                 self.Bounds(f,l);
                 
                 return std::make_tuple(f,l); },
             R"#()#" 
          )
        .def("GetTraceIndex",
             []( TopOpeBRep_LineInter &self   ){
                 Standard_Integer  exF1;
                Standard_Integer  exF2;

                 self.GetTraceIndex(exF1,exF2);
                 
                 return std::make_tuple(exF1,exF2); },
             R"#()#" 
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Arc",
             ( const TopoDS_Shape & (TopOpeBRep_LineInter::*)() const) static_cast< const TopoDS_Shape & (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::Arc),
             R"#(returns the edge of a RESTRICTION line (or a null edge).)#"
             
         )
       .def("LineW",
             ( const handle<IntPatch_WLine> & (TopOpeBRep_LineInter::*)() const) static_cast< const handle<IntPatch_WLine> & (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::LineW),
             R"#()#"
             
         )
       .def("LineG",
             ( const handle<IntPatch_GLine> & (TopOpeBRep_LineInter::*)() const) static_cast< const handle<IntPatch_GLine> & (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::LineG),
             R"#()#"
             
         )
       .def("LineR",
             ( const handle<IntPatch_RLine> & (TopOpeBRep_LineInter::*)() const) static_cast< const handle<IntPatch_RLine> & (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::LineR),
             R"#()#"
             
         )
       .def("LineW",
             ( const handle<IntPatch_WLine> & (TopOpeBRep_LineInter::*)() const) static_cast< const handle<IntPatch_WLine> & (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::LineW),
             R"#()#"
             
         )
       .def("LineG",
             ( const handle<IntPatch_GLine> & (TopOpeBRep_LineInter::*)() const) static_cast< const handle<IntPatch_GLine> & (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::LineG),
             R"#()#"
             
         )
       .def("LineR",
             ( const handle<IntPatch_RLine> & (TopOpeBRep_LineInter::*)() const) static_cast< const handle<IntPatch_RLine> & (TopOpeBRep_LineInter::*)() const>(&TopOpeBRep_LineInter::LineR),
             R"#()#"
             
         )
;

    // Class TopOpeBRep_Point2d from ./opencascade/TopOpeBRep_Point2d.hxx
    klass = m.attr("TopOpeBRep_Point2d");


    // nested enums

    static_cast<py::class_<TopOpeBRep_Point2d , shared_ptr<TopOpeBRep_Point2d>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Dump",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&TopOpeBRep_Point2d::Dump),
             R"#()#"  , py::arg("ie1")=static_cast< const Standard_Integer>(0),  py::arg("ie2")=static_cast< const Standard_Integer>(0)
          )
        .def("SetPint",
             (void (TopOpeBRep_Point2d::*)(  const IntRes2d_IntersectionPoint &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const IntRes2d_IntersectionPoint &  ) >(&TopOpeBRep_Point2d::SetPint),
             R"#()#"  , py::arg("P")
          )
        .def("HasPint",
             (Standard_Boolean (TopOpeBRep_Point2d::*)() const) static_cast<Standard_Boolean (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::HasPint),
             R"#()#" 
          )
        .def("SetIsVertex",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Boolean  ) >(&TopOpeBRep_Point2d::SetIsVertex),
             R"#()#"  , py::arg("I"),  py::arg("B")
          )
        .def("IsVertex",
             (Standard_Boolean (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) const) static_cast<Standard_Boolean (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_Point2d::IsVertex),
             R"#()#"  , py::arg("I")
          )
        .def("SetVertex",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const TopoDS_Vertex &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const TopoDS_Vertex &  ) >(&TopOpeBRep_Point2d::SetVertex),
             R"#()#"  , py::arg("I"),  py::arg("V")
          )
        .def("Vertex",
             ( const TopoDS_Vertex & (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Vertex & (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_Point2d::Vertex),
             R"#()#"  , py::arg("I")
          )
        .def("SetTransition",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const TopOpeBRepDS_Transition &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const TopOpeBRepDS_Transition &  ) >(&TopOpeBRep_Point2d::SetTransition),
             R"#()#"  , py::arg("I"),  py::arg("T")
          )
        .def("Transition",
             ( const TopOpeBRepDS_Transition & (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) const) static_cast< const TopOpeBRepDS_Transition & (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_Point2d::Transition),
             R"#()#"  , py::arg("I")
          )
        .def("ChangeTransition",
             (TopOpeBRepDS_Transition & (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) ) static_cast<TopOpeBRepDS_Transition & (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) >(&TopOpeBRep_Point2d::ChangeTransition),
             R"#()#"  , py::arg("I")
          )
        .def("SetParameter",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Real  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Real  ) >(&TopOpeBRep_Point2d::SetParameter),
             R"#()#"  , py::arg("I"),  py::arg("P")
          )
        .def("Parameter",
             (Standard_Real (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) const) static_cast<Standard_Real (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_Point2d::Parameter),
             R"#()#"  , py::arg("I")
          )
        .def("SetIsPointOfSegment",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Boolean  ) >(&TopOpeBRep_Point2d::SetIsPointOfSegment),
             R"#()#"  , py::arg("B")
          )
        .def("IsPointOfSegment",
             (Standard_Boolean (TopOpeBRep_Point2d::*)() const) static_cast<Standard_Boolean (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::IsPointOfSegment),
             R"#()#" 
          )
        .def("SetSegmentAncestors",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&TopOpeBRep_Point2d::SetSegmentAncestors),
             R"#()#"  , py::arg("IP1"),  py::arg("IP2")
          )
        .def("SegmentAncestors",
             (Standard_Boolean (TopOpeBRep_Point2d::*)( Standard_Integer & ,  Standard_Integer &  ) const) static_cast<Standard_Boolean (TopOpeBRep_Point2d::*)( Standard_Integer & ,  Standard_Integer &  ) const>(&TopOpeBRep_Point2d::SegmentAncestors),
             R"#()#"  , py::arg("IP1"),  py::arg("IP2")
          )
        .def("SetStatus",
             (void (TopOpeBRep_Point2d::*)(  const TopOpeBRep_P2Dstatus  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const TopOpeBRep_P2Dstatus  ) >(&TopOpeBRep_Point2d::SetStatus),
             R"#()#"  , py::arg("S")
          )
        .def("Status",
             (TopOpeBRep_P2Dstatus (TopOpeBRep_Point2d::*)() const) static_cast<TopOpeBRep_P2Dstatus (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Status),
             R"#()#" 
          )
        .def("SetIndex",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) >(&TopOpeBRep_Point2d::SetIndex),
             R"#()#"  , py::arg("X")
          )
        .def("Index",
             (Standard_Integer (TopOpeBRep_Point2d::*)() const) static_cast<Standard_Integer (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Index),
             R"#()#" 
          )
        .def("SetValue",
             (void (TopOpeBRep_Point2d::*)(  const gp_Pnt &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const gp_Pnt &  ) >(&TopOpeBRep_Point2d::SetValue),
             R"#()#"  , py::arg("P")
          )
        .def("SetValue2d",
             (void (TopOpeBRep_Point2d::*)(  const gp_Pnt2d &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const gp_Pnt2d &  ) >(&TopOpeBRep_Point2d::SetValue2d),
             R"#()#"  , py::arg("P")
          )
        .def("SetKeep",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Boolean  ) >(&TopOpeBRep_Point2d::SetKeep),
             R"#()#"  , py::arg("B")
          )
        .def("Keep",
             (Standard_Boolean (TopOpeBRep_Point2d::*)() const) static_cast<Standard_Boolean (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Keep),
             R"#()#" 
          )
        .def("SetEdgesConfig",
             (void (TopOpeBRep_Point2d::*)(  const TopOpeBRepDS_Config  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const TopOpeBRepDS_Config  ) >(&TopOpeBRep_Point2d::SetEdgesConfig),
             R"#()#"  , py::arg("C")
          )
        .def("EdgesConfig",
             (TopOpeBRepDS_Config (TopOpeBRep_Point2d::*)() const) static_cast<TopOpeBRepDS_Config (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::EdgesConfig),
             R"#()#" 
          )
        .def("SetTolerance",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Real  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Real  ) >(&TopOpeBRep_Point2d::SetTolerance),
             R"#()#"  , py::arg("T")
          )
        .def("Tolerance",
             (Standard_Real (TopOpeBRep_Point2d::*)() const) static_cast<Standard_Real (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Tolerance),
             R"#()#" 
          )
        .def("SetHctxff2d",
             (void (TopOpeBRep_Point2d::*)(  const handle<TopOpeBRep_Hctxff2d> &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const handle<TopOpeBRep_Hctxff2d> &  ) >(&TopOpeBRep_Point2d::SetHctxff2d),
             R"#()#"  , py::arg("ff2d")
          )
        .def("Hctxff2d",
             (handle<TopOpeBRep_Hctxff2d> (TopOpeBRep_Point2d::*)() const) static_cast<handle<TopOpeBRep_Hctxff2d> (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Hctxff2d),
             R"#()#" 
          )
        .def("SetHctxee2d",
             (void (TopOpeBRep_Point2d::*)(  const handle<TopOpeBRep_Hctxee2d> &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const handle<TopOpeBRep_Hctxee2d> &  ) >(&TopOpeBRep_Point2d::SetHctxee2d),
             R"#()#"  , py::arg("ee2d")
          )
        .def("Hctxee2d",
             (handle<TopOpeBRep_Hctxee2d> (TopOpeBRep_Point2d::*)() const) static_cast<handle<TopOpeBRep_Hctxee2d> (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Hctxee2d),
             R"#()#" 
          )
        .def("SetPint",
             (void (TopOpeBRep_Point2d::*)(  const IntRes2d_IntersectionPoint &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const IntRes2d_IntersectionPoint &  ) >(&TopOpeBRep_Point2d::SetPint),
             R"#()#"  , py::arg("P")
          )
        .def("HasPint",
             (Standard_Boolean (TopOpeBRep_Point2d::*)() const) static_cast<Standard_Boolean (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::HasPint),
             R"#()#" 
          )
        .def("SetIsVertex",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Boolean  ) >(&TopOpeBRep_Point2d::SetIsVertex),
             R"#()#"  , py::arg("Index"),  py::arg("B")
          )
        .def("IsVertex",
             (Standard_Boolean (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) const) static_cast<Standard_Boolean (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_Point2d::IsVertex),
             R"#()#"  , py::arg("Index")
          )
        .def("SetVertex",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const TopoDS_Vertex &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const TopoDS_Vertex &  ) >(&TopOpeBRep_Point2d::SetVertex),
             R"#()#"  , py::arg("Index"),  py::arg("V")
          )
        .def("SetTransition",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const TopOpeBRepDS_Transition &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const TopOpeBRepDS_Transition &  ) >(&TopOpeBRep_Point2d::SetTransition),
             R"#()#"  , py::arg("Index"),  py::arg("T")
          )
        .def("SetParameter",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Real  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Real  ) >(&TopOpeBRep_Point2d::SetParameter),
             R"#()#"  , py::arg("Index"),  py::arg("P")
          )
        .def("Parameter",
             (Standard_Real (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) const) static_cast<Standard_Real (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_Point2d::Parameter),
             R"#()#"  , py::arg("Index")
          )
        .def("SetIsPointOfSegment",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Boolean  ) >(&TopOpeBRep_Point2d::SetIsPointOfSegment),
             R"#()#"  , py::arg("B")
          )
        .def("IsPointOfSegment",
             (Standard_Boolean (TopOpeBRep_Point2d::*)() const) static_cast<Standard_Boolean (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::IsPointOfSegment),
             R"#()#" 
          )
        .def("SetSegmentAncestors",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&TopOpeBRep_Point2d::SetSegmentAncestors),
             R"#()#"  , py::arg("IP1"),  py::arg("IP2")
          )
        .def("SegmentAncestors",
             (Standard_Boolean (TopOpeBRep_Point2d::*)( Standard_Integer & ,  Standard_Integer &  ) const) static_cast<Standard_Boolean (TopOpeBRep_Point2d::*)( Standard_Integer & ,  Standard_Integer &  ) const>(&TopOpeBRep_Point2d::SegmentAncestors),
             R"#()#"  , py::arg("IP1"),  py::arg("IP2")
          )
        .def("SetStatus",
             (void (TopOpeBRep_Point2d::*)(  const TopOpeBRep_P2Dstatus  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const TopOpeBRep_P2Dstatus  ) >(&TopOpeBRep_Point2d::SetStatus),
             R"#()#"  , py::arg("I")
          )
        .def("Status",
             (TopOpeBRep_P2Dstatus (TopOpeBRep_Point2d::*)() const) static_cast<TopOpeBRep_P2Dstatus (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Status),
             R"#()#" 
          )
        .def("SetIndex",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Integer  ) >(&TopOpeBRep_Point2d::SetIndex),
             R"#()#"  , py::arg("I")
          )
        .def("Index",
             (Standard_Integer (TopOpeBRep_Point2d::*)() const) static_cast<Standard_Integer (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Index),
             R"#()#" 
          )
        .def("SetValue",
             (void (TopOpeBRep_Point2d::*)(  const gp_Pnt &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const gp_Pnt &  ) >(&TopOpeBRep_Point2d::SetValue),
             R"#()#"  , py::arg("P")
          )
        .def("SetValue2d",
             (void (TopOpeBRep_Point2d::*)(  const gp_Pnt2d &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const gp_Pnt2d &  ) >(&TopOpeBRep_Point2d::SetValue2d),
             R"#()#"  , py::arg("P")
          )
        .def("SetKeep",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Boolean  ) >(&TopOpeBRep_Point2d::SetKeep),
             R"#()#"  , py::arg("B")
          )
        .def("Keep",
             (Standard_Boolean (TopOpeBRep_Point2d::*)() const) static_cast<Standard_Boolean (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Keep),
             R"#()#" 
          )
        .def("SetEdgesConfig",
             (void (TopOpeBRep_Point2d::*)(  const TopOpeBRepDS_Config  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const TopOpeBRepDS_Config  ) >(&TopOpeBRep_Point2d::SetEdgesConfig),
             R"#()#"  , py::arg("B")
          )
        .def("EdgesConfig",
             (TopOpeBRepDS_Config (TopOpeBRep_Point2d::*)() const) static_cast<TopOpeBRepDS_Config (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::EdgesConfig),
             R"#()#" 
          )
        .def("SetTolerance",
             (void (TopOpeBRep_Point2d::*)(  const Standard_Real  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const Standard_Real  ) >(&TopOpeBRep_Point2d::SetTolerance),
             R"#()#"  , py::arg("t")
          )
        .def("Tolerance",
             (Standard_Real (TopOpeBRep_Point2d::*)() const) static_cast<Standard_Real (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Tolerance),
             R"#()#" 
          )
        .def("SetHctxff2d",
             (void (TopOpeBRep_Point2d::*)(  const handle<TopOpeBRep_Hctxff2d> &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const handle<TopOpeBRep_Hctxff2d> &  ) >(&TopOpeBRep_Point2d::SetHctxff2d),
             R"#()#"  , py::arg("h")
          )
        .def("Hctxff2d",
             (handle<TopOpeBRep_Hctxff2d> (TopOpeBRep_Point2d::*)() const) static_cast<handle<TopOpeBRep_Hctxff2d> (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Hctxff2d),
             R"#()#" 
          )
        .def("SetHctxee2d",
             (void (TopOpeBRep_Point2d::*)(  const handle<TopOpeBRep_Hctxee2d> &  ) ) static_cast<void (TopOpeBRep_Point2d::*)(  const handle<TopOpeBRep_Hctxee2d> &  ) >(&TopOpeBRep_Point2d::SetHctxee2d),
             R"#()#"  , py::arg("h")
          )
        .def("Hctxee2d",
             (handle<TopOpeBRep_Hctxee2d> (TopOpeBRep_Point2d::*)() const) static_cast<handle<TopOpeBRep_Hctxee2d> (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Hctxee2d),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Pint",
             ( const IntRes2d_IntersectionPoint & (TopOpeBRep_Point2d::*)() const) static_cast< const IntRes2d_IntersectionPoint & (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Pint),
             R"#()#"
             
         )
       .def("Value",
             ( const gp_Pnt & (TopOpeBRep_Point2d::*)() const) static_cast< const gp_Pnt & (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Value),
             R"#()#"
             
         )
       .def("Value2d",
             ( const gp_Pnt2d & (TopOpeBRep_Point2d::*)() const) static_cast< const gp_Pnt2d & (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Value2d),
             R"#()#"
             
         )
       .def("Pint",
             ( const IntRes2d_IntersectionPoint & (TopOpeBRep_Point2d::*)() const) static_cast< const IntRes2d_IntersectionPoint & (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Pint),
             R"#()#"
             
         )
       .def("Value",
             ( const gp_Pnt & (TopOpeBRep_Point2d::*)() const) static_cast< const gp_Pnt & (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Value),
             R"#()#"
             
         )
       .def("Value2d",
             ( const gp_Pnt2d & (TopOpeBRep_Point2d::*)() const) static_cast< const gp_Pnt2d & (TopOpeBRep_Point2d::*)() const>(&TopOpeBRep_Point2d::Value2d),
             R"#()#"
             
         )
;

    // Class TopOpeBRep_PointClassifier from ./opencascade/TopOpeBRep_PointClassifier.hxx
    klass = m.attr("TopOpeBRep_PointClassifier");


    // nested enums

    static_cast<py::class_<TopOpeBRep_PointClassifier , shared_ptr<TopOpeBRep_PointClassifier>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Init",
             (void (TopOpeBRep_PointClassifier::*)() ) static_cast<void (TopOpeBRep_PointClassifier::*)() >(&TopOpeBRep_PointClassifier::Init),
             R"#()#" 
          )
        .def("Load",
             (void (TopOpeBRep_PointClassifier::*)(  const TopoDS_Face &  ) ) static_cast<void (TopOpeBRep_PointClassifier::*)(  const TopoDS_Face &  ) >(&TopOpeBRep_PointClassifier::Load),
             R"#()#"  , py::arg("F")
          )
        .def("Classify",
             (TopAbs_State (TopOpeBRep_PointClassifier::*)(  const TopoDS_Face & ,   const gp_Pnt2d & ,   const Standard_Real  ) ) static_cast<TopAbs_State (TopOpeBRep_PointClassifier::*)(  const TopoDS_Face & ,   const gp_Pnt2d & ,   const Standard_Real  ) >(&TopOpeBRep_PointClassifier::Classify),
             R"#(compute position of point <P> regarding with the face <F>.)#"  , py::arg("F"),  py::arg("P"),  py::arg("Tol")
          )
        .def("State",
             (TopAbs_State (TopOpeBRep_PointClassifier::*)() const) static_cast<TopAbs_State (TopOpeBRep_PointClassifier::*)() const>(&TopOpeBRep_PointClassifier::State),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class TopOpeBRep_PointGeomTool from ./opencascade/TopOpeBRep_PointGeomTool.hxx
    klass = m.attr("TopOpeBRep_PointGeomTool");

    // default constructor
    register_default_constructor<TopOpeBRep_PointGeomTool , shared_ptr<TopOpeBRep_PointGeomTool>>(m,"TopOpeBRep_PointGeomTool");

    // nested enums

    static_cast<py::class_<TopOpeBRep_PointGeomTool , shared_ptr<TopOpeBRep_PointGeomTool>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("MakePoint_s",
                    (TopOpeBRepDS_Point (*)(  const TopOpeBRep_VPointInter &  ) ) static_cast<TopOpeBRepDS_Point (*)(  const TopOpeBRep_VPointInter &  ) >(&TopOpeBRep_PointGeomTool::MakePoint),
                    R"#()#"  , py::arg("IP")
          )
        .def_static("MakePoint_s",
                    (TopOpeBRepDS_Point (*)(  const TopOpeBRep_Point2d &  ) ) static_cast<TopOpeBRepDS_Point (*)(  const TopOpeBRep_Point2d &  ) >(&TopOpeBRep_PointGeomTool::MakePoint),
                    R"#()#"  , py::arg("P2D")
          )
        .def_static("MakePoint_s",
                    (TopOpeBRepDS_Point (*)(  const TopOpeBRep_FaceEdgeIntersector &  ) ) static_cast<TopOpeBRepDS_Point (*)(  const TopOpeBRep_FaceEdgeIntersector &  ) >(&TopOpeBRep_PointGeomTool::MakePoint),
                    R"#()#"  , py::arg("FEI")
          )
        .def_static("MakePoint_s",
                    (TopOpeBRepDS_Point (*)(  const TopoDS_Shape &  ) ) static_cast<TopOpeBRepDS_Point (*)(  const TopoDS_Shape &  ) >(&TopOpeBRep_PointGeomTool::MakePoint),
                    R"#()#"  , py::arg("S")
          )
        .def_static("IsEqual_s",
                    (Standard_Boolean (*)(  const TopOpeBRepDS_Point & ,   const TopOpeBRepDS_Point &  ) ) static_cast<Standard_Boolean (*)(  const TopOpeBRepDS_Point & ,   const TopOpeBRepDS_Point &  ) >(&TopOpeBRep_PointGeomTool::IsEqual),
                    R"#()#"  , py::arg("DSP1"),  py::arg("DSP2")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class TopOpeBRep_ShapeIntersector from ./opencascade/TopOpeBRep_ShapeIntersector.hxx
    klass = m.attr("TopOpeBRep_ShapeIntersector");


    // nested enums

    static_cast<py::class_<TopOpeBRep_ShapeIntersector , shared_ptr<TopOpeBRep_ShapeIntersector>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("InitIntersection",
             (void (TopOpeBRep_ShapeIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<void (TopOpeBRep_ShapeIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&TopOpeBRep_ShapeIntersector::InitIntersection),
             R"#(Initialize the intersection of shapes S1,S2.)#"  , py::arg("S1"),  py::arg("S2")
          )
        .def("InitIntersection",
             (void (TopOpeBRep_ShapeIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const TopoDS_Face & ,   const TopoDS_Face &  ) ) static_cast<void (TopOpeBRep_ShapeIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,   const TopoDS_Face & ,   const TopoDS_Face &  ) >(&TopOpeBRep_ShapeIntersector::InitIntersection),
             R"#(Initialize the intersection of shapes S1,S2.)#"  , py::arg("S1"),  py::arg("S2"),  py::arg("F1"),  py::arg("F2")
          )
        .def("Shape",
             ( const TopoDS_Shape & (TopOpeBRep_ShapeIntersector::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Shape & (TopOpeBRep_ShapeIntersector::*)(  const Standard_Integer  ) const>(&TopOpeBRep_ShapeIntersector::Shape),
             R"#(return the shape <Index> ( = 1 or 2) given to InitIntersection(). Index = 1 will return S1, Index = 2 will return S2.)#"  , py::arg("Index")
          )
        .def("MoreIntersection",
             (Standard_Boolean (TopOpeBRep_ShapeIntersector::*)() const) static_cast<Standard_Boolean (TopOpeBRep_ShapeIntersector::*)() const>(&TopOpeBRep_ShapeIntersector::MoreIntersection),
             R"#(returns True if there are more intersection between two the shapes.)#" 
          )
        .def("NextIntersection",
             (void (TopOpeBRep_ShapeIntersector::*)() ) static_cast<void (TopOpeBRep_ShapeIntersector::*)() >(&TopOpeBRep_ShapeIntersector::NextIntersection),
             R"#(search for the next intersection between the two shapes.)#" 
          )
        .def("CurrentGeomShape",
             ( const TopoDS_Shape & (TopOpeBRep_ShapeIntersector::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Shape & (TopOpeBRep_ShapeIntersector::*)(  const Standard_Integer  ) const>(&TopOpeBRep_ShapeIntersector::CurrentGeomShape),
             R"#(return geometric shape <Index> ( = 1 or 2 ) of current intersection.)#"  , py::arg("Index")
          )
        .def("DumpCurrent",
             (void (TopOpeBRep_ShapeIntersector::*)(  const Standard_Integer  ) const) static_cast<void (TopOpeBRep_ShapeIntersector::*)(  const Standard_Integer  ) const>(&TopOpeBRep_ShapeIntersector::DumpCurrent),
             R"#()#"  , py::arg("K")
          )
        .def("Index",
             (Standard_Integer (TopOpeBRep_ShapeIntersector::*)(  const Standard_Integer  ) const) static_cast<Standard_Integer (TopOpeBRep_ShapeIntersector::*)(  const Standard_Integer  ) const>(&TopOpeBRep_ShapeIntersector::Index),
             R"#()#"  , py::arg("K")
          )
        .def("RejectedFaces",
             (void (TopOpeBRep_ShapeIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,  TopTools_ListOfShape &  ) ) static_cast<void (TopOpeBRep_ShapeIntersector::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,  TopTools_ListOfShape &  ) >(&TopOpeBRep_ShapeIntersector::RejectedFaces),
             R"#()#"  , py::arg("anObj"),  py::arg("aReference"),  py::arg("aListOfShape")
          )
    // methods using call by reference i.s.o. return
        .def("GetTolerances",
             []( TopOpeBRep_ShapeIntersector &self   ){
                 Standard_Real  tol1;
                Standard_Real  tol2;

                 self.GetTolerances(tol1,tol2);
                 
                 return std::make_tuple(tol1,tol2); },
             R"#(return MAX of intersection tolerances with which FacesIntersector from TopOpeBRep was working.)#" 
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ChangeFacesIntersector",
             (TopOpeBRep_FacesIntersector & (TopOpeBRep_ShapeIntersector::*)() ) static_cast<TopOpeBRep_FacesIntersector & (TopOpeBRep_ShapeIntersector::*)() >(&TopOpeBRep_ShapeIntersector::ChangeFacesIntersector),
             R"#(return the current intersection of two Faces.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ChangeEdgesIntersector",
             (TopOpeBRep_EdgesIntersector & (TopOpeBRep_ShapeIntersector::*)() ) static_cast<TopOpeBRep_EdgesIntersector & (TopOpeBRep_ShapeIntersector::*)() >(&TopOpeBRep_ShapeIntersector::ChangeEdgesIntersector),
             R"#(return the current intersection of two Edges.)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("ChangeFaceEdgeIntersector",
             (TopOpeBRep_FaceEdgeIntersector & (TopOpeBRep_ShapeIntersector::*)() ) static_cast<TopOpeBRep_FaceEdgeIntersector & (TopOpeBRep_ShapeIntersector::*)() >(&TopOpeBRep_ShapeIntersector::ChangeFaceEdgeIntersector),
             R"#(return the current intersection of a Face and an Edge.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class TopOpeBRep_ShapeIntersector2d from ./opencascade/TopOpeBRep_ShapeIntersector2d.hxx
    klass = m.attr("TopOpeBRep_ShapeIntersector2d");


    // nested enums

    static_cast<py::class_<TopOpeBRep_ShapeIntersector2d , shared_ptr<TopOpeBRep_ShapeIntersector2d>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("InitIntersection",
             (void (TopOpeBRep_ShapeIntersector2d::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<void (TopOpeBRep_ShapeIntersector2d::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&TopOpeBRep_ShapeIntersector2d::InitIntersection),
             R"#(Initialize the intersection of shapes S1,S2.)#"  , py::arg("S1"),  py::arg("S2")
          )
        .def("Shape",
             ( const TopoDS_Shape & (TopOpeBRep_ShapeIntersector2d::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Shape & (TopOpeBRep_ShapeIntersector2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_ShapeIntersector2d::Shape),
             R"#(return the shape <Index> ( = 1 or 2) given to InitIntersection(). Index = 1 will return S1, Index = 2 will return S2.)#"  , py::arg("Index")
          )
        .def("MoreIntersection",
             (Standard_Boolean (TopOpeBRep_ShapeIntersector2d::*)() const) static_cast<Standard_Boolean (TopOpeBRep_ShapeIntersector2d::*)() const>(&TopOpeBRep_ShapeIntersector2d::MoreIntersection),
             R"#(returns True if there are more intersection between two the shapes.)#" 
          )
        .def("NextIntersection",
             (void (TopOpeBRep_ShapeIntersector2d::*)() ) static_cast<void (TopOpeBRep_ShapeIntersector2d::*)() >(&TopOpeBRep_ShapeIntersector2d::NextIntersection),
             R"#(search for the next intersection between the two shapes.)#" 
          )
        .def("CurrentGeomShape",
             ( const TopoDS_Shape & (TopOpeBRep_ShapeIntersector2d::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Shape & (TopOpeBRep_ShapeIntersector2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_ShapeIntersector2d::CurrentGeomShape),
             R"#(return geometric shape <Index> ( = 1 or 2 ) of current intersection.)#"  , py::arg("Index")
          )
        .def("DumpCurrent",
             (void (TopOpeBRep_ShapeIntersector2d::*)(  const Standard_Integer  ) const) static_cast<void (TopOpeBRep_ShapeIntersector2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_ShapeIntersector2d::DumpCurrent),
             R"#()#"  , py::arg("K")
          )
        .def("Index",
             (Standard_Integer (TopOpeBRep_ShapeIntersector2d::*)(  const Standard_Integer  ) const) static_cast<Standard_Integer (TopOpeBRep_ShapeIntersector2d::*)(  const Standard_Integer  ) const>(&TopOpeBRep_ShapeIntersector2d::Index),
             R"#()#"  , py::arg("K")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ChangeEdgesIntersector",
             (TopOpeBRep_EdgesIntersector & (TopOpeBRep_ShapeIntersector2d::*)() ) static_cast<TopOpeBRep_EdgesIntersector & (TopOpeBRep_ShapeIntersector2d::*)() >(&TopOpeBRep_ShapeIntersector2d::ChangeEdgesIntersector),
             R"#(return the current intersection of two Edges.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class TopOpeBRep_ShapeScanner from ./opencascade/TopOpeBRep_ShapeScanner.hxx
    klass = m.attr("TopOpeBRep_ShapeScanner");


    // nested enums

    static_cast<py::class_<TopOpeBRep_ShapeScanner , shared_ptr<TopOpeBRep_ShapeScanner>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Clear",
             (void (TopOpeBRep_ShapeScanner::*)() ) static_cast<void (TopOpeBRep_ShapeScanner::*)() >(&TopOpeBRep_ShapeScanner::Clear),
             R"#()#" 
          )
        .def("AddBoxesMakeCOB",
             (void (TopOpeBRep_ShapeScanner::*)(  const TopoDS_Shape & ,   const TopAbs_ShapeEnum ,   const TopAbs_ShapeEnum  ) ) static_cast<void (TopOpeBRep_ShapeScanner::*)(  const TopoDS_Shape & ,   const TopAbs_ShapeEnum ,   const TopAbs_ShapeEnum  ) >(&TopOpeBRep_ShapeScanner::AddBoxesMakeCOB),
             R"#()#"  , py::arg("S"),  py::arg("TS"),  py::arg("TA")=static_cast< const TopAbs_ShapeEnum>(TopAbs_SHAPE)
          )
        .def("Init",
             (void (TopOpeBRep_ShapeScanner::*)(  const TopoDS_Shape &  ) ) static_cast<void (TopOpeBRep_ShapeScanner::*)(  const TopoDS_Shape &  ) >(&TopOpeBRep_ShapeScanner::Init),
             R"#()#"  , py::arg("E")
          )
        .def("Init",
             (void (TopOpeBRep_ShapeScanner::*)( TopOpeBRepTool_ShapeExplorer &  ) ) static_cast<void (TopOpeBRep_ShapeScanner::*)( TopOpeBRepTool_ShapeExplorer &  ) >(&TopOpeBRep_ShapeScanner::Init),
             R"#()#"  , py::arg("X")
          )
        .def("More",
             (Standard_Boolean (TopOpeBRep_ShapeScanner::*)() const) static_cast<Standard_Boolean (TopOpeBRep_ShapeScanner::*)() const>(&TopOpeBRep_ShapeScanner::More),
             R"#()#" 
          )
        .def("Next",
             (void (TopOpeBRep_ShapeScanner::*)() ) static_cast<void (TopOpeBRep_ShapeScanner::*)() >(&TopOpeBRep_ShapeScanner::Next),
             R"#()#" 
          )
        .def("Index",
             (Standard_Integer (TopOpeBRep_ShapeScanner::*)() const) static_cast<Standard_Integer (TopOpeBRep_ShapeScanner::*)() const>(&TopOpeBRep_ShapeScanner::Index),
             R"#()#" 
          )
        .def("DumpCurrent",
             (Standard_OStream & (TopOpeBRep_ShapeScanner::*)( Standard_OStream &  ) const) static_cast<Standard_OStream & (TopOpeBRep_ShapeScanner::*)( Standard_OStream &  ) const>(&TopOpeBRep_ShapeScanner::DumpCurrent),
             R"#()#"  , py::arg("OS")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Current",
             ( const TopoDS_Shape & (TopOpeBRep_ShapeScanner::*)() const) static_cast< const TopoDS_Shape & (TopOpeBRep_ShapeScanner::*)() const>(&TopOpeBRep_ShapeScanner::Current),
             R"#()#"
             
         )
       .def("BoxSort",
             ( const TopOpeBRepTool_BoxSort & (TopOpeBRep_ShapeScanner::*)() const) static_cast< const TopOpeBRepTool_BoxSort & (TopOpeBRep_ShapeScanner::*)() const>(&TopOpeBRep_ShapeScanner::BoxSort),
             R"#()#"
             
         )
       .def("ChangeBoxSort",
             (TopOpeBRepTool_BoxSort & (TopOpeBRep_ShapeScanner::*)() ) static_cast<TopOpeBRepTool_BoxSort & (TopOpeBRep_ShapeScanner::*)() >(&TopOpeBRep_ShapeScanner::ChangeBoxSort),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class TopOpeBRep_VPointInter from ./opencascade/TopOpeBRep_VPointInter.hxx
    klass = m.attr("TopOpeBRep_VPointInter");


    // nested enums

    static_cast<py::class_<TopOpeBRep_VPointInter , shared_ptr<TopOpeBRep_VPointInter>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetPoint",
             (void (TopOpeBRep_VPointInter::*)(  const IntPatch_Point &  ) ) static_cast<void (TopOpeBRep_VPointInter::*)(  const IntPatch_Point &  ) >(&TopOpeBRep_VPointInter::SetPoint),
             R"#()#"  , py::arg("P")
          )
        .def("SetShapes",
             (void (TopOpeBRep_VPointInter::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (TopOpeBRep_VPointInter::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&TopOpeBRep_VPointInter::SetShapes),
             R"#()#"  , py::arg("I1"),  py::arg("I2")
          )
        .def("TransitionOnS1",
             (IntSurf_Transition (TopOpeBRep_VPointInter::*)() const) static_cast<IntSurf_Transition (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::TransitionOnS1),
             R"#()#" 
          )
        .def("TransitionOnS2",
             (IntSurf_Transition (TopOpeBRep_VPointInter::*)() const) static_cast<IntSurf_Transition (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::TransitionOnS2),
             R"#()#" 
          )
        .def("TransitionLineArc1",
             (IntSurf_Transition (TopOpeBRep_VPointInter::*)() const) static_cast<IntSurf_Transition (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::TransitionLineArc1),
             R"#()#" 
          )
        .def("TransitionLineArc2",
             (IntSurf_Transition (TopOpeBRep_VPointInter::*)() const) static_cast<IntSurf_Transition (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::TransitionLineArc2),
             R"#()#" 
          )
        .def("IsOnDomS1",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::IsOnDomS1),
             R"#()#" 
          )
        .def("IsOnDomS2",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::IsOnDomS2),
             R"#()#" 
          )
        .def("Tolerance",
             (Standard_Real (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Real (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::Tolerance),
             R"#()#" 
          )
        .def("ParameterOnLine",
             (Standard_Real (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Real (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::ParameterOnLine),
             R"#()#" 
          )
        .def("ParameterOnArc1",
             (Standard_Real (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Real (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::ParameterOnArc1),
             R"#()#" 
          )
        .def("IsVertexOnS1",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::IsVertexOnS1),
             R"#(Returns TRUE if the point is a vertex on the initial restriction facet of the first surface.)#" 
          )
        .def("ParameterOnArc2",
             (Standard_Real (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Real (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::ParameterOnArc2),
             R"#()#" 
          )
        .def("IsVertexOnS2",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::IsVertexOnS2),
             R"#(Returns TRUE if the point is a vertex on the initial restriction facet of the second surface.)#" 
          )
        .def("IsInternal",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::IsInternal),
             R"#()#" 
          )
        .def("IsMultiple",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::IsMultiple),
             R"#(Returns True if the point belongs to several intersection lines.)#" 
          )
        .def("State",
             (TopAbs_State (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const) static_cast<TopAbs_State (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const>(&TopOpeBRep_VPointInter::State),
             R"#(get state of VPoint within the domain of geometric shape domain <I> (= 1 or 2).)#"  , py::arg("I")
          )
        .def("State",
             (void (TopOpeBRep_VPointInter::*)(  const TopAbs_State ,   const Standard_Integer  ) ) static_cast<void (TopOpeBRep_VPointInter::*)(  const TopAbs_State ,   const Standard_Integer  ) >(&TopOpeBRep_VPointInter::State),
             R"#(Set the state of VPoint within the domain of the geometric shape <I> (= 1 or 2).)#"  , py::arg("S"),  py::arg("I")
          )
        .def("EdgeON",
             (void (TopOpeBRep_VPointInter::*)(  const TopoDS_Shape & ,   const Standard_Real ,   const Standard_Integer  ) ) static_cast<void (TopOpeBRep_VPointInter::*)(  const TopoDS_Shape & ,   const Standard_Real ,   const Standard_Integer  ) >(&TopOpeBRep_VPointInter::EdgeON),
             R"#(set the shape Eon of shape I (1,2) containing the point, and parameter <Par> of point on <Eon>.)#"  , py::arg("Eon"),  py::arg("Par"),  py::arg("I")
          )
        .def("EdgeON",
             ( const TopoDS_Shape & (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Shape & (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const>(&TopOpeBRep_VPointInter::EdgeON),
             R"#(get the edge of shape I (1,2) containing the point.)#"  , py::arg("I")
          )
        .def("EdgeONParameter",
             (Standard_Real (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const) static_cast<Standard_Real (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const>(&TopOpeBRep_VPointInter::EdgeONParameter),
             R"#(get the parameter on edge of shape I (1,2) containing the point.)#"  , py::arg("I")
          )
        .def("ShapeIndex",
             (Standard_Integer (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Integer (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::ShapeIndex),
             R"#(returns value of filed myShapeIndex = 0,1,2,3 0 means the VPoint is on no restriction 1 means the VPoint is on the restriction 1 2 means the VPoint is on the restriction 2 3 means the VPoint is on the restrictions 1 and 2)#" 
          )
        .def("ShapeIndex",
             (void (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) ) static_cast<void (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) >(&TopOpeBRep_VPointInter::ShapeIndex),
             R"#(set value of shape supporting me (0,1,2,3).)#"  , py::arg("I")
          )
        .def("Edge",
             ( const TopoDS_Shape & (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Shape & (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const>(&TopOpeBRep_VPointInter::Edge),
             R"#(get the edge of shape I (1,2) containing the point. Returned shape is null if the VPoint is not on an edge of shape I (1,2).)#"  , py::arg("I")
          )
        .def("EdgeParameter",
             (Standard_Real (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const) static_cast<Standard_Real (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const>(&TopOpeBRep_VPointInter::EdgeParameter),
             R"#(get the parameter on edge of shape I (1,2) containing the point)#"  , py::arg("I")
          )
        .def("SurfaceParameters",
             (gp_Pnt2d (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const) static_cast<gp_Pnt2d (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const>(&TopOpeBRep_VPointInter::SurfaceParameters),
             R"#(get the parameter on surface of shape I (1,2) containing the point)#"  , py::arg("I")
          )
        .def("IsVertex",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const>(&TopOpeBRep_VPointInter::IsVertex),
             R"#()#"  , py::arg("I")
          )
        .def("Vertex",
             ( const TopoDS_Shape & (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const) static_cast< const TopoDS_Shape & (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) const>(&TopOpeBRep_VPointInter::Vertex),
             R"#()#"  , py::arg("I")
          )
        .def("UpdateKeep",
             (void (TopOpeBRep_VPointInter::*)() ) static_cast<void (TopOpeBRep_VPointInter::*)() >(&TopOpeBRep_VPointInter::UpdateKeep),
             R"#(set myKeep value according to current states.)#" 
          )
        .def("Keep",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::Keep),
             R"#(Returns value of myKeep (does not evaluate states) False at creation of VPoint. Updated by State(State from TopAbs,Integer from Standard))#" 
          )
        .def("ChangeKeep",
             (void (TopOpeBRep_VPointInter::*)(  const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_VPointInter::*)(  const Standard_Boolean  ) >(&TopOpeBRep_VPointInter::ChangeKeep),
             R"#(updates VPointInter flag "keep" with <keep>.)#"  , py::arg("keep")
          )
        .def("EqualpP",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)(  const TopOpeBRep_VPointInter &  ) const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)(  const TopOpeBRep_VPointInter &  ) const>(&TopOpeBRep_VPointInter::EqualpP),
             R"#(returns <True> if the 3d points and the parameters of the VPoints are same)#"  , py::arg("VP")
          )
        .def("ParonE",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)(  const TopoDS_Edge & ,  Standard_Real &  ) const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)(  const TopoDS_Edge & ,  Standard_Real &  ) const>(&TopOpeBRep_VPointInter::ParonE),
             R"#(returns <false> if the vpoint is not given on arc <E>, else returns <par> parameter on <E>)#"  , py::arg("E"),  py::arg("par")
          )
        .def("Index",
             (void (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) ) static_cast<void (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) >(&TopOpeBRep_VPointInter::Index),
             R"#()#"  , py::arg("I")
          )
        .def("Index",
             (Standard_Integer (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Integer (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::Index),
             R"#()#" 
          )
        .def("Dump",
             (Standard_OStream & (TopOpeBRep_VPointInter::*)(  const Standard_Integer ,   const TopoDS_Face & ,  Standard_OStream &  ) const) static_cast<Standard_OStream & (TopOpeBRep_VPointInter::*)(  const Standard_Integer ,   const TopoDS_Face & ,  Standard_OStream &  ) const>(&TopOpeBRep_VPointInter::Dump),
             R"#()#"  , py::arg("I"),  py::arg("F"),  py::arg("OS")
          )
        .def("Dump",
             (Standard_OStream & (TopOpeBRep_VPointInter::*)(  const TopoDS_Face & ,   const TopoDS_Face & ,  Standard_OStream &  ) const) static_cast<Standard_OStream & (TopOpeBRep_VPointInter::*)(  const TopoDS_Face & ,   const TopoDS_Face & ,  Standard_OStream &  ) const>(&TopOpeBRep_VPointInter::Dump),
             R"#()#"  , py::arg("F1"),  py::arg("F2"),  py::arg("OS")
          )
        .def("PThePointOfIntersectionDummy",
             (TopOpeBRep_PThePointOfIntersection (TopOpeBRep_VPointInter::*)() const) static_cast<TopOpeBRep_PThePointOfIntersection (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::PThePointOfIntersectionDummy),
             R"#()#" 
          )
        .def("SetShapes",
             (void (TopOpeBRep_VPointInter::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (TopOpeBRep_VPointInter::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&TopOpeBRep_VPointInter::SetShapes),
             R"#()#"  , py::arg("I1"),  py::arg("I2")
          )
        .def("TransitionOnS1",
             (IntSurf_Transition (TopOpeBRep_VPointInter::*)() const) static_cast<IntSurf_Transition (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::TransitionOnS1),
             R"#()#" 
          )
        .def("TransitionOnS2",
             (IntSurf_Transition (TopOpeBRep_VPointInter::*)() const) static_cast<IntSurf_Transition (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::TransitionOnS2),
             R"#()#" 
          )
        .def("TransitionLineArc1",
             (IntSurf_Transition (TopOpeBRep_VPointInter::*)() const) static_cast<IntSurf_Transition (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::TransitionLineArc1),
             R"#()#" 
          )
        .def("TransitionLineArc2",
             (IntSurf_Transition (TopOpeBRep_VPointInter::*)() const) static_cast<IntSurf_Transition (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::TransitionLineArc2),
             R"#()#" 
          )
        .def("IsOnDomS1",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::IsOnDomS1),
             R"#()#" 
          )
        .def("IsOnDomS2",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::IsOnDomS2),
             R"#()#" 
          )
        .def("Tolerance",
             (Standard_Real (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Real (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::Tolerance),
             R"#()#" 
          )
        .def("ParameterOnLine",
             (Standard_Real (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Real (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::ParameterOnLine),
             R"#()#" 
          )
        .def("ParameterOnArc1",
             (Standard_Real (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Real (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::ParameterOnArc1),
             R"#()#" 
          )
        .def("ParameterOnArc2",
             (Standard_Real (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Real (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::ParameterOnArc2),
             R"#()#" 
          )
        .def("IsVertexOnS1",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::IsVertexOnS1),
             R"#(Returns TRUE if the point is a vertex on the initial restriction facet of the first surface.)#" 
          )
        .def("IsVertexOnS2",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::IsVertexOnS2),
             R"#(Returns TRUE if the point is a vertex on the initial restriction facet of the second surface.)#" 
          )
        .def("IsMultiple",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::IsMultiple),
             R"#(Returns True if the point belongs to several intersection lines.)#" 
          )
        .def("IsInternal",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::IsInternal),
             R"#()#" 
          )
        .def("ShapeIndex",
             (Standard_Integer (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Integer (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::ShapeIndex),
             R"#(returns value of filed myShapeIndex = 0,1,2,3 0 means the VPoint is on no restriction 1 means the VPoint is on the restriction 1 2 means the VPoint is on the restriction 2 3 means the VPoint is on the restrictions 1 and 2)#" 
          )
        .def("ShapeIndex",
             (void (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) ) static_cast<void (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) >(&TopOpeBRep_VPointInter::ShapeIndex),
             R"#(set value of shape supporting me (0,1,2,3).)#"  , py::arg("I")
          )
        .def("Keep",
             (Standard_Boolean (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::Keep),
             R"#(Returns value of myKeep (does not evaluate states) False at creation of VPoint. Updated by State(State from TopAbs,Integer from Standard))#" 
          )
        .def("ChangeKeep",
             (void (TopOpeBRep_VPointInter::*)(  const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_VPointInter::*)(  const Standard_Boolean  ) >(&TopOpeBRep_VPointInter::ChangeKeep),
             R"#(updates VPointInter flag "keep" with <keep>.)#"  , py::arg("keep")
          )
        .def("Index",
             (void (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) ) static_cast<void (TopOpeBRep_VPointInter::*)(  const Standard_Integer  ) >(&TopOpeBRep_VPointInter::Index),
             R"#()#"  , py::arg("I")
          )
        .def("Index",
             (Standard_Integer (TopOpeBRep_VPointInter::*)() const) static_cast<Standard_Integer (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::Index),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
        .def("GetShapes",
             []( TopOpeBRep_VPointInter &self   ){
                 Standard_Integer  I1;
                Standard_Integer  I2;

                 self.GetShapes(I1,I2);
                 
                 return std::make_tuple(I1,I2); },
             R"#()#" 
          )
        .def("ParametersOnS1",
             []( TopOpeBRep_VPointInter &self   ){
                 Standard_Real  u;
                Standard_Real  v;

                 self.ParametersOnS1(u,v);
                 
                 return std::make_tuple(u,v); },
             R"#()#" 
          )
        .def("ParametersOnS2",
             []( TopOpeBRep_VPointInter &self   ){
                 Standard_Real  u;
                Standard_Real  v;

                 self.ParametersOnS2(u,v);
                 
                 return std::make_tuple(u,v); },
             R"#()#" 
          )
        .def("GetShapes",
             []( TopOpeBRep_VPointInter &self   ){
                 Standard_Integer  I1;
                Standard_Integer  I2;

                 self.GetShapes(I1,I2);
                 
                 return std::make_tuple(I1,I2); },
             R"#()#" 
          )
        .def("ParametersOnS1",
             []( TopOpeBRep_VPointInter &self   ){
                 Standard_Real  u;
                Standard_Real  v;

                 self.ParametersOnS1(u,v);
                 
                 return std::make_tuple(u,v); },
             R"#()#" 
          )
        .def("ParametersOnS2",
             []( TopOpeBRep_VPointInter &self   ){
                 Standard_Real  u;
                Standard_Real  v;

                 self.ParametersOnS2(u,v);
                 
                 return std::make_tuple(u,v); },
             R"#()#" 
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             ( const gp_Pnt & (TopOpeBRep_VPointInter::*)() const) static_cast< const gp_Pnt & (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::Value),
             R"#()#"
             
         )
       .def("ArcOnS1",
             ( const TopoDS_Shape & (TopOpeBRep_VPointInter::*)() const) static_cast< const TopoDS_Shape & (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::ArcOnS1),
             R"#()#"
             
         )
       .def("ArcOnS2",
             ( const TopoDS_Shape & (TopOpeBRep_VPointInter::*)() const) static_cast< const TopoDS_Shape & (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::ArcOnS2),
             R"#()#"
             
         )
       .def("VertexOnS1",
             ( const TopoDS_Shape & (TopOpeBRep_VPointInter::*)() const) static_cast< const TopoDS_Shape & (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::VertexOnS1),
             R"#(Returns the information about the point when it is on the domain of the first patch, i-e when the function IsVertexOnS1 returns True. Otherwise, an exception is raised.)#"
             
         )
       .def("VertexOnS2",
             ( const TopoDS_Shape & (TopOpeBRep_VPointInter::*)() const) static_cast< const TopoDS_Shape & (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::VertexOnS2),
             R"#(Returns the information about the point when it is on the domain of the second patch, i-e when the function IsVertexOnS2 returns True. Otherwise, an exception is raised.)#"
             
         )
       .def("Value",
             ( const gp_Pnt & (TopOpeBRep_VPointInter::*)() const) static_cast< const gp_Pnt & (TopOpeBRep_VPointInter::*)() const>(&TopOpeBRep_VPointInter::Value),
             R"#()#"
             
         )
;

    // Class TopOpeBRep_VPointInterClassifier from ./opencascade/TopOpeBRep_VPointInterClassifier.hxx
    klass = m.attr("TopOpeBRep_VPointInterClassifier");


    // nested enums

    static_cast<py::class_<TopOpeBRep_VPointInterClassifier , shared_ptr<TopOpeBRep_VPointInterClassifier>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("VPointPosition",
             (TopAbs_State (TopOpeBRep_VPointInterClassifier::*)(  const TopoDS_Shape & ,  TopOpeBRep_VPointInter & ,   const Standard_Integer ,  TopOpeBRep_PointClassifier & ,   const Standard_Boolean ,   const Standard_Real  ) ) static_cast<TopAbs_State (TopOpeBRep_VPointInterClassifier::*)(  const TopoDS_Shape & ,  TopOpeBRep_VPointInter & ,   const Standard_Integer ,  TopOpeBRep_PointClassifier & ,   const Standard_Boolean ,   const Standard_Real  ) >(&TopOpeBRep_VPointInterClassifier::VPointPosition),
             R"#(compute position of VPoint <VP> regarding with face <F>. <ShapeIndex> (= 1,2) indicates which (u,v) point of <VP> is used. when state is ON, set VP.EdgeON() with the edge containing <VP> and associated parameter. returns state of VP on ShapeIndex.)#"  , py::arg("F"),  py::arg("VP"),  py::arg("ShapeIndex"),  py::arg("PC"),  py::arg("AssumeINON"),  py::arg("Tol")
          )
        .def("EdgeParameter",
             (Standard_Real (TopOpeBRep_VPointInterClassifier::*)() const) static_cast<Standard_Real (TopOpeBRep_VPointInterClassifier::*)() const>(&TopOpeBRep_VPointInterClassifier::EdgeParameter),
             R"#(returns the parameter of the VPoint <VP> on Edge())#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Edge",
             ( const TopoDS_Shape & (TopOpeBRep_VPointInterClassifier::*)() const) static_cast< const TopoDS_Shape & (TopOpeBRep_VPointInterClassifier::*)() const>(&TopOpeBRep_VPointInterClassifier::Edge),
             R"#(returns the edge containing the VPoint <VP> used in the last VPointPosition() call. Edge is defined if the state previously computed is ON, else Edge is a null shape.)#"
             
         )
;

    // Class TopOpeBRep_VPointInterIterator from ./opencascade/TopOpeBRep_VPointInterIterator.hxx
    klass = m.attr("TopOpeBRep_VPointInterIterator");


    // nested enums

    static_cast<py::class_<TopOpeBRep_VPointInterIterator , shared_ptr<TopOpeBRep_VPointInterIterator>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopOpeBRep_LineInter & >()  , py::arg("LI") )
    // custom constructors
    // methods
        .def("Init",
             (void (TopOpeBRep_VPointInterIterator::*)(  const TopOpeBRep_LineInter & ,   const Standard_Boolean  ) ) static_cast<void (TopOpeBRep_VPointInterIterator::*)(  const TopOpeBRep_LineInter & ,   const Standard_Boolean  ) >(&TopOpeBRep_VPointInterIterator::Init),
             R"#()#"  , py::arg("LI"),  py::arg("checkkeep")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def("Init",
             (void (TopOpeBRep_VPointInterIterator::*)() ) static_cast<void (TopOpeBRep_VPointInterIterator::*)() >(&TopOpeBRep_VPointInterIterator::Init),
             R"#()#" 
          )
        .def("More",
             (Standard_Boolean (TopOpeBRep_VPointInterIterator::*)() const) static_cast<Standard_Boolean (TopOpeBRep_VPointInterIterator::*)() const>(&TopOpeBRep_VPointInterIterator::More),
             R"#()#" 
          )
        .def("Next",
             (void (TopOpeBRep_VPointInterIterator::*)() ) static_cast<void (TopOpeBRep_VPointInterIterator::*)() >(&TopOpeBRep_VPointInterIterator::Next),
             R"#()#" 
          )
        .def("CurrentVPIndex",
             (Standard_Integer (TopOpeBRep_VPointInterIterator::*)() const) static_cast<Standard_Integer (TopOpeBRep_VPointInterIterator::*)() const>(&TopOpeBRep_VPointInterIterator::CurrentVPIndex),
             R"#()#" 
          )
        .def("PLineInterDummy",
             (TopOpeBRep_PLineInter (TopOpeBRep_VPointInterIterator::*)() const) static_cast<TopOpeBRep_PLineInter (TopOpeBRep_VPointInterIterator::*)() const>(&TopOpeBRep_VPointInterIterator::PLineInterDummy),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("CurrentVP",
             ( const TopOpeBRep_VPointInter & (TopOpeBRep_VPointInterIterator::*)() ) static_cast< const TopOpeBRep_VPointInter & (TopOpeBRep_VPointInterIterator::*)() >(&TopOpeBRep_VPointInterIterator::CurrentVP),
             R"#()#"
             
         )
       .def("ChangeCurrentVP",
             (TopOpeBRep_VPointInter & (TopOpeBRep_VPointInterIterator::*)() ) static_cast<TopOpeBRep_VPointInter & (TopOpeBRep_VPointInterIterator::*)() >(&TopOpeBRep_VPointInterIterator::ChangeCurrentVP),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class TopOpeBRep_WPointInter from ./opencascade/TopOpeBRep_WPointInter.hxx
    klass = m.attr("TopOpeBRep_WPointInter");


    // nested enums

    static_cast<py::class_<TopOpeBRep_WPointInter , shared_ptr<TopOpeBRep_WPointInter>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Set",
             (void (TopOpeBRep_WPointInter::*)(  const IntSurf_PntOn2S &  ) ) static_cast<void (TopOpeBRep_WPointInter::*)(  const IntSurf_PntOn2S &  ) >(&TopOpeBRep_WPointInter::Set),
             R"#()#"  , py::arg("P")
          )
        .def("ValueOnS1",
             (gp_Pnt2d (TopOpeBRep_WPointInter::*)() const) static_cast<gp_Pnt2d (TopOpeBRep_WPointInter::*)() const>(&TopOpeBRep_WPointInter::ValueOnS1),
             R"#()#" 
          )
        .def("ValueOnS2",
             (gp_Pnt2d (TopOpeBRep_WPointInter::*)() const) static_cast<gp_Pnt2d (TopOpeBRep_WPointInter::*)() const>(&TopOpeBRep_WPointInter::ValueOnS2),
             R"#()#" 
          )
        .def("PPntOn2SDummy",
             (TopOpeBRep_PPntOn2S (TopOpeBRep_WPointInter::*)() const) static_cast<TopOpeBRep_PPntOn2S (TopOpeBRep_WPointInter::*)() const>(&TopOpeBRep_WPointInter::PPntOn2SDummy),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
        .def("ParametersOnS1",
             []( TopOpeBRep_WPointInter &self   ){
                 Standard_Real  U;
                Standard_Real  V;

                 self.ParametersOnS1(U,V);
                 
                 return std::make_tuple(U,V); },
             R"#()#" 
          )
        .def("ParametersOnS2",
             []( TopOpeBRep_WPointInter &self   ){
                 Standard_Real  U;
                Standard_Real  V;

                 self.ParametersOnS2(U,V);
                 
                 return std::make_tuple(U,V); },
             R"#()#" 
          )
        .def("Parameters",
             []( TopOpeBRep_WPointInter &self   ){
                 Standard_Real  U1;
                Standard_Real  V1;
                Standard_Real  U2;
                Standard_Real  V2;

                 self.Parameters(U1,V1,U2,V2);
                 
                 return std::make_tuple(U1,V1,U2,V2); },
             R"#()#" 
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Value",
             ( const gp_Pnt & (TopOpeBRep_WPointInter::*)() const) static_cast< const gp_Pnt & (TopOpeBRep_WPointInter::*)() const>(&TopOpeBRep_WPointInter::Value),
             R"#()#"
             
         )
;

    // Class TopOpeBRep_WPointInterIterator from ./opencascade/TopOpeBRep_WPointInterIterator.hxx
    klass = m.attr("TopOpeBRep_WPointInterIterator");


    // nested enums

    static_cast<py::class_<TopOpeBRep_WPointInterIterator , shared_ptr<TopOpeBRep_WPointInterIterator>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopOpeBRep_LineInter & >()  , py::arg("LI") )
    // custom constructors
    // methods
        .def("Init",
             (void (TopOpeBRep_WPointInterIterator::*)(  const TopOpeBRep_LineInter &  ) ) static_cast<void (TopOpeBRep_WPointInterIterator::*)(  const TopOpeBRep_LineInter &  ) >(&TopOpeBRep_WPointInterIterator::Init),
             R"#()#"  , py::arg("LI")
          )
        .def("Init",
             (void (TopOpeBRep_WPointInterIterator::*)() ) static_cast<void (TopOpeBRep_WPointInterIterator::*)() >(&TopOpeBRep_WPointInterIterator::Init),
             R"#()#" 
          )
        .def("More",
             (Standard_Boolean (TopOpeBRep_WPointInterIterator::*)() const) static_cast<Standard_Boolean (TopOpeBRep_WPointInterIterator::*)() const>(&TopOpeBRep_WPointInterIterator::More),
             R"#()#" 
          )
        .def("Next",
             (void (TopOpeBRep_WPointInterIterator::*)() ) static_cast<void (TopOpeBRep_WPointInterIterator::*)() >(&TopOpeBRep_WPointInterIterator::Next),
             R"#()#" 
          )
        .def("PLineInterDummy",
             (TopOpeBRep_PLineInter (TopOpeBRep_WPointInterIterator::*)() const) static_cast<TopOpeBRep_PLineInter (TopOpeBRep_WPointInterIterator::*)() const>(&TopOpeBRep_WPointInterIterator::PLineInterDummy),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("CurrentWP",
             ( const TopOpeBRep_WPointInter & (TopOpeBRep_WPointInterIterator::*)() ) static_cast< const TopOpeBRep_WPointInter & (TopOpeBRep_WPointInterIterator::*)() >(&TopOpeBRep_WPointInterIterator::CurrentWP),
             R"#()#"
             
         )
;

// functions

// ./opencascade/TopOpeBRep.hxx
// ./opencascade/TopOpeBRep_Array1OfLineInter.hxx
// ./opencascade/TopOpeBRep_Array1OfVPointInter.hxx
// ./opencascade/TopOpeBRep_Bipoint.hxx
// ./opencascade/TopOpeBRep_DRAW.hxx
// ./opencascade/TopOpeBRep_DSFiller.hxx
// ./opencascade/TopOpeBRep_DataMapIteratorOfDataMapOfTopolTool.hxx
// ./opencascade/TopOpeBRep_DataMapOfTopolTool.hxx
// ./opencascade/TopOpeBRep_EdgesFiller.hxx
// ./opencascade/TopOpeBRep_EdgesIntersector.hxx
// ./opencascade/TopOpeBRep_FFDumper.hxx
// ./opencascade/TopOpeBRep_FFTransitionTool.hxx
// ./opencascade/TopOpeBRep_FaceEdgeFiller.hxx
// ./opencascade/TopOpeBRep_FaceEdgeIntersector.hxx
// ./opencascade/TopOpeBRep_FacesFiller.hxx
// ./opencascade/TopOpeBRep_FacesIntersector.hxx
// ./opencascade/TopOpeBRep_GeomTool.hxx
// ./opencascade/TopOpeBRep_HArray1OfLineInter.hxx
// ./opencascade/TopOpeBRep_HArray1OfVPointInter.hxx
// ./opencascade/TopOpeBRep_Hctxee2d.hxx
// ./opencascade/TopOpeBRep_Hctxff2d.hxx
// ./opencascade/TopOpeBRep_LineInter.hxx
// ./opencascade/TopOpeBRep_ListIteratorOfListOfBipoint.hxx
// ./opencascade/TopOpeBRep_ListOfBipoint.hxx
// ./opencascade/TopOpeBRep_P2Dstatus.hxx
// ./opencascade/TopOpeBRep_PEdgesIntersector.hxx
// ./opencascade/TopOpeBRep_PFacesFiller.hxx
// ./opencascade/TopOpeBRep_PFacesIntersector.hxx
// ./opencascade/TopOpeBRep_PIntRes2d_IntersectionPoint.hxx
// ./opencascade/TopOpeBRep_PLineInter.hxx
// ./opencascade/TopOpeBRep_PPntOn2S.hxx
// ./opencascade/TopOpeBRep_PThePointOfIntersection.hxx
// ./opencascade/TopOpeBRep_Point2d.hxx
// ./opencascade/TopOpeBRep_PointClassifier.hxx
// ./opencascade/TopOpeBRep_PointGeomTool.hxx
// ./opencascade/TopOpeBRep_SequenceOfPoint2d.hxx
// ./opencascade/TopOpeBRep_ShapeIntersector.hxx
// ./opencascade/TopOpeBRep_ShapeIntersector2d.hxx
// ./opencascade/TopOpeBRep_ShapeScanner.hxx
// ./opencascade/TopOpeBRep_TypeLineCurve.hxx
// ./opencascade/TopOpeBRep_VPointInter.hxx
// ./opencascade/TopOpeBRep_VPointInterClassifier.hxx
// ./opencascade/TopOpeBRep_VPointInterIterator.hxx
// ./opencascade/TopOpeBRep_WPointInter.hxx
// ./opencascade/TopOpeBRep_WPointInterIterator.hxx
// ./opencascade/TopOpeBRep_define.hxx
// ./opencascade/TopOpeBRep_traceSIFF.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_Array1<TopOpeBRep_LineInter>(m,"TopOpeBRep_Array1OfLineInter");
    register_template_NCollection_Array1<TopOpeBRep_VPointInter>(m,"TopOpeBRep_Array1OfVPointInter");
    register_template_NCollection_List<TopOpeBRep_Bipoint>(m,"TopOpeBRep_ListOfBipoint");
    register_template_NCollection_Sequence<TopOpeBRep_Point2d>(m,"TopOpeBRep_SequenceOfPoint2d");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
