
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepBasic_ProductDefinitionFormation.hxx>
#include <StepFEA_FeaModel.hxx>
#include <StepBasic_Product.hxx>
#include <StepFEA_FeaAxis2Placement3d.hxx>
#include <StepShape_ShapeRepresentation.hxx>
#include <StepFEA_Curve3dElementRepresentation.hxx>
#include <StepBasic_ProductDefinition.hxx>
#include <StepData_StepModel.hxx>
#include <StepRepr_ProductDefinitionShape.hxx>

// module includes
#include <StepAP209_Construct.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_StepAP209(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("StepAP209"));
py::object klass;

//Python trampoline classes

// classes

    // Class StepAP209_Construct from ./opencascade/StepAP209_Construct.hxx
    klass = m.attr("StepAP209_Construct");


    // nested enums

    static_cast<py::class_<StepAP209_Construct , shared_ptr<StepAP209_Construct>  , STEPConstruct_Tool >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<XSControl_WorkSession> & >()  , py::arg("WS") )
    // custom constructors
    // methods
        .def("Init",
             (Standard_Boolean (StepAP209_Construct::*)(  const handle<XSControl_WorkSession> &  ) ) static_cast<Standard_Boolean (StepAP209_Construct::*)(  const handle<XSControl_WorkSession> &  ) >(&StepAP209_Construct::Init),
             R"#(Initializes tool; returns True if succeeded)#"  , py::arg("WS")
          )
        .def("IsDesing",
             (Standard_Boolean (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinitionFormation> &  ) const) static_cast<Standard_Boolean (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinitionFormation> &  ) const>(&StepAP209_Construct::IsDesing),
             R"#()#"  , py::arg("PD")
          )
        .def("IsAnalys",
             (Standard_Boolean (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinitionFormation> &  ) const) static_cast<Standard_Boolean (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinitionFormation> &  ) const>(&StepAP209_Construct::IsAnalys),
             R"#()#"  , py::arg("PD")
          )
        .def("FeaModel",
             (handle<StepFEA_FeaModel> (StepAP209_Construct::*)(  const handle<StepBasic_Product> &  ) const) static_cast<handle<StepFEA_FeaModel> (StepAP209_Construct::*)(  const handle<StepBasic_Product> &  ) const>(&StepAP209_Construct::FeaModel),
             R"#()#"  , py::arg("Prod")
          )
        .def("FeaModel",
             (handle<StepFEA_FeaModel> (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinitionFormation> &  ) const) static_cast<handle<StepFEA_FeaModel> (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinitionFormation> &  ) const>(&StepAP209_Construct::FeaModel),
             R"#()#"  , py::arg("PDF")
          )
        .def("GetFeaAxis2Placement3d",
             (handle<StepFEA_FeaAxis2Placement3d> (StepAP209_Construct::*)(  const handle<StepFEA_FeaModel> &  ) const) static_cast<handle<StepFEA_FeaAxis2Placement3d> (StepAP209_Construct::*)(  const handle<StepFEA_FeaModel> &  ) const>(&StepAP209_Construct::GetFeaAxis2Placement3d),
             R"#()#"  , py::arg("theFeaModel")
          )
        .def("IdealShape",
             (handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepBasic_Product> &  ) const) static_cast<handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepBasic_Product> &  ) const>(&StepAP209_Construct::IdealShape),
             R"#()#"  , py::arg("Prod")
          )
        .def("IdealShape",
             (handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinitionFormation> &  ) const) static_cast<handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinitionFormation> &  ) const>(&StepAP209_Construct::IdealShape),
             R"#()#"  , py::arg("PDF")
          )
        .def("NominShape",
             (handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepBasic_Product> &  ) const) static_cast<handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepBasic_Product> &  ) const>(&StepAP209_Construct::NominShape),
             R"#()#"  , py::arg("Prod")
          )
        .def("NominShape",
             (handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinitionFormation> &  ) const) static_cast<handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinitionFormation> &  ) const>(&StepAP209_Construct::NominShape),
             R"#()#"  , py::arg("PDF")
          )
        .def("GetElementMaterial",
             (handle<StepElement_HSequenceOfElementMaterial> (StepAP209_Construct::*)() const) static_cast<handle<StepElement_HSequenceOfElementMaterial> (StepAP209_Construct::*)() const>(&StepAP209_Construct::GetElementMaterial),
             R"#()#" 
          )
        .def("GetElemGeomRelat",
             (handle<StepFEA_HSequenceOfElementGeometricRelationship> (StepAP209_Construct::*)() const) static_cast<handle<StepFEA_HSequenceOfElementGeometricRelationship> (StepAP209_Construct::*)() const>(&StepAP209_Construct::GetElemGeomRelat),
             R"#()#" 
          )
        .def("GetElements1D",
             (handle<StepFEA_HSequenceOfElementRepresentation> (StepAP209_Construct::*)(  const handle<StepFEA_FeaModel> &  ) const) static_cast<handle<StepFEA_HSequenceOfElementRepresentation> (StepAP209_Construct::*)(  const handle<StepFEA_FeaModel> &  ) const>(&StepAP209_Construct::GetElements1D),
             R"#()#"  , py::arg("theFeaModel")
          )
        .def("GetElements2D",
             (handle<StepFEA_HSequenceOfElementRepresentation> (StepAP209_Construct::*)(  const handle<StepFEA_FeaModel> &  ) const) static_cast<handle<StepFEA_HSequenceOfElementRepresentation> (StepAP209_Construct::*)(  const handle<StepFEA_FeaModel> &  ) const>(&StepAP209_Construct::GetElements2D),
             R"#()#"  , py::arg("theFEAModel")
          )
        .def("GetElements3D",
             (handle<StepFEA_HSequenceOfElementRepresentation> (StepAP209_Construct::*)(  const handle<StepFEA_FeaModel> &  ) const) static_cast<handle<StepFEA_HSequenceOfElementRepresentation> (StepAP209_Construct::*)(  const handle<StepFEA_FeaModel> &  ) const>(&StepAP209_Construct::GetElements3D),
             R"#()#"  , py::arg("theFEAModel")
          )
        .def("GetCurElemSection",
             (handle<StepElement_HSequenceOfCurveElementSectionDefinition> (StepAP209_Construct::*)(  const handle<StepFEA_Curve3dElementRepresentation> &  ) const) static_cast<handle<StepElement_HSequenceOfCurveElementSectionDefinition> (StepAP209_Construct::*)(  const handle<StepFEA_Curve3dElementRepresentation> &  ) const>(&StepAP209_Construct::GetCurElemSection),
             R"#(Getting list of curve_element_section_definitions for given element_representation)#"  , py::arg("ElemRepr")
          )
        .def("GetShReprForElem",
             (handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepFEA_ElementRepresentation> &  ) const) static_cast<handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepFEA_ElementRepresentation> &  ) const>(&StepAP209_Construct::GetShReprForElem),
             R"#()#"  , py::arg("ElemRepr")
          )
        .def("CreateAnalysStructure",
             (Standard_Boolean (StepAP209_Construct::*)(  const handle<StepBasic_Product> &  ) const) static_cast<Standard_Boolean (StepAP209_Construct::*)(  const handle<StepBasic_Product> &  ) const>(&StepAP209_Construct::CreateAnalysStructure),
             R"#(Create empty structure for idealized_analysis_shape)#"  , py::arg("Prod")
          )
        .def("CreateFeaStructure",
             (Standard_Boolean (StepAP209_Construct::*)(  const handle<StepBasic_Product> &  ) const) static_cast<Standard_Boolean (StepAP209_Construct::*)(  const handle<StepBasic_Product> &  ) const>(&StepAP209_Construct::CreateFeaStructure),
             R"#(Create fea structure)#"  , py::arg("Prod")
          )
        .def("ReplaceCcDesingToApplied",
             (Standard_Boolean (StepAP209_Construct::*)() const) static_cast<Standard_Boolean (StepAP209_Construct::*)() const>(&StepAP209_Construct::ReplaceCcDesingToApplied),
             R"#(Put into model entities Applied... for AP209 instead of entities CcDesing... from AP203.)#" 
          )
        .def("CreateAddingEntities",
             (Standard_Boolean (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinition> &  ) const) static_cast<Standard_Boolean (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinition> &  ) const>(&StepAP209_Construct::CreateAddingEntities),
             R"#(Create approval.. , date.. , time.. , person.. and organization.. entities for analysis structure)#"  , py::arg("AnaPD")
          )
        .def("CreateAP203Structure",
             (handle<StepData_StepModel> (StepAP209_Construct::*)() const) static_cast<handle<StepData_StepModel> (StepAP209_Construct::*)() const>(&StepAP209_Construct::CreateAP203Structure),
             R"#(Create AP203 structure from existing AP209 structure)#" 
          )
        .def("CreateAdding203Entities",
             (Standard_Boolean (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinition> & ,  handle<StepData_StepModel> &  ) const) static_cast<Standard_Boolean (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinition> & ,  handle<StepData_StepModel> &  ) const>(&StepAP209_Construct::CreateAdding203Entities),
             R"#(Create approval.. , date.. , time.. , person.. and organization.. entities for 203 structure)#"  , py::arg("PD"),  py::arg("aModel")
          )
        .def("FeaModel",
             (handle<StepFEA_FeaModel> (StepAP209_Construct::*)(  const handle<StepRepr_ProductDefinitionShape> &  ) const) static_cast<handle<StepFEA_FeaModel> (StepAP209_Construct::*)(  const handle<StepRepr_ProductDefinitionShape> &  ) const>(&StepAP209_Construct::FeaModel),
             R"#()#"  , py::arg("PDS")
          )
        .def("FeaModel",
             (handle<StepFEA_FeaModel> (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinition> &  ) const) static_cast<handle<StepFEA_FeaModel> (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinition> &  ) const>(&StepAP209_Construct::FeaModel),
             R"#()#"  , py::arg("PD")
          )
        .def("IdealShape",
             (handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinition> &  ) const) static_cast<handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepBasic_ProductDefinition> &  ) const>(&StepAP209_Construct::IdealShape),
             R"#()#"  , py::arg("PD")
          )
        .def("IdealShape",
             (handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepRepr_ProductDefinitionShape> &  ) const) static_cast<handle<StepShape_ShapeRepresentation> (StepAP209_Construct::*)(  const handle<StepRepr_ProductDefinitionShape> &  ) const>(&StepAP209_Construct::IdealShape),
             R"#()#"  , py::arg("PDS")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions

// ./opencascade/StepAP209_Construct.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
