
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <StdObjMgt_MapOfInstantiators.hxx>
#include <TDocStd_Application.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StdObjMgt_MapOfInstantiators.hxx>
#include <StdObjMgt_Persistent.hxx>

// module includes
#include <StdLDrivers.hxx>
#include <StdLDrivers_DocumentRetrievalDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <CDM_Document.hxx>
#include <PCDM_ReaderFilter.hxx>

// Module definiiton
void register_StdLDrivers(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("StdLDrivers"));
py::object klass;

//Python trampoline classes

// classes

    // Class StdLDrivers from ./opencascade/StdLDrivers.hxx
    klass = m.attr("StdLDrivers");

    // default constructor
    register_default_constructor<StdLDrivers , shared_ptr<StdLDrivers>>(m,"StdLDrivers");

    // nested enums

    static_cast<py::class_<StdLDrivers , shared_ptr<StdLDrivers>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Factory_s",
                    (handle<Standard_Transient> (*)(  const Standard_GUID &  ) ) static_cast<handle<Standard_Transient> (*)(  const Standard_GUID &  ) >(&StdLDrivers::Factory),
                    R"#(Depending from the ID, returns a list of storage or retrieval attribute drivers. Used for plugin)#"  , py::arg("aGUID")
          )
        .def_static("DefineFormat_s",
                    (void (*)(  const handle<TDocStd_Application> &  ) ) static_cast<void (*)(  const handle<TDocStd_Application> &  ) >(&StdLDrivers::DefineFormat),
                    R"#(Defines format "OCC-StdLite" and registers its retrieval driver in the specified application)#"  , py::arg("theApp")
          )
        .def_static("BindTypes_s",
                    (void (*)( StdObjMgt_MapOfInstantiators &  ) ) static_cast<void (*)( StdObjMgt_MapOfInstantiators &  ) >(&StdLDrivers::BindTypes),
                    R"#(Register types.)#"  , py::arg("theMap")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class StdLDrivers_DocumentRetrievalDriver from ./opencascade/StdLDrivers_DocumentRetrievalDriver.hxx
    klass = m.attr("StdLDrivers_DocumentRetrievalDriver");

    // default constructor
    register_default_constructor<StdLDrivers_DocumentRetrievalDriver ,opencascade::handle<StdLDrivers_DocumentRetrievalDriver>>(m,"StdLDrivers_DocumentRetrievalDriver");

    // nested enums

    static_cast<py::class_<StdLDrivers_DocumentRetrievalDriver ,opencascade::handle<StdLDrivers_DocumentRetrievalDriver>  , PCDM_RetrievalDriver >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Read",
             (void (StdLDrivers_DocumentRetrievalDriver::*)(  const TCollection_ExtendedString & ,   const handle<CDM_Document> & ,   const handle<CDM_Application> & ,   const handle<PCDM_ReaderFilter> & ,   const Message_ProgressRange &  ) ) static_cast<void (StdLDrivers_DocumentRetrievalDriver::*)(  const TCollection_ExtendedString & ,   const handle<CDM_Document> & ,   const handle<CDM_Application> & ,   const handle<PCDM_ReaderFilter> & ,   const Message_ProgressRange &  ) >(&StdLDrivers_DocumentRetrievalDriver::Read),
             R"#(Retrieve the content of a file into a new document.)#"  , py::arg("theFileName"),  py::arg("theNewDocument"),  py::arg("theApplication"),  py::arg("theFilter")=static_cast< const handle<PCDM_ReaderFilter> &>(Handle ( PCDM_ReaderFilter ) ( )),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (void (StdLDrivers_DocumentRetrievalDriver::*)( Standard_IStream & ,   const handle<Storage_Data> & ,   const handle<CDM_Document> & ,   const handle<CDM_Application> & ,   const handle<PCDM_ReaderFilter> & ,   const Message_ProgressRange &  ) ) static_cast<void (StdLDrivers_DocumentRetrievalDriver::*)( Standard_IStream & ,   const handle<Storage_Data> & ,   const handle<CDM_Document> & ,   const handle<CDM_Application> & ,   const handle<PCDM_ReaderFilter> & ,   const Message_ProgressRange &  ) >(&StdLDrivers_DocumentRetrievalDriver::Read),
             R"#(Override pure virtual method (raises exception Standard_NotImplemented))#"  , py::arg("theIStream"),  py::arg("theStorageData"),  py::arg("theDoc"),  py::arg("theApplication"),  py::arg("theFilter")=static_cast< const handle<PCDM_ReaderFilter> &>(Handle ( PCDM_ReaderFilter ) ( )),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&StdLDrivers_DocumentRetrievalDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&StdLDrivers_DocumentRetrievalDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (StdLDrivers_DocumentRetrievalDriver::*)() const) static_cast< const handle<Standard_Type> & (StdLDrivers_DocumentRetrievalDriver::*)() const>(&StdLDrivers_DocumentRetrievalDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/StdLDrivers.hxx
// ./opencascade/StdLDrivers_DocumentRetrievalDriver.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
