
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <SelectBasics.hxx>
#include <SelectBasics_EntityOwner.hxx>
#include <SelectBasics_PickResult.hxx>
#include <SelectBasics_SelectingVolumeManager.hxx>
#include <SelectBasics_SensitiveEntity.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_SelectBasics_enums(py::module &main_module) {


py::module m = main_module.def_submodule("SelectBasics", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes
    class Py_SelectBasics_SelectingVolumeManager : public SelectBasics_SelectingVolumeManager{
    public:
        using SelectBasics_SelectingVolumeManager::SelectBasics_SelectingVolumeManager;


        // public pure virtual
        Standard_Integer GetActiveSelectionType() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,GetActiveSelectionType,) };
        Standard_Boolean OverlapsBox( const NCollection_Vec3<Standard_Real> & theBoxMin, const NCollection_Vec3<Standard_Real> & theBoxMax,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsBox,theBoxMin,theBoxMax,thePickResult) };
        Standard_Boolean OverlapsBox( const NCollection_Vec3<Standard_Real> & theBoxMin, const NCollection_Vec3<Standard_Real> & theBoxMax,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsBox,theBoxMin,theBoxMax,theInside) };
        Standard_Boolean OverlapsPoint( const gp_Pnt & thePnt,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsPoint,thePnt,thePickResult) };
        Standard_Boolean OverlapsPoint( const gp_Pnt & thePnt) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsPoint,thePnt) };
        Standard_Boolean OverlapsPolygon( const TColgp_Array1OfPnt & theArrayOfPts,Standard_Integer theSensType,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsPolygon,theArrayOfPts,theSensType,thePickResult) };
        Standard_Boolean OverlapsSegment( const gp_Pnt & thePt1, const gp_Pnt & thePt2,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsSegment,thePt1,thePt2,thePickResult) };
        Standard_Boolean OverlapsTriangle( const gp_Pnt & thePt1, const gp_Pnt & thePt2, const gp_Pnt & thePt3,Standard_Integer theSensType,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsTriangle,thePt1,thePt2,thePt3,theSensType,thePickResult) };
        Standard_Boolean OverlapsSphere( const gp_Pnt & theCenter, const Standard_Real theRadius,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsSphere,theCenter,theRadius,thePickResult) };
        Standard_Boolean OverlapsSphere( const gp_Pnt & theCenter, const Standard_Real theRadius,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsSphere,theCenter,theRadius,theInside) };
        Standard_Boolean OverlapsCylinder( const Standard_Real theBottomRad, const Standard_Real theTopRad, const Standard_Real theHeight, const gp_Trsf & theTrsf, const Standard_Boolean theIsHollow,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsCylinder,theBottomRad,theTopRad,theHeight,theTrsf,theIsHollow,thePickResult) };
        Standard_Boolean OverlapsCylinder( const Standard_Real theBottomRad, const Standard_Real theTopRad, const Standard_Real theHeight, const gp_Trsf & theTrsf, const Standard_Boolean theIsHollow,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsCylinder,theBottomRad,theTopRad,theHeight,theTrsf,theIsHollow,theInside) };
        Standard_Boolean OverlapsCircle( const Standard_Real theRadius, const gp_Trsf & theTrsf, const Standard_Boolean theIsFilled,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsCircle,theRadius,theTrsf,theIsFilled,thePickResult) };
        Standard_Boolean OverlapsCircle( const Standard_Real theRadius, const gp_Trsf & theTrsf, const Standard_Boolean theIsFilled,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsCircle,theRadius,theTrsf,theIsFilled,theInside) };
        Standard_Real DistToGeometryCenter( const gp_Pnt & theCOG) const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,DistToGeometryCenter,theCOG) };
        gp_Pnt DetectedPoint( const Standard_Real theDepth) const  override { using return_type = gp_Pnt;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,DetectedPoint,theDepth) };
        Standard_Boolean IsOverlapAllowed() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,IsOverlapAllowed,) };
        gp_Pnt GetNearPickedPnt() const  override { using return_type = gp_Pnt;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,GetNearPickedPnt,) };
        gp_Pnt GetFarPickedPnt() const  override { using return_type = gp_Pnt;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,GetFarPickedPnt,) };
        gp_Dir GetViewRayDirection() const  override { using return_type = gp_Dir;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,GetViewRayDirection,) };
        Standard_Boolean IsScalableActiveVolume() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,IsScalableActiveVolume,) };
        gp_Pnt2d GetMousePosition() const  override { using return_type = gp_Pnt2d;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,GetMousePosition,) };
        void GetPlanes(NCollection_Vector<NCollection_Vec4<Standard_Real>> & thePlaneEquations) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,GetPlanes,thePlaneEquations) };


        // protected pure virtual


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<SelectBasics , shared_ptr<SelectBasics>  >(m,"SelectBasics",R"#(interface class for dynamic selection)#");
    py::class_<SelectBasics_PickResult , shared_ptr<SelectBasics_PickResult>  >(m,"SelectBasics_PickResult",R"#(This structure provides unified access to the results of Matches() method in all sensitive entities, so that it defines a Depth (distance to the entity along picking ray) and a closest Point on entity.)#");
    py::class_<SelectBasics_SelectingVolumeManager , shared_ptr<SelectBasics_SelectingVolumeManager> ,Py_SelectBasics_SelectingVolumeManager >(m,"SelectBasics_SelectingVolumeManager",R"#(This class provides an interface for selecting volume manager, which is responsible for all overlap detection methods and calculation of minimum depth, distance to center of geometry and detected closest point on entity.)#");

};

// user-defined post-inclusion per module

// user-defined post
