
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Interface_Protocol.hxx>
#include <StepData_StepModel.hxx>
#include <IFSelect_Signature.hxx>
#include <IFSelect_SelectSignature.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IFSelect_EditForm.hxx>
#include <Interface_InterfaceModel.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IFSelect_EditForm.hxx>
#include <Interface_InterfaceModel.hxx>

// module includes
#include <STEPEdit.hxx>
#include <STEPEdit_EditContext.hxx>
#include <STEPEdit_EditSDR.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_STEPEdit(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("STEPEdit"));
py::object klass;

//Python trampoline classes

// classes

    // Class STEPEdit from ./opencascade/STEPEdit.hxx
    klass = m.attr("STEPEdit");

    // default constructor
    register_default_constructor<STEPEdit , shared_ptr<STEPEdit>>(m,"STEPEdit");

    // nested enums

    static_cast<py::class_<STEPEdit , shared_ptr<STEPEdit>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Protocol_s",
                    (handle<Interface_Protocol> (*)() ) static_cast<handle<Interface_Protocol> (*)() >(&STEPEdit::Protocol),
                    R"#(Returns a Protocol fit for STEP (creates the first time))#" 
          )
        .def_static("NewModel_s",
                    (handle<StepData_StepModel> (*)() ) static_cast<handle<StepData_StepModel> (*)() >(&STEPEdit::NewModel),
                    R"#(Returns a new empty StepModel fit for STEP i.e. with its header determined from Protocol)#" 
          )
        .def_static("SignType_s",
                    (handle<IFSelect_Signature> (*)() ) static_cast<handle<IFSelect_Signature> (*)() >(&STEPEdit::SignType),
                    R"#(Returns a SignType fit for STEP (creates the first time))#" 
          )
        .def_static("NewSelectSDR_s",
                    (handle<IFSelect_SelectSignature> (*)() ) static_cast<handle<IFSelect_SelectSignature> (*)() >(&STEPEdit::NewSelectSDR),
                    R"#(Creates a Selection for ShapeDefinitionRepresentation By default searches among root entities)#" 
          )
        .def_static("NewSelectPlacedItem_s",
                    (handle<IFSelect_SelectSignature> (*)() ) static_cast<handle<IFSelect_SelectSignature> (*)() >(&STEPEdit::NewSelectPlacedItem),
                    R"#(Creates a Selection for Placed Items, i.e. MappedItem or ContextDependentShapeRepresentation, which itself refers to a RepresentationRelationship with possible subtypes (Shape... and/or ...WithTransformation) By default in the whole StepModel)#" 
          )
        .def_static("NewSelectShapeRepr_s",
                    (handle<IFSelect_SelectSignature> (*)() ) static_cast<handle<IFSelect_SelectSignature> (*)() >(&STEPEdit::NewSelectShapeRepr),
                    R"#(Creates a Selection for ShapeRepresentation and its sub-types, plus ContextDependentShapeRepresentation (which is not a sub-type of ShapeRepresentation) By default in the whole StepModel)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class STEPEdit_EditContext from ./opencascade/STEPEdit_EditContext.hxx
    klass = m.attr("STEPEdit_EditContext");


    // nested enums

    static_cast<py::class_<STEPEdit_EditContext ,opencascade::handle<STEPEdit_EditContext>  , IFSelect_Editor >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Label",
             (TCollection_AsciiString (STEPEdit_EditContext::*)() const) static_cast<TCollection_AsciiString (STEPEdit_EditContext::*)() const>(&STEPEdit_EditContext::Label),
             R"#()#" 
          )
        .def("Recognize",
             (Standard_Boolean (STEPEdit_EditContext::*)(  const handle<IFSelect_EditForm> &  ) const) static_cast<Standard_Boolean (STEPEdit_EditContext::*)(  const handle<IFSelect_EditForm> &  ) const>(&STEPEdit_EditContext::Recognize),
             R"#()#"  , py::arg("form")
          )
        .def("StringValue",
             (handle<TCollection_HAsciiString> (STEPEdit_EditContext::*)(  const handle<IFSelect_EditForm> & ,   const Standard_Integer  ) const) static_cast<handle<TCollection_HAsciiString> (STEPEdit_EditContext::*)(  const handle<IFSelect_EditForm> & ,   const Standard_Integer  ) const>(&STEPEdit_EditContext::StringValue),
             R"#()#"  , py::arg("form"),  py::arg("num")
          )
        .def("Apply",
             (Standard_Boolean (STEPEdit_EditContext::*)(  const handle<IFSelect_EditForm> & ,   const handle<Standard_Transient> & ,   const handle<Interface_InterfaceModel> &  ) const) static_cast<Standard_Boolean (STEPEdit_EditContext::*)(  const handle<IFSelect_EditForm> & ,   const handle<Standard_Transient> & ,   const handle<Interface_InterfaceModel> &  ) const>(&STEPEdit_EditContext::Apply),
             R"#()#"  , py::arg("form"),  py::arg("ent"),  py::arg("model")
          )
        .def("Load",
             (Standard_Boolean (STEPEdit_EditContext::*)(  const handle<IFSelect_EditForm> & ,   const handle<Standard_Transient> & ,   const handle<Interface_InterfaceModel> &  ) const) static_cast<Standard_Boolean (STEPEdit_EditContext::*)(  const handle<IFSelect_EditForm> & ,   const handle<Standard_Transient> & ,   const handle<Interface_InterfaceModel> &  ) const>(&STEPEdit_EditContext::Load),
             R"#()#"  , py::arg("form"),  py::arg("ent"),  py::arg("model")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&STEPEdit_EditContext::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&STEPEdit_EditContext::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (STEPEdit_EditContext::*)() const) static_cast< const handle<Standard_Type> & (STEPEdit_EditContext::*)() const>(&STEPEdit_EditContext::DynamicType),
             R"#()#"
             
         )
;

    // Class STEPEdit_EditSDR from ./opencascade/STEPEdit_EditSDR.hxx
    klass = m.attr("STEPEdit_EditSDR");


    // nested enums

    static_cast<py::class_<STEPEdit_EditSDR ,opencascade::handle<STEPEdit_EditSDR>  , IFSelect_Editor >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Label",
             (TCollection_AsciiString (STEPEdit_EditSDR::*)() const) static_cast<TCollection_AsciiString (STEPEdit_EditSDR::*)() const>(&STEPEdit_EditSDR::Label),
             R"#()#" 
          )
        .def("Recognize",
             (Standard_Boolean (STEPEdit_EditSDR::*)(  const handle<IFSelect_EditForm> &  ) const) static_cast<Standard_Boolean (STEPEdit_EditSDR::*)(  const handle<IFSelect_EditForm> &  ) const>(&STEPEdit_EditSDR::Recognize),
             R"#()#"  , py::arg("form")
          )
        .def("StringValue",
             (handle<TCollection_HAsciiString> (STEPEdit_EditSDR::*)(  const handle<IFSelect_EditForm> & ,   const Standard_Integer  ) const) static_cast<handle<TCollection_HAsciiString> (STEPEdit_EditSDR::*)(  const handle<IFSelect_EditForm> & ,   const Standard_Integer  ) const>(&STEPEdit_EditSDR::StringValue),
             R"#()#"  , py::arg("form"),  py::arg("num")
          )
        .def("Apply",
             (Standard_Boolean (STEPEdit_EditSDR::*)(  const handle<IFSelect_EditForm> & ,   const handle<Standard_Transient> & ,   const handle<Interface_InterfaceModel> &  ) const) static_cast<Standard_Boolean (STEPEdit_EditSDR::*)(  const handle<IFSelect_EditForm> & ,   const handle<Standard_Transient> & ,   const handle<Interface_InterfaceModel> &  ) const>(&STEPEdit_EditSDR::Apply),
             R"#()#"  , py::arg("form"),  py::arg("ent"),  py::arg("model")
          )
        .def("Load",
             (Standard_Boolean (STEPEdit_EditSDR::*)(  const handle<IFSelect_EditForm> & ,   const handle<Standard_Transient> & ,   const handle<Interface_InterfaceModel> &  ) const) static_cast<Standard_Boolean (STEPEdit_EditSDR::*)(  const handle<IFSelect_EditForm> & ,   const handle<Standard_Transient> & ,   const handle<Interface_InterfaceModel> &  ) const>(&STEPEdit_EditSDR::Load),
             R"#()#"  , py::arg("form"),  py::arg("ent"),  py::arg("model")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&STEPEdit_EditSDR::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&STEPEdit_EditSDR::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (STEPEdit_EditSDR::*)() const) static_cast< const handle<Standard_Type> & (STEPEdit_EditSDR::*)() const>(&STEPEdit_EditSDR::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/STEPEdit.hxx
// ./opencascade/STEPEdit_EditContext.hxx
// ./opencascade/STEPEdit_EditSDR.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
