
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDocStd_Document.hxx>
#include <XCAFDoc_ShapeTool.hxx>
#include <XCAFDoc_ColorTool.hxx>
#include <XCAFDoc_VisMaterialTool.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TDF_Label.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TDF_Label.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TDataStd_NamedData.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TDF_Label.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <RWMesh_TriangulationSource.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <RWMesh_TriangulationReader.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TDF_Label.hxx>

// module includes
#include <RWMesh.hxx>
#include <RWMesh_CafReader.hxx>
#include <RWMesh_CoordinateSystem.hxx>
#include <RWMesh_CoordinateSystemConverter.hxx>
#include <RWMesh_EdgeIterator.hxx>
#include <RWMesh_FaceIterator.hxx>
#include <RWMesh_MaterialMap.hxx>
#include <RWMesh_NameFormat.hxx>
#include <RWMesh_NodeAttributes.hxx>
#include <RWMesh_ShapeIterator.hxx>
#include <RWMesh_TriangulationReader.hxx>
#include <RWMesh_TriangulationSource.hxx>
#include <RWMesh_VertexIterator.hxx>

// template related includes

// ./opencascade/RWMesh_NodeAttributes.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <OSD_FileSystem.hxx>

// Module definiiton
void register_RWMesh(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("RWMesh"));
py::object klass;

//Python trampoline classes
    class Py_RWMesh_CafReader : public RWMesh_CafReader{
    public:
        using RWMesh_CafReader::RWMesh_CafReader;


        // public pure virtual


        // protected pure virtual
        Standard_Boolean performMesh(typename std::istream & theStream, const TCollection_AsciiString & theFile, const Message_ProgressRange & theProgress, const Standard_Boolean theToProbe) override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_CafReader,performMesh,theStream,theFile,theProgress,theToProbe) };


        // private pure virtual

    };
    class Py_RWMesh_MaterialMap : public RWMesh_MaterialMap{
    public:
        using RWMesh_MaterialMap::RWMesh_MaterialMap;


        // public pure virtual
        void DefineMaterial( const XCAFPrs_Style & theStyle, const TCollection_AsciiString & theKey, const TCollection_AsciiString & theName) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_MaterialMap,DefineMaterial,theStyle,theKey,theName) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_RWMesh_ShapeIterator : public RWMesh_ShapeIterator{
    public:
        using RWMesh_ShapeIterator::RWMesh_ShapeIterator;


        // public pure virtual
         const TopoDS_Shape & Shape() const  override { using return_type =  const TopoDS_Shape &;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,Shape,) };
        bool More() const  override { using return_type = bool;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,More,) };
        void Next() override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,Next,) };
        bool IsEmpty() const  override { using return_type = bool;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,IsEmpty,) };
        Standard_Integer ElemLower() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,ElemLower,) };
        Standard_Integer ElemUpper() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,ElemUpper,) };
        Standard_Integer NbNodes() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,NbNodes,) };
        Standard_Integer NodeLower() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,NodeLower,) };
        Standard_Integer NodeUpper() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,NodeUpper,) };


        // protected pure virtual
        gp_Pnt node( const Standard_Integer theNode) const  override { using return_type = gp_Pnt;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_ShapeIterator,node,theNode) };


        // private pure virtual

    };
    class Py_RWMesh_TriangulationReader : public RWMesh_TriangulationReader{
    public:
        using RWMesh_TriangulationReader::RWMesh_TriangulationReader;


        // public pure virtual


        // protected pure virtual
        bool load( const handle<RWMesh_TriangulationSource> & theSourceMesh, const handle<Poly_Triangulation> & theDestMesh, const handle<OSD_FileSystem> & theFileSystem) const  override { using return_type = bool;
    PYBIND11_OVERLOAD_PURE(return_type,RWMesh_TriangulationReader,load,theSourceMesh,theDestMesh,theFileSystem) };


        // private pure virtual

    };

// classes

    // Class RWMesh from ./opencascade/RWMesh.hxx
    klass = m.attr("RWMesh");

    // default constructor
    register_default_constructor<RWMesh , shared_ptr<RWMesh>>(m,"RWMesh");

    // nested enums

    static_cast<py::class_<RWMesh , shared_ptr<RWMesh>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("ReadNameAttribute_s",
                    (TCollection_AsciiString (*)(  const TDF_Label &  ) ) static_cast<TCollection_AsciiString (*)(  const TDF_Label &  ) >(&RWMesh::ReadNameAttribute),
                    R"#(Read name attribute from label.)#"  , py::arg("theLabel")
          )
        .def_static("FormatName_s",
                    (TCollection_AsciiString (*)( RWMesh_NameFormat ,   const TDF_Label & ,   const TDF_Label &  ) ) static_cast<TCollection_AsciiString (*)( RWMesh_NameFormat ,   const TDF_Label & ,   const TDF_Label &  ) >(&RWMesh::FormatName),
                    R"#(Generate name for specified labels.)#"  , py::arg("theFormat"),  py::arg("theLabel"),  py::arg("theRefLabel")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class RWMesh_CafReader from ./opencascade/RWMesh_CafReader.hxx
    klass = m.attr("RWMesh_CafReader");


    // nested enums

    static_cast<py::class_<RWMesh_CafReader ,opencascade::handle<RWMesh_CafReader> ,Py_RWMesh_CafReader , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetDocument",
             (void (RWMesh_CafReader::*)(  const handle<TDocStd_Document> &  ) ) static_cast<void (RWMesh_CafReader::*)(  const handle<TDocStd_Document> &  ) >(&RWMesh_CafReader::SetDocument),
             R"#(Set target document. Set system length unit according to the units of the document)#"  , py::arg("theDoc")
          )
        .def("SetRootPrefix",
             (void (RWMesh_CafReader::*)(  const TCollection_AsciiString &  ) ) static_cast<void (RWMesh_CafReader::*)(  const TCollection_AsciiString &  ) >(&RWMesh_CafReader::SetRootPrefix),
             R"#(Set prefix for generating root labels names)#"  , py::arg("theRootPrefix")
          )
        .def("ToFillIncompleteDocument",
             (Standard_Boolean (RWMesh_CafReader::*)() const) static_cast<Standard_Boolean (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::ToFillIncompleteDocument),
             R"#(Flag indicating if partially read file content should be put into the XDE document, TRUE by default.)#" 
          )
        .def("SetFillIncompleteDocument",
             (void (RWMesh_CafReader::*)( Standard_Boolean  ) ) static_cast<void (RWMesh_CafReader::*)( Standard_Boolean  ) >(&RWMesh_CafReader::SetFillIncompleteDocument),
             R"#(Set flag allowing partially read file content to be put into the XDE document.)#"  , py::arg("theToFillIncomplete")
          )
        .def("MemoryLimitMiB",
             (Standard_Integer (RWMesh_CafReader::*)() const) static_cast<Standard_Integer (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::MemoryLimitMiB),
             R"#(Return memory usage limit in MiB, -1 by default which means no limit.)#" 
          )
        .def("SetMemoryLimitMiB",
             (void (RWMesh_CafReader::*)( Standard_Integer  ) ) static_cast<void (RWMesh_CafReader::*)( Standard_Integer  ) >(&RWMesh_CafReader::SetMemoryLimitMiB),
             R"#(Set memory usage limit in MiB; can be ignored by reader implementation!)#"  , py::arg("theLimitMiB")
          )
        .def("SetCoordinateSystemConverter",
             (void (RWMesh_CafReader::*)(  const RWMesh_CoordinateSystemConverter &  ) ) static_cast<void (RWMesh_CafReader::*)(  const RWMesh_CoordinateSystemConverter &  ) >(&RWMesh_CafReader::SetCoordinateSystemConverter),
             R"#(Set coordinate system converter.)#"  , py::arg("theConverter")
          )
        .def("SystemLengthUnit",
             (Standard_Real (RWMesh_CafReader::*)() const) static_cast<Standard_Real (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::SystemLengthUnit),
             R"#(Return the length unit to convert into while reading the file, defined as scale factor for m (meters); -1.0 by default, which means that NO conversion will be applied.)#" 
          )
        .def("SetSystemLengthUnit",
             (void (RWMesh_CafReader::*)( Standard_Real  ) ) static_cast<void (RWMesh_CafReader::*)( Standard_Real  ) >(&RWMesh_CafReader::SetSystemLengthUnit),
             R"#(Set system length units to convert into while reading the file, defined as scale factor for m (meters).)#"  , py::arg("theUnits")
          )
        .def("HasSystemCoordinateSystem",
             (Standard_Boolean (RWMesh_CafReader::*)() const) static_cast<Standard_Boolean (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::HasSystemCoordinateSystem),
             R"#(Return TRUE if system coordinate system has been defined; FALSE by default.)#" 
          )
        .def("SetSystemCoordinateSystem",
             (void (RWMesh_CafReader::*)(  const gp_Ax3 &  ) ) static_cast<void (RWMesh_CafReader::*)(  const gp_Ax3 &  ) >(&RWMesh_CafReader::SetSystemCoordinateSystem),
             R"#(Set system origin coordinate system to perform conversion into during read.)#"  , py::arg("theCS")
          )
        .def("SetSystemCoordinateSystem",
             (void (RWMesh_CafReader::*)( RWMesh_CoordinateSystem  ) ) static_cast<void (RWMesh_CafReader::*)( RWMesh_CoordinateSystem  ) >(&RWMesh_CafReader::SetSystemCoordinateSystem),
             R"#(Set system origin coordinate system to perform conversion into during read.)#"  , py::arg("theCS")
          )
        .def("FileLengthUnit",
             (Standard_Real (RWMesh_CafReader::*)() const) static_cast<Standard_Real (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::FileLengthUnit),
             R"#(Return the length unit to convert from while reading the file, defined as scale factor for m (meters). Can be undefined (-1.0) if file format is unitless.)#" 
          )
        .def("SetFileLengthUnit",
             (void (RWMesh_CafReader::*)( Standard_Real  ) ) static_cast<void (RWMesh_CafReader::*)( Standard_Real  ) >(&RWMesh_CafReader::SetFileLengthUnit),
             R"#(Set (override) file length units to convert from while reading the file, defined as scale factor for m (meters).)#"  , py::arg("theUnits")
          )
        .def("HasFileCoordinateSystem",
             (Standard_Boolean (RWMesh_CafReader::*)() const) static_cast<Standard_Boolean (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::HasFileCoordinateSystem),
             R"#(Return TRUE if file origin coordinate system has been defined.)#" 
          )
        .def("SetFileCoordinateSystem",
             (void (RWMesh_CafReader::*)(  const gp_Ax3 &  ) ) static_cast<void (RWMesh_CafReader::*)(  const gp_Ax3 &  ) >(&RWMesh_CafReader::SetFileCoordinateSystem),
             R"#(Set (override) file origin coordinate system to perform conversion during read.)#"  , py::arg("theCS")
          )
        .def("SetFileCoordinateSystem",
             (void (RWMesh_CafReader::*)( RWMesh_CoordinateSystem  ) ) static_cast<void (RWMesh_CafReader::*)( RWMesh_CoordinateSystem  ) >(&RWMesh_CafReader::SetFileCoordinateSystem),
             R"#(Set (override) file origin coordinate system to perform conversion during read.)#"  , py::arg("theCS")
          )
        .def("Perform",
             (bool (RWMesh_CafReader::*)(  const TCollection_AsciiString & ,   const Message_ProgressRange &  ) ) static_cast<bool (RWMesh_CafReader::*)(  const TCollection_AsciiString & ,   const Message_ProgressRange &  ) >(&RWMesh_CafReader::Perform),
             R"#(Open stream and pass it to Perform method. The Document instance should be set beforehand.)#"  , py::arg("theFile"),  py::arg("theProgress")
          )
        .def("Perform",
             (bool (RWMesh_CafReader::*)( typename std::istream & ,   const Message_ProgressRange & ,   const TCollection_AsciiString &  ) ) static_cast<bool (RWMesh_CafReader::*)( typename std::istream & ,   const Message_ProgressRange & ,   const TCollection_AsciiString &  ) >(&RWMesh_CafReader::Perform),
             R"#(Read the data from specified file.)#"  , py::arg("theStream"),  py::arg("theProgress"),  py::arg("theFile")=static_cast< const TCollection_AsciiString &>("")
          )
        .def("ExtraStatus",
             (Standard_Integer (RWMesh_CafReader::*)() const) static_cast<Standard_Integer (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::ExtraStatus),
             R"#(Return extended status flags.)#" 
          )
        .def("SingleShape",
             (TopoDS_Shape (RWMesh_CafReader::*)() const) static_cast<TopoDS_Shape (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::SingleShape),
             R"#(Return result as a single shape.)#" 
          )
        .def("ProbeHeader",
             (Standard_Boolean (RWMesh_CafReader::*)(  const TCollection_AsciiString & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (RWMesh_CafReader::*)(  const TCollection_AsciiString & ,   const Message_ProgressRange &  ) >(&RWMesh_CafReader::ProbeHeader),
             R"#(Open stream and pass it to ProbeHeader method.)#"  , py::arg("theFile"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("ProbeHeader",
             (Standard_Boolean (RWMesh_CafReader::*)( typename std::istream & ,   const TCollection_AsciiString & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (RWMesh_CafReader::*)( typename std::istream & ,   const TCollection_AsciiString & ,   const Message_ProgressRange &  ) >(&RWMesh_CafReader::ProbeHeader),
             R"#(Read the header data from specified file without reading entire model. The main purpose is collecting metadata and external references - for copying model into a new location, for example. Can be NOT implemented (unsupported by format / reader).)#"  , py::arg("theStream"),  py::arg("theFile")=static_cast< const TCollection_AsciiString &>(""),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&RWMesh_CafReader::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&RWMesh_CafReader::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (RWMesh_CafReader::*)() const) static_cast< const handle<Standard_Type> & (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::DynamicType),
             R"#()#"
             
         )
       .def("Document",
             ( const handle<TDocStd_Document> & (RWMesh_CafReader::*)() const) static_cast< const handle<TDocStd_Document> & (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::Document),
             R"#(Return target document.)#"
             
         )
       .def("RootPrefix",
             ( const TCollection_AsciiString & (RWMesh_CafReader::*)() const) static_cast< const TCollection_AsciiString & (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::RootPrefix),
             R"#(Return prefix for generating root labels names.)#"
             
         )
       .def("CoordinateSystemConverter",
             ( const RWMesh_CoordinateSystemConverter & (RWMesh_CafReader::*)() const) static_cast< const RWMesh_CoordinateSystemConverter & (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::CoordinateSystemConverter),
             R"#(Return coordinate system converter.)#"
             
         )
       .def("SystemCoordinateSystem",
             ( const gp_Ax3 & (RWMesh_CafReader::*)() const) static_cast< const gp_Ax3 & (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::SystemCoordinateSystem),
             R"#(Return system coordinate system; UNDEFINED by default, which means that no conversion will be done.)#"
             
         )
       .def("FileCoordinateSystem",
             ( const gp_Ax3 & (RWMesh_CafReader::*)() const) static_cast< const gp_Ax3 & (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::FileCoordinateSystem),
             R"#(Return file origin coordinate system; can be UNDEFINED, which means no conversion will be done.)#"
             
         )
       .def("ExternalFiles",
             ( const NCollection_IndexedMap<TCollection_AsciiString> & (RWMesh_CafReader::*)() const) static_cast< const NCollection_IndexedMap<TCollection_AsciiString> & (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::ExternalFiles),
             R"#(Return the list of complementary files - external references (textures, data, etc.).)#"
             
         )
       .def("Metadata",
             ( const TColStd_IndexedDataMapOfStringString & (RWMesh_CafReader::*)() const) static_cast< const TColStd_IndexedDataMapOfStringString & (RWMesh_CafReader::*)() const>(&RWMesh_CafReader::Metadata),
             R"#(Return metadata map.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class RWMesh_CoordinateSystemConverter from ./opencascade/RWMesh_CoordinateSystemConverter.hxx
    klass = m.attr("RWMesh_CoordinateSystemConverter");


    // nested enums

    static_cast<py::class_<RWMesh_CoordinateSystemConverter , shared_ptr<RWMesh_CoordinateSystemConverter>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsEmpty",
             (Standard_Boolean (RWMesh_CoordinateSystemConverter::*)() const) static_cast<Standard_Boolean (RWMesh_CoordinateSystemConverter::*)() const>(&RWMesh_CoordinateSystemConverter::IsEmpty),
             R"#(Return TRUE if there is no transformation (target and current coordinates systems are same).)#" 
          )
        .def("InputLengthUnit",
             (Standard_Real (RWMesh_CoordinateSystemConverter::*)() const) static_cast<Standard_Real (RWMesh_CoordinateSystemConverter::*)() const>(&RWMesh_CoordinateSystemConverter::InputLengthUnit),
             R"#(Return source length units, defined as scale factor to m (meters). -1.0 by default, which means that NO conversion will be applied (regardless output length unit).)#" 
          )
        .def("SetInputLengthUnit",
             (void (RWMesh_CoordinateSystemConverter::*)( Standard_Real  ) ) static_cast<void (RWMesh_CoordinateSystemConverter::*)( Standard_Real  ) >(&RWMesh_CoordinateSystemConverter::SetInputLengthUnit),
             R"#(Set source length units as scale factor to m (meters).)#"  , py::arg("theInputScale")
          )
        .def("OutputLengthUnit",
             (Standard_Real (RWMesh_CoordinateSystemConverter::*)() const) static_cast<Standard_Real (RWMesh_CoordinateSystemConverter::*)() const>(&RWMesh_CoordinateSystemConverter::OutputLengthUnit),
             R"#(Return destination length units, defined as scale factor to m (meters). -1.0 by default, which means that NO conversion will be applied (regardless input length unit).)#" 
          )
        .def("SetOutputLengthUnit",
             (void (RWMesh_CoordinateSystemConverter::*)( Standard_Real  ) ) static_cast<void (RWMesh_CoordinateSystemConverter::*)( Standard_Real  ) >(&RWMesh_CoordinateSystemConverter::SetOutputLengthUnit),
             R"#(Set destination length units as scale factor to m (meters).)#"  , py::arg("theOutputScale")
          )
        .def("HasInputCoordinateSystem",
             (Standard_Boolean (RWMesh_CoordinateSystemConverter::*)() const) static_cast<Standard_Boolean (RWMesh_CoordinateSystemConverter::*)() const>(&RWMesh_CoordinateSystemConverter::HasInputCoordinateSystem),
             R"#(Return TRUE if source coordinate system has been set; FALSE by default.)#" 
          )
        .def("SetInputCoordinateSystem",
             (void (RWMesh_CoordinateSystemConverter::*)(  const gp_Ax3 &  ) ) static_cast<void (RWMesh_CoordinateSystemConverter::*)(  const gp_Ax3 &  ) >(&RWMesh_CoordinateSystemConverter::SetInputCoordinateSystem),
             R"#(Set source coordinate system.)#"  , py::arg("theSysFrom")
          )
        .def("SetInputCoordinateSystem",
             (void (RWMesh_CoordinateSystemConverter::*)( RWMesh_CoordinateSystem  ) ) static_cast<void (RWMesh_CoordinateSystemConverter::*)( RWMesh_CoordinateSystem  ) >(&RWMesh_CoordinateSystemConverter::SetInputCoordinateSystem),
             R"#(Set source coordinate system.)#"  , py::arg("theSysFrom")
          )
        .def("HasOutputCoordinateSystem",
             (Standard_Boolean (RWMesh_CoordinateSystemConverter::*)() const) static_cast<Standard_Boolean (RWMesh_CoordinateSystemConverter::*)() const>(&RWMesh_CoordinateSystemConverter::HasOutputCoordinateSystem),
             R"#(Return TRUE if destination coordinate system has been set; FALSE by default.)#" 
          )
        .def("SetOutputCoordinateSystem",
             (void (RWMesh_CoordinateSystemConverter::*)(  const gp_Ax3 &  ) ) static_cast<void (RWMesh_CoordinateSystemConverter::*)(  const gp_Ax3 &  ) >(&RWMesh_CoordinateSystemConverter::SetOutputCoordinateSystem),
             R"#(Set destination coordinate system.)#"  , py::arg("theSysTo")
          )
        .def("SetOutputCoordinateSystem",
             (void (RWMesh_CoordinateSystemConverter::*)( RWMesh_CoordinateSystem  ) ) static_cast<void (RWMesh_CoordinateSystemConverter::*)( RWMesh_CoordinateSystem  ) >(&RWMesh_CoordinateSystemConverter::SetOutputCoordinateSystem),
             R"#(Set destination coordinate system.)#"  , py::arg("theSysTo")
          )
        .def("Init",
             (void (RWMesh_CoordinateSystemConverter::*)(  const gp_Ax3 & ,  Standard_Real ,   const gp_Ax3 & ,  Standard_Real  ) ) static_cast<void (RWMesh_CoordinateSystemConverter::*)(  const gp_Ax3 & ,  Standard_Real ,   const gp_Ax3 & ,  Standard_Real  ) >(&RWMesh_CoordinateSystemConverter::Init),
             R"#(Initialize transformation.)#"  , py::arg("theInputSystem"),  py::arg("theInputLengthUnit"),  py::arg("theOutputSystem"),  py::arg("theOutputLengthUnit")
          )
        .def("TransformTransformation",
             (void (RWMesh_CoordinateSystemConverter::*)( gp_Trsf &  ) const) static_cast<void (RWMesh_CoordinateSystemConverter::*)( gp_Trsf &  ) const>(&RWMesh_CoordinateSystemConverter::TransformTransformation),
             R"#(Transform transformation.)#"  , py::arg("theTrsf")
          )
        .def("TransformPosition",
             (void (RWMesh_CoordinateSystemConverter::*)( gp_XYZ &  ) const) static_cast<void (RWMesh_CoordinateSystemConverter::*)( gp_XYZ &  ) const>(&RWMesh_CoordinateSystemConverter::TransformPosition),
             R"#(Transform position.)#"  , py::arg("thePos")
          )
        .def("TransformNormal",
             (void (RWMesh_CoordinateSystemConverter::*)( Graphic3d_Vec3 &  ) const) static_cast<void (RWMesh_CoordinateSystemConverter::*)( Graphic3d_Vec3 &  ) const>(&RWMesh_CoordinateSystemConverter::TransformNormal),
             R"#(Transform normal (e.g. exclude translation/scale part of transformation).)#"  , py::arg("theNorm")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("StandardCoordinateSystem_s",
                    (gp_Ax3 (*)( RWMesh_CoordinateSystem  ) ) static_cast<gp_Ax3 (*)( RWMesh_CoordinateSystem  ) >(&RWMesh_CoordinateSystemConverter::StandardCoordinateSystem),
                    R"#(Return a standard coordinate system definition.)#"  , py::arg("theSys")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("InputCoordinateSystem",
             ( const gp_Ax3 & (RWMesh_CoordinateSystemConverter::*)() const) static_cast< const gp_Ax3 & (RWMesh_CoordinateSystemConverter::*)() const>(&RWMesh_CoordinateSystemConverter::InputCoordinateSystem),
             R"#(Source coordinate system; UNDEFINED by default.)#"
             
         )
       .def("OutputCoordinateSystem",
             ( const gp_Ax3 & (RWMesh_CoordinateSystemConverter::*)() const) static_cast< const gp_Ax3 & (RWMesh_CoordinateSystemConverter::*)() const>(&RWMesh_CoordinateSystemConverter::OutputCoordinateSystem),
             R"#(Destination coordinate system; UNDEFINED by default.)#"
             
         )
;

    // Class RWMesh_MaterialMap from ./opencascade/RWMesh_MaterialMap.hxx
    klass = m.attr("RWMesh_MaterialMap");


    // nested enums

    static_cast<py::class_<RWMesh_MaterialMap ,opencascade::handle<RWMesh_MaterialMap> ,Py_RWMesh_MaterialMap , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  const TCollection_AsciiString & >()  , py::arg("theFile") )
    // custom constructors
    // methods
        .def("SetDefaultStyle",
             (void (RWMesh_MaterialMap::*)(  const XCAFPrs_Style &  ) ) static_cast<void (RWMesh_MaterialMap::*)(  const XCAFPrs_Style &  ) >(&RWMesh_MaterialMap::SetDefaultStyle),
             R"#(Set default material definition to be used for nodes with only color defined.)#"  , py::arg("theStyle")
          )
        .def("FindMaterial",
             (TCollection_AsciiString (RWMesh_MaterialMap::*)(  const XCAFPrs_Style &  ) const) static_cast<TCollection_AsciiString (RWMesh_MaterialMap::*)(  const XCAFPrs_Style &  ) const>(&RWMesh_MaterialMap::FindMaterial),
             R"#(Find already registered material)#"  , py::arg("theStyle")
          )
        .def("AddMaterial",
             (TCollection_AsciiString (RWMesh_MaterialMap::*)(  const XCAFPrs_Style &  ) ) static_cast<TCollection_AsciiString (RWMesh_MaterialMap::*)(  const XCAFPrs_Style &  ) >(&RWMesh_MaterialMap::AddMaterial),
             R"#(Register material and return its name identifier.)#"  , py::arg("theStyle")
          )
        .def("CreateTextureFolder",
             (bool (RWMesh_MaterialMap::*)() ) static_cast<bool (RWMesh_MaterialMap::*)() >(&RWMesh_MaterialMap::CreateTextureFolder),
             R"#(Create texture folder "modelName/textures"; for example: MODEL: Path/ModelName.gltf IMAGES: Path/ModelName/textures/ Warning! Output folder is NOT cleared.)#" 
          )
        .def("CopyTexture",
             (bool (RWMesh_MaterialMap::*)( TCollection_AsciiString & ,   const handle<Image_Texture> & ,   const TCollection_AsciiString &  ) ) static_cast<bool (RWMesh_MaterialMap::*)( TCollection_AsciiString & ,   const handle<Image_Texture> & ,   const TCollection_AsciiString &  ) >(&RWMesh_MaterialMap::CopyTexture),
             R"#(Copy and rename texture file to the new location.)#"  , py::arg("theResTexture"),  py::arg("theTexture"),  py::arg("theKey")
          )
        .def("DefineMaterial",
             (void (RWMesh_MaterialMap::*)(  const XCAFPrs_Style & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString &  ) ) static_cast<void (RWMesh_MaterialMap::*)(  const XCAFPrs_Style & ,   const TCollection_AsciiString & ,   const TCollection_AsciiString &  ) >(&RWMesh_MaterialMap::DefineMaterial),
             R"#(Virtual method actually defining the material (e.g. export to the file).)#"  , py::arg("theStyle"),  py::arg("theKey"),  py::arg("theName")
          )
        .def("IsFailed",
             (bool (RWMesh_MaterialMap::*)() const) static_cast<bool (RWMesh_MaterialMap::*)() const>(&RWMesh_MaterialMap::IsFailed),
             R"#(Return failed flag.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&RWMesh_MaterialMap::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&RWMesh_MaterialMap::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (RWMesh_MaterialMap::*)() const) static_cast< const handle<Standard_Type> & (RWMesh_MaterialMap::*)() const>(&RWMesh_MaterialMap::DynamicType),
             R"#()#"
             
         )
       .def("DefaultStyle",
             ( const XCAFPrs_Style & (RWMesh_MaterialMap::*)() const) static_cast< const XCAFPrs_Style & (RWMesh_MaterialMap::*)() const>(&RWMesh_MaterialMap::DefaultStyle),
             R"#(Return default material definition to be used for nodes with only color defined.)#"
             
         )
;

    // Class RWMesh_NodeAttributes from ./opencascade/RWMesh_NodeAttributes.hxx
    klass = m.attr("RWMesh_NodeAttributes");

    // default constructor
    register_default_constructor<RWMesh_NodeAttributes , shared_ptr<RWMesh_NodeAttributes>>(m,"RWMesh_NodeAttributes");

    // nested enums

    static_cast<py::class_<RWMesh_NodeAttributes , shared_ptr<RWMesh_NodeAttributes>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("Name", &RWMesh_NodeAttributes::Name)
        .def_readwrite("RawName", &RWMesh_NodeAttributes::RawName)
        .def_readwrite("Style", &RWMesh_NodeAttributes::Style)
    // methods returning by ref wrapped as properties
;

    // Class RWMesh_ShapeIterator from ./opencascade/RWMesh_ShapeIterator.hxx
    klass = m.attr("RWMesh_ShapeIterator");


    // nested enums

    static_cast<py::class_<RWMesh_ShapeIterator , shared_ptr<RWMesh_ShapeIterator> ,Py_RWMesh_ShapeIterator >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Shape",
             ( const TopoDS_Shape & (RWMesh_ShapeIterator::*)() const) static_cast< const TopoDS_Shape & (RWMesh_ShapeIterator::*)() const>(&RWMesh_ShapeIterator::Shape),
             R"#(Return shape.)#" 
          )
        .def("More",
             (bool (RWMesh_ShapeIterator::*)() const) static_cast<bool (RWMesh_ShapeIterator::*)() const>(&RWMesh_ShapeIterator::More),
             R"#(Return true if iterator points to the valid triangulation.)#" 
          )
        .def("Next",
             (void (RWMesh_ShapeIterator::*)() ) static_cast<void (RWMesh_ShapeIterator::*)() >(&RWMesh_ShapeIterator::Next),
             R"#(Find next value.)#" 
          )
        .def("IsEmpty",
             (bool (RWMesh_ShapeIterator::*)() const) static_cast<bool (RWMesh_ShapeIterator::*)() const>(&RWMesh_ShapeIterator::IsEmpty),
             R"#(Return true if mesh data is defined.)#" 
          )
        .def("HasColor",
             (bool (RWMesh_ShapeIterator::*)() const) static_cast<bool (RWMesh_ShapeIterator::*)() const>(&RWMesh_ShapeIterator::HasColor),
             R"#(Return TRUE if shape color is set.)#" 
          )
        .def("ElemLower",
             (Standard_Integer (RWMesh_ShapeIterator::*)() const) static_cast<Standard_Integer (RWMesh_ShapeIterator::*)() const>(&RWMesh_ShapeIterator::ElemLower),
             R"#(Lower element index in current triangulation.)#" 
          )
        .def("ElemUpper",
             (Standard_Integer (RWMesh_ShapeIterator::*)() const) static_cast<Standard_Integer (RWMesh_ShapeIterator::*)() const>(&RWMesh_ShapeIterator::ElemUpper),
             R"#(Upper element index in current triangulation.)#" 
          )
        .def("NbNodes",
             (Standard_Integer (RWMesh_ShapeIterator::*)() const) static_cast<Standard_Integer (RWMesh_ShapeIterator::*)() const>(&RWMesh_ShapeIterator::NbNodes),
             R"#(Return number of nodes for the current shape.)#" 
          )
        .def("NodeLower",
             (Standard_Integer (RWMesh_ShapeIterator::*)() const) static_cast<Standard_Integer (RWMesh_ShapeIterator::*)() const>(&RWMesh_ShapeIterator::NodeLower),
             R"#(Lower node index in current shape.)#" 
          )
        .def("NodeUpper",
             (Standard_Integer (RWMesh_ShapeIterator::*)() const) static_cast<Standard_Integer (RWMesh_ShapeIterator::*)() const>(&RWMesh_ShapeIterator::NodeUpper),
             R"#(Upper node index in current shape.)#" 
          )
        .def("NodeTransformed",
             (gp_Pnt (RWMesh_ShapeIterator::*)(  const Standard_Integer  ) const) static_cast<gp_Pnt (RWMesh_ShapeIterator::*)(  const Standard_Integer  ) const>(&RWMesh_ShapeIterator::NodeTransformed),
             R"#(Return the node with specified index with applied transformation.)#"  , py::arg("theNode")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ExploredShape",
             ( const TopoDS_Shape & (RWMesh_ShapeIterator::*)() const) static_cast< const TopoDS_Shape & (RWMesh_ShapeIterator::*)() const>(&RWMesh_ShapeIterator::ExploredShape),
             R"#(Return explored shape.)#"
             
         )
       .def("Style",
             ( const XCAFPrs_Style & (RWMesh_ShapeIterator::*)() const) static_cast< const XCAFPrs_Style & (RWMesh_ShapeIterator::*)() const>(&RWMesh_ShapeIterator::Style),
             R"#(Return shape material.)#"
             
         )
       .def("Color",
             ( const Quantity_ColorRGBA & (RWMesh_ShapeIterator::*)() const) static_cast< const Quantity_ColorRGBA & (RWMesh_ShapeIterator::*)() const>(&RWMesh_ShapeIterator::Color),
             R"#(Return shape color.)#"
             
         )
;

    // Class RWMesh_TriangulationReader from ./opencascade/RWMesh_TriangulationReader.hxx
    klass = m.attr("RWMesh_TriangulationReader");


    // nested enums

    static_cast<py::class_<RWMesh_TriangulationReader ,opencascade::handle<RWMesh_TriangulationReader> ,Py_RWMesh_TriangulationReader , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetFileName",
             (void (RWMesh_TriangulationReader::*)(  const TCollection_AsciiString &  ) ) static_cast<void (RWMesh_TriangulationReader::*)(  const TCollection_AsciiString &  ) >(&RWMesh_TriangulationReader::SetFileName),
             R"#(Sets file name for reporting issues.)#"  , py::arg("theFileName")
          )
        .def("SetCoordinateSystemConverter",
             (void (RWMesh_TriangulationReader::*)(  const RWMesh_CoordinateSystemConverter &  ) ) static_cast<void (RWMesh_TriangulationReader::*)(  const RWMesh_CoordinateSystemConverter &  ) >(&RWMesh_TriangulationReader::SetCoordinateSystemConverter),
             R"#(Sets coordinate system converter.)#"  , py::arg("theConverter")
          )
        .def("IsDoublePrecision",
             (bool (RWMesh_TriangulationReader::*)() const) static_cast<bool (RWMesh_TriangulationReader::*)() const>(&RWMesh_TriangulationReader::IsDoublePrecision),
             R"#(Returns flag to fill in triangulation using double or single precision; FALSE by default.)#" 
          )
        .def("SetDoublePrecision",
             (void (RWMesh_TriangulationReader::*)( bool  ) ) static_cast<void (RWMesh_TriangulationReader::*)( bool  ) >(&RWMesh_TriangulationReader::SetDoublePrecision),
             R"#(Sets flag to fill in triangulation using double or single precision.)#"  , py::arg("theIsDouble")
          )
        .def("ToSkipDegenerates",
             (Standard_Boolean (RWMesh_TriangulationReader::*)() const) static_cast<Standard_Boolean (RWMesh_TriangulationReader::*)() const>(&RWMesh_TriangulationReader::ToSkipDegenerates),
             R"#(Returns TRUE if degenerated triangles should be skipped during mesh loading (only indexes will be checked).)#" 
          )
        .def("SetToSkipDegenerates",
             (void (RWMesh_TriangulationReader::*)(  const Standard_Boolean  ) ) static_cast<void (RWMesh_TriangulationReader::*)(  const Standard_Boolean  ) >(&RWMesh_TriangulationReader::SetToSkipDegenerates),
             R"#(Sets flag to skip degenerated triangles during mesh loading (only indexes will be checked).)#"  , py::arg("theToSkip")
          )
        .def("ToPrintDebugMessages",
             (Standard_Boolean (RWMesh_TriangulationReader::*)() const) static_cast<Standard_Boolean (RWMesh_TriangulationReader::*)() const>(&RWMesh_TriangulationReader::ToPrintDebugMessages),
             R"#(Returns TRUE if additional debug information should be print.)#" 
          )
        .def("SetToPrintDebugMessages",
             (void (RWMesh_TriangulationReader::*)(  const Standard_Boolean  ) ) static_cast<void (RWMesh_TriangulationReader::*)(  const Standard_Boolean  ) >(&RWMesh_TriangulationReader::SetToPrintDebugMessages),
             R"#(Sets flag to print debug information.)#"  , py::arg("theToPrint")
          )
        .def("StartStatistic",
             (void (RWMesh_TriangulationReader::*)() ) static_cast<void (RWMesh_TriangulationReader::*)() >(&RWMesh_TriangulationReader::StartStatistic),
             R"#(Starts and reset internal object that accumulates nodes/triangles statistic during data reading.)#" 
          )
        .def("StopStatistic",
             (void (RWMesh_TriangulationReader::*)() ) static_cast<void (RWMesh_TriangulationReader::*)() >(&RWMesh_TriangulationReader::StopStatistic),
             R"#(Stops and nullify internal object that accumulates nodes/triangles statistic during data reading.)#" 
          )
        .def("PrintStatistic",
             (void (RWMesh_TriangulationReader::*)() const) static_cast<void (RWMesh_TriangulationReader::*)() const>(&RWMesh_TriangulationReader::PrintStatistic),
             R"#(Prints loading statistic. This method should be used between StartStatistic() and StopStatistic() calls for correct results.)#" 
          )
        .def("Load",
             (bool (RWMesh_TriangulationReader::*)(  const handle<RWMesh_TriangulationSource> & ,   const handle<Poly_Triangulation> & ,   const handle<OSD_FileSystem> &  ) const) static_cast<bool (RWMesh_TriangulationReader::*)(  const handle<RWMesh_TriangulationSource> & ,   const handle<Poly_Triangulation> & ,   const handle<OSD_FileSystem> &  ) const>(&RWMesh_TriangulationReader::Load),
             R"#(Loads primitive array.)#"  , py::arg("theSourceMesh"),  py::arg("theDestMesh"),  py::arg("theFileSystem")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&RWMesh_TriangulationReader::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&RWMesh_TriangulationReader::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (RWMesh_TriangulationReader::*)() const) static_cast< const handle<Standard_Type> & (RWMesh_TriangulationReader::*)() const>(&RWMesh_TriangulationReader::DynamicType),
             R"#()#"
             
         )
       .def("FileName",
             ( const TCollection_AsciiString & (RWMesh_TriangulationReader::*)() const) static_cast< const TCollection_AsciiString & (RWMesh_TriangulationReader::*)() const>(&RWMesh_TriangulationReader::FileName),
             R"#(Returns file name for reporting issues.)#"
             
         )
       .def("CoordinateSystemConverter",
             ( const RWMesh_CoordinateSystemConverter & (RWMesh_TriangulationReader::*)() const) static_cast< const RWMesh_CoordinateSystemConverter & (RWMesh_TriangulationReader::*)() const>(&RWMesh_TriangulationReader::CoordinateSystemConverter),
             R"#(Returns coordinate system converter using for correct data loading.)#"
             
         )
;

    // Class RWMesh_TriangulationSource from ./opencascade/RWMesh_TriangulationSource.hxx
    klass = m.attr("RWMesh_TriangulationSource");


    // nested enums

    static_cast<py::class_<RWMesh_TriangulationSource ,opencascade::handle<RWMesh_TriangulationSource>  , Poly_Triangulation >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetReader",
             (void (RWMesh_TriangulationSource::*)(  const handle<RWMesh_TriangulationReader> &  ) ) static_cast<void (RWMesh_TriangulationSource::*)(  const handle<RWMesh_TriangulationReader> &  ) >(&RWMesh_TriangulationSource::SetReader),
             R"#(Sets reader allowing to read data from the buffer.)#"  , py::arg("theReader")
          )
        .def("DegeneratedTriNb",
             (Standard_Integer (RWMesh_TriangulationSource::*)() const) static_cast<Standard_Integer (RWMesh_TriangulationSource::*)() const>(&RWMesh_TriangulationSource::DegeneratedTriNb),
             R"#(Returns number of degenerated triangles collected during data reading. Used for debug statistic purpose.)#" 
          )
        .def("HasGeometry",
             (Standard_Boolean (RWMesh_TriangulationSource::*)() const) static_cast<Standard_Boolean (RWMesh_TriangulationSource::*)() const>(&RWMesh_TriangulationSource::HasGeometry),
             R"#(Returns TRUE if triangulation has some geometry.)#" 
          )
        .def("NbEdges",
             (Standard_Integer (RWMesh_TriangulationSource::*)() const) static_cast<Standard_Integer (RWMesh_TriangulationSource::*)() const>(&RWMesh_TriangulationSource::NbEdges),
             R"#(Returns the number of edges for this triangulation.)#" 
          )
        .def("Edge",
             (Standard_Integer (RWMesh_TriangulationSource::*)( Standard_Integer  ) const) static_cast<Standard_Integer (RWMesh_TriangulationSource::*)( Standard_Integer  ) const>(&RWMesh_TriangulationSource::Edge),
             R"#(Returns edge at the given index.)#"  , py::arg("theIndex")
          )
        .def("SetEdge",
             (void (RWMesh_TriangulationSource::*)( Standard_Integer ,  Standard_Integer  ) ) static_cast<void (RWMesh_TriangulationSource::*)( Standard_Integer ,  Standard_Integer  ) >(&RWMesh_TriangulationSource::SetEdge),
             R"#(Sets an edge.)#"  , py::arg("theIndex"),  py::arg("theEdge")
          )
        .def("NbDeferredNodes",
             (Standard_Integer (RWMesh_TriangulationSource::*)() const) static_cast<Standard_Integer (RWMesh_TriangulationSource::*)() const>(&RWMesh_TriangulationSource::NbDeferredNodes),
             R"#(Returns number of nodes for deferred loading. Note: this is estimated values defined in object header, which might be different from actually loaded values (due to broken header or extra mesh processing). Always check triangulation size of actually loaded data in code to avoid out-of-range issues.)#" 
          )
        .def("SetNbDeferredNodes",
             (void (RWMesh_TriangulationSource::*)(  const Standard_Integer  ) ) static_cast<void (RWMesh_TriangulationSource::*)(  const Standard_Integer  ) >(&RWMesh_TriangulationSource::SetNbDeferredNodes),
             R"#(Sets number of nodes for deferred loading.)#"  , py::arg("theNbNodes")
          )
        .def("NbDeferredTriangles",
             (Standard_Integer (RWMesh_TriangulationSource::*)() const) static_cast<Standard_Integer (RWMesh_TriangulationSource::*)() const>(&RWMesh_TriangulationSource::NbDeferredTriangles),
             R"#(Returns number of triangles for deferred loading. Note: this is estimated values defined in object header, which might be different from actually loaded values (due to broken header or extra mesh processing). Always check triangulation size of actually loaded data in code to avoid out-of-range issues.)#" 
          )
        .def("SetNbDeferredTriangles",
             (void (RWMesh_TriangulationSource::*)(  const Standard_Integer  ) ) static_cast<void (RWMesh_TriangulationSource::*)(  const Standard_Integer  ) >(&RWMesh_TriangulationSource::SetNbDeferredTriangles),
             R"#(Sets number of triangles for deferred loading.)#"  , py::arg("theNbTris")
          )
        .def("ResizeEdges",
             (void (RWMesh_TriangulationSource::*)( Standard_Integer ,  Standard_Boolean  ) ) static_cast<void (RWMesh_TriangulationSource::*)( Standard_Integer ,  Standard_Boolean  ) >(&RWMesh_TriangulationSource::ResizeEdges),
             R"#(Method resizing an internal array of triangles.)#"  , py::arg("theNbEdges"),  py::arg("theToCopyOld")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&RWMesh_TriangulationSource::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&RWMesh_TriangulationSource::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (RWMesh_TriangulationSource::*)() const) static_cast< const handle<Standard_Type> & (RWMesh_TriangulationSource::*)() const>(&RWMesh_TriangulationSource::DynamicType),
             R"#()#"
             
         )
       .def("Reader",
             ( const handle<RWMesh_TriangulationReader> & (RWMesh_TriangulationSource::*)() const) static_cast< const handle<RWMesh_TriangulationReader> & (RWMesh_TriangulationSource::*)() const>(&RWMesh_TriangulationSource::Reader),
             R"#(Returns reader allowing to read data from the buffer.)#"
             
         )
       .def_property("ChangeDegeneratedTriNb",
                     [](RWMesh_TriangulationSource& self){return self.ChangeDegeneratedTriNb();} ,
                     [](RWMesh_TriangulationSource& self, Standard_Integer  val){self.ChangeDegeneratedTriNb() = val;},                      R"#(Gets access to number of degenerated triangles to collect them during data reading.)#"
         )
       .def("InternalEdges",
             (NCollection_Array1<Standard_Integer> & (RWMesh_TriangulationSource::*)() ) static_cast<NCollection_Array1<Standard_Integer> & (RWMesh_TriangulationSource::*)() >(&RWMesh_TriangulationSource::InternalEdges),
             R"#(Returns an internal array of edges. Edge()/SetEdge() should be used instead in portable code.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class RWMesh_EdgeIterator from ./opencascade/RWMesh_EdgeIterator.hxx
    klass = m.attr("RWMesh_EdgeIterator");


    // nested enums

    static_cast<py::class_<RWMesh_EdgeIterator , shared_ptr<RWMesh_EdgeIterator>  , RWMesh_ShapeIterator >>(klass)
    // constructors
        .def(py::init<  const TDF_Label &, const TopLoc_Location &, const Standard_Boolean, const XCAFPrs_Style & >()  , py::arg("theLabel"),  py::arg("theLocation"),  py::arg("theToMapColors")=static_cast< const Standard_Boolean>(false),  py::arg("theStyle")=static_cast< const XCAFPrs_Style &>(XCAFPrs_Style ( )) )
        .def(py::init<  const TopoDS_Shape &, const XCAFPrs_Style & >()  , py::arg("theShape"),  py::arg("theStyle")=static_cast< const XCAFPrs_Style &>(XCAFPrs_Style ( )) )
    // custom constructors
    // methods
        .def("More",
             (bool (RWMesh_EdgeIterator::*)() const) static_cast<bool (RWMesh_EdgeIterator::*)() const>(&RWMesh_EdgeIterator::More),
             R"#(Return true if iterator points to the valid triangulation.)#" 
          )
        .def("Next",
             (void (RWMesh_EdgeIterator::*)() ) static_cast<void (RWMesh_EdgeIterator::*)() >(&RWMesh_EdgeIterator::Next),
             R"#(Find next value.)#" 
          )
        .def("IsEmpty",
             (bool (RWMesh_EdgeIterator::*)() const) static_cast<bool (RWMesh_EdgeIterator::*)() const>(&RWMesh_EdgeIterator::IsEmpty),
             R"#(Return true if geometry data is defined.)#" 
          )
        .def("ElemLower",
             (Standard_Integer (RWMesh_EdgeIterator::*)() const) static_cast<Standard_Integer (RWMesh_EdgeIterator::*)() const>(&RWMesh_EdgeIterator::ElemLower),
             R"#(Lower element index in current triangulation.)#" 
          )
        .def("ElemUpper",
             (Standard_Integer (RWMesh_EdgeIterator::*)() const) static_cast<Standard_Integer (RWMesh_EdgeIterator::*)() const>(&RWMesh_EdgeIterator::ElemUpper),
             R"#(Upper element index in current triangulation.)#" 
          )
        .def("NbNodes",
             (Standard_Integer (RWMesh_EdgeIterator::*)() const) static_cast<Standard_Integer (RWMesh_EdgeIterator::*)() const>(&RWMesh_EdgeIterator::NbNodes),
             R"#(Return number of nodes for the current edge.)#" 
          )
        .def("NodeLower",
             (Standard_Integer (RWMesh_EdgeIterator::*)() const) static_cast<Standard_Integer (RWMesh_EdgeIterator::*)() const>(&RWMesh_EdgeIterator::NodeLower),
             R"#(Lower node index in current triangulation.)#" 
          )
        .def("NodeUpper",
             (Standard_Integer (RWMesh_EdgeIterator::*)() const) static_cast<Standard_Integer (RWMesh_EdgeIterator::*)() const>(&RWMesh_EdgeIterator::NodeUpper),
             R"#(Upper node index in current triangulation.)#" 
          )
        .def("node",
             (gp_Pnt (RWMesh_EdgeIterator::*)(  const Standard_Integer  ) const) static_cast<gp_Pnt (RWMesh_EdgeIterator::*)(  const Standard_Integer  ) const>(&RWMesh_EdgeIterator::node),
             R"#(Return the node with specified index with applied transformation.)#"  , py::arg("theNode")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Edge",
             ( const TopoDS_Edge & (RWMesh_EdgeIterator::*)() const) static_cast< const TopoDS_Edge & (RWMesh_EdgeIterator::*)() const>(&RWMesh_EdgeIterator::Edge),
             R"#(Return current edge.)#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (RWMesh_EdgeIterator::*)() const) static_cast< const TopoDS_Shape & (RWMesh_EdgeIterator::*)() const>(&RWMesh_EdgeIterator::Shape),
             R"#(Return current edge.)#"
             
         )
       .def("Polygon3D",
             ( const handle<Poly_Polygon3D> & (RWMesh_EdgeIterator::*)() const) static_cast< const handle<Poly_Polygon3D> & (RWMesh_EdgeIterator::*)() const>(&RWMesh_EdgeIterator::Polygon3D),
             R"#(Return current edge data.)#"
             
         )
;

    // Class RWMesh_FaceIterator from ./opencascade/RWMesh_FaceIterator.hxx
    klass = m.attr("RWMesh_FaceIterator");


    // nested enums

    static_cast<py::class_<RWMesh_FaceIterator , shared_ptr<RWMesh_FaceIterator>  , RWMesh_ShapeIterator >>(klass)
    // constructors
        .def(py::init<  const TDF_Label &, const TopLoc_Location &, const Standard_Boolean, const XCAFPrs_Style & >()  , py::arg("theLabel"),  py::arg("theLocation"),  py::arg("theToMapColors")=static_cast< const Standard_Boolean>(false),  py::arg("theStyle")=static_cast< const XCAFPrs_Style &>(XCAFPrs_Style ( )) )
        .def(py::init<  const TopoDS_Shape &, const XCAFPrs_Style & >()  , py::arg("theShape"),  py::arg("theStyle")=static_cast< const XCAFPrs_Style &>(XCAFPrs_Style ( )) )
    // custom constructors
    // methods
        .def("More",
             (bool (RWMesh_FaceIterator::*)() const) static_cast<bool (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::More),
             R"#(Return true if iterator points to the valid triangulation.)#" 
          )
        .def("Next",
             (void (RWMesh_FaceIterator::*)() ) static_cast<void (RWMesh_FaceIterator::*)() >(&RWMesh_FaceIterator::Next),
             R"#(Find next value.)#" 
          )
        .def("IsEmptyMesh",
             (bool (RWMesh_FaceIterator::*)() const) static_cast<bool (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::IsEmptyMesh),
             R"#(Return true if mesh data is defined.)#" 
          )
        .def("IsEmpty",
             (bool (RWMesh_FaceIterator::*)() const) static_cast<bool (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::IsEmpty),
             R"#(Return true if mesh data is defined.)#" 
          )
        .def("HasFaceColor",
             (bool (RWMesh_FaceIterator::*)() const) static_cast<bool (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::HasFaceColor),
             R"#(Return TRUE if face color is set.)#" 
          )
        .def("NbTriangles",
             (Standard_Integer (RWMesh_FaceIterator::*)() const) static_cast<Standard_Integer (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::NbTriangles),
             R"#(Return number of elements of specific type for the current face.)#" 
          )
        .def("ElemLower",
             (Standard_Integer (RWMesh_FaceIterator::*)() const) static_cast<Standard_Integer (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::ElemLower),
             R"#(Lower element index in current triangulation.)#" 
          )
        .def("ElemUpper",
             (Standard_Integer (RWMesh_FaceIterator::*)() const) static_cast<Standard_Integer (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::ElemUpper),
             R"#(Upper element index in current triangulation.)#" 
          )
        .def("TriangleOriented",
             (Poly_Triangle (RWMesh_FaceIterator::*)( Standard_Integer  ) const) static_cast<Poly_Triangle (RWMesh_FaceIterator::*)( Standard_Integer  ) const>(&RWMesh_FaceIterator::TriangleOriented),
             R"#(Return triangle with specified index with applied Face orientation.)#"  , py::arg("theElemIndex")
          )
        .def("HasNormals",
             (bool (RWMesh_FaceIterator::*)() const) static_cast<bool (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::HasNormals),
             R"#(Return true if triangulation has defined normals.)#" 
          )
        .def("HasTexCoords",
             (bool (RWMesh_FaceIterator::*)() const) static_cast<bool (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::HasTexCoords),
             R"#(Return true if triangulation has defined normals.)#" 
          )
        .def("NormalTransformed",
             (gp_Dir (RWMesh_FaceIterator::*)( Standard_Integer  ) const) static_cast<gp_Dir (RWMesh_FaceIterator::*)( Standard_Integer  ) const>(&RWMesh_FaceIterator::NormalTransformed),
             R"#(Return normal at specified node index with face transformation applied and face orientation applied.)#"  , py::arg("theNode")
          )
        .def("NbNodes",
             (Standard_Integer (RWMesh_FaceIterator::*)() const) static_cast<Standard_Integer (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::NbNodes),
             R"#(Return number of nodes for the current face.)#" 
          )
        .def("NodeLower",
             (Standard_Integer (RWMesh_FaceIterator::*)() const) static_cast<Standard_Integer (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::NodeLower),
             R"#(Lower node index in current triangulation.)#" 
          )
        .def("NodeUpper",
             (Standard_Integer (RWMesh_FaceIterator::*)() const) static_cast<Standard_Integer (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::NodeUpper),
             R"#(Upper node index in current triangulation.)#" 
          )
        .def("NodeTexCoord",
             (gp_Pnt2d (RWMesh_FaceIterator::*)(  const Standard_Integer  ) const) static_cast<gp_Pnt2d (RWMesh_FaceIterator::*)(  const Standard_Integer  ) const>(&RWMesh_FaceIterator::NodeTexCoord),
             R"#(Return texture coordinates for the node.)#"  , py::arg("theNode")
          )
        .def("node",
             (gp_Pnt (RWMesh_FaceIterator::*)(  const Standard_Integer  ) const) static_cast<gp_Pnt (RWMesh_FaceIterator::*)(  const Standard_Integer  ) const>(&RWMesh_FaceIterator::node),
             R"#(Return the node with specified index with applied transformation.)#"  , py::arg("theNode")
          )
        .def("normal",
             (gp_Dir (RWMesh_FaceIterator::*)( Standard_Integer  ) const) static_cast<gp_Dir (RWMesh_FaceIterator::*)( Standard_Integer  ) const>(&RWMesh_FaceIterator::normal),
             R"#(Return normal at specified node index without face transformation applied.)#"  , py::arg("theNode")
          )
        .def("triangle",
             (Poly_Triangle (RWMesh_FaceIterator::*)( Standard_Integer  ) const) static_cast<Poly_Triangle (RWMesh_FaceIterator::*)( Standard_Integer  ) const>(&RWMesh_FaceIterator::triangle),
             R"#(Return triangle with specified index.)#"  , py::arg("theElemIndex")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Face",
             ( const TopoDS_Face & (RWMesh_FaceIterator::*)() const) static_cast< const TopoDS_Face & (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::Face),
             R"#(Return current face.)#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (RWMesh_FaceIterator::*)() const) static_cast< const TopoDS_Shape & (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::Shape),
             R"#(Return current face.)#"
             
         )
       .def("Triangulation",
             ( const handle<Poly_Triangulation> & (RWMesh_FaceIterator::*)() const) static_cast< const handle<Poly_Triangulation> & (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::Triangulation),
             R"#(Return current face triangulation.)#"
             
         )
       .def("FaceStyle",
             ( const XCAFPrs_Style & (RWMesh_FaceIterator::*)() const) static_cast< const XCAFPrs_Style & (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::FaceStyle),
             R"#(Return face material.)#"
             
         )
       .def("FaceColor",
             ( const Quantity_ColorRGBA & (RWMesh_FaceIterator::*)() const) static_cast< const Quantity_ColorRGBA & (RWMesh_FaceIterator::*)() const>(&RWMesh_FaceIterator::FaceColor),
             R"#(Return face color.)#"
             
         )
;

    // Class RWMesh_VertexIterator from ./opencascade/RWMesh_VertexIterator.hxx
    klass = m.attr("RWMesh_VertexIterator");


    // nested enums

    static_cast<py::class_<RWMesh_VertexIterator , shared_ptr<RWMesh_VertexIterator>  , RWMesh_ShapeIterator >>(klass)
    // constructors
        .def(py::init<  const TDF_Label &, const TopLoc_Location &, const Standard_Boolean, const XCAFPrs_Style & >()  , py::arg("theLabel"),  py::arg("theLocation"),  py::arg("theToMapColors")=static_cast< const Standard_Boolean>(false),  py::arg("theStyle")=static_cast< const XCAFPrs_Style &>(XCAFPrs_Style ( )) )
        .def(py::init<  const TopoDS_Shape &, const XCAFPrs_Style & >()  , py::arg("theShape"),  py::arg("theStyle")=static_cast< const XCAFPrs_Style &>(XCAFPrs_Style ( )) )
    // custom constructors
    // methods
        .def("More",
             (bool (RWMesh_VertexIterator::*)() const) static_cast<bool (RWMesh_VertexIterator::*)() const>(&RWMesh_VertexIterator::More),
             R"#(Return true if iterator points to the valid triangulation.)#" 
          )
        .def("Next",
             (void (RWMesh_VertexIterator::*)() ) static_cast<void (RWMesh_VertexIterator::*)() >(&RWMesh_VertexIterator::Next),
             R"#(Find next value.)#" 
          )
        .def("IsEmpty",
             (bool (RWMesh_VertexIterator::*)() const) static_cast<bool (RWMesh_VertexIterator::*)() const>(&RWMesh_VertexIterator::IsEmpty),
             R"#(Return true if geometry data is defined.)#" 
          )
        .def("ElemLower",
             (Standard_Integer (RWMesh_VertexIterator::*)() const) static_cast<Standard_Integer (RWMesh_VertexIterator::*)() const>(&RWMesh_VertexIterator::ElemLower),
             R"#(Lower element index in current triangulation.)#" 
          )
        .def("ElemUpper",
             (Standard_Integer (RWMesh_VertexIterator::*)() const) static_cast<Standard_Integer (RWMesh_VertexIterator::*)() const>(&RWMesh_VertexIterator::ElemUpper),
             R"#(Upper element index in current triangulation.)#" 
          )
        .def("NbNodes",
             (Standard_Integer (RWMesh_VertexIterator::*)() const) static_cast<Standard_Integer (RWMesh_VertexIterator::*)() const>(&RWMesh_VertexIterator::NbNodes),
             R"#(Return number of nodes for the current edge.)#" 
          )
        .def("NodeLower",
             (Standard_Integer (RWMesh_VertexIterator::*)() const) static_cast<Standard_Integer (RWMesh_VertexIterator::*)() const>(&RWMesh_VertexIterator::NodeLower),
             R"#(Lower node index in current triangulation.)#" 
          )
        .def("NodeUpper",
             (Standard_Integer (RWMesh_VertexIterator::*)() const) static_cast<Standard_Integer (RWMesh_VertexIterator::*)() const>(&RWMesh_VertexIterator::NodeUpper),
             R"#(Upper node index in current triangulation.)#" 
          )
        .def("node",
             (gp_Pnt (RWMesh_VertexIterator::*)(  const Standard_Integer  ) const) static_cast<gp_Pnt (RWMesh_VertexIterator::*)(  const Standard_Integer  ) const>(&RWMesh_VertexIterator::node),
             R"#(Return the node with specified index with applied transformation.)#"  , py::arg("arg0")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Vertex",
             ( const TopoDS_Vertex & (RWMesh_VertexIterator::*)() const) static_cast< const TopoDS_Vertex & (RWMesh_VertexIterator::*)() const>(&RWMesh_VertexIterator::Vertex),
             R"#(Return current edge.)#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (RWMesh_VertexIterator::*)() const) static_cast< const TopoDS_Shape & (RWMesh_VertexIterator::*)() const>(&RWMesh_VertexIterator::Shape),
             R"#(Return current vertex.)#"
             
         )
       .def("Point",
             ( const gp_Pnt & (RWMesh_VertexIterator::*)() const) static_cast< const gp_Pnt & (RWMesh_VertexIterator::*)() const>(&RWMesh_VertexIterator::Point),
             R"#(Return current vertex data.)#"
             
         )
;

// functions

// ./opencascade/RWMesh.hxx
// ./opencascade/RWMesh_CafReader.hxx
// ./opencascade/RWMesh_CoordinateSystem.hxx
// ./opencascade/RWMesh_CoordinateSystemConverter.hxx
// ./opencascade/RWMesh_EdgeIterator.hxx
// ./opencascade/RWMesh_FaceIterator.hxx
// ./opencascade/RWMesh_MaterialMap.hxx
// ./opencascade/RWMesh_NameFormat.hxx
// ./opencascade/RWMesh_NodeAttributes.hxx
// ./opencascade/RWMesh_ShapeIterator.hxx
// ./opencascade/RWMesh_TriangulationReader.hxx
// ./opencascade/RWMesh_TriangulationSource.hxx
// ./opencascade/RWMesh_VertexIterator.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_DataMap<TopoDS_Shape, RWMesh_NodeAttributes, TopTools_ShapeMapHasher>(m,"RWMesh_NodeAttributeMap");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
