import OCP.XCAFView
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.Standard
import OCP.TCollection
import OCP.gp
__all__  = [
"XCAFView_Object",
"XCAFView_ProjectionType",
"XCAFView_ProjectionType_Central",
"XCAFView_ProjectionType_NoCamera",
"XCAFView_ProjectionType_Parallel"
]
class XCAFView_Object(OCP.Standard.Standard_Transient):
    """
    Access object for saved viewAccess object for saved viewAccess object for saved view
    """
    def BackPlaneDistance(self) -> float: ...
    def ClippingExpression(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def CreateGDTPoints(self,theLenght : int) -> None: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def FrontPlaneDistance(self) -> float: ...
    def GDTPoint(self,theIndex : int) -> OCP.gp.gp_Pnt: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasBackPlaneClipping(self) -> bool: ...
    def HasFrontPlaneClipping(self) -> bool: ...
    def HasGDTPoints(self) -> bool: ...
    def HasViewVolumeSidesClipping(self) -> bool: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Name(self) -> OCP.TCollection.TCollection_HAsciiString: ...
    def NbGDTPoints(self) -> int: ...
    def ProjectionPoint(self) -> OCP.gp.gp_Pnt: ...
    def SetBackPlaneDistance(self,theDistance : float) -> None: ...
    def SetClippingExpression(self,theExpression : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetFrontPlaneDistance(self,theDistance : float) -> None: ...
    def SetGDTPoint(self,theIndex : int,thePoint : OCP.gp.gp_Pnt) -> None: ...
    def SetName(self,theName : OCP.TCollection.TCollection_HAsciiString) -> None: ...
    def SetProjectionPoint(self,thePoint : OCP.gp.gp_Pnt) -> None: ...
    def SetType(self,theType : XCAFView_ProjectionType) -> None: ...
    def SetUpDirection(self,theDirection : OCP.gp.gp_Dir) -> None: ...
    def SetViewDirection(self,theDirection : OCP.gp.gp_Dir) -> None: ...
    def SetViewVolumeSidesClipping(self,theViewVolumeSidesClipping : bool) -> None: ...
    def SetWindowHorizontalSize(self,theSize : float) -> None: ...
    def SetWindowVerticalSize(self,theSize : float) -> None: ...
    def SetZoomFactor(self,theZoomFactor : float) -> None: ...
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Type(self) -> XCAFView_ProjectionType: ...
    def UnsetBackPlaneClipping(self) -> None: ...
    def UnsetFrontPlaneClipping(self) -> None: ...
    def UpDirection(self) -> OCP.gp.gp_Dir: ...
    def ViewDirection(self) -> OCP.gp.gp_Dir: ...
    def WindowHorizontalSize(self) -> float: ...
    def WindowVerticalSize(self) -> float: ...
    def ZoomFactor(self) -> float: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theObj : XCAFView_Object) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class XCAFView_ProjectionType():
    """
    Defines projection types of view

    Members:

      XCAFView_ProjectionType_NoCamera

      XCAFView_ProjectionType_Parallel

      XCAFView_ProjectionType_Central
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    XCAFView_ProjectionType_Central: OCP.XCAFView.XCAFView_ProjectionType # value = <XCAFView_ProjectionType.XCAFView_ProjectionType_Central: 2>
    XCAFView_ProjectionType_NoCamera: OCP.XCAFView.XCAFView_ProjectionType # value = <XCAFView_ProjectionType.XCAFView_ProjectionType_NoCamera: 0>
    XCAFView_ProjectionType_Parallel: OCP.XCAFView.XCAFView_ProjectionType # value = <XCAFView_ProjectionType.XCAFView_ProjectionType_Parallel: 1>
    __entries: dict # value = {'XCAFView_ProjectionType_NoCamera': (<XCAFView_ProjectionType.XCAFView_ProjectionType_NoCamera: 0>, None), 'XCAFView_ProjectionType_Parallel': (<XCAFView_ProjectionType.XCAFView_ProjectionType_Parallel: 1>, None), 'XCAFView_ProjectionType_Central': (<XCAFView_ProjectionType.XCAFView_ProjectionType_Central: 2>, None)}
    __members__: dict # value = {'XCAFView_ProjectionType_NoCamera': <XCAFView_ProjectionType.XCAFView_ProjectionType_NoCamera: 0>, 'XCAFView_ProjectionType_Parallel': <XCAFView_ProjectionType.XCAFView_ProjectionType_Parallel: 1>, 'XCAFView_ProjectionType_Central': <XCAFView_ProjectionType.XCAFView_ProjectionType_Central: 2>}
    pass
XCAFView_ProjectionType_Central: OCP.XCAFView.XCAFView_ProjectionType # value = <XCAFView_ProjectionType.XCAFView_ProjectionType_Central: 2>
XCAFView_ProjectionType_NoCamera: OCP.XCAFView.XCAFView_ProjectionType # value = <XCAFView_ProjectionType.XCAFView_ProjectionType_NoCamera: 0>
XCAFView_ProjectionType_Parallel: OCP.XCAFView.XCAFView_ProjectionType # value = <XCAFView_ProjectionType.XCAFView_ProjectionType_Parallel: 1>
