import OCP.RWMesh
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.TCollection
import io
import OCP.Quantity
import OCP.OSD
import OCP.gp
import OCP.TColStd
import OCP.Message
import OCP.TopoDS
import OCP.Bnd
import OCP.TDocStd
import OCP.Interface
import OCP.NCollection
import OCP.TShort
import OCP.TopLoc
import OCP.TColgp
import OCP.Image
import OCP.Standard
import OCP.Poly
import OCP.XCAFPrs
import OCP.TDF
__all__  = [
"RWMesh",
"RWMesh_CafReader",
"RWMesh_CafReaderStatusEx",
"RWMesh_CoordinateSystem",
"RWMesh_CoordinateSystemConverter",
"RWMesh_ShapeIterator",
"RWMesh_FaceIterator",
"RWMesh_MaterialMap",
"RWMesh_NameFormat",
"RWMesh_NodeAttributeMap",
"RWMesh_NodeAttributes",
"RWMesh_EdgeIterator",
"RWMesh_TriangulationReader",
"RWMesh_TriangulationSource",
"RWMesh_VertexIterator",
"RWMesh_CafReaderStatusEx_NONE",
"RWMesh_CafReaderStatusEx_Partial",
"RWMesh_CoordinateSystem_Blender",
"RWMesh_CoordinateSystem_Undefined",
"RWMesh_CoordinateSystem_Yup",
"RWMesh_CoordinateSystem_Zup",
"RWMesh_CoordinateSystem_glTF",
"RWMesh_CoordinateSystem_negZfwd_posYup",
"RWMesh_CoordinateSystem_posYfwd_posZup",
"RWMesh_NameFormat_Empty",
"RWMesh_NameFormat_Instance",
"RWMesh_NameFormat_InstanceOrProduct",
"RWMesh_NameFormat_Product",
"RWMesh_NameFormat_ProductAndInstance",
"RWMesh_NameFormat_ProductAndInstanceAndOcaf",
"RWMesh_NameFormat_ProductOrInstance"
]
class RWMesh():
    """
    Auxiliary tools for RWMesh package.
    """
    @staticmethod
    def FormatName_s(theFormat : RWMesh_NameFormat,theLabel : OCP.TDF.TDF_Label,theRefLabel : OCP.TDF.TDF_Label) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Generate name for specified labels.
        """
    @staticmethod
    def ReadNameAttribute_s(theLabel : OCP.TDF.TDF_Label) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Read name attribute from label.
        """
    def __init__(self) -> None: ...
    pass
class RWMesh_CafReader(OCP.Standard.Standard_Transient):
    """
    The general interface for importing mesh data into XDE document.
    """
    def CoordinateSystemConverter(self) -> RWMesh_CoordinateSystemConverter: 
        """
        Return coordinate system converter.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Document(self) -> OCP.TDocStd.TDocStd_Document: 
        """
        Return target document.
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def ExternalFiles(self) -> OCP.Interface.Interface_IndexedMapOfAsciiString: 
        """
        Return the list of complementary files - external references (textures, data, etc.).
        """
    def ExtraStatus(self) -> int: 
        """
        Return extended status flags.
        """
    def FileCoordinateSystem(self) -> OCP.gp.gp_Ax3: 
        """
        Return file origin coordinate system; can be UNDEFINED, which means no conversion will be done.
        """
    def FileLengthUnit(self) -> float: 
        """
        Return the length unit to convert from while reading the file, defined as scale factor for m (meters). Can be undefined (-1.0) if file format is unitless.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasFileCoordinateSystem(self) -> bool: 
        """
        Return TRUE if file origin coordinate system has been defined.
        """
    def HasSystemCoordinateSystem(self) -> bool: 
        """
        Return TRUE if system coordinate system has been defined; FALSE by default.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def MemoryLimitMiB(self) -> int: 
        """
        Return memory usage limit in MiB, -1 by default which means no limit.
        """
    def Metadata(self) -> OCP.TColStd.TColStd_IndexedDataMapOfStringString: 
        """
        Return metadata map.
        """
    @overload
    def Perform(self,theFile : OCP.TCollection.TCollection_AsciiString,theProgress : OCP.Message.Message_ProgressRange) -> bool: 
        """
        Open stream and pass it to Perform method. The Document instance should be set beforehand.

        Read the data from specified file.
        """
    @overload
    def Perform(self,theStream : io.BytesIO,theProgress : OCP.Message.Message_ProgressRange,theFile : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString) -> bool: ...
    @overload
    def ProbeHeader(self,theFile : OCP.TCollection.TCollection_AsciiString,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: 
        """
        Open stream and pass it to ProbeHeader method.

        Read the header data from specified file without reading entire model. The main purpose is collecting metadata and external references - for copying model into a new location, for example. Can be NOT implemented (unsupported by format / reader).
        """
    @overload
    def ProbeHeader(self,theStream : io.BytesIO,theFile : OCP.TCollection.TCollection_AsciiString=OCP.TCollection.TCollection_AsciiString,theProgress : OCP.Message.Message_ProgressRange=OCP.Message.Message_ProgressRange) -> bool: ...
    def RootPrefix(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Return prefix for generating root labels names.
        """
    def SetCoordinateSystemConverter(self,theConverter : RWMesh_CoordinateSystemConverter) -> None: 
        """
        Set coordinate system converter.
        """
    def SetDocument(self,theDoc : OCP.TDocStd.TDocStd_Document) -> None: 
        """
        Set target document. Set system length unit according to the units of the document
        """
    @overload
    def SetFileCoordinateSystem(self,theCS : OCP.gp.gp_Ax3) -> None: ...
    @overload
    def SetFileCoordinateSystem(self,theCS : RWMesh_CoordinateSystem) -> None: ...
    def SetFileLengthUnit(self,theUnits : float) -> None: ...
    def SetFillIncompleteDocument(self,theToFillIncomplete : bool) -> None: 
        """
        Set flag allowing partially read file content to be put into the XDE document.
        """
    def SetMemoryLimitMiB(self,theLimitMiB : int) -> None: 
        """
        Set memory usage limit in MiB; can be ignored by reader implementation!
        """
    def SetRootPrefix(self,theRootPrefix : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Set prefix for generating root labels names
        """
    @overload
    def SetSystemCoordinateSystem(self,theCS : OCP.gp.gp_Ax3) -> None: 
        """
        Set system origin coordinate system to perform conversion into during read.

        Set system origin coordinate system to perform conversion into during read.
        """
    @overload
    def SetSystemCoordinateSystem(self,theCS : RWMesh_CoordinateSystem) -> None: ...
    def SetSystemLengthUnit(self,theUnits : float) -> None: 
        """
        Set system length units to convert into while reading the file, defined as scale factor for m (meters).
        """
    def SingleShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Return result as a single shape.
        """
    def SystemCoordinateSystem(self) -> OCP.gp.gp_Ax3: 
        """
        Return system coordinate system; UNDEFINED by default, which means that no conversion will be done.
        """
    def SystemLengthUnit(self) -> float: 
        """
        Return the length unit to convert into while reading the file, defined as scale factor for m (meters); -1.0 by default, which means that NO conversion will be applied.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToFillIncompleteDocument(self) -> bool: 
        """
        Flag indicating if partially read file content should be put into the XDE document, TRUE by default.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class RWMesh_CafReaderStatusEx():
    """
    Extended status bits.

    Members:

      RWMesh_CafReaderStatusEx_NONE

      RWMesh_CafReaderStatusEx_Partial
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    RWMesh_CafReaderStatusEx_NONE: OCP.RWMesh.RWMesh_CafReaderStatusEx # value = <RWMesh_CafReaderStatusEx.RWMesh_CafReaderStatusEx_NONE: 0>
    RWMesh_CafReaderStatusEx_Partial: OCP.RWMesh.RWMesh_CafReaderStatusEx # value = <RWMesh_CafReaderStatusEx.RWMesh_CafReaderStatusEx_Partial: 1>
    __entries: dict # value = {'RWMesh_CafReaderStatusEx_NONE': (<RWMesh_CafReaderStatusEx.RWMesh_CafReaderStatusEx_NONE: 0>, None), 'RWMesh_CafReaderStatusEx_Partial': (<RWMesh_CafReaderStatusEx.RWMesh_CafReaderStatusEx_Partial: 1>, None)}
    __members__: dict # value = {'RWMesh_CafReaderStatusEx_NONE': <RWMesh_CafReaderStatusEx.RWMesh_CafReaderStatusEx_NONE: 0>, 'RWMesh_CafReaderStatusEx_Partial': <RWMesh_CafReaderStatusEx.RWMesh_CafReaderStatusEx_Partial: 1>}
    pass
class RWMesh_CoordinateSystem():
    """
    Standard coordinate system definition. Open CASCADE does not force application using specific coordinate system, although Draw Harness and samples define +Z-up +Y-forward coordinate system for camera view manipulation. This enumeration defines two commonly used conventions - Z-up and Y-up..

    Members:

      RWMesh_CoordinateSystem_Undefined

      RWMesh_CoordinateSystem_posYfwd_posZup

      RWMesh_CoordinateSystem_negZfwd_posYup

      RWMesh_CoordinateSystem_Blender

      RWMesh_CoordinateSystem_glTF

      RWMesh_CoordinateSystem_Zup

      RWMesh_CoordinateSystem_Yup
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    RWMesh_CoordinateSystem_Blender: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_posYfwd_posZup: 0>
    RWMesh_CoordinateSystem_Undefined: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_Undefined: -1>
    RWMesh_CoordinateSystem_Yup: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_negZfwd_posYup: 1>
    RWMesh_CoordinateSystem_Zup: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_posYfwd_posZup: 0>
    RWMesh_CoordinateSystem_glTF: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_negZfwd_posYup: 1>
    RWMesh_CoordinateSystem_negZfwd_posYup: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_negZfwd_posYup: 1>
    RWMesh_CoordinateSystem_posYfwd_posZup: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_posYfwd_posZup: 0>
    __entries: dict # value = {'RWMesh_CoordinateSystem_Undefined': (<RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_Undefined: -1>, None), 'RWMesh_CoordinateSystem_posYfwd_posZup': (<RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_posYfwd_posZup: 0>, None), 'RWMesh_CoordinateSystem_negZfwd_posYup': (<RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_negZfwd_posYup: 1>, None), 'RWMesh_CoordinateSystem_Blender': (<RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_posYfwd_posZup: 0>, None), 'RWMesh_CoordinateSystem_glTF': (<RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_negZfwd_posYup: 1>, None), 'RWMesh_CoordinateSystem_Zup': (<RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_posYfwd_posZup: 0>, None), 'RWMesh_CoordinateSystem_Yup': (<RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_negZfwd_posYup: 1>, None)}
    __members__: dict # value = {'RWMesh_CoordinateSystem_Undefined': <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_Undefined: -1>, 'RWMesh_CoordinateSystem_posYfwd_posZup': <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_posYfwd_posZup: 0>, 'RWMesh_CoordinateSystem_negZfwd_posYup': <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_negZfwd_posYup: 1>, 'RWMesh_CoordinateSystem_Blender': <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_posYfwd_posZup: 0>, 'RWMesh_CoordinateSystem_glTF': <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_negZfwd_posYup: 1>, 'RWMesh_CoordinateSystem_Zup': <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_posYfwd_posZup: 0>, 'RWMesh_CoordinateSystem_Yup': <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_negZfwd_posYup: 1>}
    pass
class RWMesh_CoordinateSystemConverter():
    """
    Coordinate system converter defining the following tools: - Initialization for commonly used coordinate systems Z-up and Y-up. - Perform length unit conversion (scaling). - Conversion of three basic elements: a) mesh node Positions, b) mesh node Normals, c) model nodes Transformations (locations).
    """
    def HasInputCoordinateSystem(self) -> bool: 
        """
        Return TRUE if source coordinate system has been set; FALSE by default.
        """
    def HasOutputCoordinateSystem(self) -> bool: 
        """
        Return TRUE if destination coordinate system has been set; FALSE by default.
        """
    def Init(self,theInputSystem : OCP.gp.gp_Ax3,theInputLengthUnit : float,theOutputSystem : OCP.gp.gp_Ax3,theOutputLengthUnit : float) -> None: 
        """
        Initialize transformation.
        """
    def InputCoordinateSystem(self) -> OCP.gp.gp_Ax3: 
        """
        Source coordinate system; UNDEFINED by default.
        """
    def InputLengthUnit(self) -> float: 
        """
        Return source length units, defined as scale factor to m (meters). -1.0 by default, which means that NO conversion will be applied (regardless output length unit).
        """
    def IsEmpty(self) -> bool: 
        """
        Return TRUE if there is no transformation (target and current coordinates systems are same).
        """
    def OutputCoordinateSystem(self) -> OCP.gp.gp_Ax3: 
        """
        Destination coordinate system; UNDEFINED by default.
        """
    def OutputLengthUnit(self) -> float: 
        """
        Return destination length units, defined as scale factor to m (meters). -1.0 by default, which means that NO conversion will be applied (regardless input length unit).
        """
    @overload
    def SetInputCoordinateSystem(self,theSysFrom : OCP.gp.gp_Ax3) -> None: 
        """
        Set source coordinate system.

        Set source coordinate system.
        """
    @overload
    def SetInputCoordinateSystem(self,theSysFrom : RWMesh_CoordinateSystem) -> None: ...
    def SetInputLengthUnit(self,theInputScale : float) -> None: 
        """
        Set source length units as scale factor to m (meters).
        """
    @overload
    def SetOutputCoordinateSystem(self,theSysTo : OCP.gp.gp_Ax3) -> None: 
        """
        Set destination coordinate system.

        Set destination coordinate system.
        """
    @overload
    def SetOutputCoordinateSystem(self,theSysTo : RWMesh_CoordinateSystem) -> None: ...
    def SetOutputLengthUnit(self,theOutputScale : float) -> None: 
        """
        Set destination length units as scale factor to m (meters).
        """
    @staticmethod
    def StandardCoordinateSystem_s(theSys : RWMesh_CoordinateSystem) -> OCP.gp.gp_Ax3: 
        """
        Return a standard coordinate system definition.
        """
    def TransformNormal(self,theNorm : OCP.gp.gp_Vec3f) -> None: 
        """
        Transform normal (e.g. exclude translation/scale part of transformation).
        """
    def TransformPosition(self,thePos : OCP.gp.gp_XYZ) -> None: 
        """
        Transform position.
        """
    def TransformTransformation(self,theTrsf : OCP.gp.gp_Trsf) -> None: 
        """
        Transform transformation.
        """
    def __init__(self) -> None: ...
    pass
class RWMesh_ShapeIterator():
    """
    This is a virtual base class for other shape iterators. Provides an abstract interface for iterating over the elements of a shape. It defines a set of pure virtual methods that must be implemented by derived classes to handle specific types of shapes and their elements.
    """
    def Color(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return shape color.
        """
    def ElemLower(self) -> int: 
        """
        Lower element index in current triangulation.
        """
    def ElemUpper(self) -> int: 
        """
        Upper element index in current triangulation.
        """
    def ExploredShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Return explored shape.
        """
    def HasColor(self) -> bool: 
        """
        Return TRUE if shape color is set.
        """
    def IsEmpty(self) -> bool: 
        """
        Return true if mesh data is defined.
        """
    def More(self) -> bool: 
        """
        Return true if iterator points to the valid triangulation.
        """
    def NbNodes(self) -> int: 
        """
        Return number of nodes for the current shape.
        """
    def Next(self) -> None: 
        """
        Find next value.
        """
    def NodeLower(self) -> int: 
        """
        Lower node index in current shape.
        """
    def NodeTransformed(self,theNode : int) -> OCP.gp.gp_Pnt: 
        """
        Return the node with specified index with applied transformation.
        """
    def NodeUpper(self) -> int: 
        """
        Upper node index in current shape.
        """
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Return shape.
        """
    def Style(self) -> OCP.XCAFPrs.XCAFPrs_Style: 
        """
        Return shape material.
        """
    pass
class RWMesh_FaceIterator(RWMesh_ShapeIterator):
    """
    Auxiliary class to iterate through triangulated faces. Class is designed to provide an interface for iterating over the faces of a shape, specifically focusing on triangulated faces. It inherits from the `RWMesh_ShapeIterator` base class and extends its functionality to handle faces with triangulation data.
    """
    def Color(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return shape color.
        """
    def ElemLower(self) -> int: 
        """
        Lower element index in current triangulation.
        """
    def ElemUpper(self) -> int: 
        """
        Upper element index in current triangulation.
        """
    def ExploredShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Return explored shape.
        """
    def Face(self) -> OCP.TopoDS.TopoDS_Face: 
        """
        Return current face.
        """
    def FaceColor(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return face color.
        """
    def FaceStyle(self) -> OCP.XCAFPrs.XCAFPrs_Style: 
        """
        Return face material.
        """
    def HasColor(self) -> bool: 
        """
        Return TRUE if shape color is set.
        """
    def HasFaceColor(self) -> bool: 
        """
        Return TRUE if face color is set.
        """
    def HasNormals(self) -> bool: 
        """
        Return true if triangulation has defined normals.
        """
    def HasTexCoords(self) -> bool: 
        """
        Return true if triangulation has defined normals.
        """
    def IsEmpty(self) -> bool: 
        """
        Return true if mesh data is defined.
        """
    def IsEmptyMesh(self) -> bool: 
        """
        Return true if mesh data is defined.
        """
    def More(self) -> bool: 
        """
        Return true if iterator points to the valid triangulation.
        """
    def NbNodes(self) -> int: 
        """
        Return number of nodes for the current face.
        """
    def NbTriangles(self) -> int: 
        """
        Return number of elements of specific type for the current face.
        """
    def Next(self) -> None: 
        """
        Find next value.
        """
    def NodeLower(self) -> int: 
        """
        Lower node index in current triangulation.
        """
    def NodeTexCoord(self,theNode : int) -> OCP.gp.gp_Pnt2d: 
        """
        Return texture coordinates for the node.
        """
    def NodeTransformed(self,theNode : int) -> OCP.gp.gp_Pnt: 
        """
        Return the node with specified index with applied transformation.
        """
    def NodeUpper(self) -> int: 
        """
        Upper node index in current triangulation.
        """
    def NormalTransformed(self,theNode : int) -> OCP.gp.gp_Dir: 
        """
        Return normal at specified node index with face transformation applied and face orientation applied.
        """
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Return current face.
        """
    def Style(self) -> OCP.XCAFPrs.XCAFPrs_Style: 
        """
        Return shape material.
        """
    def TriangleOriented(self,theElemIndex : int) -> OCP.Poly.Poly_Triangle: 
        """
        Return triangle with specified index with applied Face orientation.
        """
    def Triangulation(self) -> OCP.Poly.Poly_Triangulation: 
        """
        Return current face triangulation.
        """
    @overload
    def __init__(self,theLabel : OCP.TDF.TDF_Label,theLocation : OCP.TopLoc.TopLoc_Location,theToMapColors : bool=False,theStyle : OCP.XCAFPrs.XCAFPrs_Style=OCP.XCAFPrs.XCAFPrs_Style) -> None: ...
    @overload
    def __init__(self,theShape : OCP.TopoDS.TopoDS_Shape,theStyle : OCP.XCAFPrs.XCAFPrs_Style=OCP.XCAFPrs.XCAFPrs_Style) -> None: ...
    def node(self,theNode : int) -> OCP.gp.gp_Pnt: 
        """
        Return the node with specified index with applied transformation.
        """
    def normal(self,theNode : int) -> OCP.gp.gp_Dir: 
        """
        Return normal at specified node index without face transformation applied.
        """
    def triangle(self,theElemIndex : int) -> OCP.Poly.Poly_Triangle: 
        """
        Return triangle with specified index.
        """
    pass
class RWMesh_MaterialMap(OCP.Standard.Standard_Transient):
    """
    Material manager. Provides an interface for collecting all materials within the document before writing it into file, and for copying associated image files (textures) into sub-folder near by exported model.
    """
    def AddMaterial(self,theStyle : OCP.XCAFPrs.XCAFPrs_Style) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Register material and return its name identifier.
        """
    def CopyTexture(self,theResTexture : OCP.TCollection.TCollection_AsciiString,theTexture : OCP.Image.Image_Texture,theKey : OCP.TCollection.TCollection_AsciiString) -> bool: 
        """
        Copy and rename texture file to the new location.
        """
    def CreateTextureFolder(self) -> bool: 
        """
        Create texture folder "modelName/textures"; for example: MODEL: Path/ModelName.gltf IMAGES: Path/ModelName/textures/ Warning! Output folder is NOT cleared.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def DefaultStyle(self) -> OCP.XCAFPrs.XCAFPrs_Style: 
        """
        Return default material definition to be used for nodes with only color defined.
        """
    def DefineMaterial(self,theStyle : OCP.XCAFPrs.XCAFPrs_Style,theKey : OCP.TCollection.TCollection_AsciiString,theName : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Virtual method actually defining the material (e.g. export to the file).
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def FindMaterial(self,theStyle : OCP.XCAFPrs.XCAFPrs_Style) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Find already registered material
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsFailed(self) -> bool: 
        """
        Return failed flag.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def SetDefaultStyle(self,theStyle : OCP.XCAFPrs.XCAFPrs_Style) -> None: 
        """
        Set default material definition to be used for nodes with only color defined.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def __init__(self,theFile : OCP.TCollection.TCollection_AsciiString) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class RWMesh_NameFormat():
    """
    Name format preference for XCAF shape labels.

    Members:

      RWMesh_NameFormat_Empty

      RWMesh_NameFormat_Product

      RWMesh_NameFormat_Instance

      RWMesh_NameFormat_InstanceOrProduct

      RWMesh_NameFormat_ProductOrInstance

      RWMesh_NameFormat_ProductAndInstance

      RWMesh_NameFormat_ProductAndInstanceAndOcaf
    """
    def __eq__(self,other : object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __init__(self,value : int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self,other : object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self,state : int) -> None: ...
    def __str__(self) -> str: ...
    @property
    def name(self) -> None:
        """
        :type: None
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    RWMesh_NameFormat_Empty: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_Empty: 0>
    RWMesh_NameFormat_Instance: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_Instance: 2>
    RWMesh_NameFormat_InstanceOrProduct: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_InstanceOrProduct: 3>
    RWMesh_NameFormat_Product: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_Product: 1>
    RWMesh_NameFormat_ProductAndInstance: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_ProductAndInstance: 5>
    RWMesh_NameFormat_ProductAndInstanceAndOcaf: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_ProductAndInstanceAndOcaf: 6>
    RWMesh_NameFormat_ProductOrInstance: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_ProductOrInstance: 4>
    __entries: dict # value = {'RWMesh_NameFormat_Empty': (<RWMesh_NameFormat.RWMesh_NameFormat_Empty: 0>, None), 'RWMesh_NameFormat_Product': (<RWMesh_NameFormat.RWMesh_NameFormat_Product: 1>, None), 'RWMesh_NameFormat_Instance': (<RWMesh_NameFormat.RWMesh_NameFormat_Instance: 2>, None), 'RWMesh_NameFormat_InstanceOrProduct': (<RWMesh_NameFormat.RWMesh_NameFormat_InstanceOrProduct: 3>, None), 'RWMesh_NameFormat_ProductOrInstance': (<RWMesh_NameFormat.RWMesh_NameFormat_ProductOrInstance: 4>, None), 'RWMesh_NameFormat_ProductAndInstance': (<RWMesh_NameFormat.RWMesh_NameFormat_ProductAndInstance: 5>, None), 'RWMesh_NameFormat_ProductAndInstanceAndOcaf': (<RWMesh_NameFormat.RWMesh_NameFormat_ProductAndInstanceAndOcaf: 6>, None)}
    __members__: dict # value = {'RWMesh_NameFormat_Empty': <RWMesh_NameFormat.RWMesh_NameFormat_Empty: 0>, 'RWMesh_NameFormat_Product': <RWMesh_NameFormat.RWMesh_NameFormat_Product: 1>, 'RWMesh_NameFormat_Instance': <RWMesh_NameFormat.RWMesh_NameFormat_Instance: 2>, 'RWMesh_NameFormat_InstanceOrProduct': <RWMesh_NameFormat.RWMesh_NameFormat_InstanceOrProduct: 3>, 'RWMesh_NameFormat_ProductOrInstance': <RWMesh_NameFormat.RWMesh_NameFormat_ProductOrInstance: 4>, 'RWMesh_NameFormat_ProductAndInstance': <RWMesh_NameFormat.RWMesh_NameFormat_ProductAndInstance: 5>, 'RWMesh_NameFormat_ProductAndInstanceAndOcaf': <RWMesh_NameFormat.RWMesh_NameFormat_ProductAndInstanceAndOcaf: 6>}
    pass
class RWMesh_NodeAttributeMap(OCP.NCollection.NCollection_BaseMap):
    """
    Purpose: The DataMap is a Map to store keys with associated Items. See Map from NCollection for a discussion about the number of buckets.
    """
    def Allocator(self) -> OCP.NCollection.NCollection_BaseAllocator: 
        """
        Returns attached allocator
        """
    def Assign(self,theOther : RWMesh_NodeAttributeMap) -> RWMesh_NodeAttributeMap: 
        """
        Assignment. This method does not change the internal allocator.
        """
    def Bind(self,theKey : OCP.TopoDS.TopoDS_Shape,theItem : RWMesh_NodeAttributes) -> bool: 
        """
        Bind binds Item to Key in map.
        """
    def Bound(self,theKey : OCP.TopoDS.TopoDS_Shape,theItem : RWMesh_NodeAttributes) -> RWMesh_NodeAttributes: 
        """
        Bound binds Item to Key in map.
        """
    def ChangeFind(self,theKey : OCP.TopoDS.TopoDS_Shape) -> RWMesh_NodeAttributes: 
        """
        ChangeFind returns mofifiable Item by Key. Raises if Key was not bound
        """
    def ChangeSeek(self,theKey : OCP.TopoDS.TopoDS_Shape) -> RWMesh_NodeAttributes: 
        """
        ChangeSeek returns modifiable pointer to Item by Key. Returns NULL is Key was not bound.
        """
    @overload
    def Clear(self,doReleaseMemory : bool=False) -> None: 
        """
        Clear data. If doReleaseMemory is false then the table of buckets is not released and will be reused.

        Clear data and reset allocator
        """
    @overload
    def Clear(self,theAllocator : OCP.NCollection.NCollection_BaseAllocator) -> None: ...
    def Exchange(self,theOther : RWMesh_NodeAttributeMap) -> None: 
        """
        Exchange the content of two maps without re-allocations. Notice that allocators will be swapped as well!
        """
    def Extent(self) -> int: 
        """
        Extent
        """
    @overload
    def Find(self,theKey : OCP.TopoDS.TopoDS_Shape) -> RWMesh_NodeAttributes: 
        """
        Find returns the Item for Key. Raises if Key was not bound

        Find Item for key with copying.
        """
    @overload
    def Find(self,theKey : OCP.TopoDS.TopoDS_Shape,theValue : RWMesh_NodeAttributes) -> bool: ...
    def IsBound(self,theKey : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        IsBound
        """
    def IsEmpty(self) -> bool: 
        """
        IsEmpty
        """
    def NbBuckets(self) -> int: 
        """
        NbBuckets
        """
    def ReSize(self,N : int) -> None: 
        """
        ReSize
        """
    def Seek(self,theKey : OCP.TopoDS.TopoDS_Shape) -> RWMesh_NodeAttributes: 
        """
        Seek returns pointer to Item by Key. Returns NULL is Key was not bound.
        """
    def Size(self) -> int: 
        """
        Size
        """
    def Statistics(self,S : io.BytesIO) -> None: 
        """
        Statistics
        """
    def UnBind(self,theKey : OCP.TopoDS.TopoDS_Shape) -> bool: 
        """
        UnBind removes Item Key pair from map
        """
    def __call__(self,theKey : OCP.TopoDS.TopoDS_Shape) -> RWMesh_NodeAttributes: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self,theNbBuckets : int,theAllocator : OCP.NCollection.NCollection_BaseAllocator=None) -> None: ...
    @overload
    def __init__(self,theOther : RWMesh_NodeAttributeMap) -> None: ...
    def __iter__(self) -> Iterator[RWMesh_NodeAttributes]: ...
    def __len__(self) -> int: ...
    pass
class RWMesh_NodeAttributes():
    """
    Attributes of the node.
    """
    def __init__(self) -> None: ...
    @property
    def Name(self) -> OCP.TCollection.TCollection_AsciiString:
        """
        :type: OCP.TCollection.TCollection_AsciiString
        """
    @Name.setter
    def Name(self, arg0: OCP.TCollection.TCollection_AsciiString) -> None:
        pass
    @property
    def RawName(self) -> OCP.TCollection.TCollection_AsciiString:
        """
        :type: OCP.TCollection.TCollection_AsciiString
        """
    @RawName.setter
    def RawName(self, arg0: OCP.TCollection.TCollection_AsciiString) -> None:
        pass
    @property
    def Style(self) -> OCP.XCAFPrs.XCAFPrs_Style:
        """
        :type: OCP.XCAFPrs.XCAFPrs_Style
        """
    @Style.setter
    def Style(self, arg0: OCP.XCAFPrs.XCAFPrs_Style) -> None:
        pass
    pass
class RWMesh_EdgeIterator(RWMesh_ShapeIterator):
    """
    Auxiliary class to iterate through edges. Provides functionality to iterate through the edges of a shape. It inherits from `RWMesh_ShapeIterator` and implements methods to access and manipulate edge data.
    """
    def Color(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return shape color.
        """
    def Edge(self) -> OCP.TopoDS.TopoDS_Edge: 
        """
        Return current edge.
        """
    def ElemLower(self) -> int: 
        """
        Lower element index in current triangulation.
        """
    def ElemUpper(self) -> int: 
        """
        Upper element index in current triangulation.
        """
    def ExploredShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Return explored shape.
        """
    def HasColor(self) -> bool: 
        """
        Return TRUE if shape color is set.
        """
    def IsEmpty(self) -> bool: 
        """
        Return true if geometry data is defined.
        """
    def More(self) -> bool: 
        """
        Return true if iterator points to the valid triangulation.
        """
    def NbNodes(self) -> int: 
        """
        Return number of nodes for the current edge.
        """
    def Next(self) -> None: 
        """
        Find next value.
        """
    def NodeLower(self) -> int: 
        """
        Lower node index in current triangulation.
        """
    def NodeTransformed(self,theNode : int) -> OCP.gp.gp_Pnt: 
        """
        Return the node with specified index with applied transformation.
        """
    def NodeUpper(self) -> int: 
        """
        Upper node index in current triangulation.
        """
    def Polygon3D(self) -> OCP.Poly.Poly_Polygon3D: 
        """
        Return current edge data.
        """
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Return current edge.
        """
    def Style(self) -> OCP.XCAFPrs.XCAFPrs_Style: 
        """
        Return shape material.
        """
    @overload
    def __init__(self,theLabel : OCP.TDF.TDF_Label,theLocation : OCP.TopLoc.TopLoc_Location,theToMapColors : bool=False,theStyle : OCP.XCAFPrs.XCAFPrs_Style=OCP.XCAFPrs.XCAFPrs_Style) -> None: ...
    @overload
    def __init__(self,theShape : OCP.TopoDS.TopoDS_Shape,theStyle : OCP.XCAFPrs.XCAFPrs_Style=OCP.XCAFPrs.XCAFPrs_Style) -> None: ...
    def node(self,theNode : int) -> OCP.gp.gp_Pnt: 
        """
        Return the node with specified index with applied transformation.
        """
    pass
class RWMesh_TriangulationReader(OCP.Standard.Standard_Transient):
    """
    Interface for reading primitive array from the buffer.
    """
    def CoordinateSystemConverter(self) -> RWMesh_CoordinateSystemConverter: 
        """
        Returns coordinate system converter using for correct data loading.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def FileName(self) -> OCP.TCollection.TCollection_AsciiString: 
        """
        Returns file name for reporting issues.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsDoublePrecision(self) -> bool: 
        """
        Returns flag to fill in triangulation using double or single precision; FALSE by default.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def Load(self,theSourceMesh : RWMesh_TriangulationSource,theDestMesh : OCP.Poly.Poly_Triangulation,theFileSystem : OCP.OSD.OSD_FileSystem) -> bool: 
        """
        Loads primitive array.
        """
    def PrintStatistic(self) -> None: 
        """
        Prints loading statistic. This method should be used between StartStatistic() and StopStatistic() calls for correct results.
        """
    def SetCoordinateSystemConverter(self,theConverter : RWMesh_CoordinateSystemConverter) -> None: 
        """
        Sets coordinate system converter.
        """
    def SetDoublePrecision(self,theIsDouble : bool) -> None: 
        """
        Sets flag to fill in triangulation using double or single precision.
        """
    def SetFileName(self,theFileName : OCP.TCollection.TCollection_AsciiString) -> None: 
        """
        Sets file name for reporting issues.
        """
    def SetToPrintDebugMessages(self,theToPrint : bool) -> None: 
        """
        Sets flag to print debug information.
        """
    def SetToSkipDegenerates(self,theToSkip : bool) -> None: 
        """
        Sets flag to skip degenerated triangles during mesh loading (only indexes will be checked).
        """
    def StartStatistic(self) -> None: 
        """
        Starts and reset internal object that accumulates nodes/triangles statistic during data reading.
        """
    def StopStatistic(self) -> None: 
        """
        Stops and nullify internal object that accumulates nodes/triangles statistic during data reading.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def ToPrintDebugMessages(self) -> bool: 
        """
        Returns TRUE if additional debug information should be print.
        """
    def ToSkipDegenerates(self) -> bool: 
        """
        Returns TRUE if degenerated triangles should be skipped during mesh loading (only indexes will be checked).
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class RWMesh_TriangulationSource(OCP.Poly.Poly_Triangulation, OCP.Standard.Standard_Transient):
    """
    Mesh data wrapper for delayed triangulation loading. Class inherits Poly_Triangulation so that it can be put temporarily into TopoDS_Face within assembly structure.
    """
    def AddNormals(self) -> None: 
        """
        If an array for normals is not allocated yet, do it now.
        """
    def AddUVNodes(self) -> None: 
        """
        If an array for UV coordinates is not allocated yet, do it now.
        """
    def CachedMinMax(self) -> OCP.Bnd.Bnd_Box: 
        """
        Returns cached min - max range of triangulation data, which is VOID by default (e.g, no cached information).
        """
    def ChangeTriangle(self,theIndex : int) -> OCP.Poly.Poly_Triangle: ...
    def ChangeTriangles(self) -> OCP.Poly.Poly_Array1OfTriangle: ...
    def Clear(self) -> None: 
        """
        Clears internal arrays of nodes and all attributes.
        """
    def ComputeNormals(self) -> None: 
        """
        Compute smooth normals by averaging triangle normals.
        """
    def Copy(self) -> OCP.Poly.Poly_Triangulation: 
        """
        Creates full copy of current triangulation
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    @overload
    def Deflection(self) -> float: 
        """
        Returns the deflection of this triangulation.

        Sets the deflection of this triangulation to theDeflection. See more on deflection in Polygon2D
        """
    @overload
    def Deflection(self,theDeflection : float) -> None: ...
    def DegeneratedTriNb(self) -> int: 
        """
        Returns number of degenerated triangles collected during data reading. Used for debug statistic purpose.
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def DetachedLoadDeferredData(self,theFileSystem : OCP.OSD.OSD_FileSystem=None) -> OCP.Poly.Poly_Triangulation: 
        """
        Loads triangulation data into new Poly_Triangulation object from some deferred storage using specified shared input file system.
        """
    def DumpJson(self,theOStream : io.BytesIO,theDepth : int=-1) -> None: 
        """
        Dumps the content of me into the stream
        """
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def Edge(self,theIndex : int) -> int: 
        """
        Returns edge at the given index.
        """
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def HasCachedMinMax(self) -> bool: 
        """
        Returns TRUE if there is some cached min - max range of this triangulation.
        """
    def HasDeferredData(self) -> bool: 
        """
        Returns TRUE if there is some triangulation data that can be loaded using LoadDeferredData().
        """
    def HasGeometry(self) -> bool: 
        """
        Returns TRUE if triangulation has some geometry.
        """
    def HasNormals(self) -> bool: 
        """
        Returns Standard_True if nodal normals are defined.
        """
    def HasUVNodes(self) -> bool: 
        """
        Returns Standard_True if 2D nodes are associated with 3D nodes for this triangulation.
        """
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def InternalEdges(self) -> OCP.TColStd.TColStd_Array1OfInteger: 
        """
        Returns an internal array of edges. Edge()/SetEdge() should be used instead in portable code.
        """
    def InternalNodes(self) -> OCP.Poly.Poly_ArrayOfNodes: 
        """
        Returns an internal array of nodes. Node()/SetNode() should be used instead in portable code.
        """
    def InternalNormals(self) -> Any: 
        """
        Return an internal array of normals. Normal()/SetNormal() should be used instead in portable code.
        """
    def InternalTriangles(self) -> OCP.Poly.Poly_Array1OfTriangle: 
        """
        Returns an internal array of triangles. Triangle()/SetTriangle() should be used instead in portable code.
        """
    def InternalUVNodes(self) -> OCP.Poly.Poly_ArrayOfUVNodes: 
        """
        Returns an internal array of UV nodes. UBNode()/SetUVNode() should be used instead in portable code.
        """
    def IsDoublePrecision(self) -> bool: 
        """
        Returns TRUE if node positions are defined with double precision; TRUE by default.
        """
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    def LoadDeferredData(self,theFileSystem : OCP.OSD.OSD_FileSystem=None) -> bool: 
        """
        Loads triangulation data into itself from some deferred storage using specified shared input file system.
        """
    def MapNodeArray(self) -> OCP.TColgp.TColgp_HArray1OfPnt: 
        """
        Returns the table of 3D points for read-only access or NULL if nodes array is undefined. Poly_Triangulation::Node() should be used instead when possible. Returned object should not be used after Poly_Triangulation destruction.
        """
    def MapNormalArray(self) -> OCP.TShort.TShort_HArray1OfShortReal: 
        """
        Returns the table of per-vertex normals for read-only access or NULL if normals array is undefined. Poly_Triangulation::Normal() should be used instead when possible. Returned object should not be used after Poly_Triangulation destruction.
        """
    def MapTriangleArray(self) -> OCP.Poly.Poly_HArray1OfTriangle: 
        """
        Returns the triangle array for read-only access or NULL if triangle array is undefined. Poly_Triangulation::Triangle() should be used instead when possible. Returned object should not be used after Poly_Triangulation destruction.
        """
    def MapUVNodeArray(self) -> OCP.TColgp.TColgp_HArray1OfPnt2d: 
        """
        Returns the table of 2D nodes for read-only access or NULL if UV nodes array is undefined. Poly_Triangulation::UVNode() should be used instead when possible. Returned object should not be used after Poly_Triangulation destruction.
        """
    def MeshPurpose(self) -> int: 
        """
        Returns mesh purpose bits.
        """
    def MinMax(self,theBox : OCP.Bnd.Bnd_Box,theTrsf : OCP.gp.gp_Trsf,theIsAccurate : bool=False) -> bool: 
        """
        Extends the passed box with bounding box of this triangulation. Uses cached min - max range when available and: - input transformation theTrsf has no rotation part; - theIsAccurate is set to FALSE; - no triangulation data available (e.g. it is deferred and not loaded).
        """
    def NbDeferredNodes(self) -> int: 
        """
        Returns number of nodes for deferred loading. Note: this is estimated values defined in object header, which might be different from actually loaded values (due to broken header or extra mesh processing). Always check triangulation size of actually loaded data in code to avoid out-of-range issues.
        """
    def NbDeferredTriangles(self) -> int: 
        """
        Returns number of triangles for deferred loading. Note: this is estimated values defined in object header, which might be different from actually loaded values (due to broken header or extra mesh processing). Always check triangulation size of actually loaded data in code to avoid out-of-range issues.
        """
    def NbEdges(self) -> int: 
        """
        Returns the number of edges for this triangulation.
        """
    def NbNodes(self) -> int: 
        """
        Returns the number of nodes for this triangulation.
        """
    def NbTriangles(self) -> int: 
        """
        Returns the number of triangles for this triangulation.
        """
    def Node(self,theIndex : int) -> OCP.gp.gp_Pnt: 
        """
        Returns a node at the given index.
        """
    @overload
    def Normal(self,theIndex : int) -> OCP.gp.gp_Dir: 
        """
        Returns normal at the given index.

        Returns normal at the given index.
        """
    @overload
    def Normal(self,theIndex : int,theVec3 : OCP.gp.gp_Vec3f) -> None: ...
    @overload
    def Parameters(self,theParams : OCP.Poly.Poly_TriangulationParameters) -> None: 
        """
        Updates initial set of parameters used to generate this triangulation.

        Returns initial set of parameters used to generate this triangulation.
        """
    @overload
    def Parameters(self) -> OCP.Poly.Poly_TriangulationParameters: ...
    def Reader(self) -> RWMesh_TriangulationReader: 
        """
        Returns reader allowing to read data from the buffer.
        """
    def RemoveNormals(self) -> None: 
        """
        Deallocates the normals array.
        """
    def RemoveUVNodes(self) -> None: 
        """
        Deallocates the UV nodes array.
        """
    def ResizeEdges(self,theNbEdges : int,theToCopyOld : bool) -> None: 
        """
        Method resizing an internal array of triangles.
        """
    def ResizeNodes(self,theNbNodes : int,theToCopyOld : bool) -> None: 
        """
        Method resizing internal arrays of nodes (synchronously for all attributes).
        """
    def ResizeTriangles(self,theNbTriangles : int,theToCopyOld : bool) -> None: 
        """
        Method resizing an internal array of triangles.
        """
    def SetCachedMinMax(self,theBox : OCP.Bnd.Bnd_Box) -> None: 
        """
        Sets a cached min - max range of this triangulation. The bounding box should exactly match actual range of triangulation data without a gap or transformation, or otherwise undefined behavior will be observed. Passing a VOID range invalidates the cache.
        """
    def SetDoublePrecision(self,theIsDouble : bool) -> None: 
        """
        Set if node positions should be defined with double or single precision for 3D and UV nodes. Raises exception if data was already allocated.
        """
    def SetEdge(self,theIndex : int,theEdge : int) -> None: 
        """
        Sets an edge.
        """
    def SetMeshPurpose(self,thePurpose : int) -> None: 
        """
        Sets mesh purpose bits.
        """
    def SetNbDeferredNodes(self,theNbNodes : int) -> None: 
        """
        Sets number of nodes for deferred loading.
        """
    def SetNbDeferredTriangles(self,theNbTris : int) -> None: 
        """
        Sets number of triangles for deferred loading.
        """
    def SetNode(self,theIndex : int,thePnt : OCP.gp.gp_Pnt) -> None: 
        """
        Sets a node coordinates.
        """
    @overload
    def SetNormal(self,theIndex : int,theNormal : OCP.gp.gp_Vec3f) -> None: 
        """
        Changes normal at the given index.

        Changes normal at the given index.
        """
    @overload
    def SetNormal(self,theIndex : int,theNormal : OCP.gp.gp_Dir) -> None: ...
    def SetNormals(self,theNormals : OCP.TShort.TShort_HArray1OfShortReal) -> None: ...
    def SetReader(self,theReader : RWMesh_TriangulationReader) -> None: 
        """
        Sets reader allowing to read data from the buffer.
        """
    def SetTriangle(self,theIndex : int,theTriangle : OCP.Poly.Poly_Triangle) -> None: 
        """
        Sets a triangle.
        """
    def SetUVNode(self,theIndex : int,thePnt : OCP.gp.gp_Pnt2d) -> None: 
        """
        Sets an UV-node coordinates.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def Triangle(self,theIndex : int) -> OCP.Poly.Poly_Triangle: 
        """
        Returns triangle at the given index.
        """
    def Triangles(self) -> OCP.Poly.Poly_Array1OfTriangle: ...
    def UVNode(self,theIndex : int) -> OCP.gp.gp_Pnt2d: 
        """
        Returns UV-node at the given index.
        """
    def UnloadDeferredData(self) -> bool: 
        """
        Releases triangulation data if it has connected deferred storage.
        """
    def UpdateCachedMinMax(self) -> None: 
        """
        Updates cached min - max range of this triangulation with bounding box of nodal data.
        """
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    @property
    def ChangeDegeneratedTriNb(self) -> int:
        """
        Gets access to number of degenerated triangles to collect them during data reading.

        :type: int
        """
    @ChangeDegeneratedTriNb.setter
    def ChangeDegeneratedTriNb(self, arg1: int) -> None:
        """
        Gets access to number of degenerated triangles to collect them during data reading.
        """
    pass
class RWMesh_VertexIterator(RWMesh_ShapeIterator):
    """
    Auxiliary class to iterate through vertices. Provides functionality to iterate through the vertices of a shape. It inherits from `RWMesh_ShapeIterator` and implements methods to access and manipulate vertex data.
    """
    def Color(self) -> OCP.Quantity.Quantity_ColorRGBA: 
        """
        Return shape color.
        """
    def ElemLower(self) -> int: 
        """
        Lower element index in current triangulation.
        """
    def ElemUpper(self) -> int: 
        """
        Upper element index in current triangulation.
        """
    def ExploredShape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Return explored shape.
        """
    def HasColor(self) -> bool: 
        """
        Return TRUE if shape color is set.
        """
    def IsEmpty(self) -> bool: 
        """
        Return true if geometry data is defined.
        """
    def More(self) -> bool: 
        """
        Return true if iterator points to the valid triangulation.
        """
    def NbNodes(self) -> int: 
        """
        Return number of nodes for the current edge.
        """
    def Next(self) -> None: 
        """
        Find next value.
        """
    def NodeLower(self) -> int: 
        """
        Lower node index in current triangulation.
        """
    def NodeTransformed(self,theNode : int) -> OCP.gp.gp_Pnt: 
        """
        Return the node with specified index with applied transformation.
        """
    def NodeUpper(self) -> int: 
        """
        Upper node index in current triangulation.
        """
    def Point(self) -> OCP.gp.gp_Pnt: 
        """
        Return current vertex data.
        """
    def Shape(self) -> OCP.TopoDS.TopoDS_Shape: 
        """
        Return current vertex.
        """
    def Style(self) -> OCP.XCAFPrs.XCAFPrs_Style: 
        """
        Return shape material.
        """
    def Vertex(self) -> OCP.TopoDS.TopoDS_Vertex: 
        """
        Return current edge.
        """
    @overload
    def __init__(self,theLabel : OCP.TDF.TDF_Label,theLocation : OCP.TopLoc.TopLoc_Location,theToMapColors : bool=False,theStyle : OCP.XCAFPrs.XCAFPrs_Style=OCP.XCAFPrs.XCAFPrs_Style) -> None: ...
    @overload
    def __init__(self,theShape : OCP.TopoDS.TopoDS_Shape,theStyle : OCP.XCAFPrs.XCAFPrs_Style=OCP.XCAFPrs.XCAFPrs_Style) -> None: ...
    def node(self,arg0 : int) -> OCP.gp.gp_Pnt: 
        """
        Return the node with specified index with applied transformation.
        """
    pass
RWMesh_CafReaderStatusEx_NONE: OCP.RWMesh.RWMesh_CafReaderStatusEx # value = <RWMesh_CafReaderStatusEx.RWMesh_CafReaderStatusEx_NONE: 0>
RWMesh_CafReaderStatusEx_Partial: OCP.RWMesh.RWMesh_CafReaderStatusEx # value = <RWMesh_CafReaderStatusEx.RWMesh_CafReaderStatusEx_Partial: 1>
RWMesh_CoordinateSystem_Blender: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_posYfwd_posZup: 0>
RWMesh_CoordinateSystem_Undefined: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_Undefined: -1>
RWMesh_CoordinateSystem_Yup: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_negZfwd_posYup: 1>
RWMesh_CoordinateSystem_Zup: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_posYfwd_posZup: 0>
RWMesh_CoordinateSystem_glTF: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_negZfwd_posYup: 1>
RWMesh_CoordinateSystem_negZfwd_posYup: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_negZfwd_posYup: 1>
RWMesh_CoordinateSystem_posYfwd_posZup: OCP.RWMesh.RWMesh_CoordinateSystem # value = <RWMesh_CoordinateSystem.RWMesh_CoordinateSystem_posYfwd_posZup: 0>
RWMesh_NameFormat_Empty: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_Empty: 0>
RWMesh_NameFormat_Instance: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_Instance: 2>
RWMesh_NameFormat_InstanceOrProduct: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_InstanceOrProduct: 3>
RWMesh_NameFormat_Product: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_Product: 1>
RWMesh_NameFormat_ProductAndInstance: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_ProductAndInstance: 5>
RWMesh_NameFormat_ProductAndInstanceAndOcaf: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_ProductAndInstanceAndOcaf: 6>
RWMesh_NameFormat_ProductOrInstance: OCP.RWMesh.RWMesh_NameFormat # value = <RWMesh_NameFormat.RWMesh_NameFormat_ProductOrInstance: 4>
