
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_Report.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_Attribute.hxx>
#include <Message_Report.hxx>
#include <Message_CompositeAlerts.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_Messenger.hxx>
#include <TColStd_HPackedMapOfInteger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_AlertExtended.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TCollection_AsciiString.hxx>
#include <TCollection_ExtendedString.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TCollection_ExtendedString.hxx>
#include <TCollection_AsciiString.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_Report.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_CompositeAlerts.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <Message.hxx>
#include <Message_Alert.hxx>
#include <Message_AlertExtended.hxx>
#include <Message_Algorithm.hxx>
#include <Message_Attribute.hxx>
#include <Message_AttributeMeter.hxx>
#include <Message_AttributeObject.hxx>
#include <Message_AttributeStream.hxx>
#include <Message_CompositeAlerts.hxx>
#include <Message_ConsoleColor.hxx>
#include <Message_ExecStatus.hxx>
#include <Message_Gravity.hxx>
#include <Message_HArrayOfMsg.hxx>
#include <Message_LazyProgressScope.hxx>
#include <Message_Level.hxx>
#include <Message_ListIteratorOfListOfMsg.hxx>
#include <Message_ListOfAlert.hxx>
#include <Message_ListOfMsg.hxx>
#include <Message_Messenger.hxx>
#include <Message_MetricType.hxx>
#include <Message_Msg.hxx>
#include <Message_MsgFile.hxx>
#include <Message_Printer.hxx>
#include <Message_PrinterOStream.hxx>
#include <Message_PrinterSystemLog.hxx>
#include <Message_PrinterToReport.hxx>
#include <Message_ProgressIndicator.hxx>
#include <Message_ProgressRange.hxx>
#include <Message_ProgressScope.hxx>
#include <Message_ProgressSentry.hxx>
#include <Message_Report.hxx>
#include <Message_SequenceOfPrinters.hxx>
#include <Message_Status.hxx>
#include <Message_StatusType.hxx>

// template related includes

#include "NCollection_tmpl.hxx"

#include "NCollection_tmpl.hxx"

#include "NCollection_tmpl.hxx"

#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_Message_enums(py::module &main_module) {


py::module m = main_module.def_submodule("Message", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums
    py::enum_<Message_StatusType>(m, "Message_StatusType",R"#(Definition of types of execution status supported by the class Message_ExecStatus)#")
        .value("Message_DONE",Message_StatusType::Message_DONE)
        .value("Message_WARN",Message_StatusType::Message_WARN)
        .value("Message_ALARM",Message_StatusType::Message_ALARM)
        .value("Message_FAIL",Message_StatusType::Message_FAIL).export_values();
    py::enum_<Message_MetricType>(m, "Message_MetricType",R"#(Specifies kind of report information to collect)#")
        .value("Message_MetricType_None",Message_MetricType::Message_MetricType_None)
        .value("Message_MetricType_ThreadCPUUserTime",Message_MetricType::Message_MetricType_ThreadCPUUserTime)
        .value("Message_MetricType_ThreadCPUSystemTime",Message_MetricType::Message_MetricType_ThreadCPUSystemTime)
        .value("Message_MetricType_ProcessCPUUserTime",Message_MetricType::Message_MetricType_ProcessCPUUserTime)
        .value("Message_MetricType_ProcessCPUSystemTime",Message_MetricType::Message_MetricType_ProcessCPUSystemTime)
        .value("Message_MetricType_WallClock",Message_MetricType::Message_MetricType_WallClock)
        .value("Message_MetricType_MemPrivate",Message_MetricType::Message_MetricType_MemPrivate)
        .value("Message_MetricType_MemVirtual",Message_MetricType::Message_MetricType_MemVirtual)
        .value("Message_MetricType_MemWorkingSet",Message_MetricType::Message_MetricType_MemWorkingSet)
        .value("Message_MetricType_MemWorkingSetPeak",Message_MetricType::Message_MetricType_MemWorkingSetPeak)
        .value("Message_MetricType_MemSwapUsage",Message_MetricType::Message_MetricType_MemSwapUsage)
        .value("Message_MetricType_MemSwapUsagePeak",Message_MetricType::Message_MetricType_MemSwapUsagePeak)
        .value("Message_MetricType_MemHeapUsage",Message_MetricType::Message_MetricType_MemHeapUsage).export_values();
    py::enum_<Message_Gravity>(m, "Message_Gravity",R"#(Defines gravity level of messages - Trace: low-level details on algorithm execution (usually for debug purposes) - Info: informative message - Warning: warning message - Alarm: non-critical error - Fail: fatal error)#")
        .value("Message_Trace",Message_Gravity::Message_Trace)
        .value("Message_Info",Message_Gravity::Message_Info)
        .value("Message_Warning",Message_Gravity::Message_Warning)
        .value("Message_Alarm",Message_Gravity::Message_Alarm)
        .value("Message_Fail",Message_Gravity::Message_Fail).export_values();
    py::enum_<Message_ConsoleColor>(m, "Message_ConsoleColor",R"#(Color definition for console/terminal output (limited palette).)#")
        .value("Message_ConsoleColor_Default",Message_ConsoleColor::Message_ConsoleColor_Default)
        .value("Message_ConsoleColor_Black",Message_ConsoleColor::Message_ConsoleColor_Black)
        .value("Message_ConsoleColor_White",Message_ConsoleColor::Message_ConsoleColor_White)
        .value("Message_ConsoleColor_Red",Message_ConsoleColor::Message_ConsoleColor_Red)
        .value("Message_ConsoleColor_Blue",Message_ConsoleColor::Message_ConsoleColor_Blue)
        .value("Message_ConsoleColor_Green",Message_ConsoleColor::Message_ConsoleColor_Green)
        .value("Message_ConsoleColor_Yellow",Message_ConsoleColor::Message_ConsoleColor_Yellow)
        .value("Message_ConsoleColor_Cyan",Message_ConsoleColor::Message_ConsoleColor_Cyan)
        .value("Message_ConsoleColor_Magenta",Message_ConsoleColor::Message_ConsoleColor_Magenta).export_values();
    py::enum_<Message_Status>(m, "Message_Status",R"#(Enumeration covering all execution statuses supported by the class Message_ExecStatus: 32 statuses per each of 4 types (DONE, WARN, ALARM, FAIL))#")
        .value("Message_None",Message_Status::Message_None)
        .value("Message_Done1",Message_Status::Message_Done1)
        .value("Message_Done2",Message_Status::Message_Done2)
        .value("Message_Done3",Message_Status::Message_Done3)
        .value("Message_Done4",Message_Status::Message_Done4)
        .value("Message_Done5",Message_Status::Message_Done5)
        .value("Message_Done6",Message_Status::Message_Done6)
        .value("Message_Done7",Message_Status::Message_Done7)
        .value("Message_Done8",Message_Status::Message_Done8)
        .value("Message_Done9",Message_Status::Message_Done9)
        .value("Message_Done10",Message_Status::Message_Done10)
        .value("Message_Done11",Message_Status::Message_Done11)
        .value("Message_Done12",Message_Status::Message_Done12)
        .value("Message_Done13",Message_Status::Message_Done13)
        .value("Message_Done14",Message_Status::Message_Done14)
        .value("Message_Done15",Message_Status::Message_Done15)
        .value("Message_Done16",Message_Status::Message_Done16)
        .value("Message_Done17",Message_Status::Message_Done17)
        .value("Message_Done18",Message_Status::Message_Done18)
        .value("Message_Done19",Message_Status::Message_Done19)
        .value("Message_Done20",Message_Status::Message_Done20)
        .value("Message_Done21",Message_Status::Message_Done21)
        .value("Message_Done22",Message_Status::Message_Done22)
        .value("Message_Done23",Message_Status::Message_Done23)
        .value("Message_Done24",Message_Status::Message_Done24)
        .value("Message_Done25",Message_Status::Message_Done25)
        .value("Message_Done26",Message_Status::Message_Done26)
        .value("Message_Done27",Message_Status::Message_Done27)
        .value("Message_Done28",Message_Status::Message_Done28)
        .value("Message_Done29",Message_Status::Message_Done29)
        .value("Message_Done30",Message_Status::Message_Done30)
        .value("Message_Done31",Message_Status::Message_Done31)
        .value("Message_Done32",Message_Status::Message_Done32)
        .value("Message_Warn1",Message_Status::Message_Warn1)
        .value("Message_Warn2",Message_Status::Message_Warn2)
        .value("Message_Warn3",Message_Status::Message_Warn3)
        .value("Message_Warn4",Message_Status::Message_Warn4)
        .value("Message_Warn5",Message_Status::Message_Warn5)
        .value("Message_Warn6",Message_Status::Message_Warn6)
        .value("Message_Warn7",Message_Status::Message_Warn7)
        .value("Message_Warn8",Message_Status::Message_Warn8)
        .value("Message_Warn9",Message_Status::Message_Warn9)
        .value("Message_Warn10",Message_Status::Message_Warn10)
        .value("Message_Warn11",Message_Status::Message_Warn11)
        .value("Message_Warn12",Message_Status::Message_Warn12)
        .value("Message_Warn13",Message_Status::Message_Warn13)
        .value("Message_Warn14",Message_Status::Message_Warn14)
        .value("Message_Warn15",Message_Status::Message_Warn15)
        .value("Message_Warn16",Message_Status::Message_Warn16)
        .value("Message_Warn17",Message_Status::Message_Warn17)
        .value("Message_Warn18",Message_Status::Message_Warn18)
        .value("Message_Warn19",Message_Status::Message_Warn19)
        .value("Message_Warn20",Message_Status::Message_Warn20)
        .value("Message_Warn21",Message_Status::Message_Warn21)
        .value("Message_Warn22",Message_Status::Message_Warn22)
        .value("Message_Warn23",Message_Status::Message_Warn23)
        .value("Message_Warn24",Message_Status::Message_Warn24)
        .value("Message_Warn25",Message_Status::Message_Warn25)
        .value("Message_Warn26",Message_Status::Message_Warn26)
        .value("Message_Warn27",Message_Status::Message_Warn27)
        .value("Message_Warn28",Message_Status::Message_Warn28)
        .value("Message_Warn29",Message_Status::Message_Warn29)
        .value("Message_Warn30",Message_Status::Message_Warn30)
        .value("Message_Warn31",Message_Status::Message_Warn31)
        .value("Message_Warn32",Message_Status::Message_Warn32)
        .value("Message_Alarm1",Message_Status::Message_Alarm1)
        .value("Message_Alarm2",Message_Status::Message_Alarm2)
        .value("Message_Alarm3",Message_Status::Message_Alarm3)
        .value("Message_Alarm4",Message_Status::Message_Alarm4)
        .value("Message_Alarm5",Message_Status::Message_Alarm5)
        .value("Message_Alarm6",Message_Status::Message_Alarm6)
        .value("Message_Alarm7",Message_Status::Message_Alarm7)
        .value("Message_Alarm8",Message_Status::Message_Alarm8)
        .value("Message_Alarm9",Message_Status::Message_Alarm9)
        .value("Message_Alarm10",Message_Status::Message_Alarm10)
        .value("Message_Alarm11",Message_Status::Message_Alarm11)
        .value("Message_Alarm12",Message_Status::Message_Alarm12)
        .value("Message_Alarm13",Message_Status::Message_Alarm13)
        .value("Message_Alarm14",Message_Status::Message_Alarm14)
        .value("Message_Alarm15",Message_Status::Message_Alarm15)
        .value("Message_Alarm16",Message_Status::Message_Alarm16)
        .value("Message_Alarm17",Message_Status::Message_Alarm17)
        .value("Message_Alarm18",Message_Status::Message_Alarm18)
        .value("Message_Alarm19",Message_Status::Message_Alarm19)
        .value("Message_Alarm20",Message_Status::Message_Alarm20)
        .value("Message_Alarm21",Message_Status::Message_Alarm21)
        .value("Message_Alarm22",Message_Status::Message_Alarm22)
        .value("Message_Alarm23",Message_Status::Message_Alarm23)
        .value("Message_Alarm24",Message_Status::Message_Alarm24)
        .value("Message_Alarm25",Message_Status::Message_Alarm25)
        .value("Message_Alarm26",Message_Status::Message_Alarm26)
        .value("Message_Alarm27",Message_Status::Message_Alarm27)
        .value("Message_Alarm28",Message_Status::Message_Alarm28)
        .value("Message_Alarm29",Message_Status::Message_Alarm29)
        .value("Message_Alarm30",Message_Status::Message_Alarm30)
        .value("Message_Alarm31",Message_Status::Message_Alarm31)
        .value("Message_Alarm32",Message_Status::Message_Alarm32)
        .value("Message_Fail1",Message_Status::Message_Fail1)
        .value("Message_Fail2",Message_Status::Message_Fail2)
        .value("Message_Fail3",Message_Status::Message_Fail3)
        .value("Message_Fail4",Message_Status::Message_Fail4)
        .value("Message_Fail5",Message_Status::Message_Fail5)
        .value("Message_Fail6",Message_Status::Message_Fail6)
        .value("Message_Fail7",Message_Status::Message_Fail7)
        .value("Message_Fail8",Message_Status::Message_Fail8)
        .value("Message_Fail9",Message_Status::Message_Fail9)
        .value("Message_Fail10",Message_Status::Message_Fail10)
        .value("Message_Fail11",Message_Status::Message_Fail11)
        .value("Message_Fail12",Message_Status::Message_Fail12)
        .value("Message_Fail13",Message_Status::Message_Fail13)
        .value("Message_Fail14",Message_Status::Message_Fail14)
        .value("Message_Fail15",Message_Status::Message_Fail15)
        .value("Message_Fail16",Message_Status::Message_Fail16)
        .value("Message_Fail17",Message_Status::Message_Fail17)
        .value("Message_Fail18",Message_Status::Message_Fail18)
        .value("Message_Fail19",Message_Status::Message_Fail19)
        .value("Message_Fail20",Message_Status::Message_Fail20)
        .value("Message_Fail21",Message_Status::Message_Fail21)
        .value("Message_Fail22",Message_Status::Message_Fail22)
        .value("Message_Fail23",Message_Status::Message_Fail23)
        .value("Message_Fail24",Message_Status::Message_Fail24)
        .value("Message_Fail25",Message_Status::Message_Fail25)
        .value("Message_Fail26",Message_Status::Message_Fail26)
        .value("Message_Fail27",Message_Status::Message_Fail27)
        .value("Message_Fail28",Message_Status::Message_Fail28)
        .value("Message_Fail29",Message_Status::Message_Fail29)
        .value("Message_Fail30",Message_Status::Message_Fail30)
        .value("Message_Fail31",Message_Status::Message_Fail31)
        .value("Message_Fail32",Message_Status::Message_Fail32).export_values();

//Python trampoline classes
    class Py_Message_Printer : public Message_Printer{
    public:
        using Message_Printer::Message_Printer;


        // public pure virtual


        // protected pure virtual
        void send( const TCollection_AsciiString & theString, const Message_Gravity theGravity) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Message_Printer,send,theString,theGravity) };


        // private pure virtual

    };
    class Py_Message_ProgressIndicator : public Message_ProgressIndicator{
    public:
        using Message_ProgressIndicator::Message_ProgressIndicator;


        // public pure virtual


        // protected pure virtual
        void Show( const Message_ProgressScope & theScope, const Standard_Boolean isForce) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,Message_ProgressIndicator,Show,theScope,isForce) };


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<Message , shared_ptr<Message>  >(m,"Message",R"#(Defines - tools to work with messages - basic tools intended for progress indication)#");
    py::class_<Message_ExecStatus , shared_ptr<Message_ExecStatus>  >(m,"Message_ExecStatus",R"#(Tiny class for extended handling of error / execution status of algorithm in universal way.)#");
    py::class_<Message_Level , shared_ptr<Message_Level>  >(m,"Message_Level",R"#(This class is an instance of Sentry to create a level in a message report Constructor of the class add new (active) level in the report, destructor removes it While the level is active in the report, new alerts are added below the level root alert.)#");
    py::class_<Message_Msg , shared_ptr<Message_Msg>  >(m,"Message_Msg",R"#(This class provides a tool for constructing the parametrized message basing on resources loaded by Message_MsgFile tool.)#");
    py::class_<Message_MsgFile , shared_ptr<Message_MsgFile>  >(m,"Message_MsgFile",R"#(A tool providing facility to load definitions of message strings from resource file(s).)#");
    py::class_<Message_ProgressRange , shared_ptr<Message_ProgressRange>  >(m,"Message_ProgressRange",R"#(Auxiliary class representing a part of the global progress scale allocated by a step of the progress scope, see Message_ProgressScope::Next().)#");
    py::class_<Message_ProgressScope , shared_ptr<Message_ProgressScope>  >(m,"Message_ProgressScope",R"#(Message_ProgressScope class provides convenient way to advance progress indicator in context of complex program organized in hierarchical way, where usually it is difficult (or even not possible) to consider process as linear with fixed step.)#");
    py::class_<Message_Alert ,opencascade::handle<Message_Alert>  , Standard_Transient >(m,"Message_Alert",R"#(Base class of the hierarchy of classes describing various situations occurring during execution of some algorithm or procedure.Base class of the hierarchy of classes describing various situations occurring during execution of some algorithm or procedure.)#");
    py::class_<Message_Algorithm ,opencascade::handle<Message_Algorithm>  , Standard_Transient >(m,"Message_Algorithm",R"#(Class Message_Algorithm is intended to be the base class for classes implementing algorithms or any operations that need to provide extended information on its execution to the caller / user.Class Message_Algorithm is intended to be the base class for classes implementing algorithms or any operations that need to provide extended information on its execution to the caller / user.Class Message_Algorithm is intended to be the base class for classes implementing algorithms or any operations that need to provide extended information on its execution to the caller / user.)#");
    preregister_template_NCollection_Array1<NCollection_Handle<Message_Msg>>(m,"Message_ArrayOfMsg");
    py::class_<Message_Attribute ,opencascade::handle<Message_Attribute>  , Standard_Transient >(m,"Message_Attribute",R"#(Additional information of extended alert attribute To provide other custom attribute container, it might be redefined.Additional information of extended alert attribute To provide other custom attribute container, it might be redefined.)#");
    py::class_<Message_CompositeAlerts ,opencascade::handle<Message_CompositeAlerts>  , Standard_Transient >(m,"Message_CompositeAlerts",R"#(Class providing container of alertsClass providing container of alerts)#");
    preregister_template_NCollection_List<opencascade::handle<Message_Alert>>(m,"Message_ListOfAlert");
    preregister_template_NCollection_List<Message_Msg>(m,"Message_ListOfMsg");
    py::class_<Message_Messenger ,opencascade::handle<Message_Messenger>  , Standard_Transient >(m,"Message_Messenger",R"#(Messenger is API class providing general-purpose interface for libraries that may issue text messages without knowledge of how these messages will be further processed.Messenger is API class providing general-purpose interface for libraries that may issue text messages without knowledge of how these messages will be further processed.Messenger is API class providing general-purpose interface for libraries that may issue text messages without knowledge of how these messages will be further processed.)#");
    py::class_<Message_Printer ,opencascade::handle<Message_Printer> ,Py_Message_Printer , Standard_Transient >(m,"Message_Printer",R"#(Abstract interface class defining printer as output context for text messagesAbstract interface class defining printer as output context for text messagesAbstract interface class defining printer as output context for text messages)#");
    py::class_<Message_ProgressIndicator ,opencascade::handle<Message_ProgressIndicator> ,Py_Message_ProgressIndicator , Standard_Transient >(m,"Message_ProgressIndicator",R"#(Defines abstract interface from program to the user. This includes progress indication and user break mechanisms.Defines abstract interface from program to the user. This includes progress indication and user break mechanisms.)#");
    py::class_<Message_ProgressSentry , shared_ptr<Message_ProgressSentry>  , Message_ProgressScope >(m,"Message_ProgressSentry",R"#(Functionality of this class (Message_ProgressSentry) has been superseded by Message_ProgressScope. This class is kept just to simplify transition of an old code and will be removed in future.)#");
    py::class_<Message_Report ,opencascade::handle<Message_Report>  , Standard_Transient >(m,"Message_Report",R"#(Container for alert messages, sorted according to their gravity.Container for alert messages, sorted according to their gravity.Container for alert messages, sorted according to their gravity.)#");
    preregister_template_NCollection_Sequence<opencascade::handle<Message_Printer>>(m,"Message_SequenceOfPrinters");
    py::class_<Message_AlertExtended ,opencascade::handle<Message_AlertExtended>  , Message_Alert >(m,"Message_AlertExtended",R"#(Inherited class of Message_Alert with some additional information. It has Message_Attributes to provide the alert name, and other custom information It has a container of composite alerts, if the alert might provide sub-alerts collecting.Inherited class of Message_Alert with some additional information. It has Message_Attributes to provide the alert name, and other custom information It has a container of composite alerts, if the alert might provide sub-alerts collecting.)#");
    py::class_<Message_AttributeMeter ,opencascade::handle<Message_AttributeMeter>  , Message_Attribute >(m,"Message_AttributeMeter",R"#(Alert object storing alert metrics values. Start and stop values for each metric.)#");
    py::class_<Message_AttributeObject ,opencascade::handle<Message_AttributeObject>  , Message_Attribute >(m,"Message_AttributeObject",R"#(Alert object storing a transient object)#");
    py::class_<Message_AttributeStream ,opencascade::handle<Message_AttributeStream>  , Message_Attribute >(m,"Message_AttributeStream",R"#(Alert object storing stream value)#");
    py::class_<Message_PrinterOStream ,opencascade::handle<Message_PrinterOStream>  , Message_Printer >(m,"Message_PrinterOStream",R"#(Implementation of a message printer associated with an std::ostream The std::ostream may be either externally defined one (e.g. std::cout), or file stream maintained internally (depending on constructor).Implementation of a message printer associated with an std::ostream The std::ostream may be either externally defined one (e.g. std::cout), or file stream maintained internally (depending on constructor).Implementation of a message printer associated with an std::ostream The std::ostream may be either externally defined one (e.g. std::cout), or file stream maintained internally (depending on constructor).)#");
    py::class_<Message_PrinterSystemLog ,opencascade::handle<Message_PrinterSystemLog>  , Message_Printer >(m,"Message_PrinterSystemLog",R"#(Implementation of a message printer associated with system log. Implemented for the following systems: - Windows, through ReportEventW(). - Android, through __android_log_write(). - UNIX/Linux, through syslog().Implementation of a message printer associated with system log. Implemented for the following systems: - Windows, through ReportEventW(). - Android, through __android_log_write(). - UNIX/Linux, through syslog().)#");
    py::class_<Message_PrinterToReport ,opencascade::handle<Message_PrinterToReport>  , Message_Printer >(m,"Message_PrinterToReport",R"#(Implementation of a message printer associated with Message_Report Send will create a new alert of the report. If string is sent, an alert is created by Eol only. The alerts are sent into set report or default report of Message.Implementation of a message printer associated with Message_Report Send will create a new alert of the report. If string is sent, an alert is created by Eol only. The alerts are sent into set report or default report of Message.)#");

};

// user-defined post-inclusion per module

// user-defined post
