
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TopoDS_Wire.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IMeshData_Shape.hxx>
#include <IMeshData_Face.hxx>
#include <IMeshData_Wire.hxx>
#include <IMeshData_Edge.hxx>
#include <IMeshData_Curve.hxx>
#include <IMeshData_PCurve.hxx>
#include <IMeshData_Model.hxx>
#include <BRepMesh_VertexInspector.hxx>
#include <BRepMesh_CircleInspector.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <IMeshData_Curve.hxx>
#include <IMeshData_Edge.hxx>
#include <IMeshData_Face.hxx>
#include <IMeshData_Model.hxx>
#include <IMeshData_ParametersList.hxx>
#include <IMeshData_ParametersListArrayAdaptor.hxx>
#include <IMeshData_PCurve.hxx>
#include <IMeshData_Shape.hxx>
#include <IMeshData_Status.hxx>
#include <IMeshData_StatusOwner.hxx>
#include <IMeshData_TessellatedShape.hxx>
#include <IMeshData_Types.hxx>
#include <IMeshData_Wire.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_IMeshData_enums(py::module &main_module) {


py::module m = main_module.def_submodule("IMeshData", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums
    py::enum_<IMeshData_Status>(m, "IMeshData_Status",R"#(Enumerates statuses used to notify state of discrete model.)#")
        .value("IMeshData_NoError",IMeshData_Status::IMeshData_NoError)
        .value("IMeshData_OpenWire",IMeshData_Status::IMeshData_OpenWire)
        .value("IMeshData_SelfIntersectingWire",IMeshData_Status::IMeshData_SelfIntersectingWire)
        .value("IMeshData_Failure",IMeshData_Status::IMeshData_Failure)
        .value("IMeshData_ReMesh",IMeshData_Status::IMeshData_ReMesh)
        .value("IMeshData_UnorientedWire",IMeshData_Status::IMeshData_UnorientedWire)
        .value("IMeshData_TooFewPoints",IMeshData_Status::IMeshData_TooFewPoints)
        .value("IMeshData_Outdated",IMeshData_Status::IMeshData_Outdated)
        .value("IMeshData_Reused",IMeshData_Status::IMeshData_Reused)
        .value("IMeshData_UserBreak",IMeshData_Status::IMeshData_UserBreak).export_values();

//Python trampoline classes
    class Py_IMeshData_ParametersList : public IMeshData_ParametersList{
    public:
        using IMeshData_ParametersList::IMeshData_ParametersList;


        // public pure virtual
        Standard_Real & GetParameter( const Standard_Integer theIndex) override { using return_type = Standard_Real &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,GetParameter,theIndex) };
        Standard_Integer ParametersNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,ParametersNb,) };
        void Clear( const Standard_Boolean isKeepEndPoints) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,Clear,isKeepEndPoints) };


        // protected pure virtual
        void removeParameter( const Standard_Integer theIndex) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,removeParameter,theIndex) };


        // private pure virtual

    };
    class Py_IMeshData_Curve : public IMeshData_Curve{
    public:
        using IMeshData_Curve::IMeshData_Curve;


        // public pure virtual
        void InsertPoint( const Standard_Integer thePosition, const gp_Pnt & thePoint, const Standard_Real theParamOnPCurve) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Curve,InsertPoint,thePosition,thePoint,theParamOnPCurve) };
        void AddPoint( const gp_Pnt & thePoint, const Standard_Real theParamOnCurve) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Curve,AddPoint,thePoint,theParamOnCurve) };
        gp_Pnt & GetPoint( const Standard_Integer theIndex) override { using return_type = gp_Pnt &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Curve,GetPoint,theIndex) };
        void RemovePoint( const Standard_Integer theIndex) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Curve,RemovePoint,theIndex) };

        Standard_Real & GetParameter( const Standard_Integer theIndex) override { using return_type = Standard_Real &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,GetParameter,theIndex) };
        Standard_Integer ParametersNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,ParametersNb,) };
        void Clear( const Standard_Boolean isKeepEndPoints) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,Clear,isKeepEndPoints) };

        // protected pure virtual

        void removeParameter( const Standard_Integer theIndex) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,removeParameter,theIndex) };

        // private pure virtual

    };
    class Py_IMeshData_Model : public IMeshData_Model{
    public:
        using IMeshData_Model::IMeshData_Model;


        // public pure virtual
        Standard_Real GetMaxSize() const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,GetMaxSize,) };
        Standard_Integer FacesNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,FacesNb,) };
         const typename IMeshData::IFaceHandle & AddFace( const TopoDS_Face & theFace) override { using return_type =  const typename IMeshData::IFaceHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,AddFace,theFace) };
         const typename IMeshData::IFaceHandle & GetFace( const Standard_Integer theIndex) const  override { using return_type =  const typename IMeshData::IFaceHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,GetFace,theIndex) };
        Standard_Integer EdgesNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,EdgesNb,) };
         const typename IMeshData::IEdgeHandle & AddEdge( const TopoDS_Edge & theEdge) override { using return_type =  const typename IMeshData::IEdgeHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,AddEdge,theEdge) };
         const typename IMeshData::IEdgeHandle & GetEdge( const Standard_Integer theIndex) const  override { using return_type =  const typename IMeshData::IEdgeHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Model,GetEdge,theIndex) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IMeshData_PCurve : public IMeshData_PCurve{
    public:
        using IMeshData_PCurve::IMeshData_PCurve;


        // public pure virtual
        void InsertPoint( const Standard_Integer thePosition, const gp_Pnt2d & thePoint, const Standard_Real theParamOnPCurve) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_PCurve,InsertPoint,thePosition,thePoint,theParamOnPCurve) };
        void AddPoint( const gp_Pnt2d & thePoint, const Standard_Real theParamOnPCurve) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_PCurve,AddPoint,thePoint,theParamOnPCurve) };
        gp_Pnt2d & GetPoint( const Standard_Integer theIndex) override { using return_type = gp_Pnt2d &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_PCurve,GetPoint,theIndex) };
        Standard_Integer & GetIndex( const Standard_Integer theIndex) override { using return_type = Standard_Integer &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_PCurve,GetIndex,theIndex) };
        void RemovePoint( const Standard_Integer theIndex) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_PCurve,RemovePoint,theIndex) };

        Standard_Real & GetParameter( const Standard_Integer theIndex) override { using return_type = Standard_Real &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,GetParameter,theIndex) };
        Standard_Integer ParametersNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,ParametersNb,) };
        void Clear( const Standard_Boolean isKeepEndPoints) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,Clear,isKeepEndPoints) };

        // protected pure virtual

        void removeParameter( const Standard_Integer theIndex) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_ParametersList,removeParameter,theIndex) };

        // private pure virtual

    };
    class Py_IMeshData_Edge : public IMeshData_Edge{
    public:
        using IMeshData_Edge::IMeshData_Edge;


        // public pure virtual
        Standard_Integer PCurvesNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Edge,PCurvesNb,) };
         const typename IMeshData::IPCurveHandle & AddPCurve( const IMeshData::IFacePtr & theDFace, const TopAbs_Orientation theOrientation) override { using return_type =  const typename IMeshData::IPCurveHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Edge,AddPCurve,theDFace,theOrientation) };
         const typename IMeshData::IPCurveHandle & GetPCurve( const IMeshData::IFacePtr & theDFace, const TopAbs_Orientation theOrientation) const  override { using return_type =  const typename IMeshData::IPCurveHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Edge,GetPCurve,theDFace,theOrientation) };
         const typename IMeshData::IPCurveHandle & GetPCurve( const Standard_Integer theIndex) const  override { using return_type =  const typename IMeshData::IPCurveHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Edge,GetPCurve,theIndex) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IMeshData_Face : public IMeshData_Face{
    public:
        using IMeshData_Face::IMeshData_Face;


        // public pure virtual
        Standard_Integer WiresNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Face,WiresNb,) };
         const typename IMeshData::IWireHandle & AddWire( const TopoDS_Wire & theWire, const Standard_Integer theEdgeNb) override { using return_type =  const typename IMeshData::IWireHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Face,AddWire,theWire,theEdgeNb) };
         const typename IMeshData::IWireHandle & GetWire( const Standard_Integer theIndex) const  override { using return_type =  const typename IMeshData::IWireHandle &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Face,GetWire,theIndex) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_IMeshData_Wire : public IMeshData_Wire{
    public:
        using IMeshData_Wire::IMeshData_Wire;


        // public pure virtual
        Standard_Integer EdgesNb() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Wire,EdgesNb,) };
        Standard_Integer AddEdge( const IMeshData::IEdgePtr & theDEdge, const TopAbs_Orientation theOrientation) override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Wire,AddEdge,theDEdge,theOrientation) };
         const IMeshData::IEdgePtr & GetEdge( const Standard_Integer theIndex) const  override { using return_type =  const IMeshData::IEdgePtr &;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Wire,GetEdge,theIndex) };
        TopAbs_Orientation GetEdgeOrientation( const Standard_Integer theIndex) const  override { using return_type = TopAbs_Orientation;
    PYBIND11_OVERLOAD_PURE(return_type,IMeshData_Wire,GetEdgeOrientation,theIndex) };


        // protected pure virtual


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<IMeshData_StatusOwner , shared_ptr<IMeshData_StatusOwner>  >(m,"IMeshData_StatusOwner",R"#(Extension interface class providing status functionality.)#");
    py::class_<IMeshData_ParametersList ,opencascade::handle<IMeshData_ParametersList> ,Py_IMeshData_ParametersList , Standard_Transient >(m,"IMeshData_ParametersList",R"#(Interface class representing list of parameters on curve.)#");
    py::class_<IMeshData_Shape ,opencascade::handle<IMeshData_Shape>  , Standard_Transient >(m,"IMeshData_Shape",R"#(Interface class representing model with associated TopoDS_Shape. Intended for inheritance by structures and algorithms keeping reference TopoDS_Shape.)#");
    py::class_<IMeshData_Curve ,opencascade::handle<IMeshData_Curve> ,Py_IMeshData_Curve , IMeshData_ParametersList >(m,"IMeshData_Curve",R"#(Interface class representing discrete 3d curve of edge. Indexation of points starts from zero.)#");
    py::class_<IMeshData_Model ,opencascade::handle<IMeshData_Model> ,Py_IMeshData_Model , IMeshData_Shape >(m,"IMeshData_Model",R"#(Interface class representing discrete model of a shape.)#");
    py::class_<IMeshData_PCurve ,opencascade::handle<IMeshData_PCurve> ,Py_IMeshData_PCurve , IMeshData_ParametersList >(m,"IMeshData_PCurve",R"#(Interface class representing pcurve of edge associated with discrete face. Indexation of points starts from zero.)#");
    py::class_<IMeshData_TessellatedShape ,opencascade::handle<IMeshData_TessellatedShape>  , IMeshData_Shape >(m,"IMeshData_TessellatedShape",R"#(Interface class representing shaped model with deflection.)#");
    py::class_<IMeshData_Edge ,opencascade::handle<IMeshData_Edge> ,Py_IMeshData_Edge , IMeshData_TessellatedShape , IMeshData_StatusOwner >(m,"IMeshData_Edge",R"#(Interface class representing discrete model of an edge.)#");
    py::class_<IMeshData_Face ,opencascade::handle<IMeshData_Face> ,Py_IMeshData_Face , IMeshData_TessellatedShape , IMeshData_StatusOwner >(m,"IMeshData_Face",R"#(Interface class representing discrete model of a face. Face model contains one or several wires. First wire is always outer one.)#");
    py::class_<IMeshData_Wire ,opencascade::handle<IMeshData_Wire> ,Py_IMeshData_Wire , IMeshData_TessellatedShape , IMeshData_StatusOwner >(m,"IMeshData_Wire",R"#(Interface class representing discrete model of a wire. Wire should represent an ordered set of edges.)#");

};

// user-defined post-inclusion per module

// user-defined post
