
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Quantity_Color.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDocStd_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDocStd_Document.hxx>

// module includes
#include <IGESCAFControl.hxx>
#include <IGESCAFControl_ConfigurationNode.hxx>
#include <IGESCAFControl_Provider.hxx>
#include <IGESCAFControl_Reader.hxx>
#include <IGESCAFControl_Writer.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <DE_ConfigurationContext.hxx>

// Module definiiton
void register_IGESCAFControl(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("IGESCAFControl"));
py::object klass;

//Python trampoline classes

// classes

    // Class IGESCAFControl from ./opencascade/IGESCAFControl.hxx
    klass = m.attr("IGESCAFControl");

    // default constructor
    register_default_constructor<IGESCAFControl , shared_ptr<IGESCAFControl>>(m,"IGESCAFControl");

    // nested enums

    static_cast<py::class_<IGESCAFControl , shared_ptr<IGESCAFControl>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("DecodeColor_s",
                    (Quantity_Color (*)(  const Standard_Integer  ) ) static_cast<Quantity_Color (*)(  const Standard_Integer  ) >(&IGESCAFControl::DecodeColor),
                    R"#(Provides a tool for writing IGES file Converts IGES color index to CASCADE color)#"  , py::arg("col")
          )
        .def_static("EncodeColor_s",
                    (Standard_Integer (*)(  const Quantity_Color &  ) ) static_cast<Standard_Integer (*)(  const Quantity_Color &  ) >(&IGESCAFControl::EncodeColor),
                    R"#(Tries to Convert CASCADE color to IGES color index If no corresponding color defined in IGES, returns 0)#"  , py::arg("col")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class IGESCAFControl_Reader from ./opencascade/IGESCAFControl_Reader.hxx
    klass = m.attr("IGESCAFControl_Reader");


    // nested enums

    static_cast<py::class_<IGESCAFControl_Reader , shared_ptr<IGESCAFControl_Reader>  , IGESControl_Reader >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<XSControl_WorkSession> &, const Standard_Boolean >()  , py::arg("theWS"),  py::arg("FromScratch")=static_cast< const Standard_Boolean>(Standard_True) )
    // custom constructors
    // methods
        .def("Transfer",
             (Standard_Boolean (IGESCAFControl_Reader::*)(  const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Reader::*)(  const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) >(&IGESCAFControl_Reader::Transfer),
             R"#(Translates currently loaded IGES file into the document Returns True if succeeded, and False in case of fail)#"  , py::arg("theDoc"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (IGESCAFControl_Reader::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Reader::*)(  const TCollection_AsciiString & ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) >(&IGESCAFControl_Reader::Perform),
             R"#()#"  , py::arg("theFileName"),  py::arg("theDoc"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (IGESCAFControl_Reader::*)(  const Standard_CString ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Reader::*)(  const Standard_CString ,   const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) >(&IGESCAFControl_Reader::Perform),
             R"#(Translate IGES file given by filename into the document Return True if succeeded, and False in case of fail)#"  , py::arg("theFileName"),  py::arg("theDoc"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("SetColorMode",
             (void (IGESCAFControl_Reader::*)(  const Standard_Boolean  ) ) static_cast<void (IGESCAFControl_Reader::*)(  const Standard_Boolean  ) >(&IGESCAFControl_Reader::SetColorMode),
             R"#(Set ColorMode for indicate read Colors or not.)#"  , py::arg("theMode")
          )
        .def("GetColorMode",
             (Standard_Boolean (IGESCAFControl_Reader::*)() const) static_cast<Standard_Boolean (IGESCAFControl_Reader::*)() const>(&IGESCAFControl_Reader::GetColorMode),
             R"#()#" 
          )
        .def("SetNameMode",
             (void (IGESCAFControl_Reader::*)(  const Standard_Boolean  ) ) static_cast<void (IGESCAFControl_Reader::*)(  const Standard_Boolean  ) >(&IGESCAFControl_Reader::SetNameMode),
             R"#(Set NameMode for indicate read Name or not.)#"  , py::arg("theMode")
          )
        .def("GetNameMode",
             (Standard_Boolean (IGESCAFControl_Reader::*)() const) static_cast<Standard_Boolean (IGESCAFControl_Reader::*)() const>(&IGESCAFControl_Reader::GetNameMode),
             R"#()#" 
          )
        .def("SetLayerMode",
             (void (IGESCAFControl_Reader::*)(  const Standard_Boolean  ) ) static_cast<void (IGESCAFControl_Reader::*)(  const Standard_Boolean  ) >(&IGESCAFControl_Reader::SetLayerMode),
             R"#(Set LayerMode for indicate read Layers or not.)#"  , py::arg("theMode")
          )
        .def("GetLayerMode",
             (Standard_Boolean (IGESCAFControl_Reader::*)() const) static_cast<Standard_Boolean (IGESCAFControl_Reader::*)() const>(&IGESCAFControl_Reader::GetLayerMode),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class IGESCAFControl_Writer from ./opencascade/IGESCAFControl_Writer.hxx
    klass = m.attr("IGESCAFControl_Writer");


    // nested enums

    static_cast<py::class_<IGESCAFControl_Writer , shared_ptr<IGESCAFControl_Writer>  , IGESControl_Writer >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<XSControl_WorkSession> &, const Standard_Boolean >()  , py::arg("WS"),  py::arg("scratch")=static_cast< const Standard_Boolean>(Standard_True) )
        .def(py::init<  const handle<XSControl_WorkSession> &, const Standard_CString >()  , py::arg("theWS"),  py::arg("theUnit") )
    // custom constructors
    // methods
        .def("Transfer",
             (Standard_Boolean (IGESCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const Message_ProgressRange &  ) >(&IGESCAFControl_Writer::Transfer),
             R"#(Transfers a document to a IGES model Returns True if translation is OK)#"  , py::arg("doc"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (IGESCAFControl_Writer::*)(  const TDF_LabelSequence & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)(  const TDF_LabelSequence & ,   const Message_ProgressRange &  ) >(&IGESCAFControl_Writer::Transfer),
             R"#(Transfers labels to a IGES model Returns True if translation is OK)#"  , py::arg("labels"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (IGESCAFControl_Writer::*)(  const TDF_Label & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)(  const TDF_Label & ,   const Message_ProgressRange &  ) >(&IGESCAFControl_Writer::Transfer),
             R"#(Transfers label to a IGES model Returns True if translation is OK)#"  , py::arg("label"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (IGESCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const TCollection_AsciiString & ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const TCollection_AsciiString & ,   const Message_ProgressRange &  ) >(&IGESCAFControl_Writer::Perform),
             R"#()#"  , py::arg("doc"),  py::arg("filename"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (IGESCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const Standard_CString ,   const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)(  const handle<TDocStd_Document> & ,   const Standard_CString ,   const Message_ProgressRange &  ) >(&IGESCAFControl_Writer::Perform),
             R"#(Transfers a document and writes it to a IGES file Returns True if translation is OK)#"  , py::arg("doc"),  py::arg("filename"),  py::arg("theProgress")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("SetColorMode",
             (void (IGESCAFControl_Writer::*)(  const Standard_Boolean  ) ) static_cast<void (IGESCAFControl_Writer::*)(  const Standard_Boolean  ) >(&IGESCAFControl_Writer::SetColorMode),
             R"#(Set ColorMode for indicate write Colors or not.)#"  , py::arg("colormode")
          )
        .def("GetColorMode",
             (Standard_Boolean (IGESCAFControl_Writer::*)() const) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)() const>(&IGESCAFControl_Writer::GetColorMode),
             R"#()#" 
          )
        .def("SetNameMode",
             (void (IGESCAFControl_Writer::*)(  const Standard_Boolean  ) ) static_cast<void (IGESCAFControl_Writer::*)(  const Standard_Boolean  ) >(&IGESCAFControl_Writer::SetNameMode),
             R"#(Set NameMode for indicate write Name or not.)#"  , py::arg("namemode")
          )
        .def("GetNameMode",
             (Standard_Boolean (IGESCAFControl_Writer::*)() const) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)() const>(&IGESCAFControl_Writer::GetNameMode),
             R"#()#" 
          )
        .def("SetLayerMode",
             (void (IGESCAFControl_Writer::*)(  const Standard_Boolean  ) ) static_cast<void (IGESCAFControl_Writer::*)(  const Standard_Boolean  ) >(&IGESCAFControl_Writer::SetLayerMode),
             R"#(Set LayerMode for indicate write Layers or not.)#"  , py::arg("layermode")
          )
        .def("GetLayerMode",
             (Standard_Boolean (IGESCAFControl_Writer::*)() const) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)() const>(&IGESCAFControl_Writer::GetLayerMode),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions

// ./opencascade/IGESCAFControl.hxx
// ./opencascade/IGESCAFControl_ConfigurationNode.hxx
// ./opencascade/IGESCAFControl_Provider.hxx
// ./opencascade/IGESCAFControl_Reader.hxx
// ./opencascade/IGESCAFControl_Writer.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
