#pragma once

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <DE_ConfigurationContext.hxx>
#include <DE_Provider.hxx>
#include <NCollection_Buffer.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <DE_ConfigurationNode.hxx>
#include <TopoDS_Shape.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDocStd_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <DE_ConfigurationContext.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDocStd_Document.hxx>

// module includes
#include <DE_ConfigurationContext.hxx>
#include <DE_ConfigurationNode.hxx>
#include <DE_PluginHolder.hxx>
#include <DE_Provider.hxx>
#include <DE_ShapeFixConfigurationNode.hxx>
#include <DE_ShapeFixParameters.hxx>
#include <DE_Wrapper.hxx>

// user-defined pre
#include "OCP_specific.inc"

// Class template handling functions

template <typename TheConfType>
void preregister_template_DE_PluginHolder(py::object &m, const char *name){
    py::class_<DE_PluginHolder<TheConfType> , shared_ptr<DE_PluginHolder<TheConfType>> >(m,name,R"#(Base class to work with DE_Wrapper global registration of components. Control life-time of current configuration node. In creating stage load into global configuration. On destroying stage unload from global configuration. Operation to load/unload are thread safety.)#");
}

template <typename TheConfType>
void register_template_DE_PluginHolder(py::object &m, const char *name){
    static_cast<py::class_<DE_PluginHolder<TheConfType> , shared_ptr<DE_PluginHolder<TheConfType>> >>(m.attr(name))
        .def(py::init<  >()  )
    ;
};


// user-defined post

