
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <DE_ConfigurationContext.hxx>
#include <DE_Provider.hxx>
#include <NCollection_Buffer.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <DE_ConfigurationNode.hxx>
#include <TopoDS_Shape.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDocStd_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <DE_ConfigurationContext.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDocStd_Document.hxx>

// module includes
#include <DE_ConfigurationContext.hxx>
#include <DE_ConfigurationNode.hxx>
#include <DE_PluginHolder.hxx>
#include <DE_Provider.hxx>
#include <DE_ShapeFixConfigurationNode.hxx>
#include <DE_ShapeFixParameters.hxx>
#include <DE_Wrapper.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_DE_enums(py::module &main_module) {


py::module m = main_module.def_submodule("DE", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes
    class Py_DE_ConfigurationNode : public DE_ConfigurationNode{
    public:
        using DE_ConfigurationNode::DE_ConfigurationNode;


        // public pure virtual
        bool Load( const handle<DE_ConfigurationContext> & theResource) override { using return_type = bool;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,Load,theResource) };
        TCollection_AsciiString Save() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,Save,) };
        handle<DE_Provider> BuildProvider() override { using return_type = handle<DE_Provider>;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,BuildProvider,) };
        handle<DE_ConfigurationNode> Copy() const  override { using return_type = handle<DE_ConfigurationNode>;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,Copy,) };
        TCollection_AsciiString GetFormat() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,GetFormat,) };
        TCollection_AsciiString GetVendor() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,GetVendor,) };
        TColStd_ListOfAsciiString GetExtensions() const  override { using return_type = TColStd_ListOfAsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,GetExtensions,) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_DE_Provider : public DE_Provider{
    public:
        using DE_Provider::DE_Provider;


        // public pure virtual
        TCollection_AsciiString GetFormat() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_Provider,GetFormat,) };
        TCollection_AsciiString GetVendor() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_Provider,GetVendor,) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_DE_ShapeFixConfigurationNode : public DE_ShapeFixConfigurationNode{
    public:
        using DE_ShapeFixConfigurationNode::DE_ShapeFixConfigurationNode;


        // public pure virtual

        handle<DE_Provider> BuildProvider() override { using return_type = handle<DE_Provider>;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,BuildProvider,) };
        handle<DE_ConfigurationNode> Copy() const  override { using return_type = handle<DE_ConfigurationNode>;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,Copy,) };
        TCollection_AsciiString GetFormat() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,GetFormat,) };
        TCollection_AsciiString GetVendor() const  override { using return_type = TCollection_AsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,GetVendor,) };
        TColStd_ListOfAsciiString GetExtensions() const  override { using return_type = TColStd_ListOfAsciiString;
    PYBIND11_OVERLOAD_PURE(return_type,DE_ConfigurationNode,GetExtensions,) };

        // protected pure virtual


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<DE_ShapeFixParameters , shared_ptr<DE_ShapeFixParameters>  >(m,"DE_ShapeFixParameters",R"#(Struct for shape healing parameters storage)#");
    py::class_<DE_ConfigurationContext ,opencascade::handle<DE_ConfigurationContext>  , Standard_Transient >(m,"DE_ConfigurationContext",R"#(Provides convenient interface to resource file Allows loading of the resource file and getting attributes' values starting from some scope, for example if scope is defined as "ToV4" and requested parameter is "exec.op", value of "ToV4.exec.op" parameter from the resource file will be returned)#");
    py::class_<DE_ConfigurationNode ,opencascade::handle<DE_ConfigurationNode> ,Py_DE_ConfigurationNode , Standard_Transient >(m,"DE_ConfigurationNode",R"#(Base class to work with CAD transfer properties. Stores the necessary settings for a single Provider type. Configures and creates special provider to transfer CAD files.)#");
    py::class_<DE_Provider ,opencascade::handle<DE_Provider> ,Py_DE_Provider , Standard_Transient >(m,"DE_Provider",R"#(Base class to make transfer process. Reads or Writes specialized CAD files into/from OCCT. Each operation needs the Configuration Node.)#");
    py::class_<DE_Wrapper ,opencascade::handle<DE_Wrapper>  , Standard_Transient >(m,"DE_Wrapper",R"#(The main class for working with CAD file exchange. Loads and Saves special CAD transfer property. Consolidates all supported Formats and Vendors. Automatically recognizes CAD format and uses the preferred existed Vendor. Note: If Vendor's format is not binded, the configuration loading doesn't affect on its property.)#");
    py::class_<DE_ShapeFixConfigurationNode ,opencascade::handle<DE_ShapeFixConfigurationNode> ,Py_DE_ShapeFixConfigurationNode , DE_ConfigurationNode >(m,"DE_ShapeFixConfigurationNode",R"#(Base class to work with shape healing parameters for child classes.)#");

};

// user-defined post-inclusion per module

// user-defined post
