
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>

// module includes
#include <BinMDocStd.hxx>
#include <BinMDocStd_XLinkDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BinMDocStd(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("BinMDocStd"));
py::object klass;

//Python trampoline classes

// classes

    // Class BinMDocStd from ./opencascade/BinMDocStd.hxx
    klass = m.attr("BinMDocStd");

    // default constructor
    register_default_constructor<BinMDocStd , shared_ptr<BinMDocStd>>(m,"BinMDocStd");

    // nested enums

    static_cast<py::class_<BinMDocStd , shared_ptr<BinMDocStd>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("AddDrivers_s",
                    (void (*)(  const handle<BinMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) ) static_cast<void (*)(  const handle<BinMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) >(&BinMDocStd::AddDrivers),
                    R"#(Adds the attribute drivers to <theDriverTable>.)#"  , py::arg("theDriverTable"),  py::arg("aMsgDrv")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinMDocStd_XLinkDriver from ./opencascade/BinMDocStd_XLinkDriver.hxx
    klass = m.attr("BinMDocStd_XLinkDriver");


    // nested enums

    static_cast<py::class_<BinMDocStd_XLinkDriver ,opencascade::handle<BinMDocStd_XLinkDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (BinMDocStd_XLinkDriver::*)() const) static_cast<handle<TDF_Attribute> (BinMDocStd_XLinkDriver::*)() const>(&BinMDocStd_XLinkDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (BinMDocStd_XLinkDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinMDocStd_XLinkDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinMDocStd_XLinkDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinMDocStd_XLinkDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const) static_cast<void (BinMDocStd_XLinkDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const>(&BinMDocStd_XLinkDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinMDocStd_XLinkDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinMDocStd_XLinkDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinMDocStd_XLinkDriver::*)() const) static_cast< const handle<Standard_Type> & (BinMDocStd_XLinkDriver::*)() const>(&BinMDocStd_XLinkDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/BinMDocStd.hxx
// ./opencascade/BinMDocStd_XLinkDriver.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
