
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinObjMgt_Persistent.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <BinMDF.hxx>
#include <BinMDF_ADriver.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <BinMDF_DataMapIteratorOfTypeADriverMap.hxx>
#include <BinMDF_DerivedDriver.hxx>
#include <BinMDF_DoubleMapIteratorOfTypeIdMap.hxx>
#include <BinMDF_ReferenceDriver.hxx>
#include <BinMDF_StringIdMap.hxx>
#include <BinMDF_TagSourceDriver.hxx>
#include <BinMDF_TypeADriverMap.hxx>
#include <BinMDF_TypeIdMap.hxx>

// template related includes

// ./opencascade/BinMDF_TypeADriverMap.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/BinMDF_TypeIdMap.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BinMDF(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("BinMDF"));
py::object klass;

//Python trampoline classes
    class Py_BinMDF_ADriver : public BinMDF_ADriver{
    public:
        using BinMDF_ADriver::BinMDF_ADriver;


        // public pure virtual
        handle<TDF_Attribute> NewEmpty() const  override { using return_type = handle<TDF_Attribute>;
    PYBIND11_OVERLOAD_PURE(return_type,BinMDF_ADriver,NewEmpty,) };
        Standard_Boolean Paste( const BinObjMgt_Persistent & aSource, const handle<TDF_Attribute> & aTarget,BinObjMgt_RRelocationTable & aRelocTable) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,BinMDF_ADriver,Paste,aSource,aTarget,aRelocTable) };
        void Paste( const handle<TDF_Attribute> & aSource,BinObjMgt_Persistent & aTarget,BinObjMgt_SRelocationTable & aRelocTable) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,BinMDF_ADriver,Paste,aSource,aTarget,aRelocTable) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class BinMDF from ./opencascade/BinMDF.hxx
    klass = m.attr("BinMDF");

    // default constructor
    register_default_constructor<BinMDF , shared_ptr<BinMDF>>(m,"BinMDF");

    // nested enums

    static_cast<py::class_<BinMDF , shared_ptr<BinMDF>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("AddDrivers_s",
                    (void (*)(  const handle<BinMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) ) static_cast<void (*)(  const handle<BinMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) >(&BinMDF::AddDrivers),
                    R"#(Adds the attribute storage drivers to <aDriverTable>.)#"  , py::arg("aDriverTable"),  py::arg("aMsgDrv")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinMDF_ADriver from ./opencascade/BinMDF_ADriver.hxx
    klass = m.attr("BinMDF_ADriver");


    // nested enums

    static_cast<py::class_<BinMDF_ADriver ,opencascade::handle<BinMDF_ADriver> ,Py_BinMDF_ADriver , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (BinMDF_ADriver::*)() const) static_cast<handle<TDF_Attribute> (BinMDF_ADriver::*)() const>(&BinMDF_ADriver::NewEmpty),
             R"#(Creates a new attribute from TDF.)#" 
          )
        .def("Paste",
             (Standard_Boolean (BinMDF_ADriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinMDF_ADriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinMDF_ADriver::Paste),
             R"#(Translate the contents of <aSource> and put it into <aTarget>, using the relocation table <aRelocTable> to keep the sharings.)#"  , py::arg("aSource"),  py::arg("aTarget"),  py::arg("aRelocTable")
          )
        .def("Paste",
             (void (BinMDF_ADriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const) static_cast<void (BinMDF_ADriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const>(&BinMDF_ADriver::Paste),
             R"#(Translate the contents of <aSource> and put it into <aTarget>, using the relocation table <aRelocTable> to keep the sharings.)#"  , py::arg("aSource"),  py::arg("aTarget"),  py::arg("aRelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinMDF_ADriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinMDF_ADriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("SourceType",
             ( const handle<Standard_Type> & (BinMDF_ADriver::*)() const) static_cast< const handle<Standard_Type> & (BinMDF_ADriver::*)() const>(&BinMDF_ADriver::SourceType),
             R"#(Returns the type of source object, inheriting from Attribute from TDF.)#"
             
         )
       .def("TypeName",
             ( const TCollection_AsciiString & (BinMDF_ADriver::*)() const) static_cast< const TCollection_AsciiString & (BinMDF_ADriver::*)() const>(&BinMDF_ADriver::TypeName),
             R"#(Returns the type name of the attribute object)#"
             
         )
       .def("MessageDriver",
             ( const handle<Message_Messenger> & (BinMDF_ADriver::*)() const) static_cast< const handle<Message_Messenger> & (BinMDF_ADriver::*)() const>(&BinMDF_ADriver::MessageDriver),
             R"#(Returns the current message driver of this driver)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinMDF_ADriver::*)() const) static_cast< const handle<Standard_Type> & (BinMDF_ADriver::*)() const>(&BinMDF_ADriver::DynamicType),
             R"#()#"
             
         )
       .def("TypeName",
             ( const TCollection_AsciiString & (BinMDF_ADriver::*)() const) static_cast< const TCollection_AsciiString & (BinMDF_ADriver::*)() const>(&BinMDF_ADriver::TypeName),
             R"#(Returns the type name of the attribute object)#"
             
         )
;

    // Class BinMDF_ADriverTable from ./opencascade/BinMDF_ADriverTable.hxx
    klass = m.attr("BinMDF_ADriverTable");


    // nested enums

    static_cast<py::class_<BinMDF_ADriverTable ,opencascade::handle<BinMDF_ADriverTable>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("AddDriver",
             (void (BinMDF_ADriverTable::*)(  const handle<BinMDF_ADriver> &  ) ) static_cast<void (BinMDF_ADriverTable::*)(  const handle<BinMDF_ADriver> &  ) >(&BinMDF_ADriverTable::AddDriver),
             R"#(Adds a translation driver <theDriver>.)#"  , py::arg("theDriver")
          )
        .def("AddDerivedDriver",
             (void (BinMDF_ADriverTable::*)(  const handle<TDF_Attribute> &  ) ) static_cast<void (BinMDF_ADriverTable::*)(  const handle<TDF_Attribute> &  ) >(&BinMDF_ADriverTable::AddDerivedDriver),
             R"#(Adds a translation driver for the derived attribute. The base driver must be already added.)#"  , py::arg("theInstance")
          )
        .def("AddDerivedDriver",
             ( const handle<Standard_Type> & (BinMDF_ADriverTable::*)( Standard_CString  ) ) static_cast< const handle<Standard_Type> & (BinMDF_ADriverTable::*)( Standard_CString  ) >(&BinMDF_ADriverTable::AddDerivedDriver),
             R"#(Adds a translation driver for the derived attribute. The base driver must be already added.)#"  , py::arg("theDerivedType")
          )
        .def("AssignIds",
             (void (BinMDF_ADriverTable::*)(  const TColStd_IndexedMapOfTransient &  ) ) static_cast<void (BinMDF_ADriverTable::*)(  const TColStd_IndexedMapOfTransient &  ) >(&BinMDF_ADriverTable::AssignIds),
             R"#(Assigns the IDs to the drivers of the given Types. It uses indices in the map as IDs. Useful in storage procedure.)#"  , py::arg("theTypes")
          )
        .def("AssignIds",
             (void (BinMDF_ADriverTable::*)(  const TColStd_SequenceOfAsciiString &  ) ) static_cast<void (BinMDF_ADriverTable::*)(  const TColStd_SequenceOfAsciiString &  ) >(&BinMDF_ADriverTable::AssignIds),
             R"#(Assigns the IDs to the drivers of the given Type Names; It uses indices in the sequence as IDs. Useful in retrieval procedure.)#"  , py::arg("theTypeNames")
          )
        .def("GetDriver",
             (Standard_Integer (BinMDF_ADriverTable::*)(  const handle<Standard_Type> & ,  handle<BinMDF_ADriver> &  ) ) static_cast<Standard_Integer (BinMDF_ADriverTable::*)(  const handle<Standard_Type> & ,  handle<BinMDF_ADriver> &  ) >(&BinMDF_ADriverTable::GetDriver),
             R"#(Gets a driver <theDriver> according to <theType>. Returns Type ID if the driver was assigned an ID; 0 otherwise.)#"  , py::arg("theType"),  py::arg("theDriver")
          )
        .def("GetDriver",
             (handle<BinMDF_ADriver> (BinMDF_ADriverTable::*)(  const Standard_Integer  ) ) static_cast<handle<BinMDF_ADriver> (BinMDF_ADriverTable::*)(  const Standard_Integer  ) >(&BinMDF_ADriverTable::GetDriver),
             R"#(Returns a driver according to <theTypeId>. Returns null handle if a driver is not found)#"  , py::arg("theTypeId")
          )
        .def("GetDriver",
             (Standard_Integer (BinMDF_ADriverTable::*)(  const handle<Standard_Type> & ,  handle<BinMDF_ADriver> &  ) ) static_cast<Standard_Integer (BinMDF_ADriverTable::*)(  const handle<Standard_Type> & ,  handle<BinMDF_ADriver> &  ) >(&BinMDF_ADriverTable::GetDriver),
             R"#(Gets a driver <theDriver> according to <theType>. Returns Type ID if the driver was assigned an ID; 0 otherwise.)#"  , py::arg("theType"),  py::arg("theDriver")
          )
        .def("GetDriver",
             (handle<BinMDF_ADriver> (BinMDF_ADriverTable::*)(  const Standard_Integer  ) ) static_cast<handle<BinMDF_ADriver> (BinMDF_ADriverTable::*)(  const Standard_Integer  ) >(&BinMDF_ADriverTable::GetDriver),
             R"#(Returns a driver according to <theTypeId>. Returns null handle if a driver is not found)#"  , py::arg("theTypeId")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinMDF_ADriverTable::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinMDF_ADriverTable::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinMDF_ADriverTable::*)() const) static_cast< const handle<Standard_Type> & (BinMDF_ADriverTable::*)() const>(&BinMDF_ADriverTable::DynamicType),
             R"#()#"
             
         )
;

    // Class BinMDF_DerivedDriver from ./opencascade/BinMDF_DerivedDriver.hxx
    klass = m.attr("BinMDF_DerivedDriver");


    // nested enums

    static_cast<py::class_<BinMDF_DerivedDriver ,opencascade::handle<BinMDF_DerivedDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<TDF_Attribute> &, const handle<BinMDF_ADriver> & >()  , py::arg("theDerivative"),  py::arg("theBaseDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (BinMDF_DerivedDriver::*)() const) static_cast<handle<TDF_Attribute> (BinMDF_DerivedDriver::*)() const>(&BinMDF_DerivedDriver::NewEmpty),
             R"#(Creates a new instance of the derivative attribute)#" 
          )
        .def("Paste",
             (Standard_Boolean (BinMDF_DerivedDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinMDF_DerivedDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinMDF_DerivedDriver::Paste),
             R"#(Reuses the base driver to read the base fields)#"  , py::arg("theSource"),  py::arg("theTarget"),  py::arg("theRelocTable")
          )
        .def("Paste",
             (void (BinMDF_DerivedDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const) static_cast<void (BinMDF_DerivedDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const>(&BinMDF_DerivedDriver::Paste),
             R"#(Reuses the base driver to store the base fields)#"  , py::arg("theSource"),  py::arg("theTarget"),  py::arg("theRelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinMDF_DerivedDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinMDF_DerivedDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinMDF_DerivedDriver::*)() const) static_cast< const handle<Standard_Type> & (BinMDF_DerivedDriver::*)() const>(&BinMDF_DerivedDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class BinMDF_ReferenceDriver from ./opencascade/BinMDF_ReferenceDriver.hxx
    klass = m.attr("BinMDF_ReferenceDriver");


    // nested enums

    static_cast<py::class_<BinMDF_ReferenceDriver ,opencascade::handle<BinMDF_ReferenceDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (BinMDF_ReferenceDriver::*)() const) static_cast<handle<TDF_Attribute> (BinMDF_ReferenceDriver::*)() const>(&BinMDF_ReferenceDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (BinMDF_ReferenceDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinMDF_ReferenceDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinMDF_ReferenceDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinMDF_ReferenceDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const) static_cast<void (BinMDF_ReferenceDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const>(&BinMDF_ReferenceDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinMDF_ReferenceDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinMDF_ReferenceDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinMDF_ReferenceDriver::*)() const) static_cast< const handle<Standard_Type> & (BinMDF_ReferenceDriver::*)() const>(&BinMDF_ReferenceDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class BinMDF_TagSourceDriver from ./opencascade/BinMDF_TagSourceDriver.hxx
    klass = m.attr("BinMDF_TagSourceDriver");


    // nested enums

    static_cast<py::class_<BinMDF_TagSourceDriver ,opencascade::handle<BinMDF_TagSourceDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (BinMDF_TagSourceDriver::*)() const) static_cast<handle<TDF_Attribute> (BinMDF_TagSourceDriver::*)() const>(&BinMDF_TagSourceDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (BinMDF_TagSourceDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinMDF_TagSourceDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinMDF_TagSourceDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinMDF_TagSourceDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const) static_cast<void (BinMDF_TagSourceDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const>(&BinMDF_TagSourceDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinMDF_TagSourceDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinMDF_TagSourceDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinMDF_TagSourceDriver::*)() const) static_cast< const handle<Standard_Type> & (BinMDF_TagSourceDriver::*)() const>(&BinMDF_TagSourceDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/BinMDF.hxx
// ./opencascade/BinMDF_ADriver.hxx
// ./opencascade/BinMDF_ADriverTable.hxx
// ./opencascade/BinMDF_DataMapIteratorOfTypeADriverMap.hxx
// ./opencascade/BinMDF_DerivedDriver.hxx
// ./opencascade/BinMDF_DoubleMapIteratorOfTypeIdMap.hxx
// ./opencascade/BinMDF_ReferenceDriver.hxx
// ./opencascade/BinMDF_StringIdMap.hxx
// ./opencascade/BinMDF_TagSourceDriver.hxx
// ./opencascade/BinMDF_TypeADriverMap.hxx
// ./opencascade/BinMDF_TypeIdMap.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
