
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Standard_GUID.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <TDocStd_Application.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <BinDrivers.hxx>
#include <BinDrivers_DocumentRetrievalDriver.hxx>
#include <BinDrivers_DocumentStorageDriver.hxx>
#include <BinDrivers_Marker.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BinDrivers(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("BinDrivers"));
py::object klass;

//Python trampoline classes

// classes

    // Class BinDrivers from ./opencascade/BinDrivers.hxx
    klass = m.attr("BinDrivers");

    // default constructor
    register_default_constructor<BinDrivers , shared_ptr<BinDrivers>>(m,"BinDrivers");

    // nested enums

    static_cast<py::class_<BinDrivers , shared_ptr<BinDrivers>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Factory_s",
                    ( const handle<Standard_Transient> & (*)(  const Standard_GUID &  ) ) static_cast< const handle<Standard_Transient> & (*)(  const Standard_GUID &  ) >(&BinDrivers::Factory),
                    R"#()#"  , py::arg("theGUID")
          )
        .def_static("DefineFormat_s",
                    (void (*)(  const handle<TDocStd_Application> &  ) ) static_cast<void (*)(  const handle<TDocStd_Application> &  ) >(&BinDrivers::DefineFormat),
                    R"#(Defines format "BinOcaf" and registers its read and write drivers in the specified application)#"  , py::arg("theApp")
          )
        .def_static("AttributeDrivers_s",
                    (handle<BinMDF_ADriverTable> (*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<BinMDF_ADriverTable> (*)(  const handle<Message_Messenger> &  ) >(&BinDrivers::AttributeDrivers),
                    R"#(Creates the table of drivers of types supported)#"  , py::arg("MsgDrv")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinDrivers_DocumentRetrievalDriver from ./opencascade/BinDrivers_DocumentRetrievalDriver.hxx
    klass = m.attr("BinDrivers_DocumentRetrievalDriver");


    // nested enums

    static_cast<py::class_<BinDrivers_DocumentRetrievalDriver ,opencascade::handle<BinDrivers_DocumentRetrievalDriver>  , BinLDrivers_DocumentRetrievalDriver >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("AttributeDrivers",
             (handle<BinMDF_ADriverTable> (BinDrivers_DocumentRetrievalDriver::*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<BinMDF_ADriverTable> (BinDrivers_DocumentRetrievalDriver::*)(  const handle<Message_Messenger> &  ) >(&BinDrivers_DocumentRetrievalDriver::AttributeDrivers),
             R"#()#"  , py::arg("theMsgDriver")
          )
        .def("ReadShapeSection",
             (void (BinDrivers_DocumentRetrievalDriver::*)( BinLDrivers_DocumentSection & ,  Standard_IStream & ,   const Standard_Boolean ,   const Message_ProgressRange &  ) ) static_cast<void (BinDrivers_DocumentRetrievalDriver::*)( BinLDrivers_DocumentSection & ,  Standard_IStream & ,   const Standard_Boolean ,   const Message_ProgressRange &  ) >(&BinDrivers_DocumentRetrievalDriver::ReadShapeSection),
             R"#()#"  , py::arg("theSection"),  py::arg("theIS"),  py::arg("isMess")=static_cast< const Standard_Boolean>(Standard_False),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("CheckShapeSection",
             (void (BinDrivers_DocumentRetrievalDriver::*)(  const Storage_Position & ,  Standard_IStream &  ) ) static_cast<void (BinDrivers_DocumentRetrievalDriver::*)(  const Storage_Position & ,  Standard_IStream &  ) >(&BinDrivers_DocumentRetrievalDriver::CheckShapeSection),
             R"#()#"  , py::arg("thePos"),  py::arg("theIS")
          )
        .def("Clear",
             (void (BinDrivers_DocumentRetrievalDriver::*)() ) static_cast<void (BinDrivers_DocumentRetrievalDriver::*)() >(&BinDrivers_DocumentRetrievalDriver::Clear),
             R"#(Clears the NamedShape driver)#" 
          )
        .def("EnableQuickPartReading",
             (void (BinDrivers_DocumentRetrievalDriver::*)(  const handle<Message_Messenger> & ,  Standard_Boolean  ) ) static_cast<void (BinDrivers_DocumentRetrievalDriver::*)(  const handle<Message_Messenger> & ,  Standard_Boolean  ) >(&BinDrivers_DocumentRetrievalDriver::EnableQuickPartReading),
             R"#(Enables reading in the quick part access mode.)#"  , py::arg("theMessageDriver"),  py::arg("theValue")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinDrivers_DocumentRetrievalDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinDrivers_DocumentRetrievalDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinDrivers_DocumentRetrievalDriver::*)() const) static_cast< const handle<Standard_Type> & (BinDrivers_DocumentRetrievalDriver::*)() const>(&BinDrivers_DocumentRetrievalDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class BinDrivers_DocumentStorageDriver from ./opencascade/BinDrivers_DocumentStorageDriver.hxx
    klass = m.attr("BinDrivers_DocumentStorageDriver");


    // nested enums

    static_cast<py::class_<BinDrivers_DocumentStorageDriver ,opencascade::handle<BinDrivers_DocumentStorageDriver>  , BinLDrivers_DocumentStorageDriver >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("AttributeDrivers",
             (handle<BinMDF_ADriverTable> (BinDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<BinMDF_ADriverTable> (BinDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> &  ) >(&BinDrivers_DocumentStorageDriver::AttributeDrivers),
             R"#()#"  , py::arg("theMsgDriver")
          )
        .def("WriteShapeSection",
             (void (BinDrivers_DocumentStorageDriver::*)( BinLDrivers_DocumentSection & ,  Standard_OStream & ,   const TDocStd_FormatVersion ,   const Message_ProgressRange &  ) ) static_cast<void (BinDrivers_DocumentStorageDriver::*)( BinLDrivers_DocumentSection & ,  Standard_OStream & ,   const TDocStd_FormatVersion ,   const Message_ProgressRange &  ) >(&BinDrivers_DocumentStorageDriver::WriteShapeSection),
             R"#(implements the procedure of writing a shape section to file)#"  , py::arg("theDocSection"),  py::arg("theOS"),  py::arg("theDocVer"),  py::arg("theRange")=static_cast< const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("IsWithTriangles",
             (Standard_Boolean (BinDrivers_DocumentStorageDriver::*)() const) static_cast<Standard_Boolean (BinDrivers_DocumentStorageDriver::*)() const>(&BinDrivers_DocumentStorageDriver::IsWithTriangles),
             R"#(Return true if shape should be stored with triangles.)#" 
          )
        .def("IsWithNormals",
             (Standard_Boolean (BinDrivers_DocumentStorageDriver::*)() const) static_cast<Standard_Boolean (BinDrivers_DocumentStorageDriver::*)() const>(&BinDrivers_DocumentStorageDriver::IsWithNormals),
             R"#(Return true if shape should be stored with triangulation normals.)#" 
          )
        .def("SetWithTriangles",
             (void (BinDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> & ,   const Standard_Boolean  ) ) static_cast<void (BinDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> & ,   const Standard_Boolean  ) >(&BinDrivers_DocumentStorageDriver::SetWithTriangles),
             R"#(Set if triangulation should be stored or not.)#"  , py::arg("theMessageDriver"),  py::arg("theWithTriangulation")
          )
        .def("SetWithNormals",
             (void (BinDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> & ,   const Standard_Boolean  ) ) static_cast<void (BinDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> & ,   const Standard_Boolean  ) >(&BinDrivers_DocumentStorageDriver::SetWithNormals),
             R"#(Set if triangulation should be stored with normals or not.)#"  , py::arg("theMessageDriver"),  py::arg("theWithTriangulation")
          )
        .def("EnableQuickPartWriting",
             (void (BinDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> & ,   const Standard_Boolean  ) ) static_cast<void (BinDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> & ,   const Standard_Boolean  ) >(&BinDrivers_DocumentStorageDriver::EnableQuickPartWriting),
             R"#(Enables writing in the quick part access mode.)#"  , py::arg("theMessageDriver"),  py::arg("theValue")
          )
        .def("Clear",
             (void (BinDrivers_DocumentStorageDriver::*)() ) static_cast<void (BinDrivers_DocumentStorageDriver::*)() >(&BinDrivers_DocumentStorageDriver::Clear),
             R"#(Clears the NamedShape driver)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinDrivers_DocumentStorageDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinDrivers_DocumentStorageDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinDrivers_DocumentStorageDriver::*)() const) static_cast< const handle<Standard_Type> & (BinDrivers_DocumentStorageDriver::*)() const>(&BinDrivers_DocumentStorageDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/BinDrivers.hxx
// ./opencascade/BinDrivers_DocumentRetrievalDriver.hxx
// ./opencascade/BinDrivers_DocumentStorageDriver.hxx
// ./opencascade/BinDrivers_Marker.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
