
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Wire.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Face.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Wire.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor3d_Curve.hxx>

// module includes
#include <BRepAlgo.hxx>
#include <BRepAlgo_AsDes.hxx>
#include <BRepAlgo_FaceRestrictor.hxx>
#include <BRepAlgo_Image.hxx>
#include <BRepAlgo_Loop.hxx>
#include <BRepAlgo_NormalProjection.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BRepAlgo(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("BRepAlgo"));
py::object klass;

//Python trampoline classes

// classes

    // Class BRepAlgo from ./opencascade/BRepAlgo.hxx
    klass = m.attr("BRepAlgo");

    // default constructor
    register_default_constructor<BRepAlgo , shared_ptr<BRepAlgo>>(m,"BRepAlgo");

    // nested enums

    static_cast<py::class_<BRepAlgo , shared_ptr<BRepAlgo>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("ConcatenateWire_s",
                    (TopoDS_Wire (*)(  const TopoDS_Wire & ,   const GeomAbs_Shape ,   const Standard_Real  ) ) static_cast<TopoDS_Wire (*)(  const TopoDS_Wire & ,   const GeomAbs_Shape ,   const Standard_Real  ) >(&BRepAlgo::ConcatenateWire),
                    R"#(this method makes a wire whose edges are C1 from a Wire whose edges could be G1. It removes a vertex between G1 edges. Option can be G1 or C1.)#"  , py::arg("Wire"),  py::arg("Option"),  py::arg("AngularTolerance")=static_cast< const Standard_Real>(1.0e-4)
          )
        .def_static("ConcatenateWireC0_s",
                    (TopoDS_Edge (*)(  const TopoDS_Wire &  ) ) static_cast<TopoDS_Edge (*)(  const TopoDS_Wire &  ) >(&BRepAlgo::ConcatenateWireC0),
                    R"#(this method makes an edge from a wire. Junction points between edges of wire may be sharp, resulting curve of the resulting edge may be C0.)#"  , py::arg("Wire")
          )
        .def_static("ConvertWire_s",
                    (TopoDS_Wire (*)(  const TopoDS_Wire & ,   const Standard_Real ,   const TopoDS_Face &  ) ) static_cast<TopoDS_Wire (*)(  const TopoDS_Wire & ,   const Standard_Real ,   const TopoDS_Face &  ) >(&BRepAlgo::ConvertWire),
                    R"#(Method of wire conversion, calls BRepAlgo_Approx internally.)#"  , py::arg("theWire"),  py::arg("theAngleTolerance"),  py::arg("theFace")
          )
        .def_static("ConvertFace_s",
                    (TopoDS_Face (*)(  const TopoDS_Face & ,   const Standard_Real  ) ) static_cast<TopoDS_Face (*)(  const TopoDS_Face & ,   const Standard_Real  ) >(&BRepAlgo::ConvertFace),
                    R"#(Method of face conversion. The API corresponds to the method ConvertWire. This is a shortcut for calling ConvertWire() for each wire in theFace.)#"  , py::arg("theFace"),  py::arg("theAngleTolerance")
          )
        .def_static("IsValid_s",
                    (Standard_Boolean (*)(  const TopoDS_Shape &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Shape &  ) >(&BRepAlgo::IsValid),
                    R"#(Checks if the shape is "correct". If not, returns <Standard_False>, else returns <Standard_True>.)#"  , py::arg("S")
          )
        .def_static("IsValid_s",
                    (Standard_Boolean (*)(  const TopTools_ListOfShape & ,   const TopoDS_Shape & ,   const Standard_Boolean ,   const Standard_Boolean  ) ) static_cast<Standard_Boolean (*)(  const TopTools_ListOfShape & ,   const TopoDS_Shape & ,   const Standard_Boolean ,   const Standard_Boolean  ) >(&BRepAlgo::IsValid),
                    R"#(Checks if the Generated and Modified Faces from the shapes <arguments> in the shape <result> are "correct". The args may be empty, then all faces will be checked. If <Closed> is True, only closed shape are valid. If <GeomCtrl> is False the geometry of new vertices and edges are not verified and the auto-intersection of new wires are not searched.)#"  , py::arg("theArgs"),  py::arg("theResult"),  py::arg("closedSolid")=static_cast< const Standard_Boolean>(Standard_False),  py::arg("GeomCtrl")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def_static("IsTopologicallyValid_s",
                    (Standard_Boolean (*)(  const TopoDS_Shape &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Shape &  ) >(&BRepAlgo::IsTopologicallyValid),
                    R"#(Checks if the shape is "correct". If not, returns FALSE, else returns TRUE. This method differs from the previous one in the fact that no geometric controls (intersection of wires, pcurve validity) are performed.)#"  , py::arg("S")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BRepAlgo_AsDes from ./opencascade/BRepAlgo_AsDes.hxx
    klass = m.attr("BRepAlgo_AsDes");


    // nested enums

    static_cast<py::class_<BRepAlgo_AsDes ,opencascade::handle<BRepAlgo_AsDes>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Clear",
             (void (BRepAlgo_AsDes::*)() ) static_cast<void (BRepAlgo_AsDes::*)() >(&BRepAlgo_AsDes::Clear),
             R"#()#" 
          )
        .def("Add",
             (void (BRepAlgo_AsDes::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<void (BRepAlgo_AsDes::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&BRepAlgo_AsDes::Add),
             R"#(Stores <SS> as a futur subshape of <S>.)#"  , py::arg("S"),  py::arg("SS")
          )
        .def("Add",
             (void (BRepAlgo_AsDes::*)(  const TopoDS_Shape & ,   const TopTools_ListOfShape &  ) ) static_cast<void (BRepAlgo_AsDes::*)(  const TopoDS_Shape & ,   const TopTools_ListOfShape &  ) >(&BRepAlgo_AsDes::Add),
             R"#(Stores <SS> as futurs SubShapes of <S>.)#"  , py::arg("S"),  py::arg("SS")
          )
        .def("HasAscendant",
             (Standard_Boolean (BRepAlgo_AsDes::*)(  const TopoDS_Shape &  ) const) static_cast<Standard_Boolean (BRepAlgo_AsDes::*)(  const TopoDS_Shape &  ) const>(&BRepAlgo_AsDes::HasAscendant),
             R"#()#"  , py::arg("S")
          )
        .def("HasDescendant",
             (Standard_Boolean (BRepAlgo_AsDes::*)(  const TopoDS_Shape &  ) const) static_cast<Standard_Boolean (BRepAlgo_AsDes::*)(  const TopoDS_Shape &  ) const>(&BRepAlgo_AsDes::HasDescendant),
             R"#()#"  , py::arg("S")
          )
        .def("Ascendant",
             ( const TopTools_ListOfShape & (BRepAlgo_AsDes::*)(  const TopoDS_Shape &  ) const) static_cast< const TopTools_ListOfShape & (BRepAlgo_AsDes::*)(  const TopoDS_Shape &  ) const>(&BRepAlgo_AsDes::Ascendant),
             R"#(Returns the Shape containing <S>.)#"  , py::arg("S")
          )
        .def("Descendant",
             ( const TopTools_ListOfShape & (BRepAlgo_AsDes::*)(  const TopoDS_Shape &  ) const) static_cast< const TopTools_ListOfShape & (BRepAlgo_AsDes::*)(  const TopoDS_Shape &  ) const>(&BRepAlgo_AsDes::Descendant),
             R"#(Returns futur subhapes of <S>.)#"  , py::arg("S")
          )
        .def("ChangeDescendant",
             (TopTools_ListOfShape & (BRepAlgo_AsDes::*)(  const TopoDS_Shape &  ) ) static_cast<TopTools_ListOfShape & (BRepAlgo_AsDes::*)(  const TopoDS_Shape &  ) >(&BRepAlgo_AsDes::ChangeDescendant),
             R"#(Returns futur subhapes of <S>.)#"  , py::arg("S")
          )
        .def("Replace",
             (void (BRepAlgo_AsDes::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<void (BRepAlgo_AsDes::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&BRepAlgo_AsDes::Replace),
             R"#(Replace theOldS by theNewS. theOldS disappear from this.)#"  , py::arg("theOldS"),  py::arg("theNewS")
          )
        .def("Remove",
             (void (BRepAlgo_AsDes::*)(  const TopoDS_Shape &  ) ) static_cast<void (BRepAlgo_AsDes::*)(  const TopoDS_Shape &  ) >(&BRepAlgo_AsDes::Remove),
             R"#(Remove theS from me.)#"  , py::arg("theS")
          )
        .def("HasCommonDescendant",
             (Standard_Boolean (BRepAlgo_AsDes::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,  TopTools_ListOfShape &  ) const) static_cast<Standard_Boolean (BRepAlgo_AsDes::*)(  const TopoDS_Shape & ,   const TopoDS_Shape & ,  TopTools_ListOfShape &  ) const>(&BRepAlgo_AsDes::HasCommonDescendant),
             R"#(Returns True if (S1> and <S2> has common Descendants. Stores in <LC> the Commons Descendants.)#"  , py::arg("S1"),  py::arg("S2"),  py::arg("LC")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BRepAlgo_AsDes::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BRepAlgo_AsDes::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BRepAlgo_AsDes::*)() const) static_cast< const handle<Standard_Type> & (BRepAlgo_AsDes::*)() const>(&BRepAlgo_AsDes::DynamicType),
             R"#()#"
             
         )
;

    // Class BRepAlgo_FaceRestrictor from ./opencascade/BRepAlgo_FaceRestrictor.hxx
    klass = m.attr("BRepAlgo_FaceRestrictor");


    // nested enums

    static_cast<py::class_<BRepAlgo_FaceRestrictor , shared_ptr<BRepAlgo_FaceRestrictor>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Init",
             (void (BRepAlgo_FaceRestrictor::*)(  const TopoDS_Face & ,   const Standard_Boolean ,   const Standard_Boolean  ) ) static_cast<void (BRepAlgo_FaceRestrictor::*)(  const TopoDS_Face & ,   const Standard_Boolean ,   const Standard_Boolean  ) >(&BRepAlgo_FaceRestrictor::Init),
             R"#(the surface of <F> will be the surface of each new faces built. <Proj> is used to update pcurves on edges if necessary. See Add().)#"  , py::arg("F"),  py::arg("Proj")=static_cast< const Standard_Boolean>(Standard_False),  py::arg("ControlOrientation")=static_cast< const Standard_Boolean>(Standard_False)
          )
        .def("Add",
             (void (BRepAlgo_FaceRestrictor::*)( TopoDS_Wire &  ) ) static_cast<void (BRepAlgo_FaceRestrictor::*)( TopoDS_Wire &  ) >(&BRepAlgo_FaceRestrictor::Add),
             R"#(Add the wire <W> to the set of wires.)#"  , py::arg("W")
          )
        .def("Clear",
             (void (BRepAlgo_FaceRestrictor::*)() ) static_cast<void (BRepAlgo_FaceRestrictor::*)() >(&BRepAlgo_FaceRestrictor::Clear),
             R"#(Removes all the Wires)#" 
          )
        .def("Perform",
             (void (BRepAlgo_FaceRestrictor::*)() ) static_cast<void (BRepAlgo_FaceRestrictor::*)() >(&BRepAlgo_FaceRestrictor::Perform),
             R"#(Evaluate all the faces limited by the set of Wires.)#" 
          )
        .def("IsDone",
             (Standard_Boolean (BRepAlgo_FaceRestrictor::*)() const) static_cast<Standard_Boolean (BRepAlgo_FaceRestrictor::*)() const>(&BRepAlgo_FaceRestrictor::IsDone),
             R"#()#" 
          )
        .def("More",
             (Standard_Boolean (BRepAlgo_FaceRestrictor::*)() const) static_cast<Standard_Boolean (BRepAlgo_FaceRestrictor::*)() const>(&BRepAlgo_FaceRestrictor::More),
             R"#()#" 
          )
        .def("Next",
             (void (BRepAlgo_FaceRestrictor::*)() ) static_cast<void (BRepAlgo_FaceRestrictor::*)() >(&BRepAlgo_FaceRestrictor::Next),
             R"#()#" 
          )
        .def("Current",
             (TopoDS_Face (BRepAlgo_FaceRestrictor::*)() const) static_cast<TopoDS_Face (BRepAlgo_FaceRestrictor::*)() const>(&BRepAlgo_FaceRestrictor::Current),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BRepAlgo_Image from ./opencascade/BRepAlgo_Image.hxx
    klass = m.attr("BRepAlgo_Image");


    // nested enums

    static_cast<py::class_<BRepAlgo_Image , shared_ptr<BRepAlgo_Image>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetRoot",
             (void (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) ) static_cast<void (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) >(&BRepAlgo_Image::SetRoot),
             R"#()#"  , py::arg("S")
          )
        .def("Bind",
             (void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&BRepAlgo_Image::Bind),
             R"#(Links <NewS> as image of <OldS>.)#"  , py::arg("OldS"),  py::arg("NewS")
          )
        .def("Bind",
             (void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,   const TopTools_ListOfShape &  ) ) static_cast<void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,   const TopTools_ListOfShape &  ) >(&BRepAlgo_Image::Bind),
             R"#(Links <NewS> as image of <OldS>.)#"  , py::arg("OldS"),  py::arg("NewS")
          )
        .def("Add",
             (void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&BRepAlgo_Image::Add),
             R"#(Add <NewS> to the image of <OldS>.)#"  , py::arg("OldS"),  py::arg("NewS")
          )
        .def("Add",
             (void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,   const TopTools_ListOfShape &  ) ) static_cast<void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,   const TopTools_ListOfShape &  ) >(&BRepAlgo_Image::Add),
             R"#(Add <NewS> to the image of <OldS>.)#"  , py::arg("OldS"),  py::arg("NewS")
          )
        .def("Clear",
             (void (BRepAlgo_Image::*)() ) static_cast<void (BRepAlgo_Image::*)() >(&BRepAlgo_Image::Clear),
             R"#()#" 
          )
        .def("Remove",
             (void (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) ) static_cast<void (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) >(&BRepAlgo_Image::Remove),
             R"#(Remove <S> to set of images.)#"  , py::arg("S")
          )
        .def("RemoveRoot",
             (void (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) ) static_cast<void (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) >(&BRepAlgo_Image::RemoveRoot),
             R"#(Removes the root <theRoot> from the list of roots and up and down maps.)#"  , py::arg("Root")
          )
        .def("ReplaceRoot",
             (void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&BRepAlgo_Image::ReplaceRoot),
             R"#(Replaces the <OldRoot> with the <NewRoot>, so all images of the <OldRoot> become the images of the <NewRoot>. The <OldRoot> is removed.)#"  , py::arg("OldRoot"),  py::arg("NewRoot")
          )
        .def("IsImage",
             (Standard_Boolean (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) const) static_cast<Standard_Boolean (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) const>(&BRepAlgo_Image::IsImage),
             R"#()#"  , py::arg("S")
          )
        .def("ImageFrom",
             ( const TopoDS_Shape & (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) const) static_cast< const TopoDS_Shape & (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) const>(&BRepAlgo_Image::ImageFrom),
             R"#(Returns the generator of <S>)#"  , py::arg("S")
          )
        .def("Root",
             ( const TopoDS_Shape & (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) const) static_cast< const TopoDS_Shape & (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) const>(&BRepAlgo_Image::Root),
             R"#(Returns the upper generator of <S>)#"  , py::arg("S")
          )
        .def("HasImage",
             (Standard_Boolean (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) const) static_cast<Standard_Boolean (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) const>(&BRepAlgo_Image::HasImage),
             R"#()#"  , py::arg("S")
          )
        .def("Image",
             ( const TopTools_ListOfShape & (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) const) static_cast< const TopTools_ListOfShape & (BRepAlgo_Image::*)(  const TopoDS_Shape &  ) const>(&BRepAlgo_Image::Image),
             R"#(Returns the Image of <S>. Returns <S> in the list if HasImage(S) is false.)#"  , py::arg("S")
          )
        .def("LastImage",
             (void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,  TopTools_ListOfShape &  ) const) static_cast<void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,  TopTools_ListOfShape &  ) const>(&BRepAlgo_Image::LastImage),
             R"#(Stores in <L> the images of images of...images of <S>. <L> contains only <S> if HasImage(S) is false.)#"  , py::arg("S"),  py::arg("L")
          )
        .def("Compact",
             (void (BRepAlgo_Image::*)() ) static_cast<void (BRepAlgo_Image::*)() >(&BRepAlgo_Image::Compact),
             R"#(Keeps only the link between roots and lastimage.)#" 
          )
        .def("Filter",
             (void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,   const TopAbs_ShapeEnum  ) ) static_cast<void (BRepAlgo_Image::*)(  const TopoDS_Shape & ,   const TopAbs_ShapeEnum  ) >(&BRepAlgo_Image::Filter),
             R"#(Deletes in the images the shape of type <ShapeType> which are not in <S>. Warning: Compact() must be call before.)#"  , py::arg("S"),  py::arg("ShapeType")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Roots",
             ( const TopTools_ListOfShape & (BRepAlgo_Image::*)() const) static_cast< const TopTools_ListOfShape & (BRepAlgo_Image::*)() const>(&BRepAlgo_Image::Roots),
             R"#()#"
             
         )
;

    // Class BRepAlgo_Loop from ./opencascade/BRepAlgo_Loop.hxx
    klass = m.attr("BRepAlgo_Loop");


    // nested enums

    static_cast<py::class_<BRepAlgo_Loop , shared_ptr<BRepAlgo_Loop>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Init",
             (void (BRepAlgo_Loop::*)(  const TopoDS_Face &  ) ) static_cast<void (BRepAlgo_Loop::*)(  const TopoDS_Face &  ) >(&BRepAlgo_Loop::Init),
             R"#(Init with <F> the set of edges must have pcurves on <F>.)#"  , py::arg("F")
          )
        .def("AddEdge",
             (void (BRepAlgo_Loop::*)( TopoDS_Edge & ,   const TopTools_ListOfShape &  ) ) static_cast<void (BRepAlgo_Loop::*)( TopoDS_Edge & ,   const TopTools_ListOfShape &  ) >(&BRepAlgo_Loop::AddEdge),
             R"#(Add E with <LV>. <E> will be copied and trim by vertices in <LV>.)#"  , py::arg("E"),  py::arg("LV")
          )
        .def("AddConstEdge",
             (void (BRepAlgo_Loop::*)(  const TopoDS_Edge &  ) ) static_cast<void (BRepAlgo_Loop::*)(  const TopoDS_Edge &  ) >(&BRepAlgo_Loop::AddConstEdge),
             R"#(Add <E> as const edge, E can be in the result.)#"  , py::arg("E")
          )
        .def("AddConstEdges",
             (void (BRepAlgo_Loop::*)(  const TopTools_ListOfShape &  ) ) static_cast<void (BRepAlgo_Loop::*)(  const TopTools_ListOfShape &  ) >(&BRepAlgo_Loop::AddConstEdges),
             R"#(Add <LE> as a set of const edges.)#"  , py::arg("LE")
          )
        .def("SetImageVV",
             (void (BRepAlgo_Loop::*)(  const BRepAlgo_Image &  ) ) static_cast<void (BRepAlgo_Loop::*)(  const BRepAlgo_Image &  ) >(&BRepAlgo_Loop::SetImageVV),
             R"#(Sets the Image Vertex - Vertex)#"  , py::arg("theImageVV")
          )
        .def("Perform",
             (void (BRepAlgo_Loop::*)() ) static_cast<void (BRepAlgo_Loop::*)() >(&BRepAlgo_Loop::Perform),
             R"#(Make loops.)#" 
          )
        .def("UpdateVEmap",
             (void (BRepAlgo_Loop::*)( TopTools_IndexedDataMapOfShapeListOfShape &  ) ) static_cast<void (BRepAlgo_Loop::*)( TopTools_IndexedDataMapOfShapeListOfShape &  ) >(&BRepAlgo_Loop::UpdateVEmap),
             R"#(Update VE map according to Image Vertex - Vertex)#"  , py::arg("theVEmap")
          )
        .def("CutEdge",
             (void (BRepAlgo_Loop::*)(  const TopoDS_Edge & ,   const TopTools_ListOfShape & ,  TopTools_ListOfShape &  ) const) static_cast<void (BRepAlgo_Loop::*)(  const TopoDS_Edge & ,   const TopTools_ListOfShape & ,  TopTools_ListOfShape &  ) const>(&BRepAlgo_Loop::CutEdge),
             R"#(Cut the edge <E> in several edges <NE> on the vertices<VonE>.)#"  , py::arg("E"),  py::arg("VonE"),  py::arg("NE")
          )
        .def("WiresToFaces",
             (void (BRepAlgo_Loop::*)() ) static_cast<void (BRepAlgo_Loop::*)() >(&BRepAlgo_Loop::WiresToFaces),
             R"#(Build faces from the wires result.)#" 
          )
        .def("NewEdges",
             ( const TopTools_ListOfShape & (BRepAlgo_Loop::*)(  const TopoDS_Edge &  ) const) static_cast< const TopTools_ListOfShape & (BRepAlgo_Loop::*)(  const TopoDS_Edge &  ) const>(&BRepAlgo_Loop::NewEdges),
             R"#(Returns the list of new edges built from an edge <E> it can be an empty list.)#"  , py::arg("E")
          )
        .def("GetVerticesForSubstitute",
             (void (BRepAlgo_Loop::*)( TopTools_DataMapOfShapeShape &  ) const) static_cast<void (BRepAlgo_Loop::*)( TopTools_DataMapOfShapeShape &  ) const>(&BRepAlgo_Loop::GetVerticesForSubstitute),
             R"#(Returns the datamap of vertices with their substitutes.)#"  , py::arg("VerVerMap")
          )
        .def("VerticesForSubstitute",
             (void (BRepAlgo_Loop::*)( TopTools_DataMapOfShapeShape &  ) ) static_cast<void (BRepAlgo_Loop::*)( TopTools_DataMapOfShapeShape &  ) >(&BRepAlgo_Loop::VerticesForSubstitute),
             R"#()#"  , py::arg("VerVerMap")
          )
        .def("SetTolConf",
             (void (BRepAlgo_Loop::*)(  const Standard_Real  ) ) static_cast<void (BRepAlgo_Loop::*)(  const Standard_Real  ) >(&BRepAlgo_Loop::SetTolConf),
             R"#(Set maximal tolerance used for comparing distances between vertices.)#"  , py::arg("theTolConf")
          )
        .def("GetTolConf",
             (Standard_Real (BRepAlgo_Loop::*)() const) static_cast<Standard_Real (BRepAlgo_Loop::*)() const>(&BRepAlgo_Loop::GetTolConf),
             R"#(Get maximal tolerance used for comparing distances between vertices.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("NewWires",
             ( const TopTools_ListOfShape & (BRepAlgo_Loop::*)() const) static_cast< const TopTools_ListOfShape & (BRepAlgo_Loop::*)() const>(&BRepAlgo_Loop::NewWires),
             R"#(Returns the list of wires performed. can be an empty list.)#"
             
         )
       .def("NewFaces",
             ( const TopTools_ListOfShape & (BRepAlgo_Loop::*)() const) static_cast< const TopTools_ListOfShape & (BRepAlgo_Loop::*)() const>(&BRepAlgo_Loop::NewFaces),
             R"#(Returns the list of faces. Warning: The method <WiresToFaces> as to be called before. can be an empty list.)#"
             
         )
;

    // Class BRepAlgo_NormalProjection from ./opencascade/BRepAlgo_NormalProjection.hxx
    klass = m.attr("BRepAlgo_NormalProjection");


    // nested enums

    static_cast<py::class_<BRepAlgo_NormalProjection , shared_ptr<BRepAlgo_NormalProjection>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopoDS_Shape & >()  , py::arg("S") )
    // custom constructors
    // methods
        .def("Init",
             (void (BRepAlgo_NormalProjection::*)(  const TopoDS_Shape &  ) ) static_cast<void (BRepAlgo_NormalProjection::*)(  const TopoDS_Shape &  ) >(&BRepAlgo_NormalProjection::Init),
             R"#()#"  , py::arg("S")
          )
        .def("Add",
             (void (BRepAlgo_NormalProjection::*)(  const TopoDS_Shape &  ) ) static_cast<void (BRepAlgo_NormalProjection::*)(  const TopoDS_Shape &  ) >(&BRepAlgo_NormalProjection::Add),
             R"#(Add an edge or a wire to the list of shape to project)#"  , py::arg("ToProj")
          )
        .def("SetParams",
             (void (BRepAlgo_NormalProjection::*)(  const Standard_Real ,   const Standard_Real ,   const GeomAbs_Shape ,   const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (BRepAlgo_NormalProjection::*)(  const Standard_Real ,   const Standard_Real ,   const GeomAbs_Shape ,   const Standard_Integer ,   const Standard_Integer  ) >(&BRepAlgo_NormalProjection::SetParams),
             R"#(Set the parameters used for computation Tol3d is the required tolerance between the 3d projected curve and its 2d representation InternalContinuity is the order of constraints used for approximation. MaxDeg and MaxSeg are the maximum degree and the maximum number of segment for BSpline resulting of an approximation.)#"  , py::arg("Tol3D"),  py::arg("Tol2D"),  py::arg("InternalContinuity"),  py::arg("MaxDegree"),  py::arg("MaxSeg")
          )
        .def("SetDefaultParams",
             (void (BRepAlgo_NormalProjection::*)() ) static_cast<void (BRepAlgo_NormalProjection::*)() >(&BRepAlgo_NormalProjection::SetDefaultParams),
             R"#(Set the parameters used for computation in their default values)#" 
          )
        .def("SetMaxDistance",
             (void (BRepAlgo_NormalProjection::*)(  const Standard_Real  ) ) static_cast<void (BRepAlgo_NormalProjection::*)(  const Standard_Real  ) >(&BRepAlgo_NormalProjection::SetMaxDistance),
             R"#(Sets the maximum distance between target shape and shape to project. If this condition is not satisfied then corresponding part of solution is discarded. if MaxDist < 0 then this method does not affect the algorithm)#"  , py::arg("MaxDist")
          )
        .def("Compute3d",
             (void (BRepAlgo_NormalProjection::*)(  const Standard_Boolean  ) ) static_cast<void (BRepAlgo_NormalProjection::*)(  const Standard_Boolean  ) >(&BRepAlgo_NormalProjection::Compute3d),
             R"#(if With3d = Standard_False the 3dcurve is not computed the initial 3dcurve is kept to build the resulting edges.)#"  , py::arg("With3d")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("SetLimit",
             (void (BRepAlgo_NormalProjection::*)(  const Standard_Boolean  ) ) static_cast<void (BRepAlgo_NormalProjection::*)(  const Standard_Boolean  ) >(&BRepAlgo_NormalProjection::SetLimit),
             R"#(Manage limitation of projected edges.)#"  , py::arg("FaceBoundaries")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("Build",
             (void (BRepAlgo_NormalProjection::*)() ) static_cast<void (BRepAlgo_NormalProjection::*)() >(&BRepAlgo_NormalProjection::Build),
             R"#(Builds the result as a compound.)#" 
          )
        .def("IsDone",
             (Standard_Boolean (BRepAlgo_NormalProjection::*)() const) static_cast<Standard_Boolean (BRepAlgo_NormalProjection::*)() const>(&BRepAlgo_NormalProjection::IsDone),
             R"#()#" 
          )
        .def("Ancestor",
             ( const TopoDS_Shape & (BRepAlgo_NormalProjection::*)(  const TopoDS_Edge &  ) const) static_cast< const TopoDS_Shape & (BRepAlgo_NormalProjection::*)(  const TopoDS_Edge &  ) const>(&BRepAlgo_NormalProjection::Ancestor),
             R"#(For a resulting edge, returns the corresponding initial edge.)#"  , py::arg("E")
          )
        .def("Couple",
             ( const TopoDS_Shape & (BRepAlgo_NormalProjection::*)(  const TopoDS_Edge &  ) const) static_cast< const TopoDS_Shape & (BRepAlgo_NormalProjection::*)(  const TopoDS_Edge &  ) const>(&BRepAlgo_NormalProjection::Couple),
             R"#(For a projected edge, returns the corresponding initial face.)#"  , py::arg("E")
          )
        .def("Generated",
             ( const TopTools_ListOfShape & (BRepAlgo_NormalProjection::*)(  const TopoDS_Shape &  ) ) static_cast< const TopTools_ListOfShape & (BRepAlgo_NormalProjection::*)(  const TopoDS_Shape &  ) >(&BRepAlgo_NormalProjection::Generated),
             R"#(Returns the list of shapes generated from the shape <S>.)#"  , py::arg("S")
          )
        .def("IsElementary",
             (Standard_Boolean (BRepAlgo_NormalProjection::*)(  const Adaptor3d_Curve &  ) const) static_cast<Standard_Boolean (BRepAlgo_NormalProjection::*)(  const Adaptor3d_Curve &  ) const>(&BRepAlgo_NormalProjection::IsElementary),
             R"#()#"  , py::arg("C")
          )
        .def("BuildWire",
             (Standard_Boolean (BRepAlgo_NormalProjection::*)( TopTools_ListOfShape &  ) const) static_cast<Standard_Boolean (BRepAlgo_NormalProjection::*)( TopTools_ListOfShape &  ) const>(&BRepAlgo_NormalProjection::BuildWire),
             R"#(build the result as a list of wire if possible in -- a first returns a wire only if there is only a wire.)#"  , py::arg("Liste")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Projection",
             ( const TopoDS_Shape & (BRepAlgo_NormalProjection::*)() const) static_cast< const TopoDS_Shape & (BRepAlgo_NormalProjection::*)() const>(&BRepAlgo_NormalProjection::Projection),
             R"#(returns the result)#"
             
         )
;

// functions

// ./opencascade/BRepAlgo.hxx
// ./opencascade/BRepAlgo_AsDes.hxx
// ./opencascade/BRepAlgo_FaceRestrictor.hxx
// ./opencascade/BRepAlgo_Image.hxx
// ./opencascade/BRepAlgo_Loop.hxx
// ./opencascade/BRepAlgo_NormalProjection.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
