# Model Bakery: Smart fixtures for better tests

Model Bakery offers you a smart way to create fixtures for testing in Django.

With a simple and powerful API, you can create many objects with a single line of code.

Model Bakery is a rename of the legacy [model_mommy\'s project](https://pypi.org/project/model_mommy/). This is because the project\'s creator and maintainers decided to not reinforce gender stereotypes for women in technology. You can read more about this subject[here](https://witi.com/articles/1017/How-Gender-Stereotypes-are-Still-Affecting-Women-in-Tech/).

# Compatibility

Model Bakery supports Django \>= 4.2.

# Install

Install it with `pip`

```console
$ pip install model-bakery
```

# Contributing to Model Bakery

As an open-source project, Model Bakery welcomes contributions of many forms. Examples of contributions include:

- Code Patches
- Documentation improvements
- Bug reports

Take a look in our [GitHub repo](https://github.com/model-bakers/model_bakery/blob/main/CONTRIBUTING.md) for more instructions on how to set up your local environment to help Model Bakery to grow.

# Doubts? Loved it? Hated it? Suggestions?

Feel free to [open an issue](https://github.com/model-bakers/model_bakery/issues/new) for support, development or ideas!

## Contents

```{toctree}
:maxdepth: 4

basic_usage
recipes
how_bakery_behaves
test_runners
migrating_from_mommy
```
