# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql.aio import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementManagedDatabasesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_databases_list_by_instance(self, resource_group):
        response = self.client.managed_databases.list_by_instance(
            resource_group_name=resource_group.name,
            managed_instance_name="str",
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_databases_get(self, resource_group):
        response = await self.client.managed_databases.get(
            resource_group_name=resource_group.name,
            managed_instance_name="str",
            database_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_databases_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.managed_databases.begin_create_or_update(
                resource_group_name=resource_group.name,
                managed_instance_name="str",
                database_name="str",
                parameters={
                    "location": "str",
                    "autoCompleteRestore": bool,
                    "catalogCollation": "str",
                    "collation": "str",
                    "createMode": "str",
                    "creationDate": "2020-02-20 00:00:00",
                    "crossSubscriptionRestorableDroppedDatabaseId": "str",
                    "crossSubscriptionSourceDatabaseId": "str",
                    "crossSubscriptionTargetManagedInstanceId": "str",
                    "defaultSecondaryLocation": "str",
                    "earliestRestorePoint": "2020-02-20 00:00:00",
                    "failoverGroupId": "str",
                    "id": "str",
                    "isLedgerOn": bool,
                    "lastBackupName": "str",
                    "longTermRetentionBackupResourceId": "str",
                    "name": "str",
                    "recoverableDatabaseId": "str",
                    "restorableDroppedDatabaseId": "str",
                    "restorePointInTime": "2020-02-20 00:00:00",
                    "sourceDatabaseId": "str",
                    "status": "str",
                    "storageContainerIdentity": "str",
                    "storageContainerSasToken": "str",
                    "storageContainerUri": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_databases_begin_delete(self, resource_group):
        response = await (
            await self.client.managed_databases.begin_delete(
                resource_group_name=resource_group.name,
                managed_instance_name="str",
                database_name="str",
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_databases_begin_update(self, resource_group):
        response = await (
            await self.client.managed_databases.begin_update(
                resource_group_name=resource_group.name,
                managed_instance_name="str",
                database_name="str",
                parameters={
                    "autoCompleteRestore": bool,
                    "catalogCollation": "str",
                    "collation": "str",
                    "createMode": "str",
                    "creationDate": "2020-02-20 00:00:00",
                    "crossSubscriptionRestorableDroppedDatabaseId": "str",
                    "crossSubscriptionSourceDatabaseId": "str",
                    "crossSubscriptionTargetManagedInstanceId": "str",
                    "defaultSecondaryLocation": "str",
                    "earliestRestorePoint": "2020-02-20 00:00:00",
                    "failoverGroupId": "str",
                    "isLedgerOn": bool,
                    "lastBackupName": "str",
                    "longTermRetentionBackupResourceId": "str",
                    "recoverableDatabaseId": "str",
                    "restorableDroppedDatabaseId": "str",
                    "restorePointInTime": "2020-02-20 00:00:00",
                    "sourceDatabaseId": "str",
                    "status": "str",
                    "storageContainerIdentity": "str",
                    "storageContainerSasToken": "str",
                    "storageContainerUri": "str",
                    "tags": {"str": "str"},
                },
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_databases_begin_cancel_move(self, resource_group):
        response = await (
            await self.client.managed_databases.begin_cancel_move(
                resource_group_name=resource_group.name,
                managed_instance_name="str",
                database_name="str",
                parameters={"destinationManagedDatabaseId": "str"},
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_databases_begin_complete_move(self, resource_group):
        response = await (
            await self.client.managed_databases.begin_complete_move(
                resource_group_name=resource_group.name,
                managed_instance_name="str",
                database_name="str",
                parameters={"destinationManagedDatabaseId": "str"},
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_databases_begin_complete_restore(self, resource_group):
        response = await (
            await self.client.managed_databases.begin_complete_restore(
                resource_group_name=resource_group.name,
                managed_instance_name="str",
                database_name="str",
                parameters={"lastBackupName": "str"},
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_databases_begin_start_move(self, resource_group):
        response = await (
            await self.client.managed_databases.begin_start_move(
                resource_group_name=resource_group.name,
                managed_instance_name="str",
                database_name="str",
                parameters={"destinationManagedDatabaseId": "str", "operationMode": "str"},
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_databases_list_inaccessible_by_instance(self, resource_group):
        response = self.client.managed_databases.list_inaccessible_by_instance(
            resource_group_name=resource_group.name,
            managed_instance_name="str",
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
