#/
# @license Apache-2.0
#
# Copyright (c) 2017 The Stdlib Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#/

# RULES #

#/
# Runs C++ benchmarks consecutively.
#
# ## Notes
#
# -   The recipe delegates to local Makefiles which are responsible for actually compiling and running the respective benchmarks.
# -   This rule is useful when wanting to glob for C++ benchmark files (e.g., run all C++ benchmarks for a particular package).
#
#
# @param {string} [BENCHMARKS_FILTER] - file path pattern (e.g., `.*/math/base/special/beta/.*`)
# @param {string} [CXX_COMPILER] - C++ compiler (e.g., `g++`)
#
# @example
# make benchmark-cpp
#
# @example
# make benchmark-cpp BENCHMARKS_FILTER=".*/math/base/special/beta/.*"
#/
benchmark-cpp:
	$(QUIET) $(FIND_CPP_BENCHMARKS_CMD) | grep '^[\/]\|^[a-zA-Z]:[/\]' | while read -r file; do \
		echo ""; \
		echo "Running benchmark: $$file"; \
		cd `dirname $$file` && \
		$(MAKE) clean && \
		CXX_COMPILER="$(CXX)" \
		BOOST="$(DEPS_BOOST_BUILD_OUT)" $(MAKE) && \
		$(MAKE) run || exit 1; \
	done

.PHONY: benchmark-cpp

#/
# Runs a specified list of C++ benchmarks consecutively.
#
# ## Notes
#
# -   The recipe delegates to local Makefiles which are responsible for actually compiling and running the respective benchmarks.
# -   This rule is useful when wanting to run a list of C++ benchmark files generated by some other command (e.g., a list of changed C++ benchmark files obtained via `git diff`).
#
#
# @param {string} FILES - list of C++ benchmark file paths
# @param {string} [CXX_COMPILER] - C++ compiler (e.g., `g++`)
#
# @example
# make benchmark-cpp-files FILES='/foo/benchmark.cpp /bar/benchmark.cpp'
#/
benchmark-cpp-files:
	$(QUIET) for file in $(FILES); do \
		echo ""; \
		echo "Running benchmark: $$file"; \
		cd `dirname $$file` && \
		$(MAKE) clean && \
		CXX_COMPILER="$(CXX)" \
		BOOST="$(DEPS_BOOST_BUILD_OUT)" $(MAKE) && \
		$(MAKE) run || exit 1; \
	done

.PHONY: benchmark-cpp-files
