QUnit.test('Reflect.hasMetadata', assert => {
  const { defineMetadata, hasMetadata } = Reflect;
  const { create } = Object;
  assert.isFunction(hasMetadata);
  assert.arity(hasMetadata, 2);
  assert.name(hasMetadata, 'hasMetadata');
  assert.looksNative(hasMetadata);
  assert.nonEnumerable(Reflect, 'hasMetadata');
  assert.throws(() => hasMetadata('key', undefined, undefined), TypeError);
  assert.false(hasMetadata('key', {}, undefined));
  let object = {};
  defineMetadata('key', 'value', object, undefined);
  assert.true(hasMetadata('key', object, undefined));
  let prototype = {};
  object = create(prototype);
  defineMetadata('key', 'value', prototype, undefined);
  assert.true(hasMetadata('key', object, undefined));
  assert.false(hasMetadata('key', {}, 'name'));
  object = {};
  defineMetadata('key', 'value', object, 'name');
  assert.true(hasMetadata('key', object, 'name'));
  prototype = {};
  object = create(prototype);
  defineMetadata('key', 'value', prototype, 'name');
  assert.true(hasMetadata('key', object, 'name'));
});
