/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sejda.sambox.cos;

import java.util.Calendar;

/**
 * An unmodifiable COSDictionary.
 *
 * @author John Hewson
 */
final class UnmodifiableCOSDictionary extends COSDictionary
{
    UnmodifiableCOSDictionary(COSDictionary dict)
    {
        super(dict);
    }

    @Override
    public void clear()
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setItem(COSName key, COSBase value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setItem(COSName key, COSObjectable value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setItem(String key, COSObjectable value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBoolean(String key, boolean value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBoolean(COSName key, boolean value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setItem(String key, COSBase value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setName(String key, String value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setName(COSName key, String value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(String key, Calendar date)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(COSName key, Calendar date)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEmbeddedDate(String embedded, String key, Calendar date)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEmbeddedDate(String embedded, COSName key, Calendar date)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setString(String key, String value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setString(COSName key, String value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEmbeddedString(String embedded, String key, String value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEmbeddedString(String embedded, COSName key, String value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(String key, int value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(COSName key, int value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLong(String key, long value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLong(COSName key, long value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEmbeddedInt(String embeddedDictionary, String key, long value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEmbeddedInt(String embeddedDictionary, COSName key, long value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFloat(String key, float value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFloat(COSName key, float value)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeItem(COSName key)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAll(COSDictionary dic)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mergeWithoutOverwriting(COSDictionary dic)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void merge(COSDictionary dic)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFlag(COSName field, int bitFlag, boolean value)
    {
        throw new UnsupportedOperationException();
    }
}
