#
# spec file for package binutils (Version 2.16.91.0.5)
#
# Copyright (c) 2006 SUSE LINUX Products GmbH, Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

# norootforbuild

Name:         cross-x86_64-binutils
BuildRequires:  dejagnu gcc-c++
#
# RUN_TESTS
%define run_tests %(test ! -f %_sourcedir/RUN_TESTS ; echo $?)
# check the vanilla binutils, with no patches applied
# TEST_VANILLA
%define test_vanilla %(test ! -f %_sourcedir/TEST_VANILLA ; echo $?)
#
# handle test suite failures
#
%ifarch alpha armv4l hppa mips ppc64 sparc sparc64
%define	make_check_handling	true
%else
%define	make_check_handling	false
%endif
# let make check fail anyway if RUN_TESTS was requested
%if %{run_tests}
%define	make_check_handling	false
%endif
# handle all binary object formats supported by SuSE (and a few more)
%ifarch %ix86 ia64 ppc ppc64 s390 s390x x86_64
%define build_multitarget 1
%else
%define build_multitarget 0
%endif
%define target_list alpha arm hppa i686 ia64 m68k powerpc powerpc64 s390 s390x sparc sparc64 x86_64
#
#
#
URL:            http://www.gnu.org/software/binutils/
License:        LGPL
Group:          Development/Tools/Building
PreReq:         %{install_info_prereq}
%if "%name" == "binutils"
Obsoletes:      binuti_o
%endif
Autoreqprov:    on
Version:        2.16.91.0.5
Release:        27
Summary:        GNU Binutils
Source:         ftp://ftp.kernel.org/pub/linux/devel/binutils/binutils-%{version}.tar.bz2
Source1:        pre_checkin.sh
Source2:        README.First-for.SuSE.packagers
Patch:          binutils-version.patch
Patch1:         mips-pic.patch
Patch2:         s390x-pic.patch
Patch3:         binutils-skip-rpaths.patch
Patch4:         s390-biarch.diff
Patch5:         x86-64-biarch.patch
Patch6:         unit-at-a-time.patch
Patch7:         ld-dtags.diff
Patch8:         gcc4.diff
Patch9:         testsuite.diff
Patch10:        warn.diff
Patch12:        ppc64-elf-gc-mark-hook.diff
Patch13:        ppc64-gc-sections.diff
Patch14:        objdump-arm.diff
Patch15:        large-binutils.diff
Patch16:        s390-pic-dso.diff
Patch17:        suse-bdirect.diff
Patch18:        suse-dynsort.diff
Patch19:        suse-hashvals.diff
Patch20:        bfd-find-nearest-line.diff
Patch21:        pr2442.diff
Patch22:        pr2513.diff
Patch23:        elf-kept-section.diff
Patch24:        dependencies.diff
Patch25:        tekhex.diff
Patch26:        s390-tlsfix.diff
Patch27:        ia64-choose-gp.diff
Patch28:        ppc64-elf-build-stubs.diff
Patch29:        ppc-got-plt-ha-reloc.diff
Patch30:        addend-compare.diff
# Collected by Alan Modra
Patch42:        lookup-symbol-in-function-table.diff
Patch43:        ppc-stub-sym.diff
Patch44:        ppc64-opd.diff
Patch45:        ppc64-toc1.diff
Patch46:        gas-close.diff
Patch47:        ld-search-order.diff
Patch48:        eh-frame.diff
Patch49:        dwarf2dbg-file.diff
Patch50:        readelf.diff
Patch51:        concat-filename.diff
Patch52:        ppc-got-reloc.diff
Patch53:        elf-emit-reloc.diff
Patch54:        ppc-tls.diff
Patch55:        elf-fixup.diff
Patch56:        binutils-power6.diff
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
%if "%{name}" != "binutils"
%define	_prefix	/opt/cross
%else
%define	_prefix	/usr
%endif

%description
C compiler utilities: ar, as, gprof, ld, nm, objcopy, objdump, ranlib,
size, strings, and strip. These utilities are needed whenever you want
to compile a program or kernel.

This version has been compiled by SUSE with the corresponding C
library. It is not designed for cross-compiling to other architectures.



Authors:
--------
    Alan Modra <amodra@bigpond.net.au>
    Andreas Jaeger <aj@suse.de>
    Andreas Schwab <schwab@suse.de>
    Bill Cox <bill@cygnus.com>
    Brendan Kehoe <brendan@cygnus.com>
    D. V. Henkel-Wallace <gumby@cygnus.com>
    DJ Delorie <dj@redhat.com>
    David D "Zoo" Zuhn <zoo@cygnus.com>
    David J. Mackenzie <djm@cygnus.com>
    Denis Chertykov <denisc@overta.ru>
    Diego Novillo <dnovillo@redhat.com>
    Doug Evans <dje@cygnus.com>
    Eric Christopher <echristo@redhat.com>
    Eric Youngdale <eric@aib.com>
    Fred Fish <fnf@cygnus.com>
    Geoff Keating <geoffk@redhat.com>
    H.J.Lu <hjl@gnu.org>
    Hans-Peter Nilsson <hp@axis.com>
    Ian Dall <dall@hfrd.dsto.gov.au>
    Ian Taylor <ian@zembu.com>
    J.T. Conklin <jtc@cygnus.com>
    Jakub Jelinek <jakub@redhat.com>
    Jan Hubicka <jh@suse.cz>
    Jason Eckhardt <jle@redhat.com>
    Jason Merrill <jason@redhat.com>
    Jeff Law <law@redhat.com>
    Jeffrey Osier <jeffrey@cygnus.com>
    Jeffrey Wheat <cassidy@cygnus.com>
    Jim Kingdon <kingdon@cygnus.com>
    Jim Wilson <wilson@redhat.com>
    John Gilmore <gnu@cygnus.com>
    Jrn Rennecke <amylaar@redhat.com>
    K. Richard Pixley <rich@cygnus.com>
    Ken Raeburn <raeburn@cygnus.com>
    Kung Hsu <kung@cygnus.com>
    Mark Eichin <eichin@cygnus.com>
    Michael Meissner <meissner@redhat.com>
    Michael Tiemann <tiemann@cygnus.com>
    Mike Werner <mtw@cygnus.com>
    Nick Clifton <nickc@redhat.com>
    Per Bothner <bothner@cygnus.com>
    Peter Schauer <pes@regent.e-technik.tu-muenchen.de>
    Richard Earnshaw <rwe@pegasus.esprit.ec.org>
    Richard Henderson <rth@redhat.com>
    Richard Stallman <rms@gnu.org>
    Rob Savoye <rob@cygnus.com>
    Roland H. Pesch <pesch@wrs.com>
    Sean Eric Fagan <sef@cygnus.com>
    Stan Shebs <shebs@apple.com>
    Stephane Carrez <Stephane.Carrez@worldnet.fr>
    Steve Chamberlain <sac@cygnus.com>
    Stu Grossman <grossman@cygnus.com>
    Torbjorn Granlund <tege@cygnus.com>
    Ulf Carlsson <ulfc@calypso.engr.sgi.com>

%if "%{name}" != "binutils"
%define TARGET %(echo %{name}|sed -e "s/cross-\\(.*\\)-binutils/\\1/;s/-/_/g;s/parisc/hppa/;s/i.86/i586/;s/ppc/powerpc/")
%endif
%define HOST %(echo %{_target_cpu}|sed -e "s/parisc/hppa/" -e "s/i.86/i586/" -e "s/ppc/powerpc/")-suse-linux
%prep
echo "make check will return with %{make_check_handling} in case of testsuite failures."
%setup -q -n binutils-%{version}
%if !%{test_vanilla}
# Apply H.J.Lu's patches
test -f patches/README &&
sh patches/README
#
%patch
%patch1
%patch2
#
# experimental stuff not for the older distris
%if %suse_version > 820
%patch3
%endif
%patch4
%patch5
%patch6
%patch7 -p1
%patch8
%patch9
%patch10
%patch12
%patch13
%patch14
%patch15
%patch16
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21
%patch22 -p1
%patch23
%patch24
%patch25
%patch26 -p1
%patch27
%patch28 -p1
%patch29 -p1
%patch30
#
%patch42
%patch43
%patch44
%patch45
%patch46
%patch47
%patch48
%patch49
%patch50
%patch51
%patch52
%patch53
%patch54
%patch55
#%patch56
#
# test_vanilla
%endif

%build
RPM_OPT_FLAGS="$RPM_OPT_FLAGS -Wno-error"
%if "%{name}" == "binutils"
# Building native binutils
echo "Building native binutils." 
%if %build_multitarget
ADDITIONAL_TARGETS="%(echo %target_list | sed -e 's/[^ ]\+/&-suse-linux/g')"
%else
ADDITIONAL_TARGETS=
%endif
%ifarch sparc
ADDITIONAL_TARGETS="$ADDITIONAL_TARGETS sparc64-suse-linux"
%endif
%ifarch ppc
ADDITIONAL_TARGETS="$ADDITIONAL_TARGETS powerpc64-suse-linux powerpc-macos powerpc-macos10"
%endif
%ifarch s390
ADDITIONAL_TARGETS="$ADDITIONAL_TARGETS s390x-suse-linux"
%endif
%ifarch s390x
ADDITIONAL_TARGETS="$ADDITIONAL_TARGETS s390-suse-linux"
%endif
%ifarch %ix86
ADDITIONAL_TARGETS="$ADDITIONAL_TARGETS x86_64-suse-linux"
%endif
%ifarch %ix86 x86_64
ADDITIONAL_TARGETS="$ADDITIONAL_TARGETS i386-pe"
%endif
mkdir build-dir
cd build-dir
# Workaround lack of DESTDIR support
CFLAGS="${RPM_OPT_FLAGS} -L$RPM_BUILD_ROOT%{_libdir}" CC=gcc \
../configure --prefix=%{_prefix} \
	--enable-shared --with-gnu-ld --with-gnu-as --libdir=%{_libdir} \
	--infodir=%{_infodir} --mandir=%{_mandir} \
	--host=%{HOST} \
	${ADDITIONAL_TARGETS:+--enable-targets="${ADDITIONAL_TARGETS// /,}"}
make configure-bfd
make headers -C bfd
# force reconfiguring
rm bfd/Makefile
make %{?jobs:-j%jobs}
%ifnarch %arm
make -k check CFLAGS="$RPM_OPT_FLAGS -Wno-unused" || %{make_check_handling}
%endif
#
#
#
%else
# building cross-TARGET-binutils
echo "Building cross binutils." 
mkdir build-dir
cd build-dir
ADDITIONAL_TARGETS=
%if "%{TARGET}" == "sparc"
ADDITIONAL_TARGETS="sparc64-suse-linux"
%endif
%if "%{TARGET}" == "powerpc"
ADDITIONAL_TARGETS="powerpc64-suse-linux"
%endif
%if "%{TARGET}" == "s390"
ADDITIONAL_TARGETS="s390x-suse-linux"
%endif
%if "%{TARGET}" == "s390x"
ADDITIONAL_TARGETS="s390-suse-linux"
%endif
%if "%{TARGET}" == "i586"
ADDITIONAL_TARGETS="x86_64-suse-linux"
%endif
%if "%{TARGET}" == "hppa"
ADDITIONAL_TARGETS="hppa64-suse-linux"
%endif
%if "%{TARGET}" == "avr"
TARGET_OS=%{TARGET}
%else
TARGET_OS=%{TARGET}-linux
%endif
# Workaround lack of DESTDIR support
CFLAGS="${RPM_OPT_FLAGS} -L$RPM_BUILD_ROOT%{_libdir}" CC=gcc \
../configure --prefix=%{_prefix} \
	--disable-nls \
        --host=%{HOST} --target=$TARGET_OS \
	${ADDITIONAL_TARGETS:+--enable-targets="${ADDITIONAL_TARGETS// /,}"}
make configure-bfd
make headers -C bfd
# force reconfiguring
rm bfd/Makefile
make %{?jobs:-j%jobs}
make -k check CFLAGS="$RPM_OPT_FLAGS -Wno-unused" || :
%endif

%install
cd build-dir
rm -rf $RPM_BUILD_ROOT
%if "%name" == "binutils"
# installing native binutils
make DESTDIR=$RPM_BUILD_ROOT install-info install
make -C gas/doc DESTDIR=$RPM_BUILD_ROOT install-info-am install-am
rm -rf $RPM_BUILD_ROOT%{_prefix}/%{HOST}/bin/*
mkdir -p $RPM_BUILD_ROOT%{_prefix}/%{HOST}/bin
ln -sf ../../bin/{ar,as,ld,nm,ranlib,strip} $RPM_BUILD_ROOT%{_prefix}/%{HOST}/bin
mv $RPM_BUILD_ROOT%{_prefix}/%{HOST}/lib/ldscripts $RPM_BUILD_ROOT%{_libdir}
ln -sf ../../%{_lib}/ldscripts $RPM_BUILD_ROOT%{_prefix}/%{HOST}/lib/ldscripts
# Install header files
make -C libiberty install_to_libdir target_header_dir=/usr/include DESTDIR=$RPM_BUILD_ROOT
# We want the PIC libiberty.a
install -m 644 libiberty/pic/libiberty.a $RPM_BUILD_ROOT%{_libdir}
#
chmod a+x $RPM_BUILD_ROOT%{_libdir}/libbfd-*
chmod a+x $RPM_BUILD_ROOT%{_libdir}/libopcodes-*
# Remove build prefixes from *.la
perl -pi -e "s| -L[^ ']*||g" $RPM_BUILD_ROOT%{_libdir}/lib*.la
# Remove unwanted files to shut up rpm
rm $RPM_BUILD_ROOT%{_infodir}/configure* $RPM_BUILD_ROOT%{_infodir}/standards.info*
rm $RPM_BUILD_ROOT%{_mandir}/man1/dlltool.1 $RPM_BUILD_ROOT%{_mandir}/man1/windres.1
%ifarch %ix86 x86_64
# don't want these for now
rm $RPM_BUILD_ROOT%{_bindir}/dlltool $RPM_BUILD_ROOT%{_bindir}/dllwrap
rm $RPM_BUILD_ROOT%{_bindir}/windres
%endif
cd ..
%find_lang binutils
%find_lang bfd binutils.lang
%find_lang gas binutils.lang
%find_lang ld binutils.lang
%find_lang opcodes binutils.lang
%find_lang gprof binutils.lang
%else
# installing cross-TARGET-binutils
make DESTDIR=$RPM_BUILD_ROOT install
rm -rf $RPM_BUILD_ROOT%{_prefix}/man
rm -rf $RPM_BUILD_ROOT%{_prefix}/info
rm -rf $RPM_BUILD_ROOT%{_prefix}/lib
rm -rf $RPM_BUILD_ROOT%{_prefix}/include
rm -fv $RPM_BUILD_ROOT%{_prefix}/bin/*-c++filt
find $RPM_BUILD_ROOT%{_prefix} \( -name binutils.mo -o -name bfd.mo -o \
     -name gas.mo -o -name gprof.mo -o -name ld.mo -o -name opcodes.mo \) \
     -printf "%{_prefix}/%%P\n" > ../binutils.lang
%endif

%clean
rm -rf $RPM_BUILD_ROOT
%if "%name" == "binutils"

%post
%install_info --info-dir=%{_infodir} %{_infodir}/as.info.gz
%install_info --info-dir=%{_infodir} %{_infodir}/bfd.info.gz
%install_info --info-dir=%{_infodir} %{_infodir}/binutils.info.gz
%install_info --info-dir=%{_infodir} %{_infodir}/gprof.info.gz
%install_info --info-dir=%{_infodir} %{_infodir}/ld.info.gz

%postun
%install_info_delete --info-dir=%{_infodir} %{_infodir}/as.info.gz
%install_info_delete --info-dir=%{_infodir} %{_infodir}/bfd.info.gz
%install_info_delete --info-dir=%{_infodir} %{_infodir}/binutils.info.gz
%install_info_delete --info-dir=%{_infodir} %{_infodir}/gprof.info.gz
%install_info_delete --info-dir=%{_infodir} %{_infodir}/ld.info.gz
%endif

%files -f binutils.lang
%defattr(-,root,root)
%if "%name" == "binutils"
%{_prefix}/%{HOST}/bin/*
%{_prefix}/%{HOST}/lib/ldscripts
%{_libdir}/ldscripts
%{_bindir}/addr2line
%{_bindir}/ar
%{_bindir}/as
%{_bindir}/c++filt
%{_bindir}/gprof
%{_bindir}/ld
%{_bindir}/nm
%{_bindir}/objcopy
%{_bindir}/objdump
%{_bindir}/ranlib
%{_bindir}/readelf
%{_bindir}/size
%{_bindir}/strings
%{_bindir}/strip
/usr/include/ansidecl.h
/usr/include/bfd.h
/usr/include/bfdlink.h
/usr/include/symcat.h
/usr/include/demangle.h
/usr/include/dis-asm.h
/usr/include/dyn-string.h
/usr/include/fibheap.h
/usr/include/floatformat.h
/usr/include/hashtab.h
/usr/include/libiberty.h
/usr/include/objalloc.h
/usr/include/partition.h
/usr/include/safe-ctype.h
/usr/include/sort.h
/usr/include/splay-tree.h
/usr/include/ternary.h
%doc %{_infodir}/as.info*.gz
%doc %{_infodir}/bfd.info*.gz
%doc %{_infodir}/binutils.info*.gz
%doc %{_infodir}/gprof.info*.gz
%doc %{_infodir}/ld.info*.gz
%{_libdir}/libbfd.so
%{_libdir}/libbfd.a
%{_libdir}/libbfd.la
%{_libdir}/libbfd-*.so
%{_libdir}/libiberty.a
%{_libdir}/libopcodes.a
%{_libdir}/libopcodes.la
%{_libdir}/libopcodes.so
%{_libdir}/libopcodes-*.so
%doc %{_mandir}/man1/addr2line.1.gz
%doc %{_mandir}/man1/ar.1.gz
%doc %{_mandir}/man1/as.1.gz
%doc %{_mandir}/man1/c++filt.1.gz
%doc %{_mandir}/man1/gprof.1.gz
%doc %{_mandir}/man1/ld.1.gz
%doc %{_mandir}/man1/nlmconv.1.gz
%doc %{_mandir}/man1/nm.1.gz
%doc %{_mandir}/man1/objcopy.1.gz
%doc %{_mandir}/man1/objdump.1.gz
%doc %{_mandir}/man1/ranlib.1.gz
%doc %{_mandir}/man1/readelf.1.gz
%doc %{_mandir}/man1/size.1.gz
%doc %{_mandir}/man1/strings.1.gz
%doc %{_mandir}/man1/strip.1.gz
%else
%{_prefix}
%endif

%changelog -n cross-x86_64-binutils
* Mon Oct 16 2006 - schwab@suse.de
- Fix overflow in addend_compare [#211596].
* Fri Aug 25 2006 - schwab@suse.de
- Correct GOT and PLT HA reloc handling [#200874].
* Thu Aug 10 2006 - schwab@suse.de
- Fix long branch reloc handling [#197959].
* Wed Jul 26 2006 - schwab@suse.de
- Fix bad gp value [#190362].
* Fri May 19 2006 - schwab@suse.de
- Validate Tektronix Hex Format [#177088].
- Fix parallel build race [#176983].
- Fix doc for --enable-new-dtags [#78558].
* Mon May 08 2006 - hare@suse.de
- Fix invalid exeception on S/390 when calling res_init()
  [#172700 - LTC23600]
* Fri May 05 2006 - schwab@suse.de
- Fix huge link times [#167593].
* Tue Apr 11 2006 - schwab@suse.de
- PR ld/2442: fix quadratic behaviour with many relocations [#157119].
- PR ld/2513: fix invalid TLS reloc merging [#162901].
* Mon Apr 03 2006 - schwab@suse.de
- Add various bug fix backports collected by Alan Modra.  Fixes the
  following binutils bugs:
  * PR ld/2443
  * PR ld/2462
  * PR ld/2267
  * incompatibilities between REL{32,24,14}
  * ld -r on ppc64
  * -msecure-plt vs TLS
* Fri Mar 31 2006 - schwab@suse.de
- Fix build race.
* Fri Mar 31 2006 - matz@suse.de
- Also disallow linking non-PIC .o files into shared libraries on
  s390x.
* Fri Mar 31 2006 - schwab@suse.de
- Fix bfd_find_nearest_line so that gcc -frepo works again.
* Wed Feb 15 2006 - matz@suse.de
- Update -Bdirect and -zdynsort patches.
* Mon Feb 06 2006 - matz@suse.de
- Adjust testsuite for s390 -march=z900 default.
- Disallow linking non-PIC .o files into shared libraries on s390.
* Wed Jan 25 2006 - mls@suse.de
- converted neededforbuild to BuildRequires
* Wed Jan 18 2006 - matz@suse.de
- Add large model patch.
* Tue Jan 17 2006 - schwab@suse.de
- Add patch to fix --gc-sections on ppc64.
- Fix side effect of --enable-targets=arm.
* Wed Jan 11 2006 - schwab@suse.de
- Update to binutils 2.16.91.0.5.
* Tue Jan 10 2006 - rguenther@suse.de
- Don't error out for testsuite failures on hppa.
* Tue Jan 03 2006 - dmueller@suse.de
- Don't create empty rpath components when stripping
* Wed Dec 07 2005 - schwab@suse.de
- Fix handling of SHF_LINK_ORDER links for objcopy.
* Wed Dec 07 2005 - coolo@suse.de
- New -Bdirect patch.
* Fri Dec 02 2005 - schwab@suse.de
- Add experimental -Bdirect patch.
* Thu Nov 24 2005 - schwab@suse.de
- Fix aliasing warning.
* Sun Nov 13 2005 - schwab@suse.de
- Update to binutils 2.16.91.0.4.
* Wed Nov 09 2005 - schwab@suse.de
- Fixes from CVS:
  * Don't strip local absolute symbols from linker output.
  * Allow equating local symbols to undefined symbols.
* Fri Nov 04 2005 - schwab@suse.de
- Fix more warnings.
* Wed Nov 02 2005 - schwab@suse.de
- Fix warnings.
* Thu Oct 27 2005 - aj@suse.de
- Spell fix.
* Wed Sep 28 2005 - schwab@suse.de
- Add target i386-pe on ix86 and x86_64.
* Fri Sep 16 2005 - schwab@suse.de
- Update to binutils 2.16.91.0.3.
* Thu Sep 01 2005 - schwab@suse.de
- Fix objdump -adjust-vma on non-relocatable object [#114666].
* Wed Aug 10 2005 - schwab@suse.de
- Replace last change by a simpler fix.
* Sat Aug 06 2005 - schwab@suse.de
- Add hook for resetting GP after each relaxing pass.
* Fri Aug 05 2005 - matz@suse.de
- Fix alpha again.
* Wed Aug 03 2005 - schwab@suse.de
- Don't warn on overflow in the assembler if emitting a reloc on ppc
  [#100189].
- Fix handling of discarded linkonce sections [#84608].
* Tue Aug 02 2005 - schwab@suse.de
- Avoid generating R_IA64_NONE.
* Tue Aug 02 2005 - uli@suse.de
- disabled make check on ARM (one test fills up the hard disk;
  not a QEMU problem, happens on real hardware, too)
* Mon Jul 25 2005 - schwab@suse.de
- Fix syntax error in libtool library files [#98185].
* Thu Jul 21 2005 - schwab@suse.de
- Update to binutils 2.16.91.0.2.
* Thu Jun 23 2005 - schwab@suse.de
- Update to binutils 2.16.91.0.1.
* Wed Jun 22 2005 - schwab@suse.de
- Add patch to properly handle indirect symbols.
* Fri May 20 2005 - schwab@suse.de
- Fix ld testsuite.
* Tue May 17 2005 - schwab@suse.de
- Fix overflows in BFD library [#81821].
* Wed May 11 2005 - schwab@suse.de
- Update to binutils 2.16.90.0.3.
- Build with -Wno-error in beta.
* Sat May 07 2005 - schwab@suse.de
- Add patch to properly put unwind sections into section groups.
- Fix avr assembler.
* Sat May 07 2005 - matz@suse.de
- added alpha cross target.
* Tue May 03 2005 - jw@suse.de
- added target avr.
* Sun May 01 2005 - schwab@suse.de
- Update to binutils 2.16.90.0.2.
* Thu Apr 28 2005 - schwab@suse.de
- Update patch for last change.
* Mon Apr 25 2005 - matz@suse.de
- Fix breakage on alpha
* Wed Apr 20 2005 - bg@suse.de
- remove additional target hppa64
- remove obsolete hppa patch
- enable tests
* Sun Apr 17 2005 - schwab@suse.de
- Accept empty symbol names.
- Fix bugs related to section groups.
* Wed Apr 13 2005 - schwab@suse.de
- Fix mips assembler.
* Mon Apr 11 2005 - schwab@suse.de
- Add patch to fix AS_NEEDED.
* Sun Apr 10 2005 - schwab@suse.de
- Update to binutils 2.16.90.0.1.
* Wed Apr 06 2005 - schwab@suse.de
- Cleanup neededforbuild.
- Fix compilation with gcc4.
* Wed Apr 06 2005 - meissner@suse.de
- Added gettext-devel to neededforbuild.
* Wed Apr 06 2005 - schwab@suse.de
- Revert last change (don't disable parallel build).
* Tue Apr 05 2005 - meissner@suse.de
- Added gettext-devel to neededforbuild.
* Wed Mar 30 2005 - schwab@suse.de
- Support AS_NEEDED in linker script.
* Fri Feb 18 2005 - schwab@suse.de
- Update to binutils 2.15.94.0.2.2.
* Thu Feb 03 2005 - schwab@suse.de
- Fix ld testsuite for gcc4.
* Mon Jan 31 2005 - schwab@suse.de
- Add patch to properly handle protected functions for ia32 and x86_64.
* Thu Jan 20 2005 - schwab@suse.de
- Fix last change.
* Wed Jan 19 2005 - schwab@suse.de
- Handle biarch targets also for cross binutils.
* Sat Jan 08 2005 - schwab@suse.de
- Update to binutils 2.15.94.0.2.
- Enable more targets.
* Tue Nov 23 2004 - schwab@suse.de
- Update to binutils 2.15.94.0.1.
* Thu Oct 14 2004 - schwab@suse.de
- Remove broken check.
* Wed Oct 13 2004 - schwab@suse.de
- Fix ppc asm operand parsing.
* Fri Oct 08 2004 - schwab@suse.de
- Update to binutils 2.15.92.0.2.
* Thu Sep 09 2004 - schwab@suse.de
- Fix last change.
* Thu Sep 02 2004 - schwab@suse.de
- Fix relro alignment.
* Sat Aug 21 2004 - coolo@suse.de
- also build cross binutils for ppc64
* Fri Aug 06 2004 - schwab@suse.de
- Fix crash in ld [#43550].
* Wed Aug 04 2004 - schwab@suse.de
- Add patch for PR binutils/290.
* Sun Aug 01 2004 - schwab@suse.de
- Make error about relocs against discarded sections non-fatal for now.
* Wed Jul 28 2004 - schwab@suse.de
- Update to binutils 2.15.91.0.2.
* Sat Jun 05 2004 - schwab@suse.de
- Update to binutils 2.15.91.0.1.
* Tue May 04 2004 - coolo@suse.de
- created cross-*-binutils in the same directory reusing create-cross.sh
  as pre_checkin.sh
* Fri Apr 16 2004 - aj@suse.de
- Fix some offset expressions.
* Thu Apr 15 2004 - aj@suse.de
- Update to binutils 2.15.90.0.3.
* Wed Apr 14 2004 - aj@suse.de
- Update to binutils 2.15.90.0.2.
* Fri Mar 26 2004 - meissner@suse.de
- Added ppc64 patch to drop excess symbols in shared libraries.
* Tue Mar 23 2004 - schwab@suse.de
- Fix --wrap on PPC64 [#34903].
* Tue Mar 16 2004 - mludvig@suse.cz
- Added support for VIA PadLock.
- Merged obsolete fix-clflush.patch into opcode-i386.diff
* Fri Mar 12 2004 - aj@suse.de
- Fix sysenter.
- Fix x86 clflush disassembly.
* Wed Mar 10 2004 - schwab@suse.de
- Fix a possible race in the PLT.
* Mon Mar 08 2004 - aj@suse.de
- Fix cfi testsuite on s390x.
* Mon Mar 08 2004 - hare@suse.de
- Enable s390 biarch backend.
- Fix Invalid .insn from gas on s390.
* Mon Mar 08 2004 - aj@suse.de
- Fix fde alignment.
* Sat Mar 06 2004 - aj@suse.de
- Update to binutils-2.15.90.0.1.1 which incorporates the last two
  changes.
* Fri Mar 05 2004 - schwab@suse.de
- Fix align handling.
* Thu Mar 04 2004 - aj@suse.de
- Install as manpage.
* Thu Mar 04 2004 - aj@suse.de
- Update to binutils-2.15.90.0.1.
* Fri Feb 27 2004 - schwab@suse.de
- Support POSIX-compatible argument parsing in ar [#33775].
- Fix textrel patch.
* Thu Feb 26 2004 - schwab@suse.de
- Fix spurious DT_TEXTREL.
* Wed Feb 25 2004 - matz@suse.de
- Enable new dtags by default.
* Fri Feb 13 2004 - hare@suse.de
- Fix memcmp bug in gas/dwarf2dbg.c
* Thu Feb 12 2004 - bg@suse.de
- Workaround for ICE in elf32_hppa_relocate_section.
* Thu Jan 15 2004 - aj@suse.de
- Fix common page size on ppc.
- Update to binutils 2.14.90.0.8.
* Mon Jan 12 2004 - aj@suse.de
- Fix PPC64 TLS bug.
* Fri Dec 12 2003 - schwab@suse.de
- Fix file list.
* Tue Dec 02 2003 - schwab@suse.de
- Fix last change for ia64.
* Mon Nov 24 2003 - aj@suse.de
- Fix handling of '/' in gas on x86 platforms.
* Thu Oct 30 2003 - aj@suse.de
- Update to binutils 2.14.90.0.7:
  1. Update from binutils 2003 1029.
  2. Allow type changes for undefined symbols.
  3. Fix EH frame optimization.
  4. Fix the check for undefined versioned symbol with wildcard.
  5. Support generating code for Itanium.
  6. Detect and warn bad symbol index.
  7. Update IPF assemebler DV check.
* Fri Oct 17 2003 - schwab@suse.de
- Update dv warning patch once more.
- Disable -Wunused during testsuite.
* Fri Oct 17 2003 - schwab@suse.de
- Update dv warning patch.
* Wed Oct 15 2003 - aj@suse.de
- Build as non-root user.
* Fri Oct 03 2003 - kukuk@suse.de
- Remove tetex from neededforbuild
* Wed Oct 01 2003 - schwab@suse.de
- Fix spurious dv conflict warning.
- Don't ignore testsuite failures on ia64.
* Fri Sep 26 2003 - aj@suse.de
- Update to binutils-2.14.90.0.6.
* Fri Aug 29 2003 - aj@suse.de
- Add patch to speed up linker.
* Tue Aug 19 2003 - aj@suse.de
- disable unit-at-a-time for some tests so that they pass (otherwise
  some sections are reordered).
* Fri Aug 08 2003 - schwab@suse.de
- Fix generation of efi-app binaries.
* Tue Jul 29 2003 - meissner@suse.de
- Fix ppc64 bitmask detection (from current CVS).
* Fri Jul 25 2003 - schwab@suse.de
- Readd workaround for missing DESTDIR support.
* Thu Jul 24 2003 - aj@suse.de
- Update to binutils 2.14.90.0.5.
* Wed Jul 16 2003 - mludvig@suse.cz
- Reverted Alan Modra's patch for .debug_line generation.
  http://sources.redhat.com/ml/binutils/2003-07/msg00294.html
* Fri Jul 04 2003 - olh@suse.de
- update to binutils-2.14.90.0.4-cvs20030704.diff.bz2
* Wed Jul 02 2003 - olh@suse.de
- add binutils-ppc64-mminimal-toc.patch
--disable-nls in cross-binutils, remove man and info to
  avoid file conflicts with multiple cross-binutils packages
* Wed Jul 02 2003 - aj@suse.de
- Support z990 instructions.
* Mon Jun 30 2003 - olh@suse.de
- add binutils_x86_64_bfd_c90.patch
* Fri Jun 27 2003 - olh@suse.de
- update to binutils-2.14.90.0.4-cvs20030627.diff.bz2
  use DESTDIR
* Tue Jun 24 2003 - coolo@suse.de
- ignore rpaths only for > 8.2
* Mon Jun 23 2003 - coolo@suse.de
- removed %%ifarch mips
* Wed Jun 18 2003 - aj@suse.de
- Fix CFI alignment bugs.
* Wed Jun 18 2003 - olh@suse.de
- update to binutils-2.14.90.0.4-cvs20030618.diff.bz2
- provide an option to test a vanilla binutils release,
  provide an option to not apply patches that break the testsuite
* Tue Jun 17 2003 - coolo@suse.de
- apply the cvs diff on all architectures and sort out the other
  patches
- use %%find_lang
- apply objcopy.c patch to add --only-keep-debug option to strip
  and objcopy
* Fri Jun 13 2003 - olh@suse.de
- use binutils-2.14.90.0.4-cvs20030613.diff.bz2 on ppc/ppc64
  to remove the -mminimal-toc requirement on ppc64
* Thu Jun 12 2003 - aj@suse.de
- Fix directory file list.
* Thu Jun 05 2003 - ro@suse.de
- fix dangling ldscripts symlink for lib64 platforms
* Thu Jun 05 2003 - aj@suse.de
- Fix typo in CFI calculation.
- Make .eh_frame section read-only.
- Add more CFI directives.
* Thu Jun 05 2003 - coolo@suse.de
- integrating patch to ignore rpaths listed in a file specified
  by $SUSE_IGNORED_RPATHS (supposed to be set to /etc/ld.so.conf)
* Mon Jun 02 2003 - aj@suse.de
- Fix addend relocation with CFI.
* Sat May 31 2003 - aj@suse.de
- Handle GOT with more than 8191 entries corect on PowerPC.
- Fix dwarf2 CFI bugs.
* Fri May 30 2003 - aj@suse.de
- Update to binutils 2.14.90.0.4.
- Improve cfi support.
* Wed May 21 2003 - aj@suse.de
- Fix cfi build problems on ia64 and add latest revision of patch.
* Tue May 20 2003 - aj@suse.de
- Fix elf visibility problem.
- Add cfi directives.
* Sat May 17 2003 - aj@suse.de
- Update to binutils 2.14.90.0.2.
* Thu May 15 2003 - aj@suse.de
- Allow testsuite to fail on sparc.
* Wed May 14 2003 - schwab@suse.de
- Workaround lack of DESTDIR support.
- Make sure libbfd is installed before libopcodes.
* Wed May 14 2003 - aj@suse.de
- Link libopcodes against libbfd.
- Fix package list.
* Mon May 12 2003 - aj@suse.de
- Fix bugs and testsuite on s390.
* Wed May 07 2003 - aj@suse.de
- Fix bugs in creation of large files.
* Tue May 06 2003 - aj@suse.de
- Update to version 2.14.90.0.1.
* Mon Apr 28 2003 - schwab@suse.de
- Update ia64 relaxation bug fix.
* Fri Apr 25 2003 - aj@suse.de
- Fix ia64 relaxation bugs.
* Thu Apr 24 2003 - olh@suse.de
- add binutils-2.13-ppc32-ld-symbol-version.patch
  add binutils-2.13-ppc32-fPIC.patch
  fail to link shared libs compiled without -fPIC
  run make check with -k after this change
* Thu Apr 24 2003 - ro@suse.de
- fix install_info --delete call and move from preun to postun
* Tue Apr 08 2003 - adrian@suse.de
- fix build for mips
* Sat Mar 22 2003 - aj@suse.de
- Update to 2.13.0.90.20.
* Wed Mar 19 2003 - aj@suse.de
- Do not depend on binutils installation.
* Wed Mar 19 2003 - aj@suse.de
- Fix crash in ld with overly long command lines (#23743).
* Thu Feb 27 2003 - aj@suse.de
- Package all libiberty include files.
* Wed Feb 19 2003 - stepan@suse.de
- add create-cross.sh to easily create cross-binutils packages.
* Tue Feb 18 2003 - aj@suse.de
- Run testsuite.
* Fri Feb 14 2003 - aj@suse.de
- Fix symbol relocations with versioning.
* Mon Feb 10 2003 - aj@suse.de
- Fix real.plt on s390.
* Fri Feb 07 2003 - aj@suse.de
- Fix dwarf2 filenames.
* Thu Feb 06 2003 - aj@suse.de
- Fix frame header sign extension bug (#23318)
- Fix library path for 64-bit platforms
- Fix x86-64 disassembler.
* Thu Feb 06 2003 - stepan@suse.de
- Add alpha TLS patch
* Sat Feb 01 2003 - aj@suse.de
- Add sparc TLS patch.
* Sat Jan 25 2003 - aj@suse.de
- Update to binutils 2.13.90.0.18 which includes:
  * Fix some ia64 gas bugs.
  * Fix TLS bugs.
  * Fix ELF/ppc bugs.
* Tue Jan 14 2003 - bg@suse.de
- add hppa relocation patch from "John David Anglin"
  <dave@hiauly1.hia.nrc.ca>
* Sat Dec 14 2002 - adrian@suse.de
- add additional mips64 target on mips
- use mips patches which came with the tar ball on mips
- disable "make check" on mips for now
* Fri Dec 06 2002 - schwab@suse.de
- Update to binutils 2.13.90.0.16.
* Wed Dec 04 2002 - olh@suse.de
- add ppc64-binutils-ld-makecheck.diff, enable make check on ppc64
* Sat Nov 23 2002 - olh@suse.de
- add ppc64-binutils-ld-no256mbsegments.diff
  revert the binutils change that moved text and data into separate
  256M address ranges, at least until the glibc dynamic loader
  can handle such binaries gracefully.
* Tue Nov 05 2002 - bg@suse.de
- Enable hppa build
- Add support for hppa64
* Thu Oct 24 2002 - aj@suse.de
- Fix allocation of orphaned sections to aviod problems with strip.
- Fix another problem on alpha with orphaned sections.
* Tue Oct 15 2002 - aj@suse.de
- Install libiberty.h [Fixes #20941].
* Mon Oct 14 2002 - aj@suse.de
- Update to binutils-2.13.90.0.10.
* Tue Oct 01 2002 - aj@suse.de
- Update to binutils-2.13.90.0.5.
- Add tls support for x86-64.
- Fix tls support for i386.
* Mon Sep 16 2002 - schwab@suse.de
- Enable use of brl for out of range branch fixup.
* Sun Sep 01 2002 - aj@suse.de
- Fix LIB_PATH for x86_64.
* Fri Aug 30 2002 - bk@suse.de
- enable s390 as additional target on s390x
- fix LIB_PATH for elf_s390 emulation to not use lib64 paths
- fix LIB_PATH for elf64_s390 to include /usr/local/lib64 and /lib64
- delete -fsigned-char for binutils on s390/s390x
* Tue Aug 27 2002 - aj@suse.de
- Fix x86-64 gotpcrel generation.
- Add fix for bugs in gas on i386 where GOT references where
  miscompiled and fix problem with absolute section.
- Fix reference counting on various platforms.
- Fix counting of definitions in shared objects
* Fri Jul 19 2002 - schwab@suse.de
- Update to binutils 2.12.90.0.15.
* Sat Jul 13 2002 - schwab@suse.de
- Add fix for ia64 indirect call encoding bug.
* Thu Jul 11 2002 - aj@suse.de
- Fix generation of nops for x86-64.
* Wed Jul 10 2002 - aj@suse.de
- Fix -ffunction sections.
* Tue Jul 09 2002 - olh@suse.de
- add patches for gas biarch support on ppc
  binutils-2.12.90.0.14-cvs.diff 20020709
  binutils_ppc_biarch_gas.diff
  binutils_ppc_biarch_gas_weaksym.diff
* Fri Jul 05 2002 - kukuk@suse.de
- Use %%ix86 macro
* Wed Jul 03 2002 - aj@suse.de
- Update to binutils 2.12.90.0.14.
- Remove patches that have been integrated.
* Tue Jul 02 2002 - bk@suse.de
- add fixes for s390(x) - should make this version work for s390.
* Wed Jun 26 2002 - aj@suse.de
- Do not discard empty sections (otherwise the kernel build will
  break).
* Thu Jun 20 2002 - adrian@suse.de
- Update to binutils 2.12.90.0.12.
  * Update from binutils 2002 0618.
  * Fix an mips assembler bug.
- remove s390-testsuite.patch, it is inside 2.12.90.0.12 now
* Mon Jun 17 2002 - aj@suse.de
- Abort with error message if shared libs are build without -fPIC
  on x86-64 (in cases where this can be detected).
- Remove ld -Y patch.
* Fri Jun 14 2002 - olh@suse.de
- use _target_cpu in diff packagelist
* Wed Jun 12 2002 - aj@suse.de
- Update to binutils 2.12.90.0.11.
- Better handle ld -Y with multilibs.
- Do not link 32-bit and 64-bit objects togethers when searching libs
  via ld.so.conf.
- Add x86-64 as target for i386.
* Fri May 31 2002 - olh@suse.de
- update cvs patch to 20020531, obsolets ppc64_binutils.diff
  disable make check on ppc64
* Thu May 30 2002 - olh@suse.de
- add binutils_x86_64_testsuite.diff, selective[1245] xfail on x86-64
* Wed May 29 2002 - olh@suse.de
- add ppc64_binutils.diff, for libtool
  nm -B output, use D instead of ? for function descriptors
* Mon May 27 2002 - olh@suse.de
- update cvs patch to 20020527
* Thu May 23 2002 - olh@suse.de
- add cvs 20020523 diff for ppc/ppc64
  put readelf manpage in filelist
* Sun May 19 2002 - olh@suse.de
- handle elf64 (powerpc64-suse-linux) on ppc32
* Fri May 17 2002 - adrian@suse.de
- fix build for s390x and mips
  (added pic config file)
- do not ignore return value of "make check" on mips anymore
* Fri May 17 2002 - schwab@suse.de
- Add gprof docs.
- Add message catalogues.
* Fri May 17 2002 - uli@suse.de
- added gprof to file list
* Mon May 13 2002 - schwab@suse.de
- Add PIC configuration for x86-64.
* Mon May 13 2002 - olh@suse.de
- update to 2.12.90.0.7
* Sun May 12 2002 - schwab@suse.de
- Install the PIC libiberty.a.
* Fri May 10 2002 - meissner@suse.de
- x86-64 relocation conversion should not just convert to
  64bit relocations since we sometimes do have 32bit ones.
  (Patch from Andreas Schwab.)
* Tue Apr 23 2002 - aj@suse.de
- Fix a bug with --eh-frame-hdr that occured on sparc.
* Mon Apr 22 2002 - aj@suse.de
- Fix testsuite for alpha and s390.
- Fix --eh-frame-hdr.
- Update x86-64 assembler patch.
* Sat Apr 20 2002 - schwab@suse.de
- Fix pcrel handling in x86-64 assembler.
* Wed Apr 17 2002 - aj@suse.de
- Fix merging of s390 sections.
* Mon Apr 15 2002 - aj@suse.de
- Fix PPC linker bug.
* Fri Apr 12 2002 - aj@suse.de
- Update to binutils-2.12.90.0.4:
  * Contains x86-64 fix
  * Fixes S390 ld failure
  * Fixes for sparc
* Mon Apr 08 2002 - aj@suse.de
- Add fix for pcrel relocations for x86-64.
* Tue Apr 02 2002 - aj@suse.de
- Change platforms where testsuite is run.
* Mon Mar 25 2002 - schwab@suse.de
- Update to binutils-2.12.90.0.3.
* Sun Mar 10 2002 - schwab@suse.de
- Update to binutils-2.12.90.0.1.
- gprof now supported on MIPS.
* Thu Feb 28 2002 - stepan@suse.de
- add data segment alignment patches.
* Mon Feb 25 2002 - schwab@suse.de
- Add fix for elf64-ia64 linker scripts.
* Mon Feb 18 2002 - schwab@suse.de
- Fix broken patch.
* Mon Feb 18 2002 - aj@suse.de
- Update to binutils-2.11.93.0.2.
* Thu Feb 14 2002 - aj@suse.de
- Fix bug in handling of version maps by ld.  This is needed for
  GCC 3.1.
* Mon Nov 26 2001 - aj@suse.de
- gprof is not supported on MIPS, don't try to package it.
* Thu Nov 15 2001 - adrian@suse.de
- ignore known problem on mips in testsuite
- disable combreloc patch for mips
* Wed Nov 14 2001 - ro@suse.de
- added include file symcat.h to filelist
* Mon Nov 12 2001 - aj@suse.de
- Update to binutils-2.11.92.0.10.
* Sun Sep 30 2001 - schwab@suse.de
- Update to  binutils 2.11.90.0.31.
- Add support for @iplt and .data16 on ia64.
* Mon Sep 03 2001 - aj@suse.de
- Fix relative relocations on Alpha.
* Thu Aug 30 2001 - aj@suse.de
- Update to binutils 2.11.90.0.29.  It includes support for 64-bit
  PowerPC.
* Mon Aug 27 2001 - aj@suse.de
- Update to current CVS version and include patch to always enable
  sorting of relocations.  Together with the new glibc this reduces
  relocation processing at program startup significantly.
* Wed Aug 22 2001 - aj@suse.de
- Use AltiVec/PPC patch.
- Revert objdump patch that causes sparc kernel build failure.
- Add missing s390 jump instructions.
- Fix bug with unaligned accesses in the sparc assembler.
* Fri Aug 17 2001 - egger@suse.de
- Added patch for missing AltiVec/PPC opcodes.
* Thu Aug 16 2001 - aj@suse.de
- Update to 2.11.90.0.27, fix s390 relocation generation.
* Tue Jul 17 2001 - aj@suse.de
- Update to binutils 2.11.90.0.24.
* Wed Jul 11 2001 - aj@suse.de
- Update to binutils 2.11.90.0.23.
* Wed Jun 13 2001 - aj@suse.de
- Run testsuite on s390.
* Tue Jun 12 2001 - aj@suse.de
- Update to binutils 2.11.90.0.15.
* Mon May 14 2001 - aj@suse.de
- Update to binutils 2.11.90.0.8.
* Mon May 07 2001 - aj@suse.de
- Update to latest version.
* Thu Mar 29 2001 - aj@suse.de
- Fix a relaxation bug on ia32 that occurs while building GCC.
* Tue Mar 27 2001 - aj@suse.de
- Test for alpha instead of axp.
* Mon Mar 26 2001 - aj@suse.de
- Add patch for S390 to fix relocs.
* Mon Mar 26 2001 - aj@suse.de
- The testsuite is broken on axp, disable it.
* Thu Mar 08 2001 - aj@suse.de
- Use separate build directory, don't run testsuite on sparc.
* Mon Mar 05 2001 - aj@suse.de
- Update to 2.10.91.0.4.
* Thu Feb 22 2001 - aj@suse.de
- Run the testsuite on some platforms.
* Tue Feb 20 2001 - aj@suse.de
- Add sparc fix for weak symbols.
* Mon Feb 19 2001 - aj@suse.de
- Update to 2.10.91.0.2.
* Thu Nov 16 2000 - aj@suse.de
- Added an alpha patch to fix glibc problems.
* Mon Oct 23 2000 - aj@suse.de
- Update to 2.10.0.33.
- Remove PPC patch since it's solved better in .33.
* Sun Oct 15 2000 - kukuk@suse.de
- Update to binutils 2.10.0.31
- Port s390 patches
- Add PPC patch to fix glibc 2.2 problems
* Thu Sep 14 2000 - kukuk@suse.de
- Use macros in spec file
* Tue Aug 29 2000 - aj@suse.de
- New version 2.10.0.24 with additional s390 patches.
* Mon Apr 17 2000 - ro@suse.de
- added alpha3.dif to fix another problem with compaq compilers
* Sat Mar 18 2000 - aj@suse.de
- Fix problems with Compaq compiler, see:
  http://sourceware.cygnus.com/ml/binutils/2000-03/msg00226.html
  http://sourceware.cygnus.com/ml/binutils/2000-03/msg00160.html
* Mon Mar 13 2000 - aj@suse.de
- Added readelf to file list.
* Mon Feb 28 2000 - ro@suse.de
- fix HOST macro
- added alpha fix from Andrea
* Thu Jan 20 2000 - aj@suse.de
- New version 2.9.5.0.24.
* Thu Dec 09 1999 - ro@suse.de
- leave targets for now
* Wed Dec 08 1999 - kasal@suse.de
- added buildroot
  (it required a patch to target ld/Makefile.am, target install-data-local)
* Tue Nov 23 1999 - kasal@suse.de
- backported sparc patch from cvs version of binutils
- added note that geo@suse.cz can make NLMs
* Tue Nov 16 1999 - kukuk@suse.de
- Remove broken Sparc as patch, add bfd patch for sparc32
* Wed Nov 10 1999 - kukuk@suse.de
- spec file cleanup, add support for Sparc
- Remove dependency for bin86, not longer necessary
* Tue Nov 09 1999 - uli@suse.de
- added PPC-specific files to %%files section
* Mon Sep 13 1999 - bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Tue Aug 24 1999 - uli@suse.de
- fixed Makefile.Linux for PPC
* Fri May 28 1999 - ro@suse.de
- update to .25
* Thu Apr 08 1999 - ro@suse.de
- update to .23
* Mon Mar 29 1999 - ro@suse.de
- remove hacks and install libiberty.a in /usr/lib
* Sun Mar 14 1999 - ro@suse.de
- libtool tries to be smart dropping the link -liberty
  try to be smarter: changed "-liberty" to "../libiberty/libiberty.a"
* Fri Mar 05 1999 - ro@suse.de
- update to 2.9.1.0.22b FOR NOW AXP ONLY
- libnaming changed
* Fri Feb 19 1999 - ro@suse.de
- update to 2.9.1.0.20
* Mon Jan 11 1999 - ro@suse.de
- adapted specfile to build on alpha, too
- added ansidecl.h to filelist for glibc
* Mon Nov 02 1998 - ro@suse.de
- update to 2.9.1.0.15
* Fri Sep 11 1998 - ro@suse.de
- switch detection of GLIBC to automake
* Tue Jul 07 1998 - ro@suse.de
- pack files depending on used libc / compile a.out for libc5
* Wed May 20 1998 - bs@suse.de
- took c++filt off from file list (is included in egcs)
* Wed May 06 1998 - florian@suse.de
- update to binutils 2.9.1.0.4
* Tue Jul 29 1997 - florian@suse.de
- the a.out-assembler was not installed correctly by "make install"
* Wed Jun 25 1997 - florian@suse.de
- add bug-fixes from gnu.utils.bugs
* Sun Jun 08 1997 - florian@suse.de
- always remove /usr/bin/encaps
- update to version 2.8.1 with fixes by H.J. Lu
* Thu Jan 02 1997 - florian@suse.de
- Update auf Version 2.7.0.3. Sollte jetzt als normales binutils-Paket
  installiert sein. 2.6.* hoechstens unter unsorted...
