/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGStyleElement.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "SVGStyleElement.h"

#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGStyleElement)

/* Hash table */

static const HashTableValue JSSVGStyleElementTableValues[5] =
{
    { "xmlspace", DontDelete, (intptr_t)jsSVGStyleElementXmlspace, (intptr_t)setJSSVGStyleElementXmlspace },
    { "type", DontDelete, (intptr_t)jsSVGStyleElementType, (intptr_t)setJSSVGStyleElementType },
    { "media", DontDelete, (intptr_t)jsSVGStyleElementMedia, (intptr_t)setJSSVGStyleElementMedia },
    { "title", DontDelete, (intptr_t)jsSVGStyleElementTitle, (intptr_t)setJSSVGStyleElementTitle },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGStyleElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGStyleElementTableValues, 0 };
#else
    { 9, 7, JSSVGStyleElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGStyleElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGStyleElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGStyleElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGStyleElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGStyleElementPrototype::s_info = { "SVGStyleElementPrototype", 0, &JSSVGStyleElementPrototypeTable, 0 };

JSObject* JSSVGStyleElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGStyleElement>(exec, globalObject);
}

const ClassInfo JSSVGStyleElement::s_info = { "SVGStyleElement", &JSSVGElement::s_info, &JSSVGStyleElementTable, 0 };

JSSVGStyleElement::JSSVGStyleElement(PassRefPtr<Structure> structure, PassRefPtr<SVGStyleElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGStyleElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGStyleElementPrototype(JSSVGStyleElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGStyleElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGStyleElement, Base>(exec, &JSSVGStyleElementTable, this, propertyName, slot);
}

JSValuePtr jsSVGStyleElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->xmlspace());
}

JSValuePtr jsSVGStyleElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->type());
}

JSValuePtr jsSVGStyleElementMedia(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->media());
}

JSValuePtr jsSVGStyleElementTitle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->title());
}

void JSSVGStyleElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSSVGStyleElement, Base>(exec, propertyName, value, &JSSVGStyleElementTable, this, slot);
}

void setJSSVGStyleElementXmlspace(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setXmlspace(value->toString(exec), ec);
    setDOMException(exec, ec);
}

void setJSSVGStyleElementType(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setType(value->toString(exec), ec);
    setDOMException(exec, ec);
}

void setJSSVGStyleElementMedia(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setMedia(value->toString(exec), ec);
    setDOMException(exec, ec);
}

void setJSSVGStyleElementTitle(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGStyleElement* imp = static_cast<SVGStyleElement*>(static_cast<JSSVGStyleElement*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setTitle(value->toString(exec), ec);
    setDOMException(exec, ec);
}


}

#endif // ENABLE(SVG)
