/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(VIDEO)

#include "JSHTMLVideoElement.h"

#include <wtf/GetPtr.h>

#include "HTMLVideoElement.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLVideoElement)

/* Hash table */

static const HashTableValue JSHTMLVideoElementTableValues[7] =
{
    { "width", DontDelete, (intptr_t)jsHTMLVideoElementWidth, (intptr_t)setJSHTMLVideoElementWidth },
    { "height", DontDelete, (intptr_t)jsHTMLVideoElementHeight, (intptr_t)setJSHTMLVideoElementHeight },
    { "videoWidth", DontDelete|ReadOnly, (intptr_t)jsHTMLVideoElementVideoWidth, (intptr_t)0 },
    { "videoHeight", DontDelete|ReadOnly, (intptr_t)jsHTMLVideoElementVideoHeight, (intptr_t)0 },
    { "poster", DontDelete, (intptr_t)jsHTMLVideoElementPoster, (intptr_t)setJSHTMLVideoElementPoster },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLVideoElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLVideoElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSHTMLVideoElementTableValues, 0 };
#else
    { 17, 15, JSHTMLVideoElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLVideoElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLVideoElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLVideoElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLVideoElementConstructorTableValues, 0 };
#endif

class JSHTMLVideoElementConstructor : public DOMObject {
public:
    JSHTMLVideoElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLVideoElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLVideoElementPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLVideoElementConstructor::s_info = { "HTMLVideoElementConstructor", 0, &JSHTMLVideoElementConstructorTable, 0 };

bool JSHTMLVideoElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLVideoElementConstructor, DOMObject>(exec, &JSHTMLVideoElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLVideoElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLVideoElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLVideoElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLVideoElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLVideoElementPrototype::s_info = { "HTMLVideoElementPrototype", 0, &JSHTMLVideoElementPrototypeTable, 0 };

JSObject* JSHTMLVideoElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLVideoElement>(exec, globalObject);
}

const ClassInfo JSHTMLVideoElement::s_info = { "HTMLVideoElement", &JSHTMLMediaElement::s_info, &JSHTMLVideoElementTable, 0 };

JSHTMLVideoElement::JSHTMLVideoElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLVideoElement> impl)
    : JSHTMLMediaElement(structure, impl)
{
}

JSObject* JSHTMLVideoElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLVideoElementPrototype(JSHTMLVideoElementPrototype::createStructure(JSHTMLMediaElementPrototype::self(exec, globalObject)));
}

bool JSHTMLVideoElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLVideoElement, Base>(exec, &JSHTMLVideoElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLVideoElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->width());
}

JSValuePtr jsHTMLVideoElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->height());
}

JSValuePtr jsHTMLVideoElementVideoWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->videoWidth());
}

JSValuePtr jsHTMLVideoElementVideoHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->videoHeight());
}

JSValuePtr jsHTMLVideoElementPoster(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->poster());
}

JSValuePtr jsHTMLVideoElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLVideoElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLVideoElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLVideoElement, Base>(exec, propertyName, value, &JSHTMLVideoElementTable, this, slot);
}

void setJSHTMLVideoElementWidth(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(thisObject)->impl());
    imp->setWidth(value->toInt32(exec));
}

void setJSHTMLVideoElementHeight(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(thisObject)->impl());
    imp->setHeight(value->toInt32(exec));
}

void setJSHTMLVideoElementPoster(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(static_cast<JSHTMLVideoElement*>(thisObject)->impl());
    imp->setPoster(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSHTMLVideoElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLVideoElementConstructor>(exec);
}


}

#endif // ENABLE(VIDEO)
