/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSDocument.h"

#include <wtf/GetPtr.h>

#include "Attr.h"
#include "CDATASection.h"
#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "Comment.h"
#include "DOMImplementation.h"
#include "DOMSelection.h"
#include "DOMWindow.h"
#include "Document.h"
#include "DocumentFragment.h"
#include "DocumentType.h"
#include "Element.h"
#include "EntityReference.h"
#include "Event.h"
#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "JSAttr.h"
#include "JSCDATASection.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCanvasRenderingContext2D.h"
#include "JSComment.h"
#include "JSCustomXPathNSResolver.h"
#include "JSDOMImplementation.h"
#include "JSDOMSelection.h"
#include "JSDOMWindow.h"
#include "JSDocumentFragment.h"
#include "JSDocumentType.h"
#include "JSElement.h"
#include "JSEntityReference.h"
#include "JSEvent.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "JSNodeIterator.h"
#include "JSNodeList.h"
#include "JSProcessingInstruction.h"
#include "JSRange.h"
#include "JSStyleSheetList.h"
#include "JSText.h"
#include "JSTreeWalker.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeFilter.h"
#include "NodeIterator.h"
#include "NodeList.h"
#include "PlatformString.h"
#include "ProcessingInstruction.h"
#include "Range.h"
#include "StyleSheetList.h"
#include "Text.h"
#include "TreeWalker.h"
#include "XPathExpression.h"
#include "XPathNSResolver.h"
#include "XPathResult.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDocument)

/* Hash table */

static const HashTableValue JSDocumentTableValues[31] =
{
    { "doctype", DontDelete|ReadOnly, (intptr_t)jsDocumentDoctype, (intptr_t)0 },
    { "implementation", DontDelete|ReadOnly, (intptr_t)jsDocumentImplementation, (intptr_t)0 },
    { "documentElement", DontDelete|ReadOnly, (intptr_t)jsDocumentDocumentElement, (intptr_t)0 },
    { "inputEncoding", DontDelete|ReadOnly, (intptr_t)jsDocumentInputEncoding, (intptr_t)0 },
    { "xmlEncoding", DontDelete|ReadOnly, (intptr_t)jsDocumentXMLEncoding, (intptr_t)0 },
    { "xmlVersion", DontDelete, (intptr_t)jsDocumentXMLVersion, (intptr_t)setJSDocumentXMLVersion },
    { "xmlStandalone", DontDelete, (intptr_t)jsDocumentXMLStandalone, (intptr_t)setJSDocumentXMLStandalone },
    { "documentURI", DontDelete, (intptr_t)jsDocumentDocumentURI, (intptr_t)setJSDocumentDocumentURI },
    { "defaultView", DontDelete|ReadOnly, (intptr_t)jsDocumentDefaultView, (intptr_t)0 },
    { "styleSheets", DontDelete|ReadOnly, (intptr_t)jsDocumentStyleSheets, (intptr_t)0 },
    { "title", DontDelete, (intptr_t)jsDocumentTitle, (intptr_t)setJSDocumentTitle },
    { "referrer", DontDelete|ReadOnly, (intptr_t)jsDocumentReferrer, (intptr_t)0 },
    { "domain", DontDelete, (intptr_t)jsDocumentDomain, (intptr_t)setJSDocumentDomain },
    { "URL", DontDelete|ReadOnly, (intptr_t)jsDocumentURL, (intptr_t)0 },
    { "cookie", DontDelete, (intptr_t)jsDocumentCookie, (intptr_t)setJSDocumentCookie },
    { "body", DontDelete, (intptr_t)jsDocumentBody, (intptr_t)setJSDocumentBody },
    { "images", DontDelete|ReadOnly, (intptr_t)jsDocumentImages, (intptr_t)0 },
    { "applets", DontDelete|ReadOnly, (intptr_t)jsDocumentApplets, (intptr_t)0 },
    { "links", DontDelete|ReadOnly, (intptr_t)jsDocumentLinks, (intptr_t)0 },
    { "forms", DontDelete|ReadOnly, (intptr_t)jsDocumentForms, (intptr_t)0 },
    { "anchors", DontDelete|ReadOnly, (intptr_t)jsDocumentAnchors, (intptr_t)0 },
    { "lastModified", DontDelete|ReadOnly, (intptr_t)jsDocumentLastModified, (intptr_t)0 },
    { "location", DontDelete, (intptr_t)jsDocumentLocation, (intptr_t)setJSDocumentLocation },
    { "charset", DontDelete, (intptr_t)jsDocumentCharset, (intptr_t)setJSDocumentCharset },
    { "defaultCharset", DontDelete|ReadOnly, (intptr_t)jsDocumentDefaultCharset, (intptr_t)0 },
    { "readyState", DontDelete|ReadOnly, (intptr_t)jsDocumentReadyState, (intptr_t)0 },
    { "characterSet", DontDelete|ReadOnly, (intptr_t)jsDocumentCharacterSet, (intptr_t)0 },
    { "preferredStylesheetSet", DontDelete|ReadOnly, (intptr_t)jsDocumentPreferredStylesheetSet, (intptr_t)0 },
    { "selectedStylesheetSet", DontDelete, (intptr_t)jsDocumentSelectedStylesheetSet, (intptr_t)setJSDocumentSelectedStylesheetSet },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsDocumentConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDocumentTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSDocumentTableValues, 0 };
#else
    { 71, 63, JSDocumentTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSDocumentConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSDocumentConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSDocumentConstructorTableValues, 0 };
#else
    { 1, 0, JSDocumentConstructorTableValues, 0 };
#endif

class JSDocumentConstructor : public DOMObject {
public:
    JSDocumentConstructor(ExecState* exec)
        : DOMObject(JSDocumentConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSDocumentPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSDocumentConstructor::s_info = { "DocumentConstructor", 0, &JSDocumentConstructorTable, 0 };

bool JSDocumentConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentConstructor, DOMObject>(exec, &JSDocumentConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSDocumentPrototypeTableValues[37] =
{
    { "createElement", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateElement, (intptr_t)1 },
    { "createDocumentFragment", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateDocumentFragment, (intptr_t)0 },
    { "createTextNode", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateTextNode, (intptr_t)1 },
    { "createComment", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateComment, (intptr_t)1 },
    { "createCDATASection", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateCDATASection, (intptr_t)1 },
    { "createProcessingInstruction", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateProcessingInstruction, (intptr_t)2 },
    { "createAttribute", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateAttribute, (intptr_t)1 },
    { "createEntityReference", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateEntityReference, (intptr_t)1 },
    { "getElementsByTagName", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionGetElementsByTagName, (intptr_t)1 },
    { "importNode", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionImportNode, (intptr_t)2 },
    { "createElementNS", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateElementNS, (intptr_t)2 },
    { "createAttributeNS", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateAttributeNS, (intptr_t)2 },
    { "getElementsByTagNameNS", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionGetElementsByTagNameNS, (intptr_t)2 },
    { "getElementById", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionGetElementById, (intptr_t)1 },
    { "adoptNode", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionAdoptNode, (intptr_t)1 },
    { "createEvent", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateEvent, (intptr_t)1 },
    { "createRange", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateRange, (intptr_t)0 },
    { "createNodeIterator", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateNodeIterator, (intptr_t)4 },
    { "createTreeWalker", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateTreeWalker, (intptr_t)4 },
    { "getOverrideStyle", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionGetOverrideStyle, (intptr_t)2 },
    { "createExpression", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateExpression, (intptr_t)2 },
    { "createNSResolver", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionCreateNSResolver, (intptr_t)1 },
    { "evaluate", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionEvaluate, (intptr_t)5 },
    { "execCommand", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionExecCommand, (intptr_t)3 },
    { "queryCommandEnabled", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionQueryCommandEnabled, (intptr_t)1 },
    { "queryCommandIndeterm", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionQueryCommandIndeterm, (intptr_t)1 },
    { "queryCommandState", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionQueryCommandState, (intptr_t)1 },
    { "queryCommandSupported", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionQueryCommandSupported, (intptr_t)1 },
    { "queryCommandValue", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionQueryCommandValue, (intptr_t)1 },
    { "getElementsByName", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionGetElementsByName, (intptr_t)1 },
    { "elementFromPoint", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionElementFromPoint, (intptr_t)2 },
    { "getSelection", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionGetSelection, (intptr_t)0 },
    { "getCSSCanvasContext", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionGetCSSCanvasContext, (intptr_t)4 },
    { "getElementsByClassName", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionGetElementsByClassName, (intptr_t)1 },
    { "querySelector", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionQuerySelector, (intptr_t)1 },
    { "querySelectorAll", DontDelete|Function, (intptr_t)jsDocumentPrototypeFunctionQuerySelectorAll, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSDocumentPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 511, JSDocumentPrototypeTableValues, 0 };
#else
    { 135, 127, JSDocumentPrototypeTableValues, 0 };
#endif

const ClassInfo JSDocumentPrototype::s_info = { "DocumentPrototype", 0, &JSDocumentPrototypeTable, 0 };

JSObject* JSDocumentPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDocument>(exec, globalObject);
}

bool JSDocumentPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDocumentPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSDocument::s_info = { "Document", &JSEventTargetNode::s_info, &JSDocumentTable, 0 };

JSDocument::JSDocument(PassRefPtr<Structure> structure, PassRefPtr<Document> impl)
    : JSEventTargetNode(structure, impl)
{
}

JSDocument::~JSDocument()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), static_cast<Document*>(impl()));
}

JSObject* JSDocument::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDocumentPrototype(JSDocumentPrototype::createStructure(JSEventTargetNodePrototype::self(exec, globalObject)));
}

JSValuePtr jsDocumentDoctype(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->doctype()));
}

JSValuePtr jsDocumentImplementation(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->implementation()));
}

JSValuePtr jsDocumentDocumentElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->documentElement()));
}

JSValuePtr jsDocumentInputEncoding(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->inputEncoding());
}

JSValuePtr jsDocumentXMLEncoding(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->xmlEncoding());
}

JSValuePtr jsDocumentXMLVersion(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->xmlVersion());
}

JSValuePtr jsDocumentXMLStandalone(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->xmlStandalone());
}

JSValuePtr jsDocumentDocumentURI(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->documentURI());
}

JSValuePtr jsDocumentDefaultView(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->defaultView()));
}

JSValuePtr jsDocumentStyleSheets(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->styleSheets()));
}

JSValuePtr jsDocumentTitle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->title());
}

JSValuePtr jsDocumentReferrer(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->referrer());
}

JSValuePtr jsDocumentDomain(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->domain());
}

JSValuePtr jsDocumentURL(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->url());
}

JSValuePtr jsDocumentCookie(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->cookie());
}

JSValuePtr jsDocumentBody(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->body()));
}

JSValuePtr jsDocumentImages(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->images()));
}

JSValuePtr jsDocumentApplets(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->applets()));
}

JSValuePtr jsDocumentLinks(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->links()));
}

JSValuePtr jsDocumentForms(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->forms()));
}

JSValuePtr jsDocumentAnchors(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->anchors()));
}

JSValuePtr jsDocumentLastModified(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->lastModified());
}

JSValuePtr jsDocumentLocation(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSDocument*>(asObject(slot.slotBase()))->location(exec);
}

JSValuePtr jsDocumentCharset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsStringOrUndefined(exec, imp->charset());
}

JSValuePtr jsDocumentDefaultCharset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsStringOrUndefined(exec, imp->defaultCharset());
}

JSValuePtr jsDocumentReadyState(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsStringOrUndefined(exec, imp->readyState());
}

JSValuePtr jsDocumentCharacterSet(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->characterSet());
}

JSValuePtr jsDocumentPreferredStylesheetSet(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->preferredStylesheetSet());
}

JSValuePtr jsDocumentSelectedStylesheetSet(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->selectedStylesheetSet());
}

JSValuePtr jsDocumentConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSDocument*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSDocument::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSDocument, Base>(exec, propertyName, value, &JSDocumentTable, this, slot);
}

void setJSDocumentXMLVersion(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setXMLVersion(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSDocumentXMLStandalone(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setXMLStandalone(value->toBoolean(exec), ec);
    setDOMException(exec, ec);
}

void setJSDocumentDocumentURI(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setDocumentURI(valueToStringWithNullCheck(exec, value));
}

void setJSDocumentTitle(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setTitle(valueToStringWithNullCheck(exec, value));
}

void setJSDocumentDomain(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setDomain(valueToStringWithNullCheck(exec, value));
}

void setJSDocumentCookie(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setCookie(valueToStringWithNullCheck(exec, value));
}

void setJSDocumentBody(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setBody(toHTMLElement(value), ec);
    setDOMException(exec, ec);
}

void setJSDocumentLocation(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    static_cast<JSDocument*>(thisObject)->setLocation(exec, value);
}

void setJSDocumentCharset(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setCharset(valueToStringWithNullCheck(exec, value));
}

void setJSDocumentSelectedStylesheetSet(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setSelectedStylesheetSet(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSDocument::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSDocumentConstructor>(exec);
}

JSValuePtr jsDocumentPrototypeFunctionCreateElement(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& tagName = valueToStringWithNullCheck(exec, args.at(exec, 0));


    JSC::JSValuePtr result = toJSNewlyCreated(exec, WTF::getPtr(imp->createElement(tagName, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateDocumentFragment(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createDocumentFragment()));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateTextNode(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& data = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJSNewlyCreated(exec, WTF::getPtr(imp->createTextNode(data)));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateComment(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& data = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJSNewlyCreated(exec, WTF::getPtr(imp->createComment(data)));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateCDATASection(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& data = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJSNewlyCreated(exec, WTF::getPtr(imp->createCDATASection(data, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateProcessingInstruction(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& target = args.at(exec, 0)->toString(exec);
    const UString& data = args.at(exec, 1)->toString(exec);


    JSC::JSValuePtr result = toJSNewlyCreated(exec, WTF::getPtr(imp->createProcessingInstruction(target, data, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateAttribute(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJSNewlyCreated(exec, WTF::getPtr(imp->createAttribute(name, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateEntityReference(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJSNewlyCreated(exec, WTF::getPtr(imp->createEntityReference(name, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionGetElementsByTagName(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& tagname = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getElementsByTagName(tagname)));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionImportNode(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* importedNode = toNode(args.at(exec, 0));
    bool deep = args.at(exec, 1)->toBoolean(exec);


    JSC::JSValuePtr result = toJSNewlyCreated(exec, WTF::getPtr(imp->importNode(importedNode, deep, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateElementNS(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& namespaceURI = valueToStringWithNullCheck(exec, args.at(exec, 0));
    const UString& qualifiedName = valueToStringWithNullCheck(exec, args.at(exec, 1));


    JSC::JSValuePtr result = toJSNewlyCreated(exec, WTF::getPtr(imp->createElementNS(namespaceURI, qualifiedName, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateAttributeNS(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& namespaceURI = valueToStringWithNullCheck(exec, args.at(exec, 0));
    const UString& qualifiedName = valueToStringWithNullCheck(exec, args.at(exec, 1));


    JSC::JSValuePtr result = toJSNewlyCreated(exec, WTF::getPtr(imp->createAttributeNS(namespaceURI, qualifiedName, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionGetElementsByTagNameNS(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& namespaceURI = valueToStringWithNullCheck(exec, args.at(exec, 0));
    const UString& localName = args.at(exec, 1)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getElementsByTagNameNS(namespaceURI, localName)));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionGetElementById(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& elementId = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getElementById(elementId)));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionAdoptNode(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* source = toNode(args.at(exec, 0));


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->adoptNode(source, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateEvent(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& eventType = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createEvent(eventType, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateRange(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createRange()));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateNodeIterator(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* root = toNode(args.at(exec, 0));
    unsigned whatToShow = args.at(exec, 1)->toInt32(exec);
    RefPtr<NodeFilter> filter = toNodeFilter(args.at(exec, 2));
    bool expandEntityReferences = args.at(exec, 3)->toBoolean(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createNodeIterator(root, whatToShow, filter.get(), expandEntityReferences, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateTreeWalker(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* root = toNode(args.at(exec, 0));
    unsigned whatToShow = args.at(exec, 1)->toInt32(exec);
    RefPtr<NodeFilter> filter = toNodeFilter(args.at(exec, 2));
    bool expandEntityReferences = args.at(exec, 3)->toBoolean(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createTreeWalker(root, whatToShow, filter.get(), expandEntityReferences, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionGetOverrideStyle(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    Element* element = toElement(args.at(exec, 0));
    const UString& pseudoElement = args.at(exec, 1)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getOverrideStyle(element, pseudoElement)));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateExpression(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& expression = args.at(exec, 0)->toString(exec);
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(args.at(exec, 1));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, args.at(exec, 1));
        if (exec->hadException())
            return jsUndefined();
        resolver = customResolver.get();
    }


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createExpression(expression, resolver, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionCreateNSResolver(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    Node* nodeResolver = toNode(args.at(exec, 0));


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->createNSResolver(nodeResolver)));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionEvaluate(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& expression = args.at(exec, 0)->toString(exec);
    Node* contextNode = toNode(args.at(exec, 1));
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(args.at(exec, 2));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, args.at(exec, 2));
        if (exec->hadException())
            return jsUndefined();
        resolver = customResolver.get();
    }
    unsigned short type = args.at(exec, 3)->toInt32(exec);
    XPathResult* inResult = toXPathResult(args.at(exec, 4));


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->evaluate(expression, contextNode, resolver, type, inResult, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionExecCommand(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& command = args.at(exec, 0)->toString(exec);
    bool userInterface = args.at(exec, 1)->toBoolean(exec);
    const UString& value = valueToStringWithUndefinedOrNullCheck(exec, args.at(exec, 2));


    JSC::JSValuePtr result = jsBoolean(imp->execCommand(command, userInterface, value));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionQueryCommandEnabled(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& command = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsBoolean(imp->queryCommandEnabled(command));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionQueryCommandIndeterm(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& command = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsBoolean(imp->queryCommandIndeterm(command));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionQueryCommandState(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& command = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsBoolean(imp->queryCommandState(command));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionQueryCommandSupported(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& command = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsBoolean(imp->queryCommandSupported(command));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionQueryCommandValue(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& command = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsStringOrFalse(exec, imp->queryCommandValue(command));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionGetElementsByName(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& elementName = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getElementsByName(elementName)));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionElementFromPoint(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    int x = args.at(exec, 0)->toInt32(exec);
    int y = args.at(exec, 1)->toInt32(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->elementFromPoint(x, y)));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionGetSelection(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getSelection()));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionGetCSSCanvasContext(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& contextId = args.at(exec, 0)->toString(exec);
    const UString& name = args.at(exec, 1)->toString(exec);
    int width = args.at(exec, 2)->toInt32(exec);
    int height = args.at(exec, 3)->toInt32(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getCSSCanvasContext(contextId, name, width, height)));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionGetElementsByClassName(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    const UString& tagname = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getElementsByClassName(tagname)));
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionQuerySelector(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& selectors = valueToStringWithUndefinedOrNullCheck(exec, args.at(exec, 0));


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->querySelector(selectors, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsDocumentPrototypeFunctionQuerySelectorAll(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSDocument::s_info))
        return throwError(exec, TypeError);
    JSDocument* castedThisObj = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& selectors = valueToStringWithUndefinedOrNullCheck(exec, args.at(exec, 0));


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->querySelectorAll(selectors, ec)));
    setDOMException(exec, ec);
    return result;
}

Document* toDocument(JSC::JSValuePtr value)
{
    return value->isObject(&JSDocument::s_info) ? static_cast<JSDocument*>(asObject(value))->impl() : 0;
}

}
