/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSStyleSheet.h"

#include <wtf/GetPtr.h>

#include "CSSRule.h"
#include "CSSRuleList.h"
#include "CSSStyleSheet.h"
#include "JSCSSRule.h"
#include "JSCSSRuleList.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSStyleSheet)

/* Hash table */

static const HashTableValue JSCSSStyleSheetTableValues[5] =
{
    { "ownerRule", DontDelete|ReadOnly, (intptr_t)jsCSSStyleSheetOwnerRule, (intptr_t)0 },
    { "cssRules", DontDelete|ReadOnly, (intptr_t)jsCSSStyleSheetCssRules, (intptr_t)0 },
    { "rules", DontDelete|ReadOnly, (intptr_t)jsCSSStyleSheetRules, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsCSSStyleSheetConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleSheetTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSCSSStyleSheetTableValues, 0 };
#else
    { 9, 7, JSCSSStyleSheetTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSCSSStyleSheetConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleSheetConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCSSStyleSheetConstructorTableValues, 0 };
#else
    { 1, 0, JSCSSStyleSheetConstructorTableValues, 0 };
#endif

class JSCSSStyleSheetConstructor : public DOMObject {
public:
    JSCSSStyleSheetConstructor(ExecState* exec)
        : DOMObject(JSCSSStyleSheetConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSCSSStyleSheetPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSCSSStyleSheetConstructor::s_info = { "CSSStyleSheetConstructor", 0, &JSCSSStyleSheetConstructorTable, 0 };

bool JSCSSStyleSheetConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleSheetConstructor, DOMObject>(exec, &JSCSSStyleSheetConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSCSSStyleSheetPrototypeTableValues[5] =
{
    { "insertRule", DontDelete|Function, (intptr_t)jsCSSStyleSheetPrototypeFunctionInsertRule, (intptr_t)2 },
    { "deleteRule", DontDelete|Function, (intptr_t)jsCSSStyleSheetPrototypeFunctionDeleteRule, (intptr_t)1 },
    { "addRule", DontDelete|Function, (intptr_t)jsCSSStyleSheetPrototypeFunctionAddRule, (intptr_t)3 },
    { "removeRule", DontDelete|Function, (intptr_t)jsCSSStyleSheetPrototypeFunctionRemoveRule, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleSheetPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSCSSStyleSheetPrototypeTableValues, 0 };
#else
    { 8, 7, JSCSSStyleSheetPrototypeTableValues, 0 };
#endif

const ClassInfo JSCSSStyleSheetPrototype::s_info = { "CSSStyleSheetPrototype", 0, &JSCSSStyleSheetPrototypeTable, 0 };

JSObject* JSCSSStyleSheetPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSStyleSheet>(exec, globalObject);
}

bool JSCSSStyleSheetPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSStyleSheetPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSStyleSheet::s_info = { "CSSStyleSheet", &JSStyleSheet::s_info, &JSCSSStyleSheetTable, 0 };

JSCSSStyleSheet::JSCSSStyleSheet(PassRefPtr<Structure> structure, PassRefPtr<CSSStyleSheet> impl)
    : JSStyleSheet(structure, impl)
{
}

JSObject* JSCSSStyleSheet::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCSSStyleSheetPrototype(JSCSSStyleSheetPrototype::createStructure(JSStyleSheetPrototype::self(exec, globalObject)));
}

bool JSCSSStyleSheet::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleSheet, Base>(exec, &JSCSSStyleSheetTable, this, propertyName, slot);
}

JSValuePtr jsCSSStyleSheetOwnerRule(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(static_cast<JSCSSStyleSheet*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->ownerRule()));
}

JSValuePtr jsCSSStyleSheetCssRules(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(static_cast<JSCSSStyleSheet*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->cssRules()));
}

JSValuePtr jsCSSStyleSheetRules(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(static_cast<JSCSSStyleSheet*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->rules()));
}

JSValuePtr jsCSSStyleSheetConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSCSSStyleSheet*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSCSSStyleSheet::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSCSSStyleSheetConstructor>(exec);
}

JSValuePtr jsCSSStyleSheetPrototypeFunctionInsertRule(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleSheet::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(asObject(thisValue));
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& rule = args.at(exec, 0)->toString(exec);
    unsigned index = args.at(exec, 1)->toInt32(exec);


    JSC::JSValuePtr result = jsNumber(exec, imp->insertRule(rule, index, ec));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsCSSStyleSheetPrototypeFunctionDeleteRule(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleSheet::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(asObject(thisValue));
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args.at(exec, 0)->toInt32(exec);

    imp->deleteRule(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsCSSStyleSheetPrototypeFunctionAddRule(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleSheet::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(asObject(thisValue));
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& selector = args.at(exec, 0)->toString(exec);
    const UString& style = args.at(exec, 1)->toString(exec);

    int argsCount = args.size();
    if (argsCount < 3) {

        JSC::JSValuePtr result = jsNumber(exec, imp->addRule(selector, style, ec));
        setDOMException(exec, ec);
        return result;
    }

    unsigned index = args.at(exec, 2)->toInt32(exec);


    JSC::JSValuePtr result = jsNumber(exec, imp->addRule(selector, style, index, ec));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsCSSStyleSheetPrototypeFunctionRemoveRule(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleSheet::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleSheet* castedThisObj = static_cast<JSCSSStyleSheet*>(asObject(thisValue));
    CSSStyleSheet* imp = static_cast<CSSStyleSheet*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args.at(exec, 0)->toInt32(exec);

    imp->removeRule(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


}
