/****************************************************************************
    Qt-LCoV Library Editor for Qt-BSch3V
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef SPTNOBJARC_H
#define SPTNOBJARC_H

#include "sptnobj.h"

class SPtnObjArc :
	public SPtnObj
{
public:
	//̤Υ󥿡ե
	SPtnObjArc(void);
	~SPtnObjArc(void);
	int id(){return VECTPTN_AR;}
//	SPtnObjArc(const SPtnObjArc&);					//ԡ󥹥ȥ饯
//	SPtnObjArc& operator=(const SPtnObjArc&);		//黻
	SPtnObj* duplicate();							//ʣ
	bool qValid();									//ͭʥǡɤ֤

	//åפο֤
	int gripCount(){return 7;}
	//åפΰ֤֤
	SPoint gripPos(int grip);
	//åפΰ֤ư
	void setGripPos(int grip,int x,int y);

	void move(int offsetx,int offsety);				//֤ư
	void mirrorH(int x); 							//XɸꤷƺȿžԤ
	void mirrorH();									//ȿžԤ
	void rotate(const SPoint& p);					//XY濴ɸꤷơžԤ
	void rotate();									//žԤ
	bool testIntersect(const SRect& );				//ϰϤꤷåԤ
	bool testIntersect(const SPoint& );				//ꤷåԤ
	SRect area();									//ͭϰϤ֤
	bool readCe3(SReadCE3& rce3);
	bool writeCe3(SWriteCE3& wce3,SPoint* pOrigin=NULL);
	
	void setBeginPoint(int x,int y);			//ϳѤɸꡣ濴Ƥ
	void setEndPoint(int x,int y);				//λѤɸꡣ濴Ƥ
	SPoint AngleToPoint(int angle);				//(deg*16)߼
	SPoint AngleToPoint500(int angle);			//(deg*16)Ⱦ500α߼


public:
	SPoint m_ptC;		//濴ɸ
	int    m_nR;		//Ⱦ
	int	   m_nBegin;	//ϳ
	int	   m_nEnd;		//λ

	SPoint m_ptBegin;
	SPoint m_ptEnd;


protected:
	void normalizeAngle();
public:
	//static bool  Conv3PointArcToAR(SPoint pE0,SPoint pE1,SPoint p,SPoint& center,int& r,int& begin, int& end);
	static double  PointRad(double cx,double cy,double r,double x0,double y0);
};

#endif

