/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "assert-macros.h"

#include "gpass/password.h"

/***********************************************************
 *
 * initialize/terminate,  setup/teardown
 *
 ***********************************************************/
static void
initialize(void)
{
    g_type_init();
}

static void
terminate(void)
{
}

static void
setup(void)
{
}

static void
teardown(void)
{
}

/***********************************************************
 *
 * test case
 *
 ***********************************************************/
START_TEST(test_generate)
{
    GString *password;
    gchar *p;
    GError *error;

    password = g_string_new(NULL);

    error = gpass_password_generate(GPASS_PASSWORD_GENERATE_TYPE_RANDOM,
                                    GPASS_PASSWORD_GENERATE_USE_LOWERCASE,
                                    8, &password);
    ASSERT_NULL(error);
    for (p = password->str; *p != '\0'; p++) {
        ASSERT_TRUE('a' <= *p && *p <= 'z');
    }
    ASSERT_EQUAL_INT(8, password->len);

    error = gpass_password_generate(GPASS_PASSWORD_GENERATE_TYPE_RANDOM,
                                    GPASS_PASSWORD_GENERATE_USE_UPPERCASE,
                                    16, &password);
    ASSERT_NULL(error);
    for (p = password->str; *p != '\0'; p++) {
        ASSERT_TRUE('A' <= *p && *p <= 'Z');
    }
    ASSERT_EQUAL_INT(16, password->len);

    error = gpass_password_generate(GPASS_PASSWORD_GENERATE_TYPE_RANDOM,
                                    GPASS_PASSWORD_GENERATE_USE_NUMBER,
                                    5, &password);
    ASSERT_NULL(error);
    for (p = password->str; *p != '\0'; p++) {
        ASSERT_TRUE('0' <= *p && *p <= '9');
    }
    ASSERT_EQUAL_INT(5, password->len);

    error = gpass_password_generate(GPASS_PASSWORD_GENERATE_TYPE_RANDOM,
                                    GPASS_PASSWORD_GENERATE_USE_SPECIAL,
                                    20, &password);
    ASSERT_NULL(error);
    for (p = password->str; *p != '\0'; p++) {
        ASSERT_TRUE(('!' <= *p && *p <= '@') || ('[' <= *p && *p <= '_') ||
                    ('{' <= *p && *p <= '}'));
    }
    ASSERT_EQUAL_INT(20, password->len);

    error = gpass_password_generate(GPASS_PASSWORD_GENERATE_TYPE_RANDOM,
                                    GPASS_PASSWORD_GENERATE_USE_NORMAL,
                                    100, &password);
    ASSERT_NULL(error);
    for (p = password->str; *p != '\0'; p++) {
        ASSERT_TRUE(('a' <= *p && *p <= 'z') || ('A' <= *p && *p <= 'Z') ||
                    ('0' <= *p && *p <= '9') );
    }
    ASSERT_EQUAL_INT(100, password->len);
    
    g_string_free(password, TRUE);
}
END_TEST

/***********************************************************
 *
 * suite / main
 *
 ***********************************************************/
static Suite *
test_suite(void)
{
    Suite *s = suite_create("GPassPassword");
    TCase *tc;
    
    tc = tcase_create("functions");
    suite_add_tcase(s, tc);
    tcase_add_checked_fixture(tc, setup, teardown);
    
    tcase_add_test(tc, test_generate);
    return s;
}

int
main(int argc, char *argv[])
{
    Suite *s;
    SRunner *sr;
    int nf;

    initialize();
    
    s = test_suite();
    sr = srunner_create(s);
    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);
    
    terminate();
    return (nf == 0) ? EXIT_SUCCESS : EXIT_FAILURE;
}
