#!/usr/bin/env python
"""
Build script for yum-presto.
"""
import os.path
from setuptools import setup, find_packages
from distutils.command.build import build as _build
from distutils.command.install_data import install_data as _install_data

class build(_build):
    sub_commands = _build.sub_commands + [('compile_catalog', None)]
    def run(self):
        _build.run(self)
        
class install_data(_install_data):
    def run(self):
        for lang in os.listdir('locale'):
            if not os.path.isdir(os.path.join('locale', lang)):
                continue
            print lang
            lang_dir = os.path.join('share', 'locale', lang, 'LC_MESSAGES')
            lang_file = os.path.join('locale', lang, 'LC_MESSAGES', 'yum-presto.mo')
            self.data_files.append( (lang_dir, [lang_file]) )
        _install_data.run(self)
        
cmdclass = {
    'build': build,
    'install_data': install_data,
}

setup (name = "yum-presto",
    version = '0.7.2',
    packages = find_packages(), 
    description = "Utilizes the work done on deltarpm to provide faster, smaller size downloads to Fedora users.",
    author = 'Jonathan Dieter',
    author_email = 'jdieter@lesbg.com',
    license = 'GPLv2+',
    platforms=["Linux"],
    install_requires=["Babel"],
    data_files=[('/usr/lib/yum-plugins/', ['presto.py']),
                ('/etc/yum/pluginconf.d/', ['presto.conf'])],

    classifiers=['License :: OSI Approved ::  GNU General Public License (GPL)',
                 'Operating System :: Unix',
                 'Programming Language :: Python',
                 ],
    cmdclass=cmdclass,
)
