#/bin/bash

cd qdvdauthor/i18n

histFile=/tmp/hist
tempFile=/tmp/stats
outFile=/tmp/stats.html
if  [ -e $tempFile ]; then
  rm -rf $tempFile
fi
if  [ -e $outFile ]; then
  rm -rf $outFile
fi

getHistory ()
{
  ../../cvs.sh history -c -l *_??.ts >$histFile
}

getCountry ()
{
  if [ $1 == "en" ]; then echo "English";     fi;
  if [ $1 == "de" ]; then echo "German";      fi;
  if [ $1 == "ca" ]; then echo "Catalan";     fi;
  if [ $1 == "cs" ]; then echo "Czech";       fi;
  if [ $1 == "it" ]; then echo "Ialy";        fi;
  if [ $1 == "eo" ]; then echo "Esperamto";   fi;
  if [ $1 == "es" ]; then echo "Spain";       fi;
  if [ $1 == "pl" ]; then echo "Poland";      fi;
  if [ $1 == "fr" ]; then echo "France";      fi;
  if [ $1 == "ru" ]; then echo "Russian";     fi;
}

getHistory

# Here we create statistics per language translation
ls -1 *.ts | while read file
do
  untrans=`grep translation $file | sed -e 's,</translation>,THISISTHEEND,g' -e 's,.*<translation.*>,,g' | grep ^THISISTHEEND | wc -l`
  total=`grep translation $file | wc -l`
  trans=$(( total - untrans ));
  percent="100.0000"
  lang=`echo $file | sed -e 's,^.*_,,g' -e 's,\.ts,,g'`
#  date=`ls -l $file  | awk '{ print $6}'`
  date=`grep $file $histFile | awk '{ print $2 }'`

  if [ $total -ne 0 ]; then 
    percent=`echo "scale=4; $trans / $total * 100.0" | bc -q`
  fi;
  #echo "$lang : percent=$percent file=$file translated=$trans total=$total" 
  echo "$lang $total $trans $date" >>$tempFile
done
echo "zzz 0 0" >>$tempFile

grandTotal=0
grandTrans=0
prevName=`cat $tempFile | sort | head -1 | awk '{print $1}'`
latestDate="1970-01-01"
cat $tempFile | sort | while read line
do
  name=`echo  $line | awk '{print $1}'`
  total=`echo $line | awk '{print $2}'`
  trans=`echo $line | awk '{print $3}'`
  date=`echo  $line | awk '{print $4}'`

  if [ "x$name" == "x$prevName" ]; then
    grandTotal=$(( total + grandTotal ))
    grandTrans=$(( trans + grandTrans ))
    if [[ $date > $latestDate ]]; then
      latestDate=$date
    fi
  else
    percent="100.0000"
    if [ $grandTotal -ne 0 ]; then
      percent=`echo "scale=4; $grandTrans / $grandTotal * 100.0" | bc -q`
    fi
    #echo "$prevName = $percent = $grandTotal $grandTrans"
    echo "$prevName $percent $latestDate qdvdauthor_$prevName.ts" >>$outFile
    echo "$prevName $percent% done. Last modified=$latestDate qdvdauthor_$prevName.ts"
    grandTotal=$total
    grandTrans=$trans
    prevName=$name
    latestDate=$date
  fi
done;

rm $tempFile
mv $outFile $tempFile

cat <<EOF >$outFile
<head>
</head>
<body bgcolor="black" text="#ff8000" link="YELLOW" VLINK="BLUE" ALINK="RED">

<p><hr><p>

<center><table border="1"><tr><td>
<table cellspacing="0">
<thead bgcolor="#999999">
        <tr bgcolor="#222222">
                <th>language</th>
                <th class="graph">graph</th>
                <th>translated</th>
                <th>untrans.</th>
                <th>last updated</th>
        </tr>
<thead>
<tbody>
EOF

alternate=1
cat $tempFile | while read line
do
  file=`echo $line | awk '{print $4}'`
  date=`echo $line | awk '{print $3}'`
  percent=`echo $line | awk '{print $2}'`
  name=`echo $line | awk '{print $1}'`
  transWidth=`echo "scale=0;  $percent * 2 / 1" | bc`
  untransWidth=$(( 200 - transWidth ));
  unpercent=`echo "100.0 - $percent " | bc`
  longName=`getCountry $name`
  color="#000022"
  if [ $alternate -eq 1 ]; then
    color="#000000"
    alternate=0
  else
    alternate=1
  fi

  echo "<tr bgcolor=\"$color\">" >>$outFile
  echo "<td><a href=\"http://qdvdauthor.cvs.sourceforge.net/viewvc/*checkout*/qdvdauthor/qdvdauthor/qdvdauthor/i18n/$file\"><b>$longName ($name)</b></a></td>" >>$outFile
  echo "<td><img src=\"translated.png\" width=\"$transWidth\" height=\"16\"/><img src=\"untranslated.png\" width=\"$untransWidth\" height=\"16\"/></td>" >>$outFile
  echo "<td><font color=\"#008800\"><b>$percent %</b></font></td><td><font color=\"#aa0000\"><b>$unpercent %</b></font></td><td>$date</td>" >>$outFile

done

cat <<EOF >>$outFile
</tbody>
</table>

</td></tr></table></center>

</body>
</html>
EOF



