/****************************************************************************
** Client - class
**
**   Created : Fri Jun 6 12:09:08 2008
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**
****************************************************************************/

#ifndef RENDER_SERVER_H
#define RENDER_SERVER_H

#include <QList>
#include <QTcpServer>

#include "logger.h"

namespace Render
{

class Render;

class Server : public QTcpServer
{
    Q_OBJECT

public:
    Server ( QObject *p=NULL );

    void setLogInfo ( int, QString );
    Render *findSlideshowThread ( quint64, Render * );

protected:
    void incomingConnection(int socketDescriptor);

protected slots:
    virtual void slotRenderExited ( ::Render::Render * );

private:
    QList<Render *> m_listOfRenderTasks;
    int     m_iLogLevel;
    QString m_qsLogFileName;
    Logger  m_logger;
};

}; // end of namespace Render

#endif
