/*****************************************************************************
 ** Class QRender::Server
 **
 ** 
 **   Created : Fri Jun 6 12:09:08 2008
 **        by : Varol Okan using kate editor
 ** Copyright : (c) Varol Okan
 ** License   : GPL v 2.0
 **
 **
 *****************************************************************************/

#include "server.h"
#include "render.h"

#include <stdlib.h>

#include <QApplication>
#include <qdir.h>

#include "utils.h"

namespace Render
{

Server::Server ( QObject *pParent )
    : QTcpServer ( pParent )
{
  QString qsTempPath, qsLogFile;
  qsTempPath  = QDir::tempPath ( ) + "/qrender/";

  Utils theUtils;
  theUtils.recMkdir ( qsTempPath );

  qsLogFile    = qsTempPath + "log.txt";
  m_logger.setLogInfo ( 3, qsLogFile    );
  m_logger.setLogObjectInfo ( true );
}

void Server::incomingConnection ( int iSocketDescriptor )
{
  Render *pRender  =  new Render ( iSocketDescriptor, this      );
  pRender->logger ( ).setLogInfo ( m_iLogLevel, m_qsLogFileName );

  connect ( pRender, SIGNAL ( signalIAmDone ( ::Render::Render * ) ), this, SLOT ( slotRenderExited ( ::Render::Render * ) ) );
  pRender->start ( QThread::LowestPriority );
  m_logger.iLOG ( "Server::incomingConnection<%d> start<%p>\n", iSocketDescriptor, pRender );
  m_listOfRenderTasks.append ( pRender );
}

void Server::setLogInfo ( int iLogLevel, QString qsLogFileName )
{
  m_iLogLevel     = iLogLevel;
  m_qsLogFileName = qsLogFileName;
}

void Server::slotRenderExited ( ::Render::Render *pRender )
{
  m_logger.iLOG ( "Server::slotRenderExited \n" );
  m_listOfRenderTasks.removeAll ( pRender );
  // If Server and Client are on different machines, then keep it running. 
  // Else terminating it will not cause any harm as QDVDAuthor will be able 
  // to re-start QRender when needed.
  if ( ( pRender->isLocalServer ( ) ) && ( m_listOfRenderTasks.count ( ) == 0 ) )
    qApp->exit ( );
}

Render *Server::findSlideshowThread ( quint64 iHash, Render *pNotMe )
{
  Render *pRender = NULL;
  QList<Render *>::iterator it = m_listOfRenderTasks.begin ( );
  while ( it != m_listOfRenderTasks.end ( ) )  {
    pRender = *it++;
    if ( pNotMe && pNotMe == pRender )
      continue;
    if ( pRender->hash ( ) == iHash )
      return pRender;
  }
  return NULL;
}

}; // end of namespace Render

