#!/bin/bash

# First we check if we are in the qrender directory
curDir=`pwd`
curDir=`echo $curDir | sed s/qrender$//g`
export QTDIR4=$QTDIR

CORES=`cat /proc/cpuinfo | grep processor | wc -l`
if [ $# -gt 0 ]; then
  if [ $1 -eq $1 2> /dev/null ]; then
    CORES=$1
  fi;
fi;

is_qt_dir4 ()
{
export QTDIR4=$(
  if [ -e $1/bin/moc ];
  then
    export qtVersion=`$1/bin/moc -v 2>&1 | awk -F"(" '{printf $2}' | awk '{print $2}' | awk -F ")" '{print $1}' | awk -F. '{printf ("%.2d%.2d%.2d", $1, $2, $3);}'`;
    if [ $qtVersion -gt 040000 ] && [ $qtVersion -lt 050000 ];
    then
      echo $1
    fi;
  fi;
)
}

find_qt_dir4 ()
{
export QTDIR4=$(
  is_qt_dir4 $1
  if [ ! -z "$QTDIR4" ];
  then
    echo $QTDIR4
  else
    ls -d1 $1/qt4* 2>/dev/null |
    (while read dir
    do
      is_qt_dir4 $dir
      if [ ! -z "$QTDIR4" ];
      then
        echo $QTDIR4
        break;
      fi;
    done;
    )
fi;)
}

check_qt_dir4 ()
{
  # First make sure QTDIR is not already set
  if [ ! -z "$QTDIR4" ]
  then
    is_qt_dir4 $QTDIR4
  fi;

  if [ -z "$QTDIR4" ]
  then
    qtPaths="/usr/lib64 /usr/lib /usr/share /usr/local/lib64 /usr/local/lib /usr /usr/local";
    for thePath in $qtPaths
    do
      find_qt_dir4 $thePath
      if [ -d "$QTDIR4" ];
      then
        break;
      fi;
    done;
  fi;
}

QMAKE=qmake
check_qt_dir4

if [ "x$QTDIR4" == "x" ]; then
  # Unfortunately Fedora decided to rename qake for qt4
  QMAKE=qmake-qt4
  check_qt_dir4
  if [ "x$QTDIR4" == "x" ]; then
    QMAKE=qmake
  else
    QMAKE=$QTDIR4/bin/qmake-qt4
  fi;
else
  QMAKE=$QTDIR4/bin/qmake
fi

if [ $# -ge 1 ]; then
  if [ "$1" == "-s" ]; then
    silenceWGet=true
  fi;
fi

if [ x"$curDir" == x"`pwd`" ];
then
  echo; echo
  echo "    Your current directory is "`pwd`
  echo "    Please execute this script in the"
  echo "    qrender sub directory of QDVDAuthor"
  echo; echo
  exit -1
fi;

buildQRender ()
{
  make clean

  $QMAKE -o Makefile.tmp qrender.pro;
  sed "10 s,^,QTDIR = $QTDIR\n," Makefile.tmp > Makefile

  make -j $CORES
}

# If the user chooses to link dynamically against ffmpeg
# we do not need/want to get the latest ffmpeg library,
# but instead use the system ffmpeg.
if [ "x$STATIC_FFMPEG" == "x" ] || [ "x$STATIC_FFMEPG" == "x1" ]; then
  buildQRender
  exit 0
fi;

# The 0.5 release from March 2009
# theLib="http://ffmpeg.mplayerhq.hu/releases/ffmpeg-0.5.tar.bz2"

# Or the latest source from svn/git
theLib="http://ffmpeg.mplayerhq.hu/releases/ffmpeg-snapshot.tar.bz2"
theFile=`basename $theLib`

echo
echo "This script will pull the latest ffmpeg version off of :"
echo "$theLib"

if [ x"`whoami`" == "xvokan" -o x`whoami` == "xvarol" ];
then
  echo avoid build local_ffmpeg at `date` > /tmp/local_ffmpeg
  $QMAKE -o Makefile.tmp qrender.pro;
  sed "10 s,^,QTDIR = $QTDIR\n," Makefile.tmp > Makefile
  make -j $CORES 
  exit
fi;

# Check if the file exists ...
if [ -e $theFile ];
then
  rm $theFile
fi;
if [ -e `basename $theFile .bz2` ];
then
  rm `basename $theFile .bz2`
fi;

# One little hack to avoid breaking this build if ffmpeg changes 
#whichLib=`wget --spider http://qdvdauthor.sf.net/ffmpeg_location.txt 2>&1 | grep "200 OK"`
if [ "x$whichLib" != "x" ]; 
then
  if [ -f ffmpeg_location.txt ]; then
    rm ffmpeg_location.txt
  fi;
  # Found a workaround library. Now lets get the location and run with it.
  wget http://qdvdauthor.sf.net/ffmpeg_location.txt
  if [ -f ffmpeg_location.txt ]; then
    theLib=`cat ffmpeg_location.txt`
  fi;
fi;

res=`wget --spider $theLib 2>&1 | grep "200 OK"`

if [ "x$res" == "x" ];
then
  # Not found, lets try to use svn to DL the source
  svn checkout svn://svn.mplayerhq.hu/ffmpeg/trunk ffmpeg
  if [ ! -d ffmpeg ];
  then
    echo "Could not download ffmpeg. Please try to manually install it"
    echo "on your system and if needed set the FFMPEG environment"
    echo "variable before compiling qrender"
    exit -1
  else
    mv ffmpeg ffmpeg-snapshot
    ln -s ffmpeg-snapshot ffmpeg
  fi;
else
  # The tar file exists ...
  theFile=`basename $theLib`
  if [ "x$silenceWGet" != "x" ]; then
    wget $theLib >/dev/null 2>&1
  else
    wget $theLib
  fi;
  bzip2 -d $theFile
  theFile=`basename $theFile .bz2`
  if [ -d ffmpeg ]; then 
    # This could be differet than the $extractDir
    rm ffmpeg -rf
  fi;
  extractDir=`tar --list -f $theFile | grep INSTALL | sed "s/\\/INSTALL$//"`
  if [ -d "$extractDir" ]; then
    rm -r "$extractDir"
  fi;
  tar -xf $theFile
  if [[ -e ffmpeg && -L ffmpeg ]]; then
    rm ffmpeg
  fi;
  if [ "xffmpeg" != x"$extractDir" ]; then
    ln -s "$extractDir" ffmpeg
  fi;
fi;

cd ffmpeg
#./configure --prefix=/home/varol/utils/ffmpeg --enable-gpl --enable-nonfree --enable-shared --enable-static
#./configure --prefix="`pwd`" --enable-gpl --enable-swscale --enable-static --enable-shared
hasCrystal=`grep crystalhdd configure`
if [ "x" == "x$hasCrystal" ]; then
  ./configure --prefix="`pwd`" --enable-gpl --enable-static --enable-shared
else
  ./configure --prefix="`pwd`" --enable-gpl --enable-static --enable-shared --disable-crystalhd
fi

make -j $CORES && make install

# At this point the static libraries should have been built

# one last thing to do is to copy the header files to the include/ffmpeg directory
if [ ! -d include ]; then
  mkdir include 
fi;

cd include
mkdir ffmpeg
cp `find . -name "*.h"` ffmpeg/

# and lastly we should clean qrender and re-build it
cd ../..
buildQRender

