#!/bin/bash

dirs="/usr/lib64 /usr/lib /usr/share /usr/local/lib64 /usr/local/lib /usr /usr/local"

conf=`ffmpeg 2>&1 | grep configuration`

findLib ()
{
  for theDir in $dirs; do
    lib=`ls $theDir/$1*.so 2>/dev/null`
    if [ "x$lib" != "x" ]; then 
      echo $lib
      return
    else
      lib=`ls $theDir/$1*.so.0 2>/dev/null`
      if [ "x$lib" != "x" ]; then
        echo $lib
        return
      fi
    fi
  done
}

process ()
{
  for cnt do
    enabled=`echo $cnt | grep \\\-enable`
    if [ "x$enabled" != "x" ]; then
      enabled=`echo $enabled | sed 's,--enable-,,g'`
      if [ "$enabled" == "x11grab"  ]; then continue; fi;
      if [ "$enabled" == "gpl"      ]; then continue; fi;
      if [ "$enabled" == "shared"   ]; then continue; fi;
      if [ "$enabled" == "nonfree"  ]; then continue; fi;
      if [ "$enabled" == "avfilter" ]; then continue; fi;
      if [ "$enabled" == "version3" ]; then continue; fi;
      if [ "$enabled" == "pthreads" ]; then continue; fi;
      if [ "$enabled" == "postproc" ]; then enabled="libpostproc"; fi;

      lib=`findLib $enabled`
      echo -n "$lib "
    fi;
  done

}
libs=`process $conf`
echo -n " $libs"

#g++  -o ../bin/qrender .obj/main.o .obj/utils.o .obj/server.o .obj/render.o .obj/parser.o .obj/logger.o .obj/filter.o .obj/slideshow.o .obj/encoder.o .obj/ffmpeg_enc.o .obj/xml_slideshow.o .obj/moc_server.o .obj/moc_render.o    -L/usr/lib /usr/lib/libavformat.a /usr/lib/libavcodec.a /usr/lib/libavutil.a /usr/lib/libavdevice.a /usr/lib/libswscale.a -L/usr/lib /usr/lib/libtheora.so.0 /usr/lib/libvorbisenc.so.2 /lib/libbz2.so.1 -lQtXml -lQtGui -L/usr/X11R6/lib -lQtNetwork -lQtCore -lpthread $libs 

