/****************************************************************************
** QDVDAuthorUndoObject - code
**
**   Created : Thursday Jan 2'nd 2003
**        by : Varol Okan
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
****************************************************************************/
#include "qdvdauthorundoobject.h"
#include "qdvdauthor.h"

QDVDAuthorUndoObject::QDVDAuthorUndoObject()
{
	m_enUndoType = (int)UNDEFINED;
}

QDVDAuthorUndoObject::~QDVDAuthorUndoObject()
{
}

// Here is the code for the storage of the user input in the ConstructionArea.
//
// This code needs to get accounted for in the ConstructionArea - class.
// The information found in here is later used to restore to the previous configuration.
/*
QDVDAuthorUndoObject::QDVDAuthorUndoObject(enUndoType type, ConstructionThing *pThing)
{
	m_enUndoType = (int)type;
	// Here we squeeze out the information stored in the ConstructionThing - class.
	//ConstructionThingInfo 
	pThing->GetInfo();
}
*/

QDVDAuthorUndoObject::QDVDAuthorUndoObject(enUndoType type, float fZoom)
{
	m_enUndoType = (int)type;
	if (type == ZOOM)
		m_fZoom = fZoom;
}

QDVDAuthorUndoObject::QDVDAuthorUndoObject(enUndoType type, bool bGrid)
{
	m_enUndoType = (int)type;
	if (type == GRID)
		m_bGrid = bGrid;
}

QDVDAuthorUndoObject::QDVDAuthorUndoObject(enUndoType type, QPoint pointPanStartPos)
{
	m_enUndoType = (int)type;
	if (type == PAN)
		m_pointPanStartPos = pointPanStartPos;
}


// Here is the code, to restore the previous configuration.
void
QDVDAuthorUndoObject::undo(QDVDAuthor *pDVDAuthor)
{
	pDVDAuthor = pDVDAuthor;
	switch (m_enUndoType)	{
	case ZOOM :
		// After undo-ing the zoom, we puyt this object in the Redo Buffer.
		// So If the user choses to Redo the Undo then we need the previous
		// Zoom and not the value which we already have restored ...
//		m_fZoom = pCA->DoZoom (m_fZoom);
	break;
	case PAN :

	break;
	case GRID :
//		m_bGrid = pCA->DoGrid(m_bGrid);
	break;
	case MOVE :

	break;
	case NEW_FUNCTION :

	break;
	case NEW_CONNECTION :

	break;
	case DELETE_THING :

	break;
	};	// End of the switch loop.
}

void
QDVDAuthorUndoObject::redo(QDVDAuthor *pDVDAuthor)
{
	pDVDAuthor = pDVDAuthor;
	switch (m_enUndoType)	{
	case ZOOM :
		// After redo-ing the zoom, we put this object in the Redo Buffer.
		// So If the user choses to Redo the Undo then we need the previous
		// Zoom and not the value which we already have restored ...
//		m_fZoom = pCA->DoZoom (m_fZoom);
	break;
	case PAN :

	break;
	case GRID :
//		m_bGrid = pCA->DoGrid(m_bGrid);
	break;
	case MOVE :

	break;
	case NEW_FUNCTION :

	break;
	case NEW_CONNECTION :

	break;
	case DELETE_THING :

	break;
	};	// End of the switch loop.
}

void
QDVDAuthorUndoObject::updateDelta (int iDeltaX, int iDeltaY)
{
	if (m_enUndoType != PAN)
		return;
	// This function is called every time the MouseMove function
	// is executed while panning.
	m_pointPanDelta.setX(m_pointPanDelta.x() + iDeltaX);
	m_pointPanDelta.setY(m_pointPanDelta.y() + iDeltaY);
}

