unix {
  UI_DIR      = .ui
  MOC_DIR     = .moc
  OBJECTS_DIR = .obj
}

TEMPLATE	= lib
LANGUAGE	= C++

HEADERS += complexdvd.h run.h \
	   ../interface.h

SOURCES += complexdvd.cpp run.cpp

FORMS	 = uicomplexdvd.ui

WHICH_PREFIX = $$(PREFIX)
isEmpty( WHICH_PREFIX ) {
        WHICH_PREFIX =/usr
}

# Here we handle the language file generation
!exists ( ../../i18n/complexdvd_de.qm )       {
        LRELEASE=$$(QTDIR)/bin/lrelease
        !exists ( $${LRELEASE} ) {
                LRELEASE=lrelease
        }
        system ( $${LRELEASE} complexdvd.pro )
}

thePlugin.path  = $${WHICH_PREFIX}/share/qdvdauthor/plugins
thePlugin.files = ../plugins/libcomplexdvd.so*

support.path  = $${WHICH_PREFIX}/share/qdvdauthor/plugins/complexdvd
support.files = background.jpg main.png prev.png next.png

scripts.path  = $${WHICH_PREFIX}/share/qdvdauthor/plugins/complexdvd/scripts
scripts.files = fantom-xp.sh hdrcreme.sh dreamscene.sh

i18n.path   = $${WHICH_PREFIX}/share/qdvdauthor
i18n.files  = ./i18n/complexdvd_*.qm

TRANSLATIONS  = ../../i18n/complexdvd_de.ts \
                ../../i18n/complexdvd_cs.ts \
                ../../i18n/complexdvd_ru.ts

DESTDIR    =../plugins

INSTALLS   = thePlugin support scripts i18n

LIBS    += -L/usr/lib
VERSION  = 2.0
DEFINES += PLUGIN_VERSION=$${VERSION}
CONFIG	+= qt warn_on release

#QMAKE_POST_LINK = qmake -o Makefile

