
#include <stdlib.h>
#include <dlfcn.h>

#include <qdir.h>
#include <qimage.h>
#include <qapplication.h>
#include <qfiledialog.h>
#include <qpushbutton.h>
#include <qprogressbar.h>
#include <qiconview.h>

#include "window.h"

Window::Window ( QWidget *parent )
    : uiDialog ( parent )
{
  connect ( m_pButtonBrowse, SIGNAL ( clicked ( ) ), this, SLOT ( slotBrowse ( ) ) );
  loadPlugin ( );
}

Window::~Window ( )
{
  unloadPlugin ( );
}

void Window::slotBrowse ( )
{
  // For easier testing I want to re-load the plugin each time ...
  unloadPlugin ( );
  loadPlugin   ( );

  if ( m_pPlugin )  {
    int iCounter = 1;
    QString qsDir = QFileDialog::getExistingDirectory ( QString::null, this );

    if ( qsDir.isEmpty ( ) )
      return;

    QDir theDir ( qsDir );
    QString qsFullPath, qsThumbPath;
    QString qsFilter ( "*.jpg *.jpeg *.JPG *.JPEG");

    QValueList<jhead::JHead::Info *> list;
    jhead::JHead::Info *pInfo = NULL;
//    QStringList listOfFilter  = QStringList::split   ( QString ( " " ) );
    QStringList listOfFiles   = theDir.entryList ( qsFilter, QDir::Files );

    m_pProgressBar->setTotalSteps ( listOfFiles.count ( ) * 2 );
    QStringList::iterator it = listOfFiles.begin ( );
    while ( it != listOfFiles.end ( ) )  {
      qsFullPath  = theDir.path   ( ) + "/" + *it;
      qsThumbPath = "/tmp/" + *it++;
      pInfo       = m_pPlugin->getFileInfo ( qsFullPath ); //, &qsThumbPath );
      if ( pInfo ) 
           list.append ( pInfo );
 
      m_pProgressBar->setProgress ( iCounter ++ );
      qApp->processEvents ( 100 );
    }

    m_pIconView->clear ( );
    QFileInfo fileInfo;
    QPixmap thePixmap;
    QString qsFileName, qsInfo;
    QValueList<jhead::JHead::Info *>::iterator it2 = list.begin ( );

    while ( it2 != list.end ( ) )  {
      pInfo      = *it2++;
      if ( ! pInfo )
        continue;
      if ( ! pInfo->pThumbnail )  {
        delete pInfo;
        continue;
      }

      thePixmap.convertFromImage ( *pInfo->pThumbnail );
      fileInfo.setFile    (  pInfo->qsFileName );
      qsInfo = QString ( "%1\n%2\n%3x%4" ).arg ( fileInfo.fileName ( ) ).arg ( pInfo->imageDate.toString ( "yyyy/MM/dd hh:mm:ss" ) ).arg ( pInfo->iWidth ).arg ( pInfo->iHeight );
      new QIconViewItem ( m_pIconView, qsInfo, thePixmap );
      m_pProgressBar->setProgress ( iCounter ++ );
      //qApp->processEvents ( 100 );

      delete pInfo;
    }
    m_pProgressBar->setProgress ( 0 );
    QString qsTitle = QString ( "%1 Images in <%2> have exif built in thumbnails" ).arg ( m_pIconView->count ( ) ).arg ( qsDir );
    setCaption ( qsTitle );
  }
}
/*
void Window::slotBrowse ( )
{
  // For easier testing I want to re-load the plugin each time ...
  unloadPlugin ( );
  loadPlugin   ( );

  if ( m_pPlugin )  {
    int iCounter = 1;
    QString qsDir = QFileDialog::getExistingDirectory ( QString::null, this );

    if ( qsDir.isEmpty ( ) )
      return;

    QDir theDir ( qsDir );
    QString qsFullPath, qsThumbPath;
    QString qsFilter ( "*.jpg *.jpeg *.JPG *.JPEG");

    QValueList<jhead::JHead::Info *> list;
    jhead::JHead::Info *pInfo = NULL;
//    QStringList listOfFilter  = QStringList::split   ( QString ( " " ) );
    QStringList listOfFiles   = theDir.entryList ( qsFilter, QDir::Files );

    m_pProgressBar->setTotalSteps ( listOfFiles.count ( ) * 2 );
    QStringList::iterator it = listOfFiles.begin ( );
    while ( it != listOfFiles.end ( ) )  {
      qsFullPath  = theDir.path ( ) + "/" + *it;
      qsThumbPath = "/tmp/"   + *it++;
      pInfo = m_pPlugin->getFileInfo   ( qsFullPath, &qsThumbPath );
      if ( pInfo )
           list.append ( pInfo );
      m_pProgressBar->setProgress ( iCounter ++ );
      qApp->processEvents ( 100 );
    }

    m_pIconView->clear ( );
    QFileInfo fileInfo;
    QPixmap thePixmap;
    QString qsFileName, qsInfo;
    QValueList<jhead::JHead::Info *>::iterator it2 = list.begin ( );

    while ( it2 != list.end ( ) )  {
      pInfo      = *it2++;
      if ( ! pInfo )
        continue;
      if ( ! pInfo->pThumbnail )  {
        delete pInfo;
        continue;
      }

      thePixmap.convertFromImage ( *pInfo->pThumbnail );
      fileInfo.setFile    (  pInfo->qsThumbnailFileName );
      qsInfo = QString ( "%1\n%2\n%3x%4" ).arg ( fileInfo.fileName ( ) ).arg ( pInfo->imageDate.toString ( "yyyy/MM/dd hh:mm:ss" ) ).arg ( pInfo->iWidth ).arg ( pInfo->iHeight );
      new QIconViewItem ( m_pIconView, qsInfo, thePixmap );
      m_pProgressBar->setProgress ( iCounter ++ );
      //qApp->processEvents ( 100 );

      delete pInfo;
    }
    m_pProgressBar->setProgress ( 0 );
    QString qsTitle = QString ( "%1 Images in <%2> have exif built in thumbnails" ).arg ( m_pIconView->count ( ) ).arg ( qsDir );
    setCaption ( qsTitle );
  }
}
*/
bool Window::loadPlugin ( )
{
  QString qsFilePath = "../../../../lib/libjhead.so";

  m_pLibrary = dlopen ( qsFilePath.ascii ( ), RTLD_LAZY );
  if ( ! m_pLibrary ) {
    printf ( "Fatal: Cannot load library <%s>\n       %s\n", qsFilePath.ascii ( ), dlerror ( ) );
    return false;
  }

  // reset errors
  dlerror ( );

  // load the symbols
  createJHead_t   *pCreateLibrary = (createJHead_t *) dlsym ( m_pLibrary, "createPlugin" );
  const char *pErrorString   = dlerror (  );
  if ( pErrorString ) {
    printf ( "Cannot load symbol create: %s\n", pErrorString );
    return false;
  }

  m_pDestroyFunction = (destroyJHead_t *) dlsym ( m_pLibrary, "destroyPlugin" );
  pErrorString = dlerror ( );
  if ( pErrorString ) {
    printf ( "Cannot load symbol destroy: %s\n", pErrorString );
    return false;
  }

  // create an instance of the class
  m_pPlugin = pCreateLibrary ( );

  return true;
}

void Window::unloadPlugin ( )
{
  // destroy the class
  if ( m_pPlugin && m_pDestroyFunction )  {
    m_pDestroyFunction ( m_pPlugin );
  }
  m_pDestroyFunction = NULL;
  m_pPlugin = NULL;

  // unload the triangle library
  if ( m_pLibrary )
    dlclose ( m_pLibrary );
  m_pLibrary = NULL;
}




