// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

'use strict';
require('../common');
const repl = require('./helper-debugger-repl.js');

repl.startDebugger('breakpoints.js');
const linesWithBreakpoint = [
  /1/, /2/, /3/, /4/, /5/, /\* 6/
];
// We slice here, because addTest will change the given array.
repl.addTest('sb(6)', linesWithBreakpoint.slice());

const initialLines = repl.initialLines.slice();
initialLines.splice(2, 0, /Restoring/, /Warning/);

// Restart the debugged script
repl.addTest('restart', [
  /terminated/,
].concat(initialLines));

repl.addTest('list(5)', linesWithBreakpoint);
repl.addTest('quit', []);
