/*
    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) 2011  <copyright holder> <maurobender@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef SONGINFO_H
#define SONGINFO_H

#include "song.h"
#include <QGraphicsWidget>
#include <QGraphicsGridLayout>
#include <Plasma/Label>
#include "albumart.h"

class SongInfo : public QGraphicsWidget {
public:
	SongInfo(const Song & = Song(), QGraphicsItem * = 0, Qt::WindowFlags = 0);
	virtual ~SongInfo();
	
	void setSong(const Song &);
	const Song &song() const;
private:
	void updateInfo();
	
	Song m_song;
	
	QGraphicsGridLayout *m_layout;
	AlbumArt *m_cover;
	Plasma::Label *m_title;
	Plasma::Label *m_artist;
	Plasma::Label *m_album;
};

#endif // SONGINFO_H
